/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.FeatureGenerator;
import se.lth.cs.srl.features.QuadraticFeature;
import se.lth.cs.srl.features.SingleFeature;

public class QSingleSingleFeature
extends SingleFeature
implements QuadraticFeature {
    private static final long serialVersionUID = 1L;
    private SingleFeature f1;
    private SingleFeature f2;

    protected QSingleSingleFeature(SingleFeature f1, SingleFeature f2, boolean usedForPredicateIdentification, String POSPrefix) {
        super(f1.name, f1.includeArgs || f2.includeArgs, usedForPredicateIdentification, POSPrefix);
        this.f1 = f1;
        this.f2 = f2;
    }

    @Override
    protected void performFeatureExtraction(Sentence s, boolean allWords) {
        if (this.includeArgs) {
            for (Predicate pred : s.getPredicates()) {
                if (!this.doExtractFeatures(pred)) continue;
                for (Word arg : pred.getArgMap().keySet()) {
                    this.addMap(this.getFeatureString(pred, arg));
                }
            }
        } else {
            super.performFeatureExtraction(s, allWords);
        }
    }

    @Override
    public String getFeatureString(Sentence s, int predIndex, int argIndex) {
        return this.f1.getFeatureString(s, predIndex, argIndex) + " + " + this.f2.getFeatureString(s, predIndex, argIndex);
    }

    @Override
    public String getFeatureString(Predicate pred, Word arg) {
        return this.f1.getFeatureString(pred, arg) + " + " + this.f2.getFeatureString(pred, arg);
    }

    @Override
    public String getName() {
        return FeatureGenerator.getCanonicalName(this.f1.name, this.f2.name);
    }
}

