/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.util.Collection;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.FeatureName;
import se.lth.cs.srl.features.SingleFeature;

public class PositionFeature
extends SingleFeature {
    private static final long serialVersionUID = 1L;
    public static final String BEFORE = "B";
    public static final String ON = "O";
    public static final String AFTER = "A";

    protected PositionFeature(String POSPrefix) {
        super(FeatureName.Position, true, false, POSPrefix);
        this.indices.put(BEFORE, 1);
        this.indices.put(ON, 2);
        this.indices.put(AFTER, 3);
        this.indexcounter = 4;
    }

    @Override
    public void addFeatures(Sentence s, Collection<Integer> indices, int predIndex, int argIndex, Integer offset, boolean allWords) {
        indices.add(this.indexOf(this.getFeatureString(s, predIndex, argIndex)) + offset);
    }

    @Override
    public void addFeatures(Collection<Integer> indices, Predicate pred, Word arg, Integer offset, boolean allWords) {
        indices.add(this.indexOf(this.getFeatureString(pred, arg)) + offset);
    }

    @Override
    protected void performFeatureExtraction(Sentence s, boolean allWords) {
    }

    @Override
    public String getFeatureString(Sentence s, int predIndex, int argIndex) {
        if (predIndex == argIndex) {
            return ON;
        }
        if (predIndex < argIndex) {
            return AFTER;
        }
        return BEFORE;
    }

    @Override
    public String getFeatureString(Predicate pred, Word arg) {
        int cmp = pred.getMySentence().wordComparator.compare(pred, arg);
        if (cmp < 0) {
            return AFTER;
        }
        if (cmp == 0) {
            return ON;
        }
        return BEFORE;
    }
}

