/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.lth.cs.srl.features.Feature;
import se.lth.cs.srl.features.FeatureSet;

public class FeatureFile {
    public static Map<String, List<String>> readFile(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        BufferedReader in = new BufferedReader(new FileReader(file));
        return FeatureFile.readFile(in);
    }

    public static Map<String, List<String>> readFile(BufferedReader in) throws IOException {
        String line;
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        ArrayList<String> array = null;
        String prefix = null;
        while ((line = in.readLine()) != null) {
            if (line.startsWith("#")) continue;
            if (prefix == null) {
                prefix = line;
                array = new ArrayList<String>();
                continue;
            }
            if (line.equals("")) {
                ret.put(prefix, array);
                prefix = null;
                array = null;
                continue;
            }
            String name = line.contains(" ") ? line.substring(0, line.indexOf(" ")) : line;
            array.add(name);
        }
        if (prefix != null && array != null && array.size() != 0) {
            ret.put(prefix, (List<String>)array);
        }
        in.close();
        return ret;
    }

    public static void writeToOutput(FeatureSet fs, PrintWriter out) throws IOException {
        boolean first = true;
        for (String prefix : fs.POSPrefixes) {
            if (first) {
                first = false;
            } else {
                out.println();
            }
            out.println(prefix);
            for (Feature f : (List)fs.get(prefix)) {
                out.println(f.getName() + " - size: " + f.size(false) + "/" + f.size(true));
            }
        }
        out.flush();
    }

    public static void writeToFile(List<Feature> features, String POSPrefix, List<String> comments, File file) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
        out.println(POSPrefix);
        for (int i = 0; i < features.size(); ++i) {
            Feature f = features.get(i);
            out.print(f.getName() + " - size: " + f.size(false) + "/" + f.size(true));
            if (i < comments.size()) {
                out.print(" # " + comments.get(i));
            }
            out.println();
        }
        out.close();
    }
}

