/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.util.Arrays;
import java.util.Set;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.FeatureName;
import se.lth.cs.srl.features.SingleFeature;

public class DepSubCatFeature
extends SingleFeature {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = " ";

    DepSubCatFeature(boolean usedForPredicateIdentification, String POSPrefix) {
        super(FeatureName.DepSubCat, false, usedForPredicateIdentification, POSPrefix);
    }

    @Override
    public String getFeatureString(Sentence s, int predIndex, int argIndex) {
        return this.makeFeatureString(s, ((Word)s.get(predIndex)).getChildren());
    }

    @Override
    public String getFeatureString(Predicate pred, Word arg) {
        return this.makeFeatureString(pred.getMySentence(), pred.getChildren());
    }

    private String makeFeatureString(Sentence s, Set<Word> children) {
        switch (children.size()) {
            case 0: {
                return SEPARATOR;
            }
            case 1: {
                return children.iterator().next().getDeprel();
            }
        }
        Word[] sortedChildren = children.toArray(new Word[0]);
        Arrays.sort(sortedChildren, s.wordComparator);
        StringBuilder ret = new StringBuilder(sortedChildren[0].getDeprel());
        int size = sortedChildren.length;
        for (int i = 1; i < size; ++i) {
            ret.append(SEPARATOR).append(sortedChildren[i].getDeprel());
        }
        return ret.toString();
    }
}

