/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.FeatureName;
import se.lth.cs.srl.features.SetFeature;

public class ChildSetFeature
extends SetFeature {
    private static final long serialVersionUID = 1L;
    Word.WordData attr;

    protected ChildSetFeature(FeatureName name, Word.WordData attr, boolean usedForPredicateIdentification, String POSPrefix) {
        super(name, false, usedForPredicateIdentification, POSPrefix);
        this.attr = attr;
    }

    @Override
    public String[] getFeatureStrings(Sentence s, int predIndex, int argIndex) {
        return this.makeFeatureStrings((Word)s.get(predIndex));
    }

    @Override
    public String[] getFeatureStrings(Predicate pred, Word arg) {
        return this.makeFeatureStrings(pred);
    }

    private String[] makeFeatureStrings(Word pred) {
        String[] ret = new String[pred.getChildren().size()];
        int i = 0;
        for (Word child : pred.getChildren()) {
            ret[i++] = child.getAttr(this.attr);
        }
        return ret;
    }

    @Override
    protected void performFeatureExtraction(Sentence s, boolean allWords) {
        if (allWords) {
            int size = s.size();
            for (int i = 1; i < size; ++i) {
                if (!this.doExtractFeatures((Word)s.get(i))) continue;
                for (Word child : ((Word)s.get(i)).getChildren()) {
                    this.addMap(child.getAttr(this.attr));
                }
            }
        } else {
            for (Predicate pred : s.getPredicates()) {
                if (!this.doExtractFeatures(pred)) continue;
                for (Word child : pred.getChildren()) {
                    this.addMap(child.getAttr(this.attr));
                }
            }
        }
    }
}

