/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.corpus;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;

public class Yield
extends TreeSet<Word>
implements Comparable<Yield> {
    private static final long serialVersionUID = 1L;
    private Predicate pred;
    private Sentence sen;
    private String argLabel;

    public String getArgLabel() {
        return this.argLabel;
    }

    public Yield(Predicate pred, Sentence sen, String argLabel) {
        super(sen.wordComparator);
        this.pred = pred;
        this.sen = sen;
        this.argLabel = argLabel;
    }

    public Predicate getPred() {
        return this.pred;
    }

    public boolean isContinuous() {
        if (this.size() < 2) {
            return true;
        }
        int senIndex = this.sen.indexOf(this.first());
        for (Word w : this) {
            if (this.sen.get(senIndex++) == w) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Yield y) {
        return ((Word)this.first()).getMySentence().wordComparator.compare((Word)this.first(), (Word)y.first());
    }

    public Collection<Yield> explode() {
        if (this.isContinuous()) {
            return Arrays.asList(this);
        }
        TreeSet<Yield> ret = new TreeSet<Yield>();
        String curArgLabel = this.argLabel;
        Yield subYield = new Yield(this.pred, this.sen, curArgLabel);
        for (int i = this.sen.indexOf(this.first()); i <= this.sen.indexOf(this.last()); ++i) {
            Word curWord = (Word)this.sen.get(i);
            if (this.contains(curWord)) {
                subYield.add(curWord);
                continue;
            }
            if (subYield.isEmpty()) continue;
            ret.add(subYield);
            curArgLabel = "C-" + curArgLabel;
            subYield = new Yield(this.pred, this.sen, curArgLabel);
        }
        if (!subYield.isEmpty()) {
            ret.add(subYield);
        }
        return ret;
    }
}

