/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.corpus;

import is2.data.SentenceData09;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Word;

public class Sentence
extends ArrayList<Word> {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final long serialVersionUID = 10L;
    private List<Predicate> predicates;
    public final Comparator<Word> wordComparator = new Comparator<Word>(){

        @Override
        public int compare(Word arg0, Word arg1) {
            return Sentence.this.indexOf(arg0) - Sentence.this.indexOf(arg1);
        }
    };

    private Sentence() {
        Word BOS = new Word(this);
        super.add(BOS);
        this.predicates = new ArrayList<Predicate>();
    }

    public Sentence(SentenceData09 data) {
        this();
        int i;
        for (i = 0; i < data.forms.length; ++i) {
            Word nextWord = new Word(data.forms[i], data.plemmas[i], data.ppos[i], data.pfeats[i], this);
            super.add(nextWord);
        }
        for (i = 0; i < data.forms.length; ++i) {
            Word curWord = (Word)super.get(i + 1);
            curWord.setHead((Word)super.get(data.pheads[i]));
            curWord.setDeprel(data.plabels[i]);
        }
        this.buildDependencyTree();
    }

    public Sentence(String[] words, String[] lemmas, String[] tags, String[] morphs) {
        this();
        for (int i = 1; i < words.length; ++i) {
            Word nextWord = new Word(words[i], lemmas[i], tags[i], morphs[i], this);
            super.add(nextWord);
        }
    }

    private void addPredicate(Predicate pred) {
        this.predicates.add(pred);
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public void buildDependencyTree() {
        for (int i = 1; i < this.size(); ++i) {
            Word curWord = (Word)this.get(i);
            curWord.setHead((Word)this.get(curWord.getHeadId()));
        }
    }

    public void buildSemanticTree() {
        for (int i = 0; i < this.predicates.size(); ++i) {
            Predicate pred = this.predicates.get(i);
            for (int j = 1; j < super.size(); ++j) {
                Word curWord = (Word)this.get(j);
                String arg = curWord.getArg(i);
                if (arg.equals("_")) continue;
                pred.addArgMap(curWord, arg);
            }
        }
        for (Word w : this) {
            w.clearArgArray();
        }
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (int i = 1; i < super.size(); ++i) {
            Word w = (Word)super.get(i);
            ret.append(i).append("\t").append(w.toString());
            if (!(w instanceof Predicate)) {
                ret.append("\t_\t_");
            }
            for (int j = 0; j < this.predicates.size(); ++j) {
                ret.append("\t");
                Predicate pred = this.predicates.get(j);
                String tag = pred.getArgumentTag(w);
                ret.append(tag != null ? tag : "_");
            }
            ret.append("\n");
        }
        return ret.toString().trim();
    }

    public void makePredicate(int wordIndex) {
        Predicate p = new Predicate((Word)super.get(wordIndex));
        super.set(wordIndex, p);
        this.addPredicate(p);
    }

    public String[] getFormArray() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = ((Word)this.get((int)i)).Form;
        }
        return ret;
    }

    public String[] getPOSArray() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = ((Word)this.get((int)i)).POS;
        }
        return ret;
    }

    public String[] getFeats() {
        String[] ret = new String[this.size()];
        ret[0] = "<no-type>";
        for (int i = 1; i < this.size(); ++i) {
            ret[i] = ((Word)this.get(i)).getFeats();
        }
        return ret;
    }

    public void setHeadsAndDeprels(int[] heads, String[] deprels) {
        for (int i = 0; i < heads.length; ++i) {
            Word w = (Word)this.get(i + 1);
            w.setHead((Word)this.get(heads[i]));
            w.setDeprel(deprels[i]);
        }
    }

    public static Sentence newDepsOnlySentence(String[] lines) {
        Sentence ret = new Sentence();
        for (String line : lines) {
            String[] cols = WHITESPACE_PATTERN.split(line, 13);
            Word nextWord = new Word(cols, ret);
            ret.add(nextWord);
        }
        ret.buildDependencyTree();
        return ret;
    }

    public static Sentence newSentence(String[] lines) {
        Sentence ret = new Sentence();
        for (String line : lines) {
            Word nextWord;
            String[] cols = WHITESPACE_PATTERN.split(line);
            if (cols[12].equals("Y")) {
                Predicate pred = new Predicate(cols, ret);
                ret.addPredicate(pred);
                nextWord = pred;
            } else {
                nextWord = new Word(cols, ret);
            }
            ret.add(nextWord);
        }
        ret.buildDependencyTree();
        ret.buildSemanticTree();
        return ret;
    }

    public static Sentence newSRLOnlySentence(String[] lines) {
        Sentence ret = new Sentence();
        for (String line : lines) {
            Word nextWord;
            String[] cols = WHITESPACE_PATTERN.split(line, 13);
            if (cols[12].charAt(0) == 'Y') {
                Predicate pred = new Predicate(cols, ret);
                ret.addPredicate(pred);
                nextWord = pred;
            } else {
                nextWord = new Word(cols, ret);
            }
            ret.add(nextWord);
        }
        ret.buildDependencyTree();
        return ret;
    }
}

