/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.corpus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.languages.Language;

public class PredicateReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, PredicateMap> map = new HashMap<String, PredicateMap>();
    private String[] POSPrefixes;

    public PredicateReference(String[] POSPrefixes) {
        this.POSPrefixes = POSPrefixes;
        for (String prefix : POSPrefixes) {
            this.map.put(prefix, new PredicateMap(prefix));
        }
    }

    public void extractSense(Predicate p) {
        String predPOS = p.getPOS();
        for (String prefix : this.POSPrefixes) {
            if (!predPOS.startsWith(prefix)) continue;
            this.map.get(prefix).add(p.getLemma(), p.getSense());
            return;
        }
        if (!Learn.learnOptions.skipNonMatchingPredicates) {
            this.map.get(this.POSPrefixes[0]).add(p.getLemma(), p.getSense());
        }
    }

    public void trim() {
        for (PredicateMap pm : this.map.values()) {
            pm.trim();
        }
    }

    public String getFileName(String lemma, String POSPrefix) {
        Value v = (Value)this.map.get(POSPrefix).map.get(lemma);
        return v == null ? null : v.filename;
    }

    public int getLabel(String lemma, String POSPrefix, String sense) {
        return ((Value)((PredicateMap)this.map.get((Object)POSPrefix)).map.get((Object)lemma)).senses.indexOf(sense);
    }

    public String getSense(String lemma, String POSPrefix, Integer label) {
        return ((Value)((PredicateMap)this.map.get((Object)POSPrefix)).map.get((Object)lemma)).senses.get(label);
    }

    public String getSimpleSense(String lemma, String prefix) {
        PredicateMap predicateMap = this.map.get(prefix);
        if (predicateMap == null) {
            return Language.getLanguage().getDefaultSense(lemma);
        }
        Value v = (Value)predicateMap.map.get(lemma);
        if (v == null) {
            return Language.getLanguage().getDefaultSense(lemma);
        }
        return v.senses.get(0);
    }

    private static class Value
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String filename;
        ArrayList<String> senses;

        private Value() {
        }
    }

    private static class PredicateMap
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, Value> map = new HashMap<String, Value>();
        private int lemmaCounter = 0;
        private String POS;

        public PredicateMap(String POS) {
            this.POS = POS;
        }

        private void add(String lemma, String sense) {
            if (this.map.containsKey(lemma)) {
                Value v = this.map.get(lemma);
                if (!v.senses.contains(sense)) {
                    v.senses.add(sense);
                }
            } else {
                Value v = new Value();
                v.filename = this.POS + ++this.lemmaCounter;
                v.senses = new ArrayList();
                v.senses.add(sense);
                this.map.put(lemma, v);
            }
        }

        public void trim() {
            for (Value v : this.map.values()) {
                if (v.senses.size() == 1) {
                    v.filename = null;
                }
                v.senses.trimToSize();
            }
        }
    }
}

