/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.corpus;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;

public class Predicate
extends Word {
    private static final long serialVersionUID = 1L;
    private Map<Word, String> argmap;
    private String sense;

    public Predicate(Word w) {
        super(w);
        this.argmap = Learn.learnOptions != null && Learn.learnOptions.deterministicPipeline ? new TreeMap<Word, String>(this.mySentence.wordComparator) : new HashMap<Word, String>();
    }

    public Predicate(String[] CoNLL2009Columns, Sentence s) {
        super(CoNLL2009Columns, s);
        if (CoNLL2009Columns.length > 13) {
            this.sense = CoNLL2009Columns[13];
        }
        this.argmap = Learn.learnOptions != null && Learn.learnOptions.deterministicPipeline ? new TreeMap<Word, String>(this.mySentence.wordComparator) : new HashMap<Word, String>();
    }

    public Map<Word, String> getArgMap() {
        return this.argmap;
    }

    public void setArgMap(Map<Word, String> argmap) {
        this.argmap = argmap;
    }

    public void addArgMap(Word w, String label) {
        this.argmap.put(w, label);
    }

    public String getSense() {
        return this.sense;
    }

    public void setSense(String sense) {
        this.sense = sense;
    }

    @Override
    public String getAttr(Word.WordData attr) {
        if (attr == Word.WordData.Pred) {
            return this.sense;
        }
        return super.getAttr(attr);
    }

    public String getArgumentTag(Word w) {
        return this.argmap.get(w);
    }

    @Override
    public String toString() {
        return super.toString() + "\tY\t" + this.sense;
    }
}

