/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.corpus;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import se.lth.cs.srl.corpus.Word;

public class ArgMap
extends HashMap<Word, String> {
    private static final long serialVersionUID = 1L;
    private double prob;
    private double idProb;
    private double lblProb;
    private double rerankProb;
    public static final Comparator<ArgMap> PROB_COMPARATOR = new Comparator<ArgMap>(){

        @Override
        public int compare(ArgMap arg0, ArgMap arg1) {
            if (arg0.prob < arg1.prob) {
                return -1;
            }
            if (arg0.prob == arg1.prob) {
                return 0;
            }
            return 1;
        }
    };
    public static final Comparator<ArgMap> REVERSE_PROB_COMPARATOR = Collections.reverseOrder(PROB_COMPARATOR);

    public ArgMap() {
        this.prob = 1.0;
    }

    public ArgMap(ArgMap argmap) {
        super(argmap);
        this.prob = argmap.prob;
        this.idProb = argmap.idProb;
        this.lblProb = argmap.lblProb;
        this.rerankProb = argmap.rerankProb;
    }

    public ArgMap(Map<Word, String> argMap) {
        super(argMap);
    }

    public String put(Word arg, String argLabel, double prob) {
        this.multiplyProb(prob);
        return super.put(arg, argLabel);
    }

    public void multiplyProb(double prob) {
        this.prob *= prob;
    }

    public double computeScore(Map<Word, String> goldStandard) {
        if (this.size() == 0 && goldStandard.size() == 0) {
            return 1.0;
        }
        int tp = 0;
        int fp = 0;
        int fn = 0;
        for (Word w : this.keySet()) {
            if (goldStandard.containsKey(w)) {
                String propLabel;
                String goldLabel = goldStandard.get(w);
                if (goldLabel.equals(propLabel = (String)this.get(w))) {
                    ++tp;
                    continue;
                }
                ++fn;
                ++fp;
                continue;
            }
            ++fp;
        }
        for (Word w : goldStandard.keySet()) {
            if (this.containsKey(w)) continue;
            ++fn;
        }
        double p = (double)tp / (double)(tp + fp);
        double r = (double)tp / (double)(tp + fn);
        if (p + r > 0.0) {
            return 2.0 * p * r / (p + r);
        }
        return 0.0;
    }

    @Override
    public String toString() {
        return "Prob: " + this.prob + ", IDProb: " + this.idProb + ", LblProb: " + this.lblProb + ", RerankProb: " + this.rerankProb + ". " + super.toString();
    }

    public double getProb() {
        return this.prob;
    }

    public void setProb(double prob) {
        this.prob = prob;
    }

    public void resetProb() {
        this.prob = 1.0;
    }

    public double getIdProb() {
        return this.idProb;
    }

    public void setIdProb(double idProb) {
        this.idProb = idProb;
    }

    public double getLblProb() {
        return this.lblProb;
    }

    public void setLblProb(double lblProb) {
        this.lblProb = lblProb;
    }

    public double getRerankProb() {
        return this.rerankProb;
    }

    public void setRerankProb(double rerankProb) {
        this.rerankProb = rerankProb;
    }
}

