/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl;

import java.util.zip.ZipFile;
import se.lth.cs.srl.SemanticRoleLabeler;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.io.AbstractCoNLL09Reader;
import se.lth.cs.srl.io.CoNLL09Writer;
import se.lth.cs.srl.io.DepsOnlyCoNLL09Reader;
import se.lth.cs.srl.io.SRLOnlyCoNLL09Reader;
import se.lth.cs.srl.options.ParseOptions;
import se.lth.cs.srl.pipeline.Pipeline;
import se.lth.cs.srl.pipeline.Reranker;
import se.lth.cs.srl.pipeline.Step;
import se.lth.cs.srl.util.Util;

public class Parse {
    public static ParseOptions parseOptions;

    public static void main(String[] args) throws Exception {
        SemanticRoleLabeler srl;
        long startTime = System.currentTimeMillis();
        parseOptions = new ParseOptions(args);
        if (Parse.parseOptions.useReranker) {
            srl = new Reranker(parseOptions);
        } else {
            ZipFile zipFile = new ZipFile(Parse.parseOptions.modelFile);
            srl = Parse.parseOptions.skipPI ? Pipeline.fromZipFile(zipFile, new Step[]{Step.pd, Step.ai, Step.ac}) : Pipeline.fromZipFile(zipFile);
            zipFile.close();
        }
        CoNLL09Writer writer = new CoNLL09Writer(Parse.parseOptions.output);
        AbstractCoNLL09Reader reader = Parse.parseOptions.skipPI ? new SRLOnlyCoNLL09Reader(Parse.parseOptions.inputCorpus) : new DepsOnlyCoNLL09Reader(Parse.parseOptions.inputCorpus);
        int senCount = 0;
        for (Sentence s : reader) {
            if (++senCount % 100 == 0) {
                System.out.println("Parsing sentence " + senCount);
            }
            srl.parseSentence(s);
            writer.write(s);
        }
        writer.close();
        reader.close();
        long totalTime = System.currentTimeMillis() - startTime;
        System.out.println("Done.");
        System.out.println(srl.getStatus());
        System.out.println();
        System.out.println("Total execution time: " + Util.insertCommas(totalTime) + "ms");
    }
}

