/* Test struct */

int expect(int a, int b)
{
    if (!(a == b)) {
        printf("Failed\n");
        printf("  %d expected, but got %d\n", a, b);
        exit(1);
    }
}

int t1()
{
    struct {
        int a;
    } x;
    x.a = 61;
    expect(61, x.a);
}

int t2()
{
    struct {
        int a;
        int b;
    } x;
    x.a = 61;
    x.b = 2;
    expect(63, x.a + x.b);
}

int t3()
{
    struct {
        int a;
        struct {
            char b;
            int c;
        } y;
    } x;
    x.a = 61;
    x.y.b = 3;
    x.y.c = 3;
    expect(67, x.a + x.y.b + x.y.c);
}

int t4()
{
    struct tag4 {
        int a;
        struct {
            char b;
            int c;
        } y;
    } x;
    struct tag4 s;
    s.a = 61;
    s.y.b = 3;
    s.y.c = 3;
    expect(67, s.a + s.y.b + s.y.c);
}

int t5()
{
    struct tag5 {
        int a;
    } x;
    struct tag5 *p = &x;
    x.a = 68;
    expect(68, (*p).a);
}

int t6()
{
    struct tag6 {
        int a;
    } x;
    struct tag6 *p = &x;
    (*p).a = 69;
    expect(69, x.a);
}

int t7()
{
    struct tag7 {
        int a;
        int b;
    } x;
    struct tag7 *p = &x;
    x.b = 71;
    expect(71, (*p).b);
}

int t8()
{
    struct tag8 {
        int a;
        int b;
    } x;
    struct tag8 *p = &x;
    (*p).b = 72;
    expect(72, x.b);
}

int t9()
{
    struct tag9 {
        int a[3];
        int b[3];
    } x;
    x.a[0] = 73;
    expect(73, x.a[0]);
    x.b[1] = 74;
    expect(74, x.b[1]);
    expect(74, x.a[4]);
}

struct tag10 {
    int a;
    struct tag10a {
        char b;
        int c;
    } y;
} v10;
int t10()
{
    v10.a = 71;
    v10.y.b = 3;
    v10.y.c = 3;
    expect(77, v10.a + v10.y.b + v10.y.c);
}

struct tag11 {
    int a;
} v11;
int t11()
{
    struct tag11 *p = &v11;
    v11.a = 78;
    expect(78, (*p).a);
    expect(78, v11.a);
    expect(78, p->a);
    p->a = 79;
    expect(79, (*p).a);
    expect(79, v11.a);
    expect(79, p->a);
}

struct tag12 {
    int a;
    int b;
} x;
int t12()
{
    struct tag12 a[3];
    a[0].a = 83;
    expect(83, a[0].a);
    a[0].b = 84;
    expect(84, a[0].b);
    a[1].b = 85;
    expect(85, a[1].b);
    int *p = a;
    expect(85, p[3]);
}

int main()
{
    t1();
    t2();
    t3();
    t4();
    t5();
    t6();
    t7();
    t8();
    t9();
    t10();
    t11();
    t12();

    return 0;
}
