# General Approach

This is a relaxed and welcoming space for those looking to make their first open source contributions. This is my general approach toward pull requests:

- It doesn't have to be perfect – if it works but needs some optimisation I'll still merge it
- If there are optimisations that can be made we can open a new issue to address them
- Expectations will be a little higher for more experienced contributors

To begin, please check the [issues](https://github.com/jrobind/dev-jot/issues) to see where you can contribute.

## Issue Label/Tagging Breakdown

Checking the open issues is a great place to see what's currently being worked on and also what's available to work on. Labels are used to group different issues by status, type, and difficulty. The main labels you should be aware of are:

- react
- bug
- enhancement
- good first issue
- code level easy
- code level medium
- code level hard
- in progress
- ready to work on
- discussion

**To claim an issue to work on please write a comment on the issue letting me know you'd like to take it on. Once the issue has been claimed the 'in progress' label will be added.**

If something doesn't make sense please ask for clarification or assistance by writing a comment on the issue, or if you'd like to discuss in more detail please join the [Discord channel](https://discord.com/invite/YMsd9sgZ4f).

## Pull Requests

There are currently two versions of the app. 

1. The default (vanilla) version can be found within the `app-main` directory. For set up, please go [here](https://github.com/jrobind/dev-jot/blob/master/README.md#project-set-up).

2. The React version can be found within the `app-react` directory. For set up, please go [here](https://github.com/jrobind/dev-jot/blob/master/app-react/README.md#project-set-up).

Before submitting a PR that relates directly to an issue, please write a comment on the relevant issue letting me know you'd like to take it on. Once the issue has been claimed the 'in progress' label will be added. After long periods of inactivity, I'll remove the 'in progress' label so someone else can work on it.

If you've never submitted a pull request before then I would recommend you check out this guide: [How to create a pull request on GitHub.](https://www.digitalocean.com/community/tutorials/how-to-create-a-pull-request-on-github)

Don't panic if you feel as though your code isn't quite up-to-scratch. This is an opportunity for you to learn and to receive feedback. If your code needs some work then please see this as a positive experience and opportunity to improve.

Pull requests big or small will be accepted, however, if you are submitting a major feature then please make sure you create an issue for discussion before attempting this work, likewise if you spot a bug please raise a new issue before creating a pull request.
