# Using the update framework

Managing updates to applications can be tedious. The _update framework for
AdobeAIR applications_ provides APIs that enable developers to provide
robustupdate capabilities in AIR applications. The AIR update framework performs
the following tasks for developers:

- Periodically check for updates based on an interval or when the user requests

- Download AIR files (updates) from a web source

- Alert the user on the first run of the newly installed version

- Confirm that the user wants to check for updates

- Display information on the new update version to the user

- Display download progress and error information to the user

The AIR update framework supplies a sample user interface for your application.
It provides the user with basic information and configuration options for
application updates. Your application can also define a custom user interface
for use with the update framework.

The AIR update framework lets you store information about the update version of
an AIR application in simple XML configuration files. For most applications,
setting up these configuration files to include basic code provides a good
update functionality to the end user.

Even without using the update framework, Adobe AIR includes an Updater class
that AIR applications can use to upgrade to new versions. The Updater class lets
an application upgrade to a version contained in an AIR file on the user's
computer. However, upgrade management can involve more than simply having the
application update based on a locally stored AIR file.

- [AIR update framework files](WS436E8E33-B9A3-49c9-A914-84035319B7DA.html)
- [Setting up your Flex development environment](WS01EC1957-C9FB-484d-9AA4-D7293468133D.html)
- [Including framework files in an HTML-based AIR application](WSF03EE194-4501-482d-BB53-99E6F51C6D44.html)
- [Basic example: Using the ApplicationUpdaterUI version](WS96E10DFB-39A5-4488-A666-15B9B46C5EE8.html)
- [Updating to AIR 2.5](WSfffb011ac560372f-3559cf7812b5ab123af-8000.html)
- [Defining the update descriptor files and adding the AIR file to your web server](WS3A1F0087-BF77-45ed-B442-E654E5C7E8F1.html)
- [Instantiating an updater object](WSA28FD1A6-320F-4cdc-8B2E-FEEE2BBAF0AC.html)
- [Configuring the update settings](WS83C043EC-9D2C-4db9-AA1F-352EE2E30892.html)
- [The update process](WSDB4AA835-A13F-40f1-AB5C-610EE25BCDE1.html)
- [Initializing the update framework](WS6C09B923-6464-472e-8EDA-0BAA0A2FFCA1.html)
- [Managing the update process in the ApplicationUpdaterUI version](WS3E12395C-1F02-4314-A040-B12F2E800EE8.html)
- [Managing the update process in the ApplicationUpdater version](WS7416A939-B5AD-4e77-AB3C-D0FFE5D20471.html)
- [Installing from an arbitrary AIR file](WS1C85A6A7-F137-4f5a-966C-95D5CF92C513.html)
- [Canceling the update process](WSF3DE47E9-2009-49b2-966D-35DF9F93CC45.html)
- [Localizing the ApplicationUpdaterUI interface](WS35FDB8D9-5684-44ad-829D-DFA53A7ED75A.html)
