# Creating a self-signed certificate with ADT

You can use self-signed certificates to produce a valid AIR installation file.
However, self-signed certificates only provide limited security assurances to
your users. The authenticity of self-signed certificates cannot be verified.
When a self-signed AIR file is installed, the publisher information is displayed
to the user as Unknown. A certificate generated by ADT is valid for five years.

If you create an update for an AIR application that was signed with a
self-generated certificate, you must use the same certificate to sign both the
original and update AIR files. The certificates that ADT produces are always
unique, even if the same parameters are used. Thus, if you want to self-sign
updates with an ADT-generated certificate, preserve the original certificate in
a safe location. In addition, you will be unable to produce an updated AIR file
after the original ADT-generated certificate expires. (You can publish new
applications with a different certificate, but not new versions of the same
application.)

Important: Because of the limitations of self-signed certificates, Adobe
strongly recommends using a commercial certificate issued by a reputable
certification authority for signing publicly released AIR applications.

The certificate and associated private key generated by ADT are stored in a
PKCS12-type keystore file. The password specified is set on the key itself, not
the keystore.

#### Certificate generation examples

    adt -certificate -cn SelfSign -ou QE -o "Example, Co" -c US 2048-RSA newcert.p12 39#wnetx3tl
    adt -certificate -cn ADigitalID 1024-RSA SigningCert.p12 39#wnetx3tl

To use these certificates to sign AIR files, you use the following signing
options with the ADT `-package` or `-prepare` commands:

    -storetype pkcs12 -keystore newcert.p12 -storepass 39#wnetx3tl
    -storetype pkcs12 -keystore SigningCert.p12 -storepass 39#wnetx3tl

> **Note:** Java versions 1.5 and above do not accept high-ASCII characters in
> passwords used to protect PKCS12 certificate files. Use only regular ASCII
> characters in the password.
