# Developing AIR applications for mobile devices

AIR applications on mobile devices are deployed as native applications. They use
the application format of the device, not the AIR file format. Currently AIR
supports Android APK packages and iOS IPA packages. Once you have created the
release version of your application package, you can distribute your app through
the standard platform mechanism. For Android, this typically means the Android
Market; for iOS, the Apple App Store.

You can use the [AIR SDK](https://airsdk.harman.com/) and Flash Professional,
Flash Builder, or another ActionScript development tool to build AIR apps for
mobile devices. HTML-based mobile AIR apps are not currently supported.

> **Note:** The Research In Motion (RIM) BlackBerry Playbook provides its own
> SDK for AIR development. For information on Playbook development, see
> [RIM: BlackBerry Tablet OS Development](https://web.archive.org/web/20120215075832/https://bdsc.webapps.blackberry.com/air/).

> **Note:** This document describes how to develop iOS applications using the
> AIR 2.6 SDK or later. Applications created with AIR 2.6+ can be installed on
> iPhone 3Gs, iPhone 4, and iPad devices running iOS 4, or later. To develop AIR
> applications for earlier versions of iOS, you must use the AIR 2 Packager for
> iPhone as described in
> [Building iPhone apps](https://web.archive.org/web/20150414032840/http://help.adobe.com/en_US/as3/iphone/index.html).

For more information on privacy best practices, see
[Adobe AIR SDK Privacy Guide](https://web.archive.org/web/20180415053853/https://helpx.adobe.com/air/licenses/air-sdk-privacy-guidelines.html).

For the full system requirements for running AIR applications, see
[Adobe AIR system requirements](https://web.archive.org/web/20200408200256/https://www.adobe.com/products/air/tech-specs.html).

- [Setting up your development environment](WS2d929364fa0b81371f0a344f12a2038d1f4-8000.html)
- [Mobile application design considerations](WSfffb011ac560372f82c4ee412b1275403b-8000.html)
- [Workflow for creating AIR applications for mobile devices](WS901d38e593cd1bac1e63e3d1295c1072d7-8000.html)
- [Setting mobile application properties](WSfffb011ac560372f-5d0f4f25128cc9cd0cb-7ffe.html)
- [Packaging a mobile AIR application](WSfffb011ac560372f-5d0f4f25128cc9cd0cb-7ffb.html)
- [Debugging a mobile AIR application](WSfffb011ac560372f-5d0f4f25128cc9cd0cb-7ffa.html)
- [Installing AIR and AIR applications on mobile devices](WSfffb011ac560372f-5d0f4f25128cc9cd0cb-7ff6.html)
- [Updating mobile AIR applications](WS901d38e593cd1bac-77bd3ea112e2c0a7ed0-8000.html)
- [Use push notifications](WSd6d4f896b3a8801b7be2f55d138e29d5e40-8000.html)
