[![Netlify Status](https://api.netlify.com/api/v1/badges/f4455669-0ce8-40ea-8ff5-5c31f0aadfa5/deploy-status)](https://app.netlify.com/sites/skeleventy/deploys)

# An Eleventy starter skeleton

Skeleventy gives you a rock solid foundation to build fast and accessible static websites. [View the demo site](http://skeleventy.netlify.app/).

## Features

- A clean, minimal build pipeline with SCSS and [Laravel Mix](https://laravel-mix.com/docs/5.0/basic-example) for compiling assets
- [Gorko](https://github.com/hankchizljaw/gorko), a smart little Sass-powered utility class generator
- [Purgecss](https://purgecss.com/) to remove unused CSS
- HTML minifier
- Supports ES2017 JavaScript, with Babel compilation
- SEO friendly page meta, including Open Graph and Twitter
- Image lazy loading
- Mobile navigation
- XML Sitemap
- Clean and simple blog, with categories and featured images

## Getting started

### Prerequisites
Node `v10+`

### Installation

1. Clone the repo `git clone https://github.com/josephdyer/skeleventy.git`
2. `cd` into the project folder and run `npm install`
3. Start the local development server by running `npm run dev` **Tip:** _Eleventy has live reload baked in!_

## Folder structure

### Eleventy

- `site/` contains all the global data, templates and content
- `utilities/` contains Eleventy helper `filters` and `transforms`
- Each page should have it's own respective folder containing an `index.md` file
- You can then choose the most appropriate layout for each page (or create more if you need to)
- The navigation is powered by the official [Eleventy navigation plugin](https://www.11ty.dev/docs/plugins/navigation/)

### Assets

- `css/` for compiled CSS
- `js/` for compiled JavaScript
- `images/` contains our site's images, an SVG icon sprite and a folder for meta images (OG, Twitter etc)

## The build pipeline

[Laravel Mix](https://laravel-mix.com/docs/5.0/basic-example) gives us a nice API layer on top of Webpack. Skeleventy uses a simplistic set up, but you _can_ take advantage of extending Mix with custom Webpack configurations, code splitting and plugins such as PostCSS, if you so wish.

You'll find the site's uncompiled SCSS and JS within `resources/` where Mix will be watching these directories for any changes. **Tip:** _it's best to always restart the server when creating any new partials or folders_

### SCSS

- `scss/` is structured into opinionated sub folders
- The `_config.scss` file is where you can change the site's colours and the utility classes generated by Gorko
- A typographic scale has already been set up using my personal favourite _Major Third_ scale.
- **Tip:** *for more scales, check out [Type Scale](https://type-scale.com/)*

### Gorko

I decided to remove Tailwind in favour of Gorko, purely for its simplicity and maintainability (especially for newer developers). Not having _too much_ to begin with and adding in what you need, will lead to a simpler, more maintainable codebase. Gorko lets you add a sprinkle of reusable utility classes to help keep your code DRY. _Credit to [Andy Bell](https://piccalil.li/) for making this handy little tool_

### JavaScript

- `utilities/` contains any global utility/helper functions
- `modules/` contains your site's actual JavaScript, all kept neat and tidy within their respective _modular_ subfolders
- You can import these subfolders into `main.js` using `import '@modules/example-module'`
- **Tip:** *you can set up optional import aliases via the `webpack.mix.js` file*

### A note on responsive images

Skeleventy doesn't have responsive images baked in, the main reason being: it's best using [CDN](https://cloudinary.com/invites/lpov9zyyucivvxsnalc5/zsykhj88yzvi0i8kugfs). Check out this [tutorial on setting up Eleventy with Cloudinary](https://sia.codes/posts/eleventy-and-cloudinary-images/).
