# Introduction

Frontile aims to provide the legos (components, helpers, modifiers, and styles)
necessary for building consistent and powerful Ember.js apps while following best
practices from the community and providing both low-level and high-level components for your application.

- Built with accessibility in mind into every component;
- Built as logically separated packages, so you can choose the pieces you're going to use;
- Written in TypeScript;
- All components are Glimmer components;
- Styles are just TailwindCSS plugins, and fully responsive;

## What is available?

There are a few packages available to use already; you can use them in your
applications today if you are in a supported Ember version. The project is
still pre-version 1.0.0, so breaking changes can still occur.


- `@frontile/buttons`: Components for working with buttons.
- `@frontile/collections`: Components like Listbox and dropdown menu.
- `@frontile/overlays`: Components to render content over the UI, like Modal Dialogs.
- `@frontile/notifications`: Package that provides toast-like notifications.
- `@frontile/forms`: Components for working with forms.
- `@frontile/changeset-form`: Integration between the Forms package and [Changeset](https://github.com/poteto/ember-changeset).
- `@frontile/utilities`: Utility components.
- `@frontile/status`: Components like progress bar.
- `@frontile/theme`: Theming capabilities using [Tailwind Variants](https://www.tailwind-variants.org/).
