# 📝 Contributing Guidelines

**Welcome to unsaged!** 🎉

We're thrilled that you're considering contributing to our project. Your support is essential in maintaining and enhancing the quality of unsaged.

Before you start, we highly recommend that you read through our contributing guidelines. This will ensure a smooth and effective collaboration. 📚

## 🚀 Ways to Contribute

We appreciate all types of contributions. Here are some ways you can contribute:

- 🐛 **Bug Fixes**: Found a bug? Don't hesitate to fix it and submit a pull request.
- ✨ **Feature Additions**: Got a feature in mind? Implement it and submit a pull request. We're excited to see your ideas come to life!
- 📚 **Documentation**: If you can enhance our documentation to make it clearer and more informative, we welcome your contributions.
- 🏎 **Code Optimization**: If you can make our code more efficient, we'd love to hear from you!
- 🌐 **Translations**: Help us make our project accessible to more users by providing translations.
- 🧪 **Testing**: Help us improve the robustness of our code by enhancing our test coverage.

## 🏁 Getting Started

Here's a step-by-step guide to help you start with your contribution:

1. Fork the project on GitHub: This creates your own copy of our project where you can make your changes.
2. Clone your forked repository to your local machine: This allows you to work on the changes locally.
3. Create a new branch from the main branch: This ensures that your changes are isolated and can be reviewed independently.
4. Make your changes on the new branch: This is your moment to bring your contribution to life!
5. Ensure that your changes adhere to our code style guidelines and pass our automated tests: This helps maintain the quality and consistency of our codebase.
6. Commit your changes and push them to your forked repository: This saves your changes and prepares them for submission.
7. Submit a pull request to the main branch of the main repository: This is the final step where you submit your contribution for review.

## 📧 Contact

If you have any questions or need help getting started, don't hesitate to reach out to me via [e-mail](mailto:jorge@useatlas.ai).
