#MetaflowOfflinePredict

The `MetaflowOfflinePredict` class is a subclass of `BasePredict` and provides methods for running a Metaflow flow object and obtaining artifacts from the `MetaflowOfflinePredict` pipeline.

## Attributes

- `METAFLOW_CLASS` - The name of the class that inherits from metaflow's `FlowSpec`

## Configuration 

### Required Configuration 

`MetaflowOfflinePredict` requires the following component types: 

- `data_connector`
- `metadata_tracker`
- `resource_version_control`
- `model_explainer`
- `data_checker`
- `data_profiler` 

## Methods

### run 
This method loads and runs a provided Metaflow flow with the provided inputs.

```python 
def run(self, model, model_version, data, dataset_version, **kwargs)
```


**Arguments**:

- `model` (object): The model object to use for predictions.
- `model_version` (object): The model version of the model object
- `data` (object): The prediction data
- `dataset_version` (object): The dataset version of the prediction data


**Returns**:

- `None`


## get_artifacts 

```python 
def get_artifacts(self, artifact_keys)
```
This method gets the artifacts generated by the Metaflow flow.

**Arguments**:

- `artifact_keys` (list): A list of artifact keys.

**Returns**:

- `artifacts` (dict): A dictionary containing the requested artifacts.


## MetaflowOfflinePredictSpec Methods

`MetaflowOfflinePredictSpec` contains the following methods. These are mirrored from the `OfflinePredict` class, and you should see that documentation for more information (Note: instead of these method explicitly using arguments, they instead access saved artifacts during the Metaflow run). 

- `start`
- `compate_data`
- `get_predictions`
- `track_predictions`
- `analyze_prediction_drift`
- `check_predicitons`
- `save_predictions`
- `end`