
lolpop comes with several examples that show leveraging the framework to solve different use cases. These are useful for a variety of reasons: 

1. They provide working examples of using existing lolpop integrations. 
2. They can likely be adapted with slight modifications to fit existing use cases for users. 
3. They are a great starting point for developers who are looking to build their own integrations. 


We expect to build out more examples in time, and look forward to community contributions as well. If you're doing something cool with lolpop, feel free to get in touch and tell us about it. 

## Quickstart Examples 

The quickstart example are designed to get users to a successful result with a minimal amount of effort. Some components may require existing infrastructure, have complicated setup, or require user accounts set up on external systems. For these reasons, and more, quickstart examples avoid using those kind of components and focus solely on running a workflow quickly. 

These are not intended for production use, nor do we suggest these mirror real workloads. Instead, it's simply a good way for users to get started in the system and start seeing lolpop in action. We would typically recommend getting started with a quickstart example before moving into something more complex. 

## Regular Examples

Regular examples, on the other hand, are meant to try to tackle a full use case, from end to end. This will likely involve non-trivial infrastructure requirements, setup, and it may take awhile for the use case to run. 

These should be *excellent examples* to pull from as you start migrating your own workloads into lolpop. 

## In This Section 

- Quick Start Examples: 
    - [Classification](classification_quickstart.md)
    - [Regression](regression_quickstart.md)
    - [Time Series Forecasting](timeseries_forecasting_quickstart.md)
- Regular Examples 
    - [Classification](classification.md)
    - [Regression](regression.md)
    - [Time Series Forecasting](timeseries_forecasting.md)
- Metaflow Examples 
    - [Classification](classification_metaflow.md)
    - [Regression](regression_metaflow.md)
    - [Time Series Forecasting](timeseries_forecasting_metaflow.md)
