# EvidentlyAIDataChecker

This class generates a data check report using EvidentlyAI and provides a summary of the data quality tests run. In particular, this runs the [Data Quality Test Suite](https://docs.evidentlyai.com/presets/data-quality#data-quality-test-suite). 

## Configuration

### Required Configuration
The EvidentlyAI data checker requires the following configuration: 

- `local_dir`: Location of a local directory to output files generated by this component. 

### Optional Configuration
The EvidentlyAI data checker has no optional configuration.

### Default Configuration
The EvidentlyAI data checker uses the following optional configuration: 

- `evidentlyai_report_name`: The file name of the generated report. Defaults to `EVIDENTLYAI_DATA_REPORT.HTML`. 


## Methods:
The following are the methods available in the `EvidentlyAIDataChecker` class: 

- `check_data` 

### check_data
```python
check_data(self,data,*args,**kwargs)
```

This method generates a data check report using EvidentlyAI.

**Arguments:**

- `data` (pandas.DataFrame): A pandas DataFrame of the data to check.


**Returns:**

- `data_report` *(object)*: A Python object of the data report.

- `file_path` *(string)*: Path to the exported data check report.

- `checks_status` *(string)*: The status of the checks ("PASS","WARN","ERROR", etc.)

**Example:**

```python
from lolpop.component import EvidentlyAIDataChecker, StdOutLogger
import pandas as pd

# define input data
my_data = pd.DataFrame({'A': [1, 2, 3], 'B': [4, 5, 6], 'C': [7, 8, 9]})

#create component configuration
kwargs = {
    "conf" : {
        "config": {
            "local_dir": "/tmp/artifacts",
        },
    },
    "component": {
        "logger": StdOutLogger(),
    }
}

# instantiate the data checker class
data_checker = EvidentlyAIDataChecker(**kwargs)

#run data check 
data_report, file_path, checks_status = data_checker.check_data(data=my_data)

#print report path and checks status
print(f"Data check report saved at {file_path}. Checks status: {checks_status}")
```