# AlibiModelExplainer

This class provides methods to explain machine learning models using Alibi. It is a subclass of `BaseModelExplainer`.

## Configuration

### Required Configuration
The Alibi model explainer requires the following configuration: 

- `local_dir`: Location of a local directory to output files generated by this component. 
- `explainer_cl`: The [alibi.explainer](https://docs.seldon.io/projects/alibi/en/latest/api/alibi.explainers.html) class to user to generate explanations. 

### Optional Configuration
The Alibi model explainer uses no optional configuration: 


### Default Configuration
The Alibi model explainer uses the following optional configuration: 

- `skip_explainer_plots`: Whether or not to generate explainer plots. Defaults to `False`.

## Methods

### get_explanations
Generates feature importance scores for a given model and input data.

```python
def get_explanations(data, model, model_version, label, classification_type=None, to_list=False, skip_explainer_plots=True, *args, **kwargs)
```

**Arguments**:

- `data (pandas.DataFrame)`: The input data to explain the model.
- `model (object)`: The machine learning model to explain.
- `model_version (string)`: The model version obtained from the metadata_tracker.
- `label (string)`: The model target.
- `classification_type (string)`: The type of classification. This parameter is optional and only used if the problem type is classification.
- `to_list (boolean)`: If True, the returned explanations will be in a list format.
- `skip_explainer_plots (boolean)`: If True, skip the explainer plots.

**Returns**:

A dictionary containing explainer values.


### get_feature_importance 
Generates feature importance scores for train and test sets.

```python 
def get_feature_importance(data_dict, model, model_version, *args, **kwargs)
```

**Argumentss**:

- `data_dict (dict)`: A dictionary of the input data to explain.
- `model (object)`: The machine learning model to explain.
- `model_version (string)`: The model version obtained from the metadata_tracker.

**Returns**:

Tuple of two Alibi data objects:
- the feature importance for the training set.
- the feature importance for the test set.


### _get_shap_plots
Generates various SHAP plots for the given SHAP values and saves them as artifacts.

```python 
def _get_shap_plots(shap_values, expected_value, data, model, label, model_version, classification_type=None)
```

**Arguments**:

- `shap_values (numpy.ndarray)`: The SHAP values to generate the plots.
- `expected_value (float)`: The expected value of the model.
- `data (pandas.DataFrame)`: The input data to the model.
- `model (object)`: The machine learning model to explain.
- `label (string)`: A label for the data.
- `model_version (string)`: The model version.
- `classification_type (string)`: The type of classification.


### _save_pyplot 
Saves the generated plot as an artifact.

```python 
def _save_pyplot(name, label, model_version)
```

**Arguments**:

- `name (string)`: A name for the plot.
- `label (string)`: The label of the data.
- `model_version (string)`: The model version obtained from the metadata_tracker.

**Returns**:
The saved artifact.

### _save_file 
Saves the generated  plot to a file as an artifact.

```python 
def _save_file(name, label, content, model_version, extension="html")
```

**Arguments**:

- `name (string)`: A name for the file.
- `label (string)`: The label of the data.
- `content (string)`: The content of the file.
- `model_version (string)`: The version of the model to explain.
- `extension (string)`: The extension of the file.

**Returns**:

The saved artifact.

### _compare_train_test_feat_importance
Compares the feature importance scores between the train and test sets.

```python 
def _compare_train_test_feat_importance(explanations_train, explanations_test, classification_type, threshold=0.25)
```

**Arguments**:

- `explanations_train (pandas.DataFrame)`: The SHAP-based feature importance for the training set.
- `explanations_test (pandas.DataFrame)`: The SHAP-based feature importance for the test set.
- `classification_type (string)`: The type of classification.
- `threshold (float)`: A threshold value for checking the differences between train and test sets.

**Returns**:

Tuple containing the expected differences and the feature importance differences.

## Usage

```python
from lolpop.explainer import AlibiModelExplainer

... ## generate data, model, and model_verison 

config = {
    #insert component configuration
}

explainer = AlibiModelExplainer(conf=config)


# Generate SHAP-based feature importance scores for train and test sets
explanations_train, explanations_test = explainer.get_feature_importance(data_dict, model, model_version)
```