# SwiftUI Kit
A SwiftUI system components and interactions demo app based on iOS 17, macOS Sonoma, watchOS 10, and tvOS 17.

![SwiftUI Kit](https://user-images.githubusercontent.com/110813/87210094-5accf380-c2e2-11ea-91c9-4f21aa313bc6.png)

Use the SwiftUI Kit app to see how SwiftUI views appear and interact when using the system defaults. You can view the source to see how particular examples work.

Includes Buttons, Colors, Controls, Fonts, Haptics, Images, Indicators, Shapes, Text, and more. 

![iOS, iPadOS, macOS, watchOS, tvOS](https://user-images.githubusercontent.com/110813/87250474-f8cfd380-c432-11ea-830b-b90cce39a067.png)

![SwiftUI Kit examples](https://user-images.githubusercontent.com/110813/87210295-00806280-c2e3-11ea-91e3-4ea6da79f73e.png)

#### To run
Make sure you're using [Xcode 15+](https://developer.apple.com/xcode/) as well as a device running iOS 17+. Works on iPhone, iPad, Mac, Apple Watch, and Apple TV.

#### Accent color
To change the accent color and see how it affects the system components, go to the `AccentColor` section of `Assets.xcassets` in Xcode. You can then change the Light and Dark accent colors that will be applied to the app.

#### Contributing
Please feel free to submit pull requests in order to contribute back to SwiftUI Kit. This is for the SwiftUI community!

#### SwiftUI Resources
- [Recreate](https://recreatecode.com) - A video series about recreating popular UI with SwiftUI
- [Primitive](https://primitive.school) - Learn SwiftUI for designers

#### Apple Resources
- [Apple Human Interface Guidelines](https://developer.apple.com/design/human-interface-guidelines/) - Apple’s design guidelines for creating best-in-class apps.
- [SF Symbols](https://developer.apple.com/sf-symbols/) – Apple’s comprehensive library of vector-based symbols included in Apple’s system fonts that you can incorporate into your app.

By [Jordan Singer](https://ibuildmyideas.com) ([@jsngr](https://twitter.com/jsngr))

Credit [SwiftUI Apple Developer Documentation](https://developer.apple.com/documentation/swiftui) for many examples and terminology
