# 디자인 패턴 자바

<img align="right" alt="Unit Test" src="https://github.com/joonas-yoon/design-patterns-java/actions/workflows/junit.yml/badge.svg" />

Java로 구현해보는 디자인 패턴

> 디자인 패턴은 모든 문제를 해결할 수 없다. 참고할 뿐이다.

> 아래 목록은 알파벳순으로 정렬되었으며, **자주 사용되는 패턴은 굵게** 표시하였습니다.

### 생성 패턴 (Creational Design Patterns)

> 주로 생성 방식이나 절차를 결정하는 것과 관련된 패턴

- [x] **[Abstract Factory Pattern](src/main/designpatterns/abstractfactory)**
- [ ] Builder Pattern
- [x] **[Factory Method Pattern](src/main/designpatterns/factorymethod)**
- [ ] Prototype Pattern
- [x] **[Singleton Pattern](src/main/designpatterns/singleton)**

### 구조 패턴 (Structural Design Patterns)

> 구조를 유연하고 효율적으로 유지하거나, 더 큰 구조로 조립하는 등의 패턴

- [ ] **Adapter Pattern**
- [ ] Bridge Pattern
- [ ] **Composite Pattern**
- [x] **[Decorator Pattern](src/main/designpatterns/decorator)**
- [ ] **Facade Pattern**
- [ ] Flyweight Pattern
- [ ] **Proxy Pattern**

### 행동 패턴 (Behavioral Design Patterns)

> 클래스 간의 상호 작용이나 역할(책임)에 대해 다루는 패턴

- [ ] Chain of Responsibility Pattern
- [ ] Command Pattern
- [ ] Interpreter Pattern
- [ ] **Iterator Pattern**
- [ ] Mediator Pattern
- [ ] Memento Pattern
- [x] **[Observer Pattern](src/main/designpatterns/observer)**
- [ ] **State Pattern**
- [x] **[Strategy Pattern](src/main/designpatterns/strategy)**
- [ ] **Template Method Pattern**
- [ ] Visitor Pattern

### 그 외 (Miscellaneous Design Patterns)

1. [ ] DAO Design Pattern
2. [ ] Dependency Injection Pattern
3. [ ] MVC Pattern

## References

* https://github.com/RefactoringGuru/design-patterns-java
* https://refactoring.guru/ko/design-patterns
* https://www.digitalocean.com/community/tutorials/java-design-patterns-example-tutorial
* https://www.oreilly.com/library/view/head-first-design/0596007124/
