<?php
$language = [
    "en_US" => [
        "locale" => "us_EN",
        "dateformat" => "F d, Y",
        "settings_i18n" => "Internationalization:",
        "settings_blog_creation" => "Let's create your blog",
        "settings_blog_edition" => "Edit your blog's settings",
        "settings_first_time" => "First, some details...",
        "settings_welcome_back" => "Welcome back!",
        "settings_blog_name" => "Blog Name:",
        "settings_blog_name_placeholder" => "Enter your blog's name",
        "settings_blog_info" => "Blog Summary:",
        "settings_blog_info_placeholder" => "Enter a summary of your blog's content",
        "settings_blog_domain" => "Blog Domain:",
        "settings_blog_domain_placeholder" => "Enter the domain of your blog (i.e. blog.mysite.com)",
        "settings_blog_OGImage" => "OpenGraph Image:",
        "settings_blog_OGImage_placeholder" => "Enter the URL of an image you'd like displayed on social media sites",
        "settings_footer_message" => "Footer Message:",
        "settings_footer_message_placeholder" => "Enter an optional footer message",
        "settings_header_inject" => "Header Injection Code:",
        "settings_header_inject_placeholder" => "Enter an optional header injection, ie. analytics",
        "settings_template" => "Site Template Name:",
        "settings_template_placeholder" => "Enter the name of a template",
        "settings_posts_per_page" => "Number of posts to display per page",
        "settings_timezone" => "Post Timezone:",
        "settings_timezone_placeholder" => "Enter a timezone",
        "settings_basepath" => "Site Base Path:",
        "settings_basepath_placeholder" => "Enter the base path",
        "settings_password_legend" => "Last but not least, the password:",
        "settings_password_placeholder" => "Choose a good password",
        "settings_password_legend_update" => "Type your password to update your blog:",
        "settings_password_placeholder_update" => "Management password",
        "settings_submit_creation" => "Create Your Blog",
        "settings_submit_update" => "Update Your Blog",
        "settings_dashboard_return" => "Return To Dashboard",
        "dashboard_title" => "Your Blog Dashboard",
        "dashboard_write_post" => "Write A Blog Post",
        "dashboard_settings" => "Edit The Site Settings",
        "dashboard_logout" => "Log Out",
        "dashboard_draft_post" => "Draft Posts:",
        "dashboard_published_post" => "Published Posts:",
        "dashboard_posted_by" => "Posted by",
        "dashboard_post_fulldate" => "F d, Y @ g:i A",
        "dashboard_publish" => "Publish",
        "dashboard_draft" => "Make Draft",
        "dashboard_edit" => "Edit",
        "dashboard_delete" => "Delete",
        "login_title" => "Log Into Your Blog",
        "login_password_legend" => "Type your password to update your blog:",
        "login_password_placeholder" => "Management password",
        "login_submit" => "Log In",
        "private_title" => "Private Post",
        "private_password_legend" => "Type your password to access private post:",
        "private_password_placeholder" => "Post password",
        "private_submit" => "Unlock",
        "write_title" => "Time to write your prose",
        "write_post_title_placeholder" => "The post title",
        "write_post_author_placeholder" => "The post author",
        "write_post_image_placeholder" => "A featured image for this post",
        "write_post_password_placeholder" => "Password if you want to hide the post",
        "write_post_markdown_placeholder" => "Write your post here, you can use Markdown",
    ],
    "fr_FR" => [
        "locale" => "fr_FR",
        "dateformat" => "l d F o",
        "settings_i18n" => "Internationalisation:",
        "settings_blog_creation" => "Création du blog",
        "settings_blog_edition" => "Edition des paramétres",
        "settings_first_time" => "D'abord, quelques infos...",
        "settings_welcome_back" => "Content de te revoir!",
        "settings_blog_name" => "Nom du blog:",
        "settings_blog_name_placeholder" => "Entrez un nom pour votre blog",
        "settings_blog_info" => "Sujet du blog:",
        "settings_blog_info_placeholder" => "Entrez un sujet du contenu de votre blog",
        "settings_blog_domain" => "Domaine du blog:",
        "settings_blog_domain_placeholder" => "Saisissez le domaine de votre blog (c'est-à-dire blog.monsite.com)",
        "settings_blog_OGImage" => "OuvrirGraphique Image:",
        "settings_blog_OGImage_placeholder" => "Entrez une URL vers une image que vous souhaitez afficher sur les sites de médias sociaux",
        "settings_footer_message" => "Pied de page:",
        "settings_footer_message_placeholder" => "Entrez un message de pied de page",
        "settings_header_inject" => "Injection de Code en En-tête:",
        "settings_header_inject_placeholder" => "Entrez un code d'en-tête, ex: statistique",
        "settings_template" => "Template du site:",
        "settings_template_placeholder" => "Entrez le nom du template",
        "settings_posts_per_page" => "Nombre d'articles à afficher par page",
        "settings_timezone" => "Fuseau horaire:",
        "settings_timezone_placeholder" => "Entrez une timezone",
        "settings_basepath" => "Dossier du site:",
        "settings_basepath_placeholder" => "Entrez le dossier de base du site",
        "settings_password_legend" => "Le dernier mais non le moindre, votre mot de passe",
        "settings_password_placeholder" => "Choisissez un bon mot de passe",
        "settings_password_legend_update" => "Entrez votre mot de passe pour mettre à jour le blog:",
        "settings_password_placeholder_update" => "Mot de passe d'administration",
        "settings_submit_creation" => "Créez votre blog",
        "settings_submit_update" => "Mettre à jour",
        "settings_dashboard_return" => "Retour au tableau de bord",
        "dashboard_title" => "Votre tableau de bord",
        "dashboard_write_post" => "Ecrire un article",
        "dashboard_settings" => "Paramètres du site",
        "dashboard_logout" => "Déconnexion",
        "dashboard_draft_post" => "Projets d'articles:",
        "dashboard_published_post" => "Articles publiés:",
        "dashboard_posted_by" => "Publié par",
        "dashboard_post_fulldate" => "l d F o à H:i",
        "dashboard_publish" => "Publier",
        "dashboard_draft" => "Passer en Brouillon",
        "dashboard_edit" => "Editer",
        "dashboard_delete" => "Supprimer",
        "login_title" => "Connecter vous à votre blog",
        "login_password_legend" => "Taper votre mot de passe:",
        "login_password_placeholder" => "Mot de passe d'administration",
        "login_submit" => "Connexion",
        "private_title" => "Article privé",
        "private_password_legend" => "Tapez le mot de passe pour accèder à cet article:",
        "private_password_placeholder" => "Mot de passe de l'article",
        "private_submit" => "Déverouiller",
        "write_title" => "C'est le moment de composer",
        "write_post_title_placeholder" => "Titre de l'article",
        "write_post_author_placeholder" => "Nom de l'auteur",
        "write_post_image_placeholder" => "Image de description",
        "write_post_password_placeholder" => "Mot de passe, pour rendre l'article privée",
        "write_post_markdown_placeholder" => "Ecrivez votre article ici en markdown",
    ],
    "uk_UA" => [
        "locale" => "uk_UA",
        "dateformat" => "F d, Y",
        "settings_i18n" => "Інтернаціоналізація:",
        "settings_blog_creation" => "Давай створимо твій блог",
        "settings_blog_edition" => "Зміна налаштуваннь блогу",
        "settings_first_time" => "Спочатку деякі деталі...",
        "settings_welcome_back" => "З поверненням!",
        "settings_blog_name" => "Назва блогу:",
        "settings_blog_name_placeholder" => "Введіть назву свого блогу",
        "settings_blog_info" => "Резюме блогу:",
        "settings_blog_info_placeholder" => "Коротко про що блог",
        "settings_blog_domain" => "Домен блогу:",
        "settings_blog_domain_placeholder" => "Введіть домен вашого блогу (наприклад blog.mysite.com)",
        "settings_blog_OGImage" => "OpenGraph зображення:",
        "settings_blog_OGImage_placeholder" => "Введіть URL зображення яке буде відображатись в соціальних мережах коли користувачі ділятся посиланням на блог",
        "settings_footer_message" => "Нижній колонтитул (footer):",
        "settings_footer_message_placeholder" => "Повідомлення для відображення на нижньому колонтитулі",
        "settings_header_inject" => "Додатковий код для верхнього колонтитула:",
        "settings_header_inject_placeholder" => "При необхідності додайте код для верхнього колонтитула",
        "settings_template" => "Назва шаблону сайту:",
        "settings_template_placeholder" => "Оберить назву шаблону сайту",
        "settings_posts_per_page" => "Скільки дописів буде відображатись на одній сторінці",
        "settings_timezone" => "Часовий:",
        "settings_timezone_placeholder" => "Введіть часовий пояс",
        "settings_basepath" => "Базовий url сайту:",
        "settings_basepath_placeholder" => "Введіть базовий url сайту",
        "settings_password_legend" => "І останнє, але не менш важливе, пароль:",
        "settings_password_placeholder" => "Введіть надійний пароль",
        "settings_password_legend_update" => "Введіть пароль, щоб оновити свій блог:",
        "settings_password_placeholder_update" => "Пароль керування",
        "settings_submit_creation" => "Створити блог",
        "settings_submit_update" => "Оновити налаштування",
        "settings_dashboard_return" => "Назад на інформаційну панель",
        "dashboard_title" => "Інформаційна панель вашого блогу",
        "dashboard_write_post" => "Створити новий допис",
        "dashboard_settings" => "Змінити налаштування сайту",
        "dashboard_logout" => "Вийти",
        "dashboard_draft_post" => "Чернетки дописів:",
        "dashboard_published_post" => "Опубліковані дописи:",
        "dashboard_posted_by" => "Опубліковано:",
        "dashboard_post_fulldate" => "F d, Y @ g:i A",
        "dashboard_publish" => "Опублікувати",
        "dashboard_draft" => "Створити чернетку",
        "dashboard_edit" => "Змінити",
        "dashboard_delete" => "Видалити",
        "login_title" => "Авторизуватись",
        "login_password_legend" => "Введіть пароль, щоб оновити свій блог:",
        "login_password_placeholder" => "Пароль керування",
        "login_submit" => "Увійти",
        "private_title" => "Приватний допис",
        "private_password_legend" => "Введіть свій пароль для доступу до приватного допису:",
        "private_password_placeholder" => "Пароль допису",
        "private_submit" => "Розблокувати",
        "write_title" => "Створення/редагування допису",
        "write_post_title_placeholder" => "Назва",
        "write_post_author_placeholder" => "Автор",
        "write_post_image_placeholder" => "Рекомендоване зображення для цього допису",
        "write_post_password_placeholder" => "Пароль, якщо ви хочете приховати публікацію",
        "write_post_markdown_placeholder" => "Напишіть свій допис тут, ви можете використовувати Markdown",
    ],
];

function i18n($index, $echo = true){
    global $siteConfig;
    global $language;
    $en = "en_US";
    $i18n = empty($siteConfig['I18N'])?$en:$siteConfig['I18N'];
    $default_value = isset($language[$en][$index])?$language[$en][$index]:$index;
    $value = isset($language[$i18n][$index])?$language[$i18n][$index]:$default_value;
    if($echo){
        echo $value;
    }
    return $value;
}

setlocale(LC_ALL, i18n('locale',false));

?>