﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using System.Text.Json.Serialization;
using System.Threading.Tasks;

namespace Whetstone.ChatGPT.Models.FineTuning
{
    public class AutoIntConverter : JsonConverter<int?>
    {
        public override int? Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
        {
            if (reader.TokenType == System.Text.Json.JsonTokenType.Number)
            {
                return reader.GetInt32();
            }
            else if (reader.TokenType == System.Text.Json.JsonTokenType.String)
            {
                string? autoText = reader.GetString();

                if (string.IsNullOrEmpty(autoText))
                {
                    throw new System.Text.Json.JsonException("Invalid value for AutoFloatConverter");
                }
                else if (autoText!.Equals("auto", StringComparison.OrdinalIgnoreCase))
                {
                    return null;
                }
            }

            throw new System.Text.Json.JsonException("Invalid value for AutoFloatConverter");
        }

        public override void Write(Utf8JsonWriter writer, int? value, JsonSerializerOptions options)
        {
            if (value is null)
                writer.WriteStringValue("auto");
            else
                writer.WriteNumberValue(value.Value);
        }
    }
}
