﻿// SPDX-License-Identifier: MIT
using System.Diagnostics.CodeAnalysis;
using System.Text.Json.Serialization;

namespace Whetstone.ChatGPT.Models
{
    [Obsolete("Use ChatGPTChatCompletionStreamResponse")]
    public class ChatGPTCompletionStreamResponse
    {
        [JsonPropertyName("id")]
        public string? Id { get; set; }

        [JsonPropertyName("object")]
        [SuppressMessage("Naming", "CA1720:Identifier contains type name", Justification = "This is the name of the property returned by the API.")]
        public string? @Object { get; set; }

        [JsonConverter(typeof(UnixEpochTimeJsonConverter))]
        [JsonPropertyName("created")]
        public DateTime Created { get; set; }

        /// <summary>
        /// Completion choices generated by the OpenAI API.
        /// </summary>
        [JsonPropertyName("choices")]
        public List<ChatGPTChoice>? Choices { get; set; }

        /// <summary>
        /// Model used to generate the original request. 
        /// </summary>
        /// <remarks>
        /// See <see cref="ChatGPTCompletionModels">ChatGPTCompletionModels</see> for recommended completion models.
        /// </remarks>
        [JsonPropertyName("model")]
        public string? Model { get; set; }
    }
}
