﻿// SPDX-License-Identifier: MIT
using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using System.Linq;
using System.Text;
using System.Text.Json.Serialization;
using System.Threading.Tasks;

namespace Whetstone.ChatGPT.Models
{
    /// <summary>
    /// OpenAI generated response to a <c>ChatGPTChatCompletionRequest</c>.
    /// </summary>
    public class ChatGPTChatCompletionResponse
    {
        /// <summary>
        /// Server generated ID for the completion response.
        /// </summary>
        [JsonPropertyName("id")]
        public string? Id { get; set; }

        /// <summary>
        /// The OpenAI object used to serialize the response. For completion responese, this should be <c>chat.completion</c>.
        /// </summary>
        [JsonPropertyName("object")]
        [SuppressMessage("Naming", "CA1720:Identifier contains type name", Justification = "This is the name of the property returned by the API.")]
        public string? @Object { get; set; }

        /// <summary>
        /// Date and time the completion response was generated.
        /// </summary>
        [JsonConverter(typeof(UnixEpochTimeJsonConverter))]
        [JsonPropertyName("created")]
        public DateTime Created { get; set; }

        /// <summary>
        /// Model used to generate the original request. 
        /// </summary>
        /// <remarks>
        /// See <see cref="ChatGPT35Models">ChatGPT35Models</see> and <see cref="ChatGPT4Models">ChatGPT4Models</see> for recommended chat models.
        /// </remarks>
        [JsonPropertyName("model")]
        public string? Model { get; set; }

        /// <summary>
        /// Completion choices generated by the GPT-3 API.
        /// </summary>
        [JsonPropertyName("choices")]
        public List<ChatGPTChatChoice>? Choices { get; set; }


        /// <summary>
        /// This fingerprint represents the backend configuration that the model runs with.
        /// </summary>
        /// <remarks>
        /// Can be used in conjunction with the seed request parameter to understand when backend changes have been made that might impact determinism.
        /// </remarks>
        [JsonPropertyName("system_fingerprint")]
        public string? SystemFingerprint { get; set; }

        /// <summary>
        /// Details the number of tokens used to process the completion.
        /// </summary>
        [JsonPropertyName("usage")]
        public ChatGPTUsage? Usage { get; set; }
    }

    public class ChatGPTChatChoice
    {
        [JsonPropertyName("index")]
        public int? Index { get; set; }

        [JsonPropertyName("message")]
        public ChatGPTChatCompletionMessage? Message { get; set; }

        [JsonPropertyName("finish_reason")]
        public string? FinishReason { get; set; }

    }
}
