const express = require('express')
const router = new express.Router()
const multer = require('multer')
const upload = multer()
const controller = require('./chirpController')
const auth = require('../../middleware/auth')

router.post('/chirps', auth, controller.createChirp)
router.post('/chirps/image', auth, upload.any(), controller.createChirpWithImage)
router.delete('/chirps/delete/:id', auth, controller.deleteChirp)
router.post('/chirps/rechirp', auth, controller.addRechirp)
router.post('/chirps/reply', auth, controller.addReply)
router.post('/chirps/reply/image', auth, upload.any(), controller.addReplyWithImage)
router.get('/chirps/reply/:id/:query', auth, controller.getReplies)
router.delete('/chirps/rechirp/delete/:id', auth, controller.deleteRechirp)
router.get('/chirps/feed/:query', auth, controller.getCurrentUserChirpFeed)
router.get('/chirps/profile/auth/:userId/:query', auth, controller.getUserChirps)
router.get('/chirps/profile/media/:userId/:query', auth, controller.getUserMedia)
router.post('/chirps/profile/likes/:query', auth, controller.getUserLikedChirps)
router.get('/chirps/:id', auth, controller.getChirp)

module.exports = router