<?php

class onez_cloud {
    var $debug = false;
    var $_config = false;
    var $_homepage = false;
    var $_db = false;
    var $context = [];
    var $logs = [];
    var $tables = [];
    var $_output = ['status' => 'success'];
    var $_option = false;
    function __construct() {
        $this->context = [];
    }
    /**
     * 读取用户get或post的信息
     *
     * @param string $keys 键
     * @param string $method 方法:G get,P post
     * @param boolean $cvtype 是否为数字
     *
     * @return string
     */
    function gp($keys, $cvtype = 1, $method = null) {
        global $G;
        if ($method == 'G') {
            $value = $_GET[$keys];
        } elseif ($method == 'P') {
            $value = $_POST[$keys];
        } else {
            $value = $_REQUEST[$keys];
        }
        $G['gp_' . $keys] = $value;
        if (!empty($cvtype) || $cvtype == 2) {
            $value = $this->charcv($value, $cvtype == 2, true);
        }
        $value == 'undefined' && $value = '';
        return $value;
    }
    /**
     * 读取变量
     *
     * @param mixed $mixed 字符串
     * @param boolean $isint 是否为数字
     * @param boolean $istrim 是否去除空格
     *
     * @return
     */
    function charcv($mixed, $isint = false, $istrim = false) {
        if (is_array($mixed)) {
            foreach ($mixed as $key => $value) {
                $mixed[$key] = $this->charcv($value, $isint, $istrim);
            }
        } elseif ($isint) {
            $mixed = (int)$mixed;
        } elseif (!is_numeric($mixed) && ($istrim ? $mixed = trim($mixed) : $mixed) && $mixed) {
            $mixed = str_replace(array(
                "\0",
                "%00",
                "\r"
            ) , '', $mixed);
            $mixed = preg_replace(array(
                '/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]/',
                '/&(?!(#[0-9]+|[a-z]+);)/is'
            ) , array(
                '',
                '&amp;'
            ) , $mixed);
            $mixed = str_replace(array(
                "%3C",
                '<'
            ) , '&lt;', $mixed);
            $mixed = str_replace(array(
                "%3E",
                '>'
            ) , '&gt;', $mixed);
            $mixed = str_replace('&amp;', '&', $mixed);
            $mixed = str_replace(array(
                '"',
                "'",
                "\t",
                '  '
            ) , array(
                '&quot;',
                '&#39;',
                '    ',
                '&nbsp;&nbsp;'
            ) , $mixed);
        }
        return $mixed;
    }
    /**
     * 读取本地文件数据
     *
     * @param string $filename 文件名
     * @param string $method 默认rb
     *
     * @return mixed 文件数据
     */
    function read($fileId, $method = "rb") {
        $filename = dirname(__FILE__) . $fileId;
        if (!file_exists($filename)) {
            return;
        }
        if ($handle = @fopen($filename, $method)) {
            flock($handle, LOCK_SH);
            $size = filesize($filename);
            if ($size > 0) {
                $filedata = fread($handle, $size);
            }
            fclose($handle);
        }
        return $filedata;
    }
    function file_exists($fileId) {
        return file_exists(dirname(__FILE__) . $fileId);
    }
    /**
     * 写入本地文件
     *
     * @param string $filename 文件名
     * @param mixed $data 文件内容
     * @param string $method 写入方式,a+为追加
     * @param boolean $iflock
     *
     * @return
     */
    function write($fileId, $data, $method = "rb+", $iflock = 1) {
        $filename = dirname(__FILE__) . $fileId;
        $this->mkdirs(dirname($filename));
        touch($filename);
        $handle = fopen($filename, $method);
        if ($iflock) {
            flock($handle, LOCK_EX);
        }
        fwrite($handle, $data);
        if ($method == "rb+") ftruncate($handle, strlen($data));
        fclose($handle);
        return $fileId;
    }
    /**
     * 创建多级目录
     *
     * @param string $dir 要创建的完整路径
     *
     * @return
     */
    function mkdirs($dir) {
        if (!is_dir($dir)) {
            $this->mkdirs(dirname($dir));
            mkdir($dir, 0777);
        }
        return;
    }
    function fileUrl($fileId) {
        return $this->context['homepage'] . $fileId;
    }
    /**
     * 读取远程网址代码
     *
     * @param string $url 请求的网址
     * @param mixed $fields 需要post的参数
     * @param array $options 附加选项
     *
     * @return mixed 直接返回目标输出的内容
     */
    function post($url, $fields = '', $options = null) {
        !$options && $options = [];
        if (!function_exists('curl_init')) {
            return $this->mypost($url, $fields, $options);
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        if (strpos($url, 'https://') !== false) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 1);
        }
        if ($options['useragent']) {
            curl_setopt($ch, CURLOPT_USERAGENT, $options['useragent']);
        } else {
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; zh-CN; rv:1.9.0.19) Gecko/2010031422 Firefox/3.0.19');
        }
        curl_setopt($ch, CURLOPT_TIMEOUT, $options['timeout'] ? $options['timeout'] : 10);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        @curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        $options['headers'] && curl_setopt($ch, CURLOPT_HTTPHEADER, $options['headers']);
        if ($options['showheader']) {
            curl_setopt($ch, CURLOPT_HEADER, 1);
        } else {
            curl_setopt($ch, CURLOPT_HEADER, 0);
        }
        if ($options['cookie']) {
            if (file_exists($options['cookie'])) {
                curl_setopt($ch, CURLOPT_COOKIEJAR, $options['cookie']);
                curl_setopt($ch, CURLOPT_COOKIEFILE, $options['cookie']);
            } else {
                curl_setopt($ch, CURLOPT_COOKIE, $options['cookie']);
            }
        }
        curl_setopt($ch, CURLOPT_REFERER, $options['baseurl'] ? $options['baseurl'] : $url);
        if ($fields) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            curl_setopt($ch, CURLOPT_POST, 1);
        }
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
    function mypost($url, $fields = '', $options = null) {
        !$options && $options = array();
        if ($fields) {
            $opt = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'content-type:application/x-www-form-urlencoded' . ($options['headers'] ? (';' . implode(';', $options['headers'])) : '') ,
                    'content' => is_array($fields) ? http_build_query($fields) : $fields
                )
            );
            $context = stream_context_create($opt);
            $mydata = file_get_contents($url, false, $context);
        } else {
            if ($options['headers']) {
                $opt = array(
                    'http' => array(
                        'method' => 'GET',
                        'header' => implode(';', $options['headers']) ,
                    )
                );
                $context = stream_context_create($opt);
                $mydata = file_get_contents($url, false, $context);
            } else {
                $mydata = file_get_contents($url);
            }
        }
        return $mydata;
    }
    //数据库操作
    function db($request, $is_system = false) {
        //读写权限判断
        $r = $this->db_permission($request, $is_system);
        if ($r['error']) {
            return $this->error($r['error']);
        }
        $result = false;
        if (!empty($request['where']['namespace'])) {
            unset($request['where']['namespace']);
        }
        if (!empty($request['arr']['namespace'])) {
            unset($request['arr']['namespace']);
        }
        if ($this->_db == false) {
            $this->_db = [];
            $option = $this->option();
            $this->_db['txtdb_path'] = $option['txtdb_path'];
            !$this->_db['txtdb_path'] && $this->_db['txtdb_path'] = '/data';
            $this->_db['txtdb_path'].= '/' . ($request['where']['namespace'] ? $request['where']['namespace'] : 'default');
            $this->_db['txtdb_init_file'] = $this->_db['txtdb_path'] . '/init.php';
        }
        if (!$this->file_exists($this->_db['txtdb_init_file'])) {
            $dbInfo = ['tables' => [], ];
        } else {
            list(, , $data) = explode("\n", $this->read($this->_db['txtdb_init_file']));
            $dbInfo = json_decode($data, 1);
            unset($data);
        }
        //多少记录后更换文件
        $pageSize = 10;
        !$dbInfo['tables'][$request['table']] && $dbInfo['tables'][$request['table']] = ['record' => [['page' => 1, 'time_begin' => 0, 'time_end' => 0, 'num' => 0, ], ], 'total' => 0, 'pageCount' => 1, ];
        $info = $dbInfo['tables'][$request['table']];
        if ($request['method'] == 'page') {
            $totalput = $this->db(['method' => 'rows', 'table' => $request['table'], 'where' => $request['where'], ]);
            !$request['pageSize'] && $request['pageSize'] = 20;
            $request['pageSize'] = max(1, $request['pageSize']);
            if (($totalput % $request['pageSize']) == 0) {
                $PageCount = intval($totalput / $request['pageSize']);
            } else {
                $PageCount = intval($totalput / $request['pageSize'] + 1);
            }
            $PageCount < 1 && $PageCount = 1;
            !$request['page'] && $request['page'] = $this->gp('page');
            !$request['page'] && $request['page'] = 1;
            $request['page'] = max(1, intval($request['page']));
            $request['method'] = 'record';
            $request['limit'] = (($request['page'] - 1) * $request['pageSize']) . "," . $request['pageSize'];
            $record = $this->db($request);
            return ['page' => $request['page'], 'pageSize' => $request['pageSize'], 'record' => $record, 'total' => $totalput, 'pageCount' => $PageCount, ];
        } elseif ($request['method'] == 'insert') {
            $Index = $info['pageCount'] - 1;
            $thisPage = $info['record'][$Index];
            if (!$thisPage) {
                $thisPage = ['page' => $Index + 1, ];
            }
            $tableFile = $this->_db['txtdb_path'] . '/tables/' . $request['table'] . '/' . $thisPage['page'] . '.php';
            list(, , $data) = explode("\n", $this->read($tableFile));
            $array = json_decode($data, 1);
            !$array && $array = [];
            $rs = $request['arr'] ? $request['arr'] : [];
            !$rs['_id'] && $rs['_id'] = $this->guid();
            !$rs['addtime'] && $rs['addtime'] = time();
            !$rs['updatetime'] && $rs['updatetime'] = time();
            !$rs['ip'] && $rs['ip'] = $this->ip();
            $_id = $rs['_id'];
            unset($rs['_id']);
            $array[$_id] = $rs;
            unset($data);
            $thisPage['time_begin'] = 0;
            $thisPage['time_end'] = 0;
            $dataFull = "<" . "?php\n!defined('IN_ONEZ_CLOUD') && exit('Access Denied');?" . ">";
            $dataIndex = "<" . "?php\n!defined('IN_ONEZ_CLOUD') && exit('Access Denied');?" . ">";
            $line = 0;
            $arrayIndex = [];
            foreach ($array as $_id => $rs) {
                if ($thisPage['time_begin'] === 0) {
                    $thisPage['time_begin'] = $rs['addtime'];
                } else {
                    $thisPage['time_begin'] = min($thisPage['time_begin'], $rs['addtime']);
                }
                if ($thisPage['time_end'] === 0) {
                    $thisPage['time_end'] = $rs['addtime'];
                } else {
                    $thisPage['time_end'] = max($thisPage['time_end'], $rs['addtime']);
                }
                $line++;
                $index_rs = ['_line' => $line];
                foreach ($rs as $k => $v) {
                    $type = gettype($v);
                    if (in_array($type, ['integer', 'double'])) {
                        $index_rs[$k] = $v;
                    }
                }
                $arrayIndex[$_id] = $index_rs;
            }
            $thisPage['num'] = $line;
            $info['record'][$Index] = $thisPage;
            $dataFull.= "\n" . json_encode($array);
            //是否增加一页
            if ($thisPage['num'] >= $pageSize || strlen($dataFull) > 1 * 1024 * 1024) {
                $info['pageCount']++;
            }
            $dbInfo['tables'][$request['table']] = $info;
            $this->write($tableFile, $dataFull);
            $dataIndex.= "\n" . json_encode($arrayIndex);
            $this->write(substr($tableFile, 0, -4) . '.index.php', $dataIndex);
            unset($array);
            $this->write($this->_db['txtdb_init_file'], "<" . "?php\n!defined('IN_ONEZ_CLOUD') && exit('Access Denied');?" . ">\n" . json_encode($dbInfo));
            return $_id;
        }
        $results = [];
        $num = 0;
        $stop = false;
        $where = $request['where'] ? $request['where'] : [];
        $records = $info['record'];
        if (in_array($request['method'], ['delete', 'rows'])) {
            unset($request['sort']);
        }
        $limit = 0;
        $skip = 0;
        if ($request['limit']) {
            if (strpos($request['limit'], ',') !== false) {
                list($skip, $limit) = explode(',', $request['limit']);
            } else {
                $limit = $request['limit'];
            }
        }
        if ($request['sort']) {
            $datas = [];
            $sorts = [];
            foreach ($info['record'] as $Index => $thisPage) {
                $tableFile = $this->_db['txtdb_path'] . '/tables/' . $request['table'] . '/' . $thisPage['page'] . '.index.php';
                if (!$this->file_exists($tableFile)) {
                    continue;
                }
                if ($thisPage['num'] === 0) {
                    continue;
                }
                if ($where['addtime']) {
                    if ($where['addtime']['$gt']) {
                        if ($thisPage['time_end'] <= $where['addtime']['$gt']) {
                            continue;
                        }
                    }
                    if ($where['addtime']['$gte']) {
                        if ($thisPage['time_end'] < $where['addtime']['$gte']) {
                            continue;
                        }
                    }
                    if ($where['addtime']['$lt']) {
                        if ($thisPage['time_begin'] >= $where['addtime']['$lt']) {
                            continue;
                        }
                    }
                    if ($where['addtime']['$lte']) {
                        if ($thisPage['time_begin'] > $where['addtime']['$lte']) {
                            continue;
                        }
                    }
                }
                list(, , $data) = explode("\n", $this->read($tableFile));
                $array = json_decode($data, 1);
                unset($data);
                foreach ($array as $_id => $rs) {
                    $datas[] = [$_id, $Index];
                    foreach ($request['sort'] as $k => $v) {
                        $sorts[$k][] = $rs[$k];
                    }
                }
                unset($array);
            }
            if (!empty($datas)) {
                foreach ($request['sort'] as $k => $v) {
                    array_multisort($sorts[$k], $v == 1 ? SORT_ASC : SORT_DESC, SORT_NUMERIC, $datas);
                }
            }
            $records = $datas;
        }
        foreach ($records as $Key => $Value) {
            if ($request['sort']) {
                if ($Value[1] !== $lastIndex) {
                    $lastIndex = $Value[1];
                    $Index = $Value[1];
                    $thisPage = $info['record'][$Index];
                    $tableFile = $this->_db['txtdb_path'] . '/tables/' . $request['table'] . '/' . $thisPage['page'] . '.php';
                    if (!$this->file_exists($tableFile)) {
                        continue;
                    }
                    list(, , $data) = explode("\n", $this->read($tableFile));
                    $lastArray = json_decode($data, 1);
                    unset($data);
                }
                $_id = $Value[0];
                $array = [$_id => $lastArray[$_id]];
            } else {
                $Index = $Key;
                $thisPage = $Value;
                if ($where['addtime']) {
                    if ($where['addtime']['$gt']) {
                        if ($thisPage['time_end'] <= $where['addtime']['$gt']) {
                            continue;
                        }
                    }
                    if ($where['addtime']['$gte']) {
                        if ($thisPage['time_end'] < $where['addtime']['$gte']) {
                            continue;
                        }
                    }
                    if ($where['addtime']['$lt']) {
                        if ($thisPage['time_begin'] >= $where['addtime']['$lt']) {
                            continue;
                        }
                    }
                    if ($where['addtime']['$lte']) {
                        if ($thisPage['time_begin'] > $where['addtime']['$lte']) {
                            continue;
                        }
                    }
                }
                $tableFile = $this->_db['txtdb_path'] . '/tables/' . $request['table'] . '/' . $thisPage['page'] . '.php';
                if (!$this->file_exists($tableFile)) {
                    continue;
                }
                list(, , $data) = explode("\n", $this->read($tableFile));
                $array = json_decode($data, 1);
                unset($data);
            }
            $edit_num = 0;
            foreach ($array as $_id => $rs) {
                $match = true;
                foreach ($where as $k => $v) {
                    if ($k == '$or') {
                        $match = false;
                        foreach ($v as $v2) {
                            foreach ($v2 as $k3 => $v3) {
                                if ($rs[$k3] == $v3) {
                                    $match = true;
                                    break;
                                }
                            }
                        }
                        break;
                    } elseif (is_array($v)) {
                        if ($v['$ne']) {
                            $value = $v['$ne'];
                            if ($rs[$k] == $value) {
                                $match = false;
                                break;
                            }
                        }
                        if ($v['$gt']) {
                            $value = $v['$gt'];
                            if ($rs[$k] <= $value) {
                                $match = false;
                                break;
                            }
                        }
                        if ($v['$gte']) {
                            $value = $v['$gte'];
                            if ($rs[$k] < $value) {
                                $match = false;
                                break;
                            }
                        }
                        if ($v['$lt']) {
                            $value = $v['$lt'];
                            if ($rs[$k] >= $value) {
                                $match = false;
                                break;
                            }
                        }
                        if ($v['$lte']) {
                            $value = $v['$lte'];
                            if ($rs[$k] <= $value) {
                                $match = false;
                                break;
                            }
                        }
                        if ($v['$regex']) {
                            $value = $v['$regex'];
                            $value = str_replace('^', '', $value);
                            if (strpos($rs[$k], $value) === false) {
                                $match = false;
                                break;
                            }
                        }
                    } elseif ($k == '_id') {
                        if ($_id != $v) {
                            $match = false;
                            break;
                        }
                    } else {
                        if ($rs[$k] != $v) {
                            $match = false;
                            break;
                        }
                    }
                }
                if ($match) {
                    $rs['_id'] = $_id;
                    if ($request['method'] == 'rows') {
                        $num++;
                        continue;
                    } elseif ($request['method'] == 'one') {
                        unset($array);
                        return $this->db_format_output($rs, $request, $is_system);
                    } elseif ($request['method'] == 'record') {
                        $num++;
                        $rs['_id'] = $_id;
                        if ($skip && $num <= $skip) {
                            continue;
                        }
                        $results[] = $rs;
                    } elseif ($request['method'] == 'update') {
                        $rs = array_merge($rs, $request['arr']);
                        unset($array[$_id]);
                        $array[$rs['_id'] ? $rs['_id'] : $_id] = $rs;
                        $edit_num++;
                        continue;
                    } elseif ($request['method'] == 'delete') {
                        unset($array[$_id]);
                        $edit_num++;
                        continue;
                    }
                }
                if ($limit && count($results) >= $limit) {
                    $stop = true;
                    break;
                }
            }
            if ($edit_num > 0) {
                $thisPage['time_begin'] = 0;
                $thisPage['time_end'] = 0;
                $dataFull = "<" . "?php\n!defined('IN_ONEZ_CLOUD') && exit('Access Denied');?" . ">";
                $dataIndex = "<" . "?php\n!defined('IN_ONEZ_CLOUD') && exit('Access Denied');?" . ">";
                $line = 0;
                $arrayIndex = [];
                foreach ($array as $_id => $rs) {
                    if ($thisPage['time_begin'] === 0) {
                        $thisPage['time_begin'] = $rs['addtime'];
                    } else {
                        $thisPage['time_begin'] = min($thisPage['time_begin'], $rs['addtime']);
                    }
                    if ($thisPage['time_end'] === 0) {
                        $thisPage['time_end'] = $rs['addtime'];
                    } else {
                        $thisPage['time_end'] = max($thisPage['time_end'], $rs['addtime']);
                    }
                    $line++;
                    $index_rs = ['_line' => $line];
                    foreach ($rs as $k => $v) {
                        $type = gettype($v);
                        if (in_array($type, ['integer', 'double'])) {
                            $index_rs[$k] = $v;
                        }
                    }
                    $arrayIndex[$_id] = $index_rs;
                }
                $thisPage['num'] = $line;
                if ($line > 0) {
                    $info['record'][$Index] = $thisPage;
                } else {
                    unset($info['record'][$Index]);
                }
                if ($info) {
                    $dbInfo['tables'][$request['table']] = $info;
                } else {
                    unset($dbInfo['tables'][$request['table']]);
                }
                $dataFull.= "\n" . json_encode($array);
                $dataIndex.= "\n" . json_encode($arrayIndex);
                if ($line > 0) {
                    $this->write($tableFile, $dataFull);
                    $this->write(substr($tableFile, 0, -4) . '.index.php', $dataIndex);
                } else {
                    @unlink($tableFile);
                    @unlink(substr($tableFile, 0, -4) . '.index.php');
                }
                $this->write($this->_db['txtdb_init_file'], "<" . "?php\n!defined('IN_ONEZ_CLOUD') && exit('Access Denied');?" . ">\n" . json_encode($dbInfo));
            }
            unset($array);
            if ($stop) {
                break;
            }
        }
        if ($request['method'] == 'rows') {
            return $num;
        } elseif ($request['method'] == 'record') {
            return $this->db_format_output($results, $request, $is_system);
        }
    }
    function homepage() {
        //分析当前网址
        if (!$this->_homepage) {
            if (!$_SERVER['REQUEST_SCHEME']) {
                $_SERVER['REQUEST_SCHEME'] = 'http';
            }
            if (!empty($_SERVER['HTTPS'])) {
                if ($_SERVER['HTTPS'] == 'on') {
                    $_SERVER['REQUEST_SCHEME'] = 'https';
                }
            }
            $homepage = $_SERVER['REQUEST_SCHEME'] . '://';
            $homepage.= $_SERVER['HTTP_HOST'];
            if (strpos($homepage, ':') === false) {
                $_SERVER['SERVER_PORT'] != '80' && $_SERVER['SERVER_PORT'] != '443' && $homepage.= ':' . $_SERVER['SERVER_PORT'];
            }
            $key = substr(dirname(__FILE__) , strlen($_SERVER['DOCUMENT_ROOT']));
            $key = str_replace('\\', '/', $key);
            $homepage.= $key;
            $this->_homepage = $homepage;
        }
        return $this->_homepage;
    }
    function ip() {
        if (getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP') , 'unknown')) {
            $onlineip = getenv('HTTP_CLIENT_IP');
        } elseif (getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR') , 'unknown')) {
            $onlineip = getenv('HTTP_X_FORWARDED_FOR');
        } elseif (getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR') , 'unknown')) {
            $onlineip = getenv('REMOTE_ADDR');
        } elseif (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
            $onlineip = $_SERVER['REMOTE_ADDR'];
        }
        $onlineip[0] == ':' && $onlineip = $_SERVER['SERVER_NAME'];
        $onlineip = preg_replace("/^([\d\.]+).*/", "\\1", $onlineip);
        return $onlineip;
    }
    //数据库读写权限判断
    function db_permission(&$request, $is_system = false) {
        //配置表只有安装或系统维护时可修改（固定）
        $permissions = $this->context['db_permissions'];
        //某个页面单独的表权限
        $pageToken = $this->context['pageToken'];
        if ($pageToken) {
            if ($permissions[$pageToken][$request['table']]) {
                $permissions[$request['table']] = $permissions[$pageToken][$request['table']];
            }
        }
        if (!$is_system) { //系统服务端调用，不判断权限，外部环境无法传第2个参数
            if ($request['table'] == 'config') {
                $permissions['config'] = ['default' => ['read' => 'all', ], 'admin' => ['update' => 'all', ], ];
            } elseif ($request['table'] == 'device') {
                $permissions['device'] = ['default' => ['insert' => 'udid', 'update' => 'udid', 'delete' => 'none', 'read' => 'udid', ], ];
            } elseif ($request['table'] == 'user') {
                $permissions['user'] = ['user' => ['read' => 'userid', 'edit' => 'userid', ], 'admin' => ['read' => 'all', 'insert' => 'all', 'update' => 'all', 'delete' => 'all', ], ];
            }
            if (!$permissions) {
                return $this->error('没有权限[01-' . $request['table'] . ']');
            }
            if (!$permissions[$request['table']]) {
                return $this->error('没有权限[02-' . $request['table'] . ']');
            }
            $method = $request['method'];
            if (in_array($method, ['one', 'record', 'rows', 'page'])) {
                $method = 'read';
            }
            $method_permissions = [];
            //默认的匹配规则
            if (!empty($permissions[$request['table']]['default'])) {
                $method_permissions = $permissions[$request['table']]['default'];
            }
            //是否为某个角色单独设置了规则
            foreach ($this->context['roles'] as $v) {
                if (!empty($permissions[$request['table']][$v])) {
                    $method_permissions = array_merge($method_permissions, $permissions[$request['table']][$v]);
                }
            }
            if (!$method_permissions) {
                return $this->error('没有权限[03-' . $request['table'] . ']');
            }
            if (empty($method_permissions[$method])) {
                return $this->error('没有权限[04-' . $request['table'] . ']');
            }
            $match = 0;
            foreach (explode(',', $method_permissions[$method]) as $v) {
                if ($v == 'login') { //必须登录
                    if ($this->context['userid'] <= 0) {
                        return ['status' => 'success', ];
                        //return $this->error('请先登录');
                        
                    }
                } elseif ($v == 'auto') { //已登录按userid操作，否则按udid
                    if ($this->context['userid'] <= 0) {
                        if ($request['arr']) {
                            $request['arr']['udid'] = $this->context['udid'];
                        }
                        $request['where']['udid'] = $this->context['udid'];
                    } else {
                        if ($request['arr']) {
                            $request['arr']['userid'] = (int)$this->context['userid'];
                        }
                        $request['where']['userid'] = (int)$this->context['userid'];
                    }
                    $match++;
                } elseif ($v == 'userid') { //只能操作自己的数据
                    if ($this->context['userid'] <= 0) {
                        return ['status' => 'success', ];
                        //return $this->error('请先登录');
                        
                    }
                    if ($request['arr']) {
                        $request['arr']['userid'] = (int)$this->context['userid'];
                    }
                    $request['where']['userid'] = (int)$this->context['userid'];
                    $match++;
                } elseif ($v == 'udid') { //只能操作自己设备产生的数据
                    if ($request['arr']) {
                        $request['arr']['udid'] = $this->context['udid'];
                    }
                    $request['where']['udid'] = $this->context['udid'];
                    $match++;
                } elseif ($v == 'all') { //没有任何限制
                    $match++;
                } elseif ($v == 'none') { //谁都没有权限
                    return $this->error('没有权限[05-' . $request['table'] . ']');
                } elseif (in_array($v, $this->context['roles'])) { //任意一角色符合
                    $match++;
                }
            }
            if ($match <= 0) {
                return $this->error('没有权限[06-' . $request['table'] . ']');
            }
        }
        //使用命名空间
        if (!isset($request['where']['namespace'])) {
            $request['where']['namespace'] = $this->context['namespace'];
        }
        if ($request['method'] == 'insert') {
            if (!isset($request['arr']['namespace'])) {
                $request['arr']['namespace'] = $this->context['namespace'];
                $permissions[$request['table']]['fields'][] = 'namespace';
            }
        }
        //限定字段
        if (!$is_system && $permissions[$request['table']]['fields']) {
            $request['fields'] = $permissions[$request['table']]['fields'];
            if (!in_array('*', $request['fields'])) {
                if ($request['method'] == 'insert' || $request['method'] == 'update') {
                    $arr = [];
                    foreach ($request['fields'] as $field) {
                        if (isset($request['arr'][$field])) {
                            $arr[$field] = $request['arr'][$field];
                        }
                    }
                    $request['arr'] = $arr;
                }
            }
        }
        return ['status' => 'success', ];
    }
    //重新处理字段
    function db_format_output($result, $request, $is_system = false) {
        if ($request['method'] == 'page') {
            $db_serializes = $this->option('db_serializes');
            if (!$result['record']) {
                return $result;
            } elseif (!$request['fields'] || in_array('*', $request['fields'])) {
                if (!empty($db_serializes[$request['table']])) {
                    $array = [];
                    foreach ($result['record'] as $rs) {
                        foreach ($db_serializes[$request['table']] as $k) {
                            $rs[$k] = unserialize($rs[$k]);
                        }
                        $array[] = $rs;
                    }
                    $result['record'] = $arrary;
                }
                return $result;
            }
            $array = [];
            foreach ($result['record'] as $rs) {
                $arr = [];
                foreach ($request['fields'] as $field) {
                    if (isset($rs[$field])) {
                        $arr[$field] = $rs[$field];
                        if (!empty($db_serializes[$request['table']]) && in_array($field, $db_serializes[$request['table']])) {
                            $arr[$field] = unserialize($arr[$field]);
                        }
                    }
                }
                $array[] = $arr;
            }
            $result['record'] = $array;
            return $result;
        } elseif ($request['method'] == 'record') {
            $db_serializes = $this->option('db_serializes');
            if (!$result) {
                return $result;
            } elseif (!$request['fields'] || in_array('*', $request['fields'])) {
                if (!empty($db_serializes[$request['table']])) {
                    $array = [];
                    foreach ($result as $rs) {
                        foreach ($db_serializes[$request['table']] as $k) {
                            $rs[$k] = unserialize($rs[$k]);
                        }
                        $array[] = $rs;
                    }
                    return $array;
                }
                return $result;
            }
            $array = [];
            foreach ($result as $rs) {
                $arr = [];
                foreach ($request['fields'] as $field) {
                    if (isset($rs[$field])) {
                        $arr[$field] = $rs[$field];
                        if (!empty($db_serializes[$request['table']]) && in_array($field, $db_serializes[$request['table']])) {
                            $arr[$field] = unserialize($arr[$field]);
                        }
                    }
                }
                $array[] = $arr;
            }
            return $array;
        } elseif ($request['method'] == 'one') {
            $db_serializes = $this->option('db_serializes');
            if (!$result) {
                return null;
            } elseif (!$request['fields'] || in_array('*', $request['fields'])) {
                if (!empty($db_serializes[$request['table']])) {
                    foreach ($db_serializes[$request['table']] as $k) {
                        $result[$k] = unserialize($result[$k]);
                    }
                    return $result;
                }
                return $result;
            }
            $arr = [];
            foreach ($request['fields'] as $field) {
                if (isset($result[$field])) {
                    $arr[$field] = $result[$field];
                    if (!empty($db_serializes[$request['table']]) && in_array($field, $db_serializes[$request['table']])) {
                        $arr[$field] = unserialize($arr[$field]);
                    }
                }
            }
            return $arr;
        } else {
            return $result;
        }
    }
    //运行
    function run() {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Max-Age: 3600");
        header("Access-Control-Allow-Credentials: true");
        header("Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE");
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization, cache-control");
            header("HTTP/1.0 200 OK");
            exit();
        }
        $this->context['homepage'] = $this->homepage();
        $this->context['ip'] = $this->ip();
        $this->context['build_time'] = filemtime(__FILE__);
        $this->context['build_date'] = date('Y-m-d H:i:s', $this->context['build_time']);
        $this->context['get'] = $_GET;
        $this->context['request'] = $_REQUEST;
        $this->context['post'] = $_POST;
        $this->context['roles'] = ['guest'];
        $this->context['userid'] = 0;
        $this->context['namespace'] = 'default';
        if ($_GET['namespace']) {
            $this->context['namespace'] = $this->gp('namespace');
        }
        $token = [];
        $fromUrl = $_SERVER['HTTP_REFERER'];
        if (!$fromUrl || strpos($fromUrl, '?') === false) {
            $fromUrl = $this->gp('$from');
        }
        if ($fromUrl || strpos($fromUrl, '?') !== false) {
            list($autoId) = explode('#', $fromUrl);
            list(, $autoId) = explode('?', $autoId);
            list($autoId) = explode('.', $autoId);
            $this->context['type'] = 'platform';
            if (strpos($autoId, '|') !== false) {
                list($autoId, $this->context['type']) = explode('|', $autoId);
            }
            if ($autoId) {
                $token[] = $this->context['type'];
                $token[] = $this->context['autoId'] = $autoId;
                $this->context['namespace'] = $autoId;
            }
        }
        $this->context['udid'] = md5(__FILE__ . $_SERVER['SERVER_NAME']);
        if ($this->context['request']['udid']) {
            $this->context['udid'] = $this->context['request']['udid'];
        }
        $this->context['appKey'] = $this->appKey();
        $this->context['db_permissions'] = $this->option('db_permissions');
        if (is_string($this->context['db_permissions'])) {
            $this->context['db_permissions'] = json_decode($this->context['db_permissions'], 1);
        }
        !$this->context['db_permissions'] && $this->context['db_permissions'] = [];
        //构建通过url触发的函数
        $method = $this->gp('_method');
        if ($method) {
            $r = $this->cloud($method, ['from' => 'url', ]); //为保证安全，仅自带url解析的函数可以执行，如支付接口回调
            if (is_array($r)) {
                $this->_output = $r;
                $this->output();
            } else {
                echo $r;
                exit();
            }
        }
        //处理请求信息
        if (isset($_REQUEST['postData'])) {
            $input = $_REQUEST['postData'];
        } else {
            $input = @file_get_contents('php://input');
        }
        if (substr($input, 0, 6) == '@onez:') {
            $input = $this->strcode(substr($input, 6) , 'DECODE');
        }
        if ($input) {
            $this->context['$input'] = json_decode($input, 1);
            if (!$this->context['$input']['udid']) {
                return $this->error('udid无效', true);
            }
            $sign = md5($this->context['$input']['udid'] . $this->context['$input']['time'] . $this->context['appKey']);
            if ($sign != $this->context['$input']['sign']) {
                return $this->error('签名验证失败', true);
            }
            if (abs($this->context['$input']['time'] - time()) > 300) {
                return $this->error('系统繁忙，请稍候重试！', true);
            }
            //登录信息
            $this->context['udid'] = $this->context['$input']['udid'];
            $this->context['device'] = $this->db(['method' => 'one', 'table' => 'device', 'where' => ['udid' => $this->context['$input']['udid']], ], true);
            //自动增加设备记录
            if (!$this->context['device']) {
                $arr = [];
                $arr['udid'] = $this->context['udid'];
                $arr['userid'] = 0;
                $arr['netType'] = $this->context['$input']['netType'];
                $arr['platform'] = $this->context['$input']['platform'];
                $arr['systemInfo'] = $this->context['$input']['systemInfo'];
                $this->db(['method' => 'insert', 'table' => 'device', 'arr' => $arr, ], true);
                $this->context['device'] = $this->db(['method' => 'one', 'table' => 'device', 'where' => ['udid' => $this->context['$input']['udid']], ], true);
            }
            if ($this->context['device'] && $this->context['device']['userid']) {
                $this->context['user'] = $this->db(['method' => 'one', 'table' => 'user', 'where' => ['userid' => $this->context['device']['userid']], ], true);
                if ($this->context['user']) {
                    $this->context['roles'] = $this->context['user']['roles'];
                    if (!$this->context['roles'] || !is_array($this->context['roles'])) {
                        $this->context['roles'] = ['user'];
                    }
                    $this->context['userid'] = (int)$this->context['user']['userid'];
                } else {
                    unset($this->context['user']);
                }
            }
            $this->output('userid', $this->context['userid']);
            $this->output('roles', $this->context['roles']);
            $results = [];
            foreach ($this->context['$input']['req'] as $KEY => $_REQUEST) {
                //当前页面信息
                $this->context['pageToken'] = $this->gp('pageToken');
                $this->result = ['status' => 'success', 'data' => $this->cloud($this->gp('method') , $_REQUEST['request']) , ];
                $results[$KEY] = $this->result;
            }
            $this->output('results', $results);
            $this->context['encrypt'] = true; //加密传输
            
        }
        $this->output();
    }
    function user($userid = 0, $is_system = false) {
        if (!$userid) {
            $userid = $this->context['userid'];
        }
        if (!$userid) {
            return;
        }
        $user = $this->db(['method' => 'one', 'table' => 'user', 'where' => ['userid' => $userid], ], $is_system);
        return $user;
    }
    function siteurl() {
        $get = [];
        foreach (func_get_args() as $v) {
            if (is_string($v)) {
                parse_str($v, $v);
            }
            $v && $get = array_merge($get, $v);
        }
        $url = $this->context['homepage'] . '/' . basename(__FILE__);
        $get && $url.= '?' . http_build_query($get);
        return $url;
    }
    function guid() {
        mt_srand((double)microtime() * 10000); //optional for php 4.2.0 and up.
        $charid = strtoupper(md5(uniqid(rand() , true)));
        $hyphen = chr(45); // "-"
        $uuid = '' // "{"
         . substr($charid, 0, 8) . $hyphen . substr($charid, 8, 4) . $hyphen . substr($charid, 12, 4) . $hyphen . substr($charid, 16, 4) . $hyphen . substr($charid, 20, 12) . ''; // "}"
        return $uuid;
    }
    //验证
    function post_sign() {
        $udid = $this->gp('udid');
        $time = $this->gp('time');
        $sign = md5($udid . $time . $this->context['appKey']);
        if ($sign != $this->gp('sign')) {
            return $this->error('签名验证失败', true);
        }
        if (abs($time - time()) > 300) {
            return $this->error('系统繁忙，请稍候重试！', true);
        }
    }
    //base64上传
    function base64() {
        $this->post_sign();
        $data = $_REQUEST['data'];
        $ext = 'jpg';
        $type = 'image';
        if (strpos($data, ';base64') !== false) {
            $datePre = substr($data, 0, 100);
            if (strpos($datePre, 'audio/mp3;') !== false) {
                $ext = 'mp3';
                $type = 'audio';
            } elseif (strpos($datePre, 'video/') !== false) {
                list(, $ext) = explode('video/', $datePre);
                list($ext) = explode(';', $ext);
                $type = 'video';
            }
            list(, $data) = explode(';base64', $data);
        }
        $data = base64_decode($data);
        $md5 = md5($data);
        $file = $this->db(['method' => 'one', 'table' => 'files', 'where' => ['md5' => $md5, ], ], true);
        if ($file) {
            $this->db(['method' => 'update', 'table' => 'files', 'arr' => ['updatetime' => time() , 'times' => $file['times'] + 1, ], 'where' => ['_id' => $file['_id'], ], ], true);
            return json_encode(['status' => 'success', 'code' => 200, 'url' => $file['url']]);
        }
        $file = '/uploads/' . date('Y/m/d') . '/' . uniqid() . '.' . $ext;
        if ($type == 'image') {
            $im = @imagecreatefromstring($data);
            if (!$im) {
                $this->error('无效图片');
            }
            $width = @imagesx($im);
            $height = @imagesy($im);
            @imagedestroy($im);
            if ($width <= 0 || $height <= 0) {
                $this->error('无效图片');
            }
            $fileId = $this->write($file, $data);
        } elseif ($type == 'audio') {
            $fileId = $this->write($file, $data);
        } elseif ($type == 'video') {
            $fileId = $this->write($file, $data);
        } else {
        }
        if ($fileId) {
            $url = $this->fileUrl($fileId);
            $this->db(['method' => 'insert', 'table' => 'files', 'arr' => ['fileId' => $fileId, 'url' => $url, 'ext' => $ext, 'size' => strlen($data) , 'md5' => $md5, 'times' => 1, 'udid' => $this->gp('udid') , ], ], true);
            return json_encode(['status' => 'success', 'code' => 200, 'url' => $url]);
        } else {
            $this->error('上传失败');
        }
    }
    //获取加密密钥
    function appKey() {
        $appKey = $this->config('appKey');
        !$appKey && $appKey = '7762b25a171ecf93d1d232a7458137fb';
        return $appKey;
    }
    function strcode($string, $action = 'ENCODE', $key = false) {
        $strlen = 0;
        $arr = array();
        if ($action == 'ENCODE') {
            $string = base64_encode($string);
            $strlen = strlen($string);
        } else {
            $string = base64_decode($string);
            $arr = array();
            for ($i = 0; $i < strlen($string); $i+= 2) {
                $arr[] = hexdec(substr($string, $i, 2));
            }
            $strlen = count($arr);
        }
        $code = array();
        if ($key === false) {
            $key = $this->context['appKey'];
        }
        $keylen = strlen($key);
        for ($i = 0; $i < $strlen; $i++) {
            $k = $i % $keylen;
            if ($action == 'ENCODE') {
                $code[] = str_pad(dechex(hexdec(bin2hex($string[$i])) ^ hexdec(bin2hex($key[$k]))) , 2, '0', STR_PAD_LEFT);
            } else {
                $r = $arr[$i] ^ hexdec(bin2hex($key[$k]));
                $code[] = hex2bin(dechex($r));
            }
        }
        return ($action == 'DECODE' ? base64_decode(implode("", $code)) : base64_encode(implode("", $code)));
    }
    //读取变量
    function config($key = false, $value = false, $namespace = false) {
        if ($namespace === false) {
            $namespace = $this->context['namespace'];
        }
        if ($this->_config === false) {
            $this->_config = $this->db(['method' => 'one', 'table' => 'config', 'where' => ['namespace' => $namespace]], true);
        }
        if ($key && $value !== false) {
            $this->_config[$key] = $value;
            $this->db(['method' => 'update', 'table' => 'config', 'arr' => [$key => $value], 'where' => ['namespace' => $namespace]], true);
        } else {
            return $key ? $this->_config[$key] : $this->_config;
        }
    }
    //输出操作
    function output($key = false, $value = false) {
        if ($key === false) {
            header('Content-Type:application/json; charset=utf-8');
            if ($this->logs) {
                $this->_output['logs'] = $this->logs;
            }
            $str = json_encode($this->_output, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
            if ($this->context['encrypt']) {
                $str = $this->strcode($str, 'ENCODE');
            }
            exit($str);
        } else {
            $this->_output[$key] = $value;
        }
    }
    //输出错误
    function error($text) {
        $this->output('status', 'error');
        $this->output('error', $text);
        $this->output();
    }
    function cloud($method, $request, $onErrorStop = true, $is_system = false) {
        if ($method) {
            $method_ = preg_replace('/[^0-9a-zA-Z_]+/i', '_', $method);
            if (method_exists($this, $method_)) {
                return call_user_func_array(array(
                    $this,
                    $method_
                ) , [$request, $is_system]);
            }
        }
        if ($onErrorStop) {
            return $this->error('云函数' . $method . '不存在');
        }
    }
    //佳蓝云服务
    function service($method, $request) {
        $r = $this->post('https://onez.cn/api/service.php', http_build_query(['method' => $method, 'request' => serialize($request) ]));
        return unserialize($r);
    }
    function option($key = false) {
        if (!$this->_option) {
            if (file_exists(dirname(__FILE__) . '/config/option.php')) {
                $this->_option = include (dirname(__FILE__) . '/config/option.php');
            } else {
                $this->_option = ['ver' => '1.0'];
            }
            $config = $this->config();
            if ($config) {
                $this->_option = array_merge($config, $this->_option);
            }
        }
        if ($key === false) {
            return $this->_option;
        } else {
            return $this->_option[$key];
        }
    }
    /**
     * 支付购买回调
     *
     * @param string $request['orderno'] 订单号
     * @param string $request['amount'] 订单金额
     * @param string $request['payInfo'] 接口返回信息
     *
     */
    function pay_buy($request, $is_system = false) {
        $result = [];
        $order = $this->cloud('order.get', $request);
        if (!$order || $order->error) {
            return $this->error('获取订单信息失败');
        }
        if ($order['callback_time']) {
            return $this->error('请勿重复处理订单');
        }
        $result['orderno'] = $order['orderno'];
        $this->cloud('order.update', array(
            'orderno' => $order['orderno'],
            'update' => array(
                'status' => 'end',
                'status_name' => '已完成',
                'callback_time' => time()
            )
        ));
        $product = $this->db(array(
            'method' => 'one',
            'table' => 'product',
            'where' => array(
                '_id' => $order['info']['pid']
            )
        ) , true);
        $nickname = '匿名用户';
        if ($order['userid']) {
            $user = $this->db(array(
                'method' => 'one',
                'table' => 'user',
                'where' => array(
                    'userid' => $order['userid']
                )
            ) , true);
            if ($user) {
                $nickname = $user['nickname'];
            }
        }
        if ($product['type'] == 'card') {
            if ($product['kc'] < 1) {
                return $this->error('库存不足');
            }
        }
        $item = array(
            'subject' => $product['subject'],
            'orderno' => $order['orderno'],
            'type' => $product['type'],
            'icon' => explode('|', $product['pics']) [0],
            'nickname' => $nickname,
            'pid' => $product['_id'],
            'price' => $order['amount'],
            'userid' => $order['userid'],
            'udid' => $order['udid']
        );
        $update = array(
            'sellnum' => intval($product['sellnum']) + 1
        );
        if ($product['type'] == 'card') {
            $card = $this->db(array(
                'method' => 'one',
                'table' => 'card',
                'where' => array(
                    'pid' => $order['info']['pid'],
                    'use_time' => 0
                )
            ) , true);
            $update['kc'] = $product['kc'] - 1;
            $item['card_usr'] = $card['name'];
            $item['card_pwd'] = $card['pass'];
            $this->db(array(
                'method' => 'update',
                'table' => 'card',
                'arr' => array(
                    'use_time' => time() ,
                    'use_userid' => $order['userid'],
                    'nickname' => $nickname
                ) ,
                'where' => array(
                    '_id' => $card['_id']
                )
            ) , true);
        } else if ($product['type'] == 'hide') {
            $item['hide_content'] = $product['hide_content'];
        } else if ($product['type'] == 'baidu') {
            $item['baidu_url'] = $product['baidu_url'];
            $item['baidu_pwd'] = $product['baidu_pwd'];
        }
        $this->db(array(
            'method' => 'update',
            'table' => 'product',
            'arr' => $update,
            'where' => array(
                '_id' => $product['_id']
            )
        ) , true);
        $result['logId'] = $this->db(array(
            'method' => 'insert',
            'table' => 'buylog',
            'arr' => $item
        ) , true);
        $this->db(array(
            'method' => 'insert',
            'table' => 'moneylog',
            'arr' => array(
                'orderno' => $order['orderno'],
                'userid' => $order['userid'],
                'amount' => $order['amount'],
                'subject' => $order['subject'],
                'summary' => $order['summary'],
                'paytype' => $order['paytype'],
                'paytype_name' => $order['paytype_name'],
                'type' => 'out'
            )
        ) , true);
        $this->cloud('finance.commission', array(
            'orderno' => $order['orderno'],
            'userid' => $order['userid'],
            'amount' => $order['amount']
        ) , true, true);
        if ($order['info']['callId']) {
            $this->cloud('im.call', array(
                'udid' => $order['udid'],
                'callId' => $order['info']['callId'],
                'result' => array(
                    'status' => 'success',
                    'logId' => $result['logId'],
                    'orderno' => $result['orderno']
                )
            ));
        }
        return $result;
    }
    /**
     * 财务 - 佣金分配
     *
     * @param number $request['amount'] 支付金额
     * @param number $request['userid'] 当前用户
     * @param object $request['info'] 附加信息
     *
     */
    function finance_commission($request, $is_system = false) {
        $amount = floatval($request['amount']);
        $income_bl = array();
        $config = $this->config();
        for ($i = 1; $i <= 3; $i++) {
            $bl = intval($config['income_bl' . $i]);
            if ($bl > 0) {
                array_push($income_bl, $bl);
            }
        }
        if (count($income_bl) > 0) {
            $userid = intval($request['userid']);
            $userid_root = $userid;
            for ($i = 0; $i < count($income_bl); $i++) {
                $user = $this->user($userid, $is_system);
                if ($user && $user['up_uid']) {
                    $user_ = $this->user($user['up_uid'], $is_system);
                    if ($user_) {
                        $bl = $income_bl[$i] / 100;
                        $amount_ = $amount * $bl;
                        if ($amount_ > 0) {
                            $this->db(array(
                                'method' => 'update',
                                'table' => 'user',
                                'arr' => array(
                                    'amount' => floatval($user_['amount']) + $amount_
                                ) ,
                                'where' => array(
                                    'userid' => $user_['userid']
                                )
                            ) , $is_system);
                            $this->db(array(
                                'method' => 'insert',
                                'table' => 'moneylog',
                                'arr' => array(
                                    'userid' => $user_['userid'],
                                    'amount' => $amount_,
                                    'orderno' => $request['orderno'],
                                    'subject' => '分销返佣',
                                    'userid_pay' => $userid_root,
                                    'userid_parent' => $user_['up_uid'],
                                    'userid_children' => $userid,
                                    'step' => $i + 1,
                                    'bl' => $bl,
                                    'type' => 'in'
                                )
                            ) , $is_system);
                        }
                        $userid = $user_['userid'];
                    } else {
                        break;
                    }
                } else {
                    break;
                }
            }
        }
        return $result;
    }
    /**
     * 财务 - 申请提现
     *
     * @param number $request['accountId'] 收款账号编号
     * @param number $request['amount'] 提现金额
     *
     */
    function finance_withdraw($request, $is_system = false) {
        $result = [];
        $userid = $this->context['userid'];
        $amount = floatval($request['amount']);
        if ($amount < 1) {
            return $this->error('提现金额不能少于1元');
        }
        $me = $this->user(0);
        if ($me['amount'] < $amount) {
            return $this->error('可提现金额不足');
        }
        $account = $this->db(array(
            'method' => 'one',
            'table' => 'withdraw-account',
            'where' => array(
                '_id' => $request['accountId'],
                'userid' => $userid
            )
        ) , true);
        if (!$account) {
            return $this->error('请正确选择提现账号');
        }
        $update = array(
            'amount' => floatval($me['amount']) - $amount
        );
        if ($account['bank_type'] == 'bank') {
            $update['amount_lock'] = floatval($me['amount_lock']) + $amount;
            $result['goto'] = 'auto?success=已提交提现申请';
            $withdraw_id = $this->db(array(
                'method' => 'insert',
                'table' => 'withdraw',
                'arr' => array(
                    'accountId' => $accountId,
                    'account' => $account,
                    'userid' => $userid,
                    'amount' => $amount,
                    'status' => 'wait',
                    'status_name' => '等待客服处理'
                )
            ) , true);
            $this->db(array(
                'method' => 'insert',
                'table' => 'moneylog',
                'arr' => array(
                    'userid' => $userid,
                    'amount' => $amount,
                    'withdraw_id' => $withdraw_id,
                    'subject' => '申请提现',
                    'type' => 'out'
                )
            ) , true);
        } else if ($account['bank_type'] == 'weixin') {
            $r = $this->cloud('finance.withdraw.weixin', $withdraw_id);
            if ($r['error']) {
                return $this->error($r['error']);
            }
            $result['goto'] = 'auto?success=提现成功';
            $withdraw_id = $this->db(array(
                'method' => 'insert',
                'table' => 'withdraw',
                'arr' => array(
                    'accountId' => $accountId,
                    'account' => $account,
                    'userid' => $userid,
                    'amount' => $amount,
                    'status' => 'success',
                    'status_name' => '提现成功'
                )
            ) , true);
            $this->db(array(
                'method' => 'insert',
                'table' => 'moneylog',
                'arr' => array(
                    'userid' => $userid,
                    'amount' => $amount,
                    'withdraw_id' => $withdraw_id,
                    'subject' => '提现',
                    'type' => 'out'
                )
            ) , true);
        } else if ($account['bank_type'] == 'alipay') {
            $r = $this->cloud('finance.withdraw.alipay', $withdraw_id);
            if ($r['error']) {
                return $this->error($r['error']);
            }
            $result['goto'] = 'auto?success=提现成功';
            $withdraw_id = $this->db(array(
                'method' => 'insert',
                'table' => 'withdraw',
                'arr' => array(
                    'accountId' => $accountId,
                    'account' => $account,
                    'userid' => $userid,
                    'amount' => $amount,
                    'status' => 'success',
                    'status_name' => '提现成功'
                )
            ) , true);
            $this->db(array(
                'method' => 'insert',
                'table' => 'moneylog',
                'arr' => array(
                    'userid' => $userid,
                    'amount' => $amount,
                    'withdraw_id' => $withdraw_id,
                    'subject' => '提现',
                    'type' => 'out'
                )
            ) , true);
        }
        $this->db(array(
            'method' => 'update',
            'table' => 'user',
            'arr' => $update,
            'where' => array(
                'userid' => $userid
            )
        ) , true);
        return $result;
    }
    /**
     * 即时消息 - 触发发起者回调
     *
     * @param string $request['udid'] 设备编号
     * @param string $request['callId'] 呼叫号
     * @param string $request['result'] 处理结果
     *
     */
    function im_call($request, $is_system = false) {
        if ($request['callId']) {
            $ws_apiurl = $this->config('ws_apiurl');
            !$ws_apiurl && $ws_apiurl = 'https://live.onez.cn/api';
            return $this->post($ws_apiurl, array(
                'action' => '$emit',
                'callId' => $request['callId'],
                'result' => $request['result']
            ));
        }
        return $result;
    }
    /**
     * 订单 - 生成新订单
     *
     * @param number $request['amount'] 金额
     * @param string $request['subject'] 支付说明
     * @param string $request['type'] 类型标识
     * @param object $request['info'] 附带参数
     *
     * @return 订单号，类型:null
     */
    function order_add($request, $is_system = false) {
        $orderno = date('YmdHis') . rand(100000, 999999);
        $request['orderno'] = $orderno;
        $request['userid'] = $this->context['userid'];
        $request['udid'] = $this->context['udid'];
        $request['status'] = 'new';
        $request['status_name'] = '新订单';
        $request['is_pay'] = false;
        $request['paytime'] = 0;
        $request['history'] = array(
            array(
                'status' => $request['status'],
                'status_name' => $request['status_name'],
                'time' => time()
            )
        );
        $this->db(array(
            'method' => 'insert',
            'table' => 'order',
            'arr' => $request
        ) , true);
        return $orderno;
    }
    /**
     * 订单 - 获取订单信息
     *
     * @param string $request['订单号'] orderno
     *
     * @return 完整订单信息，类型:null
     */
    function order_get($request, $is_system = false) {
        $orderno = is_array($request) ? $request['orderno'] : $request;
        $order = $this->db(array(
            'method' => 'one',
            'table' => 'order',
            'where' => array(
                'orderno' => $orderno
            )
        ) , true);
        if (!$order) {
            return $this->error('订单不存在');
        }
        return $order;
    }
    /**
     * 订单 - 更新订单信息
     *
     * @param string $request['orderno'] 订单号
     * @param string $request['update'] 需要更新的订单信息
     *
     * @return 新的完整订单信息，类型:null
     */
    function order_update($request, $is_system = false) {
        if (!$request['update'] || !is_array($request['update'])) {
            return $this->error('order.update失败');
        }
        $order = $this->cloud('order.get', $request);
        if ($order['error']) {
            return $this->error($order['error']);
        }
        $newData = json_decode(json_encode($request['update']) , 1);
        array_push($order['history'], $request['update']);
        $newData['history'] = $order['history'];
        $this->db(array(
            'method' => 'update',
            'table' => 'order',
            'arr' => $newData,
            'where' => array(
                'orderno' => $order['orderno']
            )
        ) , true);
        return $this->cloud('order.get', $request);
    }
    /**
     * 支付
     *
     * @param number $request['amount'] 金额
     * @param string $request['subject'] 支付说明
     * @param string $request['type'] 类型标识
     * @param object $request['info'] 附带参数
     *
     */
    function pay($request, $is_system = false) {
        $result = [];
        $paytypes = array();
        $config = $this->config();
        if ($request['type'] != 'charge') {
            if (!$config['disabled_pay_account']) {
                array_push($paytypes, array(
                    'name' => '余额支付',
                    'token' => 'account'
                ));
            }
        }
        if ($this->context['h5']) {
            if ($this->context['is_weixin']) {
                if ($config['enabled_pay_weixin_mp']) {
                    array_push($paytypes, array(
                        'name' => '微信支付',
                        'token' => 'weixin.mp'
                    ));
                }
            } else {
                if ($config['enabled_pay_weixin_h5']) {
                    array_push($paytypes, array(
                        'name' => '微信支付',
                        'token' => 'weixin.h5'
                    ));
                }
                if ($config['enabled_pay_alipay_h5']) {
                    array_push($paytypes, array(
                        'name' => '支付宝支付',
                        'token' => 'alipay.h5'
                    ));
                }
            }
        }
        $result['paytypes'] = array();
        for ($i = 0; $i < count($paytypes); $i++) {
            array_push($result['paytypes'], array(
                'name' => $paytypes[$i]['name'],
                'event' => array(
                    'token' => 'cloud',
                    'method' => 'pay.' . $paytypes[$i]['token'],
                    'request' => $request
                )
            ));
        }
        return $result;
    }
    /**
     * 支付 - 余额支付
     *
     *
     */
    function pay_account($request, $is_system = false) {
        $result = [];
        $amount = floatval($request['amount']);
        if ($amount <= 0) {
            return $this->error('支付金额有误');
        }
        if ($this->context['userid'] <= 0) {
            return $this->error('请先登录');
        }
        $user = $this->user(0);
        if (!$user) {
            return $this->error('账号信息有误');
        }
        if (!is_numeric($user['amount']) || $user['amount'] < $amount) {
            return $this->error('余额不足');
        }
        $this->db(array(
            'method' => 'update',
            'table' => 'user',
            'arr' => array(
                'amount' => $user['amount'] - $amount
            ) ,
            'where' => array(
                'userid' => $user['userid']
            )
        ) , true);
        $request['paytype'] = 'account';
        $request['paytype_name'] = '余额支付';
        $orderno = $this->cloud('order.add', $request);
        if ($request['callback']) {
            return $this->cloud($request['callback'], $orderno);
        }
        $result['orderno'] = $orderno;
        $result['message'] = '支付成功';
        $result['update'] = '*';
        return $result;
    }
    /**
     * 推广优化 - 海报
     *
     * @param string $request['path'] 跳转页面路径
     *
     * @return 含二维码的海报图片地址，类型:null
     */
    function seo_poster($request, $is_system = false) {
        $url = explode('#', $this->context['$input']['url']) [0];
        $url.= '#' . $request['path'];
        $request['url'] = $url;
        //海报宣传语
        $request['text'] = $this->config('poster_text');
        return $this->service('seo.poster', $request);
    }
    /**
     * 用户 - 登录
     *
     * @param string $request['username']
     * @param string $request['password']
     *
     */
    function user_login($request, $is_system = false) {
        $result = [];
        if (!$request['username']) {
            return $this->error('请正确填写登录账号或手机号');
        }
        $or = [];
        $or[] = ['username' => $request['username']];
        $or[] = ['mobile' => $request['username']];
        $T = $this->db(['method' => 'one', 'table' => 'user', 'where' => ['$or' => $or], ], true);
        if (!$T) {
            return $this->error('账号不存在');
        }
        if ($T['password'] != md5($request['password'])) {
            return $this->error('密码不正确');
        }
        if (!$this->context['udid']) {
            return $this->error('非法操作');
        }
        //更新登录信息
        $this->db(['method' => 'update', 'table' => 'user', 'arr' => ['last_login_date' => time() , 'last_login_ip' => $this->ip() , 'udid' => $this->context['udid'], ], 'where' => ['_id' => $T['_id']], ], true);
        $result['info'] = ['userid' => $T['userid'], 'roles' => $T['roles'], ];
        $this->output('userid', $T['userid']);
        $this->output('roles', $T['roles']);
        $this->db(['method' => 'update', 'table' => 'device', 'arr' => ['userid' => $T['userid'], 'lasttime' => time() , ], 'where' => ['udid' => $this->context['udid']], ], true);
        $result['message'] = '登录成功';
        $result['update'] = '*';
        return $result;
    }
    /**
     * 用户 - 绑定邀请关系
     *
     * @param number $request['userid'] 当前用户编号
     * @param string $request['inv'] 邀请码
     *
     */
    function user_onInvite($request, $is_system = false) {
        $userid = intval($request['userid']);
        $user = $this->user($userid);
        if ($user['up_uid']) {
            return;
        }
        $up_uid = intval($request['inv']);
        if ($up_uid == 0 || $up_uid == $userid) {
            return;
        }
        $up_user = $this->user($up_uid);
        if (!$up_user) {
            return;
        }
        $this->db(array(
            'method' => 'update',
            'table' => 'user',
            'arr' => array(
                'up_uid' => $up_uid
            ) ,
            'where' => array(
                'userid' => $userid
            )
        ) , true);
        $child_num = $this->db(array(
            'method' => 'rows',
            'table' => 'user',
            'where' => array(
                'userid' => $up_uid
            )
        ) , true);
        $this->db(array(
            'method' => 'update',
            'table' => 'user',
            'arr' => array(
                'child_num' => $child_num
            ) ,
            'where' => array(
                'userid' => $up_uid
            )
        ) , true);
        return $request['inv'];
    }
    /**
     * 用户 - 注册
     *
     * @param string $request['username']
     * @param string $request['password']
     * @param string $request['password2']
     *
     */
    function user_register($request, $is_system = false) {
        $result = [];
        if (!$request['username']) {
            return $this->error('请正确填写登录账号');
        }
        $T = $this->db(['method' => 'one', 'table' => 'user', 'where' => ['username' => $request['username']], ], true);
        if ($T) {
            return $this->error('登录账号已被注册，请更换');
        }
        if (!$T) {
            $item = [];
            $last = $this->db(['method' => 'one', 'table' => 'user', 'sort' => ['userid' => - 1], ], true);
            $item['userid'] = $last['userid'] + 1;
            $item['roles'] = ['user'];
            $item['nickname'] = $request['username'];
            $item['username'] = $request['username'];
            $item['password'] = md5($request['password']);
            $item['register_date'] = time();
            $item['register_ip'] = $this->ip();
            $item['avatar'] = 'http://cdn.onez.cn/icons/2021/0710/2021071014052557730001.png';
            $item['udid'] = $this->context['udid'];
            $this->db(['method' => 'insert', 'table' => 'user', 'arr' => $item], true);
            $T = $this->db(['method' => 'one', 'table' => 'user', 'where' => ['username' => $request['username']], ], true);
        }
        $this->db(['method' => 'update', 'table' => 'user', 'arr' => ['last_login_date' => time() , 'last_login_ip' => $this->ip() , 'udid' => $this->context['udid'], ], 'where' => ['_id' => $T['_id']], ], true);
        $result['info'] = ['userid' => $T['userid']];
        $this->output('userid', $T['userid']);
        $this->db(['method' => 'update', 'table' => 'device', 'arr' => ['userid' => $T['userid'], 'lasttime' => time() , ], 'where' => ['udid' => $this->context['udid']], ], true);
        $result['message'] = '注册成功';
        $result['update'] = '*';
        return $result;
    }
}
define('IN_ONEZ_CLOUD', TRUE);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
//强制编码
header('Content-Type:text/html;charset=utf-8');
@ini_set('date.timezone', 'Asia/Shanghai');
global $onez_cloud_api;
$onez_cloud_api = new onez_cloud();
$onez_cloud_api->run();
function onez() {
    global $onez_cloud_api;
    return $onez_cloud_api;
} ?>