🌍
*[Čeština](README-cs.md) ∙ [Deutsch](README-de.md) ∙ [Ελληνικά](README-el.md) ∙ [English](README.md) ∙ [Español](README-es.md) ∙ [Français](README-fr.md) ∙ [Indonesia](README-id.md) ∙ [Italiano](README-it.md) ∙ [日本語](README-ja.md) ∙ [한국어](README-ko.md) ∙ [polski](README-pl.md) ∙ [Português](README-pt.md) ∙ [Română](README-ro.md) ∙ [Русский](README-ru.md) ∙ [Slovenščina](README-sl.md) ∙ [Українська](README-uk.md) ∙ [简体中文](README-zh.md) ∙ [繁體中文](README-zh-Hant.md)*

# Мистецтво командного рядка

[![Задайте питання](https://img.shields.io/badge/%3f-Ask%20a%20Question-ff69b4.svg)](https://airtable.com/shrzMhx00YiIVAWJg)
[![Вступайте в англомовний чат проекту https://gitter.im/jlevy/the-art-of-command-line](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/jlevy/the-art-of-command-line?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)


- [Опис](#Опис)
- [Основи](#Основи)
- [Щоденне використання](#Щоденне-використання)
- [Обробка файлів та інформації](#Обробка-файлів-та-інформації)
- [Відладка](#Відладка)
- [Одним рядком](#Одним-рядком)
- [Складно але корисно](#Складно-але-корисно)
- [Тільки для OS X](#Тільки-для-os-x)
- [Тільки для Windows](#Тільки-для-windows)
- [Інші джерела](#Інші-джерела)
- [Відмова від відповідальності](#Відмова-від-відповідальності)


![curl -s 'https://raw.githubusercontent.com/jlevy/the-art-of-command-line/master/README.md' | egrep -o '`\w+`' | tr -d '`' | cowsay -W50](cowsay.png)

Використанню командного рядка часто не приділяють достатньої уваги. Про термінал говорять, як про щось містичне. Насправді, ці навики явно (і не явно) збільшують вашу продуктивність у роботі. Даний документ є підбіркою на наш погляд корисних при роботі з командним рядком в Linux заміток і порад. Деякі з них - прості та очевидні, але інші - або призначені для вирішення конкретних завдань, або досить складні чи широко невідомі. Це невелика публікація, але якщо ви вже все знаєте, що тут написано, і можете згадати як це все використовувати - ви знаєте багато!

Це -- результат роботи [багатьох авторів і перекладачів](AUTHORS.md).
Дещо з цього [спочатку](http://www.quora.com/What-are-some-lesser-known-but-useful-Unix-commands) [з'явилось](http://www.quora.com/What-are-the-most-useful-Swiss-army-knife-one-liners-on-Unix) на [Quora](http://www.quora.com/What-are-some-time-saving-tips-that-every-Linux-user-should-know), але потім переїхало на Github, де багато людей талановитіших за початкового автора, внесли багато удосконалень.
[**Задайте питання**](https://airtable.com/shrzMhx00YiIVAWJg) якщо у вас є питання стосовно командного рядка. 
[**Будь-ласка, зробіть свій внесок**](/CONTRIBUTING.md) якщо ви знайшли помилку або можете щось покращити!



## Опис

Охоплення:

- Дана публікація призначена як для початківців, так і для досвідчених користувачів. Цілі: *наповнення* (зібрати всі важливі аспекти використання командного рядка), *практичність* (надати конкретні приклади для найпоширеніших ситуацій) та *стислість* (не варто вдаватись у несуттєві деталі, про які можна прочитати деінде).
- Цей документ написаний для користувачів Linux, за винятком розділів "[Тільки для OS X](#Тільки-для-os-x)" та "[Тільки для Windows(#Тільки-для-Windows)]". Все інше підходить для всіх UNIX чи OS X систем (і навіть для Cygwin).
- Сфокусована на інтерактивному Bash, але багато порад також можуть застосовуватися в інших командних оболонках чи загалом до Bash-скриптів.
- Ця інструкція включає в себе як стандартні Unix команди, так і ті, для використання яких потрібно встановлювати додаткові пакети, якщо користь  від  застосування команди виправдовує установку пакету.

Нотатки:

- Вся інформація збережена в одному файлі для спрощення пошуку, перекладу та навігації. У  вас вистачить  вмінь, щоб самостійно вивчити питання більш детально в іншому місці. Використовуйте `apt-get`, `yum`, `dnf`, `pacman`, `pip` та `brew` (залежно від вашої системи управління пакетами) для установки нових програм.

- На [Explainshell](http://explainshell.com/) можна знайти просте і докладне пояснення того, що таке команди, їх опції, пайпи(pipes(*|*)) і т.д.


## Основи

- Вивчіть основи Bash. Просто візьміть і наберіть у командному рядку термінала `man bash` і хоча б перегляньте; він досить просто читається і він не дуже великий. Інші шелли теж можуть бути хороші, але Bash - потужна програма, і Bash завжди під рукою (вивчення *виключно* zsh, fish і т.д., хоч і привабливо  на вашому особистому комп'ютері, насправді обмежує в багатьох випадках, наприклад при використанні існуючих серверів).

- Вивчіть використання хоча б одного консольного редактора тексту. Найкраще Vim (`vi`), адже у нього немає конкурентів, коли вам потрібно швидко щось правити (навіть якщо ви постійно використовуєте Emacs чи якийсь важкий IDE або модний хіпстерський редактор).

- Знайте, як читати документацію командою `man` (для допитливих: `man man` пояснює номери розділів документації, наприклад 1 - для звичайних команд, 5 - для файлів, 8 - для адміністративних команд). Шукайте інформацію через `apropos`, і пам'ятайте, що деякі команди - не виконувані (executables), а внутрішні команди Bash, і допомогу по них можна отримати через команду `help` і `help -d`. Ви можете з'ясувати чи є Ваша команда виконуваним файлом чи вбудована в shell чи є псевдонім, використовуючи команду `type команда`.

- Можна перенаправляти ввід та вивід користуючися `>`, `<` та каналами `|`. Пам'ятайте, що `>` - переписує вихідний файл, а `>>` додає до нього. Дізнайтеся побільше про stdout і stderr.

- Дізнайтеся побільше про розширення шаблонів `*` (а також `?` і `[`...`]`), про вживанняя лапок та про відмінності між подвійними `"` та одинарними `'` лапками.

- Ознайомтеся, як працювати із процесами в Bash: `&`, **ctrl-z**, **ctrl-c**, `jobs`, `fg`, `bg`, `kill`, і т.д.

- Знайте `ssh` та основи безпарольної аутентифікації через `ssh-agent`, `ssh-add`, і т.д.

- Основи роботи з файлами: `ls` і `ls -l` (зокрема, дізнайтеся, що значить кожен стовпець в `ls -l`), `less`, `head`,` tail` і `tail -f` (або навіть краще - `less +F`), `ln` і `ln -s` (дізнайтеся про відмінності та переваги символьних і жорстких посилань), `chown`, `chmod`, `du` (для отримання швидкої інформації по використанню диска: `du -hk *`). Для керування файловою системою: `df`, `mount`, `fdisk`, `mkfs`, `lsblk`. Дізнайтеся, що таке inode (`ls -i` чи `df -i`).

- Основи роботи з мережею: `ip`, `ifconfig`, `dig`, `traceroute` або `route`.

- Вивчіть і використовуйте систему управління версіями, наприклад таку, як `git`.

- Навчіться писати регулярні вирази і вивчіть різні опції для `grep`/`egrep`. Такі опції як `-i`, `-o`, `-A`, та `-B` варто знати.

- Навчіться використовувати системами управління пакетами `apt-get`, `yum`, `dnf` та `pacman` (залежно від дистрибутива). Знайте як шукати і встановлювати пакети. Обов'язково майте встановленим `pip` для встановки модулів та програм, написаних на Python (деякі з тих команд, що ви знайдете нижче, найлегше встановити через `pip`).



## Щоденне використання

- Використовуйте клавішу табуляції (**Tab**) в Bash для автодоповнення аргументів до команд та **ctrl-r** для пошуку по історії командного рядка.

- Використовуйте **ctrl-w** в Bash для того, щоб видалити останнє слово в команді; **ctrl-u** для того, щоб видалити команду повністю. Використовуйте **alt-b** і **alt-f** для того, щоб переміщатись між словами у команді, **ctrl-k** для того, щоб перейти в кінець рядка, **ctrl-l** для того, щоб очистити екран. Гляньте на `man readline` щоб дізнатися про всі комбінації клавіш Bash. Їх багато! Наприклад, **alt-.**  переміщається між попередніми аргументам команди, а **alt-*** максимально розширює аргументи.

- Якщо вам подобаються клавішні комбінації vim, виконайте `set -o vi` (`set -o emacs` щоб повернути налаштування).
- Для редагування довгих команд після налаштування вашого консольного редактора (наприклад `export EDITOR=vim`), **ctrl-x** **ctrl-e** відкриє поточну команду в редакторі для багаторядкового редагування команди. Або у vi стилі, **escape-v**.
- Для того, щоб переглянути історію, введіть `history`. Також існує безліч абревіатур, наприклад `! $` - Останній аргумент, `!!` - остання команда, хоча ці абревіатури часто заміняються комбінаціями **ctrl-r** та **alt-.**.
- Перейти в домашню директорію можна за допомогою `cd`. Щоб вказати шлях до файлів із домашньої директорії можна скористатися префіксом `~` (наприклад: `~/.bashrc`). У `sh` скриптах для звернення до домашньої директорії можна використовувати змінну `$HOME`.
- Для того, щоб стрибнути до останньої робочої директорії, використовуйте `cd -`
- Якщо ви написали команду наполовину і раптом передумали, натисніть **alt-#** для того, щоб додати `#` на початок команди, та відправте команду як коментар. Потім ви зможете повернутися до неї через історію команд.
- Використовуйти `xargs` (або `parallel`). Це дуже корисно. Зверніть увагу, що ви можете контролювати кількість команд на кожен рядок (`-L`) також паралельність (`-P`). Якщо ви не впевнені, що робите щось правильно, почніть з `xargs echo`. Також `-I{}` - корисно. Приклади:
```bash
      find . -name '*.py' | xargs grep some_function
      cat hosts | xargs -I{} ssh root@{} hostname
```
- `pstree -p` - допоможе побачити дерево процесів.
- Grep the output of `ps aux` to know the pid of a process, like `ps aux | grep postgresql`
- Використовуйте `pgrep` і `pkill` для того, щоб знаходити або слати сигнали до процесів по імені (`-f` корисна опція).
- Знайте різні сигнали, які можна слати процесам. Наприклад, щоб призупинити процес, використовуйте `kill -STOP [pid]`. Для повного списку подивіться `man 7 signal`.
- Використовуйте `nohup` або` disown`, якщо ви хочете запустити фоновий процес що б він постійно виконувався у фоні.
- Дізнайтеся, які процеси слухають порти через `netstat -lntp` або `ss -plat` (для TCP; додайте `-u` для UDP).
- Зверніть увагу на команду `lsof` і `fuser`. Вони допоможуть Вам подивитися відкриті сокети і файли.
- Команда `uptime` or `w` показує як довго працює система.
- Використовуйте `alias`, щоб створити скорочення для часто використовуємих команд. Наприклад, `alias ll='ls -latr'` створить нове скорочення(alias) `ll`.
- Збережіть свої синоніми (aliases), налаштування і фунції які ви часто використовуєте у `~/.bashrc`, більш детально [тут](http://superuser.com/a/183980/7106). Це зробить їх доступними в усіх ваших сесіях shell.
- Синхронізуйте ваші конфігураційні файли (наприклад `.bashrc` та `.bash_profile`) між різними комп'ютерами за допомогою Git.
- Вставте настройки змінних середовища і команди, які повинні бути виконані при вході у систему в файл `~/.bash_profile`. Окремі налаштування будуть потрібні для оболонок, які запускаються із під графічного інтерфейсу та з під `cron` задач.
- Необхідно розуміти, що потрібна обережність коли змінні та імена файлів включають пробіли. Окружіть ваші Bash змінні в подвійні лапки: `"$FOO"`. Використовуйте `-0` або `-print0` опції щоб дозволити розмежувати імена файлів за допомогою нульових(null) символів. Наприклад: `locate -0 pattern | xargs -0 ls -al` або `find / -print0 -type d | xargs -0 ls -al`. Щоб перебрати імена файлів які містять пробільні символи для циклу встановіть ваш IFS(API файлової системи) використовувати тільки '\n' для цього використовуйте - `IFS=$'\n'`.
- У Bash скриптах використовуйте `set -x` (або `set -v`) щоб дебажити вивід. Використовуйте строгий(strict) режим скрізь, де це можливо. Використовуйте `set -e` для того, щоб припиняти виконання при помилках (не нульовий вихідний код). Використовуйте `set -u` що б визначити невстановленні змінні. Використовуйте `set -o pipefail` щоб при помилках невикористовувати пайпи(вертикальна риска). Для більш складних скриптів також використовуйте `trap` на EXIT or ERR.
Корисною буде звичка почати використовувати настипний скрипт, який допоможе виявити і перервати на загальних помилках і вивести повідомлення:
```bash
      set -euo pipefail
      trap "echo 'error: Script failed: see failed command above'" ERR
```
- У Bash-скриптах підоболочки(subshells) - зручний спосіб групувати команди. Один із найпоширеніших прикладів - тимчасово пересунутися в іншу робочу директорію:
```bash
     # Do something in current dir
     (cd / some / other / dir && other-command)
     # Continue in original dir
```
- У Bash багато типів простору змінних. Перевірити, чи існує змінна - `${name:? Error message}`. Наприклад, якщо Bash-скрипту потрібен всього один аргумент, просто напишіть `input_file=${1:?usage: $0 input_file}`. Арифметична область видимості: `i=$(( (i + 1) % 5 ))`. Послідовності: `{1..10}`. Обрізка рядків: `${var%suffix}` і `${var#prefix}`. Наприклад, якщо `var=foo.pdf` тоді `echo ${var%.pdf}.txt` виведе `foo.txt`.
- Фігурні скобки, використовуючи `{`...`}` може зменшити необхідність повторно вводити той самий текст і автоматизувати. Це корисно в такому прикладі як `mv foo.{txt,pdf} some-dir` (який пересуває обидва файла), `cp somefile{,.bak}` (який розширюється у `cp somefile somefile.bak`) або `mkdir -p test-{a,b,c}/subtest-{1,2,3}` (яка розширює всі можливі комбінації і створює дерево деректорій).
- Вивід будь-якої команди можна обробити як файл наступним чином `<(some command)`. Наприклад, порівняння локального файлу `/etc/hosts з віддаленим:
```sh
      diff /etc/hosts <(ssh somehost cat /etc/hosts)
```
- Знайте про *heredoc* -синтаксис в Bash: `cat << EOF ...`.
- У Bash перенаправляйте стандартні потоки виводу(output) та помилок, ось так: `some-command >logfile 2>&1`. Найчастіше, для того, щоб переконатись, що команда не залишить відкритим файл, прив'язавши його до відкритого терміналу, вважається хорошою практикою додавати `</dev/null`.
- Використовуйте `man ascii` щоб отримати таблицю ASCII символів із шіснадцядковими і десятковими значеннями. Для інших основних кодувань користуйтесь: `man unicode`,` man utf-8` і `man latin1`.
- Використовуйте `screen` або [`tmux`](https://tmux.github.io/) для того, щоб мати кілька екранів в одному терміналі. Це особливо корисно в ssh сесії що б приєднатись чи відєднатись до сесії. `byobu` розширює функціонал screen або tmux надає більше інформації і полегшить керування. Більш мінімалістичною альтернативою для цього є [`dtach`](https://github.com/bogner/dtach).
- У SSH корисно знати як зробити port tunnel з опціями `-L` і` -D` (іноді `-R`) це корисно наприклад для того, щоб отримати доступ до сайту із віддаленого сервера.
- Ще може бути корисно зробити декілька оптимізацій у конфігурації вашого SSH, наприклад у файлі `~/.ssh/config` містить налаштування, які допомагають уникати втрачених підключень в деяких мережевих оточеннях, використати стиснення (яке корисне при використанні scp при повільному підключенні) і збільште кількість каналів до одного сервера через цей конфіг, ось так:
```
      TCPKeepAlive=yes
      ServerAliveInterval=15
      ServerAliveCountMax=6
      Compression=yes
      ControlMaster auto
      ControlPath /tmp/%r@%h:%p
      ControlPersist yes
```
- Деякі із інших налаштування SSH можуть сильно вплинути на безпеку і повинні мінятися обережно, наприклад, для конкретної підмережі, конкретної машини або в домашніх мережах: `StrictHostKeyChecking=no`, `ForwardAgent=yes`
- Розглянемо [`mosh`](https://mosh.org/) як альтернатива ssh який використовує UDP, уникаючи розривів підключеня (вимагає установки на стороні сервера).
- Щоб отримати права доступу до файлу у вісімковому вигляді, що є корисно для конфігурації систем але не можна отримати з допомогою команди `ls`, можна використовувати щось схоже на це:
```sh
      stat -c '%A %a %n' /etc/timezone
```
- Для інтерактивного виділення результатів інших команд використовуйте [`percol`](https://github.com/mooz/percol) або [`fzf`](https://github.com/junegunn/fzf).
- Для роботи з файлами, список яких дала інша команда (наприклад `git`), використовуйте `fpp` ([PathPicker](https://github.com/facebook/PathPicker)).
- Щоб швидко підняти веб-сервер в поточній директорії (і піддерикторіях), який доступний для всіх у вашій мережі, використовуйте:
`python -m SimpleHTTPServer 7777` (на прту 7777 і для Python 2) або `python -m http.server 7777` (на прту 7777 і для Python 3).
- Щоб виконати команду з привілеями, використовуйте `sudo` (для root) і `sudo -u` (для іншого користувача). Використовуйте `su` або `sudo bash`, щоб запустити шелл від імені цього користувача. Використовуйте `su -`, щоб симулювати свіжий вхід під root або під іншим користувачем.


## Обробка файлів та інформації

- Для того, щоб знайти файл в поточній директорії, виконайте `find. -iname '*something*'`. Для того, щоб шукати файл по всій системі, використовуйте `locate something` (але не забувайте, що `updatedb` міг ще не проіндексувати нещодавно створені файли).
- Для пошуку по вмісту або фалах (більш детально зробити пошук допоможе `grep -r`) використовуйте [`ag`](https://github.com/ggreer/the_silver_searcher).
- Для конвертації HTML в текст: `lynx -dump -stdin`
- Для конвертації різних типів розмітки (HTML, Markdown та ін.) спроробуйте утиліту [`pandoc`](http://pandoc.org/).
- Якщо нуобхідно працювати з XML, є стара, але хороша утиліта - `xmlstarlet`.
- Для роботи з JSON використовуйте [`jq`](http://stedolan.github.io/jq/).
- Для YAML використовуйте [`shyaml`](https://github.com/0k/shyaml).
- Для Excel і CSV файлів [csvkit](https://github.com/onyxfish/csvkit) надає `in2csv`, `csvcut`, `csvjoin`, `csvgrep` і т.д.
- Для Amazon S3 [`s3cmd`](https://github.com/s3tools/s3cmd) є зручним і [`s4cmd`](https://github.com/bloomreach/s4cmd) є швидшим. Для решти сервісів Амазону використовуйте стандартний [`aws`](https://github.com/aws/aws-cli) і удосконалений [`saws`](https://github.com/donnemartin/saws).
- Знайте про `sort` і `uniq`, включаючи опції `-u` і `-d`, дивіться приклади нижче. Ще спробуйте `comm`.
- Знайте про `cut`, `paste`, і `join` для роботи з текстовими файлами. Багато людей використовують `cut`, забувши про `join`.
- Знайте про `wc`: для підрахунку нових рядків (`-l`), символів (`-m`), слів (`-w`) і для байтового підрахунку (`-c`).
- Знайте про `tee` для копіювання в файл з stdin і stdout, щось типу `ls -al | tee file.txt`.
- Не забувайте, що ваші налаштування консолі та мовні/регіональні налаштування (локаль) впливають на багато команд, включаючи порядок сортування, порівняння і продуктивність. Багато дистрибутиви Linux автоматично виставляють `LANG` або будь-яку іншу змінну в підходящу для вашого регіону. Через це результати функцій сортування можуть працювати непередбачувано. Знайте що `i18n` можуть значно знизити продуктивність сортувань. У деяких випадках можна повністю цього уникати (за винятком рідкісних випадків), сортуючи традиційно побайтово, використовуйте `export LC_ALL = C`.
- Ви можете встановити спецефічне середовище для команди за допомогогю префікса, а саме: `TZ=Pacific/Fiji date`.
- Знайте основи `awk` і `sed` для простих маніпуляцій з даними. Наприклад, щоб отримати суму всіх чисел, які знаходяться в третій колонці текстового файлу, можна використати `awk '{ x += $3 } END { print x }'`. Швидше за все, це вийде в рази 3 швидше і рази в 3 простіше, ніж робити це в Пітоні.
- Щоб замінити всі входження підрядка в одному або декількох файлах:
```sh
      perl -pi.bak -e 's/old-string/new-string/g' my-files-*.txt
```
- Щоб перейменувати відразу багато файлів за шаблоном, використовуйте `rename`. Для складних перейменувань може допомогти [`repren`](https://github.com/jlevy/repren):
```sh
      # Recover backup files foo.bak -> foo:
      rename 's/\.bak$//' *.bak
      # Full rename of filenames, directories, and contents foo -> bar:
      repren --full --preserve-case --from foo --to bar .
```
- Як говорить man сторінка, `rsync` дійсно є швидким і універсальним інструментом копіювання файлів, для синхронізації між машинами, але в рівній мірі корисні на локальному рівні. Також [швидке рішення](https://web.archive.org/web/20130929001850/http://linuxnote.net/jianingy/en/linux/a-fast-way-to-remove-huge-number-of-files.html) що б видалити велику кількість файлів:
```sh
      mkdir empty && rsync -r --delete empty/ some-dir && rmdir some-dir
```
- Використовуйте `shuf`, щоб перемішати або вибрати випадкові рядки з файлу.
- Знайте опції для команди `sort`. Для чисел використовуйте `-n` або `-h`, для роботи з числами (наприклад `du -h`). Знайте як працюють ключі (`-t` і `-k`). Зокрема, не забувайте, що вам потрібно писати `-k1,1` для того, щоб впорядкувати тільки перше поле; `-k1` - це означає сортування враховуючи цілий рядок. Може бути корисною (`sort -s`). Наприклад для того, щоб відсортувати найважливіше по другому полю, а другорядне по першому, можна використовувати `sort -k1,1 | sort -s -k2,2`.
- Якщо вам коли-небудь доведеться написати код символу табуляції в терміналі, наприклад, для сортування за табуляції з прапором -t, використовуйте скорочення **ctrl-v** **[Tab]** або напишіть `$'\t'`. Останнє краще, тому що його можна скопіювати/вставити.
- Стандартні інструменти для виправлення вихідного коду це `diff` і `patch`. Також зверніть увагу на `diffstat` для перегляду статистики diff і `sdiff` для крок за кроком diff. Запамятайте `diff -r` працює рекурсивно по всій директорії. Використовуйте `diff -r tree1 tree2 | diffstat` для повного зведення змін. Використовуйте `vimdiff` порівняти і редагувати файли.
- Для бінарних файлів використовуйте `hd`, `hexdump` або `xxd` для простих hex-дампом, і `bvi`, hexedit або `biew` для зміни бінарників.
- Також для бінарних файлів, `strings` (плюс `grep`, і т.п.) дозволить вам знайти біти тексту.
- Щоб подивитися різницю в бінарниках (дельта-кодування): `xdelta3`.
- Для конвертування кодувань використовуйте `iconv`. Для більш складних завдань - `uconv`, він підтримує деякі складні фічі Юникода. Наприклад, ця команда переводить рядки з файлу в нижній регістр і прибирає наголоси (наприклад в іспанській мові)
```sh
      uconv -f utf-8 -t utf-8 -x '::Any-Lower; ::Any-NFD; [:Nonspacing Mark:] >; ::Any-NFC; ' < input.txt > output.txt
```
- Для того, щоб розбити файл на шматки, використовуйте `split` (розбиває на шматки за розміром), або `csplit` (за шаблоном або по регулярному виразу).
- Для дати і часу використовуйте  `dateadd`, `datediff`, `strptime` ще можете знайти на [`dateutils`](http://www.fresse.org/dateutils).
- Використовуйте `zless`, `zmore`, `zcat`, і `zgrep` для роботи зі стиснутими файлами.


## Відладка

- Для відладки веб сторінок використовуйте `curl` і `curl -I`, або альтернативу - `wget` або [`httpie`](https://github.com/jakubroztocil/httpie).
- Щоб отримати інформацію про диск/CPU/мережі використовуйте `iostat`, `netstat`, `top` (краще `htop`) і `dstat`. Використовуйте `iostat -mxz 15` для отримання основної інформації CPU.
- Для інформації про мережу використовуйте `netstat` і `ss`.
- Для більш детальної інформації використовуйте [`glances`](https://github.com/nicolargo/glances). Ця програма показує відразу кілька різних статистик в одному вікні терміналу. Корисно, коли стежите за відразу декількома системами.
- Для того, щоб стежити за пам'яттю вокористовуйте `free` і `vmstat`. Зокрема, не забувайте, що значення кешування ("cached" value) - Це пам'ять, яку тримає ядро і ці значення є частиною `free`.
- Використовуйте [`mtr`](http://www.bitwizard.nl/mtr/) для збору статистики трасування(простежити маршрут до віддаленого сервера), щоб знаходити проблеми мережі.
- Для того, щоб дізнатися, чому диск повністю забитий, використовуйте [`ncdu`](https://dev.yorhel.nl/ncdu), це зберігає час у порівнянні з тим же `du -sh *`.
- Для того, щоб дізнатися, який сокет або процес використовує інтернет, використовуйте [`iftop`](http://www.ex-parrot.com/~pdw/iftop/) або [`nethogs`](https://github.com/raboof/nethogs).
- Додаток `ab` який поставляється разом з apache, корисний для швидкої і поверхневої перевірки продуктивності веб-сервера. Для більш серйозного лоад-тестінгу використовуйте `siege`.
- Для більш серйозної відладки мережі використовуйте [`wireshark`](https://wireshark.org/), [`tshark`](https://www.wireshark.org/docs/wsug_html_chunked/AppToolstshark.html), і [`ngrep`](http://ngrep.sourceforge.net/).
- Знайте про `strace` та `ltrace`. Ці команди можуть бути корисні, якщо програма падає або висить, і ви не знаєте чому або якщо ви хочете протестувати продуктивність програми. Не забувайте про можливість відладки (`-c`) і можливість причепитися до процесу по pid (` -p`).
- `ldd` для перевірки системних бібліотек.
- Знайте як причепитися до працюючого процесу через `gdb` і отримати трасування стека.
- Використовуйте `/proc`. Іноді він неймовірно корисний для налагодження запущених програм. Приклади: `/proc/cpuinfo`, `/proc/xxx/cwd`, ​​`/proc/xxx/exe`, `/proc/xxx/fd/`, `/proc/xxx/smaps` (де `xxx` id or pid процесу).
- Коли дебажите щось, що зламалося в минулому, використовуйте [`sar`](http://sebastien.godard.pagesperso-orange.fr/) буває дуже корисно. Показує історію та статистику CPU, пам'яті, мережі і т.д.
- Для аналізу більш складних систем і продуктивності використовуйте `stap` ([SystemTap](https://sourceware.org/systemtap/wiki)), [`perf`](http://en.wikipedia.org/wiki/ Perf_(Linux)) і [`sysdig`](https://github.com/draios/sysdig).
- Дізнайтеся, яка у вас операційна система, через `uname` або `uname -a` (інформація про ядро) або `lsb_release -a` (інформація про дистрибутив Linux).
- Використовуйте `dmesg`, коли щось відбувається зовсім дивне (це можуть бути проблеми із залізом, драйверами, тощо).


## Одним рядком

Кілька прикладів склеювання команд:
- Це досить круто, що можна знайти множинни перетину файлів, з'єднати відсортовані файли і подивитися різницю декількох файлів через `sort`/`uniq`. Це швидкий підхід і працює на файлах будь-якого розміру (включаючи багатогігабайтні файли). (Сортування не обмежено пам'яттю, але можливо вам доведеться додати `-T`, якщо `/tmp` знаходиться на невеликому логічному диску). Ще подивіться на те, що було сказано вище про `LC_ALL`. Опція сортування `-u` не використовується нижче, щоб було зрозуміліше:
```sh
      cat a b | sort | uniq > c   # c is a union b
      cat a b | sort | uniq -d > c   # c is a intersect b
      cat a b b | sort | uniq -u > c   # c is set difference a - b
```
- Використовуйте `grep . *` для того, щоб подивитися вміст всіх файлів в директорії. Це може бути корисно для директорій заповнених конфігураціями як ці в `/sys`, `/proc`, `/etc`.
- Просумувати всі числа, які знаходяться в третій колонці текстового файлу (це в 3 рази швидше і 3 рази простіше, ніж робити це в Пітоні) можна наступним чином:
```sh
      awk '{ x += $3 } END { print x }' myfile
```
- Щоб побачити розмір/дату файлів в дереві, це як рекурсивний `ls -l` але легше `ls -lR`:
```sh
      find . -type f -ls
```
- Скажемо що у нас є якийсь текстовий файл, наприклад лог веб сервера і на якихось рядках з'являється значення, рядки з яким нам цікаві. Наприклад, `acct_id`. Давайте підрахуємо, скільки таких запитів в нашім логу:
```sh
      cat access.log | egrep -o 'acct_id=[0-9]+' | cut -d= -f2 | sort | uniq -c | sort -rn
```
- Використовуйте `xargs` (або `parallel`). Зверніть увагу, що ви можете контролювати кількість команд на кожен рядок, а так само паралельність. Якщо ви не впевнені, що робите правильно, почніть з `xargs echo`. Ще `-I {}` - корисна штука. Приклади:
```sh
      find. -name '* .py' | xargs grep some_function
      cat hosts | xargs -I {} ssh root @ {} hostname
```
- Запустіть цю функцію, щоб отримати випадкову вибірку із цього документа:
```sh
      function taocl() {
        curl -s https://raw.githubusercontent.com/jlevy/the-art-of-command-line/master/README.md |
          pandoc -f markdown -t html |
          xmlstarlet fo --html --dropdtd |
          xmlstarlet sel -t -v "(html/body/ul/li[count(p)>0])[$RANDOM mod last()+1]" |
          xmlstarlet unesc | fmt -80
      }
```


## Складно але корисно

- `expr`: для виконання арифметичних і булевих операцій, а також регулярних виразів
- `m4`: простий макро-процесор
- `yes`: безкінечно виводить рядок зі словом "yes"
- `cal`: хороший календар
- `env`: показує змінні середовища (корисно в Bash-скриптах)
- `printenv`: показує змінні оточення (корисно в скриптах або при відладці)
- `look`: виведе рядки у файлі які починаються із заданого слова/підрядка
- `cut`, `paste` і `join`: маніпуляції з даними
- `fmt`: форматування параграфів у тексті
- `pr`: відформатовує текст в сторінки/колонки
- `fold`: (обернути) обмежити довжину рядків у файлі
- `column`: форматувати текст в колонки або таблиці
- `expand` і `unexpand`: конвертація між табами і пробілами
- `nl`: додає номери до рядків
- `seq`: вивести послідовність чисел
- `bc`: калькулятор
- `factor`: піднести число в степінь
- [`gpg`](https://gnupg.org/): зашифрувати і підписати файли
- `toe`: таблиця терміналів terminfo з описом
- `nc`: відладка мережі і передачі даних
- `socat`: перемикач сокетів і перенаправлення tcp-портів (схоже на `netcat`)
- [`slurm`](https://github.com/mattthias/slurm): візуалізація трафіку мережі
- `dd`: перенесення інформації між файлами або пристроями
- `file`: визначає тип файлу
- `tree`: показує директорії і піддиректорії у вигляді дерева, як `ls`, але рекурсивно
- `stat`: інформація про файл
- `time`: виведе інформацію про час виконання команди/програми
- `timeout`: зупиняє виконання команди після того як завершиться вказаний час в аргументі
- `lockfile`: створює позначку в файлі який може бути видаленим тільки через команду `rm -f`
- `logrotate`: змінити, зжати і відправити логи.
- `watch`: запустити команду повторно, показуючи результати і/або виділення змін
- `tac`: вивести файли посимвольно навпаки
- `shuf`: випадкова вибірка рядків з файлу
- `comm`: порядково порівняти відсортовані файли
- `pv`: моніторинг прогресу проходження інформації через пайп
- `hd`, `hexdump`, `xxd`, `biew` і `bvi`: дамп і редагування бінарних файлів
- `strings`: витягнути текст із бінарних файлів
- `tr`: маніпуляція з char (символьним типом)
- `iconv` або `uconv`: конвертація кодувань
- `split` і `csplit`: розбити файли
- `sponge`: прочитати весь інпут перед тим, як його записати. Корисно, коли читаєш з того ж файлу, куди записуєш. Наприклад, ось так: `grep -v something some-file | sponge some-file`
- `units`: використовується для конвертації одиниць вимірювання (дивіться `/usr/share/units/definitions.units`)
- `apg`: генерація паролів
- `7z`: архіватор з високим ступенем стиснення
- `ldd`: показує залежності програми від системних бібліотек
- `nm`: symbols from object files
- `ab`: вбудований в Apache бенчмарк веб-серверів
- `strace` або `wrk`: відладка системних викликів
- [`mtr`](http://www.bitwizard.nl/mtr/): трасування для відладки мережі
- `cssh`: паралельне виконання команд в графічному інтерфейсі
- `rsync`: синхронізація файлів і папок через SSH або на локальній файловій системі
- [`wireshark`](https://wireshark.org/) і [`tshark`](https://www.wireshark.org/docs/wsug_html_chunked/AppToolstshark.html): перехоплення пакетів і відладка мережі
- [`ngrep`](http://ngrep.sourceforge.net/): grep мережевого рівня
- `host` і `dig`: пошук в DNS
- `lsof`: інформація про файлові дескриптори та сокети
- `dstat`: корисна статистика ОС
- [`glances`](https://github.com/nicolargo/glances): сумарна статистика багатьох підсистем
- `iostat`: статистика системи вводу/виводу жорстких дисків
- `mpstat`: статистика використання CPU
- `vmstat`: статистика використання оперативної пам'яті
- `htop`: вдосконалена версія `top`
- `last`: історія входів у систему
- `w`: хто є залогіненим
- `id`: інформація про користувача/групу
- [`sar`](http://sebastien.godard.pagesperso-orange.fr/): historic system stats
- [`iftop`](http://www.ex-parrot.com/~pdw/iftop/) або [`nethogs`](https://github.com/raboof/nethogs): використання мережі конкретним сокетом або процесом
- `ss`: статистика сокетів
- `dmesg`: помилки завантаження і помилки системи
- `sysctl`: перегляду і налаштування параметрів ядра Linux коли воно запущене
- `hdparm`: маніпуляція/налаштування SATA/ATA диску
- `lsblk`: cписок блокових пристроїв комп'ютера: дерево ваших дисків і логічних дисків
- `lshw`, `lscpu`, `lspci`, `lsusb`, `dmidecode`: інформація про апаратне забезпечення, включає CPU, BIOS, RAID, графічну карту і т.д.
- `lsmod` і `modinfo`: показує список і детальну інформацію модулів ядра.
- `fortune`, `ddate`, and `sl`: um, well, it depends on whether you consider steam locomotives and Zippy quotations "useful"


## Тільки для OS X

Деякі речі, які підходять *тільки* для Мака.

- Система управління пакетами - `brew` (Homebrew) і `port` (MacPorts) можуть бути використані для того, щоб встановити більшість програм, згаданих у цьому документі.
- Копіюйте вивід будь-якої консольної команди до графічної за допомогою `pbcopy` і вставляйте вивід за допомогою `pbpaste`.
- Щоб відкрити файл або десктопну програму, використовуйте `open` або `open -a /Applications/Whatever.app`.
- Spotlight: Шукає файли в консолі, через `mdfind`, і дивиться метадані (наприклад EXIF ​​інформацію із фотографії) із `mdls`.
- Не забувайте, що MacOS створений на основі BSD Unix і багато команд (наприклад `ps`, `ls`, `tail`, `awk`, `sed`) мають невеликі відмінності від лінуксових. Це обумовлено впливом `UNIX System V` і `GNU Tools`. Різницю можна помітити, побачивши заголовок "BSD General Commands Manual." Інколи на MacOS можна поставити GNU-версії програм, наприклад `gawk` і `gsed`. Коли пишете кросплатформені Bash-скрипти, намагайтеся уникати використовувати команди, які можуть відрізнятися (наприклад, краще використовуйте Python або `perl`), або ретельно все перевіряйте.


## Тільки для Windows

- Ви можете використовувати Unix shell у Windows, встановивши [Cygwin](https://cygwin.com/).
- Встановіть ще Unix програми за допомогою менеджера пакетів Cygwin.
- Використовуйте `mintty` в якості термінала.
- Ви можете працювати із буфером обміну Windows за допомогою `/dev/clipboard`.
- Запустіть `cygstart`, щоб відкрити файл за допомогою програми, що встановлена за замовчуванням.
- Працювати з реєстром Windows можна за допомогою `regtool`.
- Майте на увазі, що диск `C:\` доступний в Cygwin за шляхом `/cygdrive/c`, `/` являється папкою `C:\cygwin`. Конвертуйте шляхи до файлів за допомогою `cygpath`.
- Ви можете запускати і автоматизувати більшість задач з адміністрування Windows із командного рядка, оволодівши `wmic`.


## Інші джерела

- [awesome-shell](https://github.com/alebcay/awesome-shell): Розширює Shell.
- [awesome-osx-command-line](https://github.com/herrbischoff/awesome-osx-command-line): Поглиблений посібник до командного рядка OS X.
- [Strict mode](http://redsymbol.net/articles/unofficial-bash-strict-mode/) щоб краще писати Shell скрипти.
- [shellcheck](https://github.com/koalaman/shellcheck): A shell script static analysis tool. Essentially, lint for bash/sh/zsh.
- [Filenames and Pathnames in Shell](http://www.dwheeler.com/essays/filenames-in-shell.html): The sadly complex minutiae on how to handle filenames correctly in shell scripts.


## Відмова від відповідальності

За невеликим винятком, весь код написаний так, щоб інші його змогли прочитати.
Той факт, що щось може бути написано на Bash, зовсім не означає, що воно має бути на ньому написано. ;)


## Ліцензія

[![Creative Commons License](https://i.creativecommons.org/l/by-sa/4.0/88x31.png)](http://creativecommons.org/licenses/by-sa/4.0/)

Ця работа і переклад на Українську мову розповсюджується за ліцензією [Creative Commons Attribution-ShareAlike 4.0 International License](http://creativecommons.org/licenses/by-sa/4.0/).
