🌍
*[Čeština](README-cs.md) ∙ [Deutsch](README-de.md) ∙ [Ελληνικά](README-el.md) ∙ [English](README.md) ∙ [Español](README-es.md) ∙ [Français](README-fr.md) ∙ [Indonesia](README-id.md) ∙ [Italiano](README-it.md) ∙ [日本語](README-ja.md) ∙ [한국어](README-ko.md) ∙ [polski](README-pl.md) ∙ [Português](README-pt.md) ∙ [Română](README-ro.md) ∙ [Русский](README-ru.md) ∙ [Slovenščina](README-sl.md) ∙ [Українська](README-uk.md) ∙ [简体中文](README-zh.md) ∙ [繁體中文](README-zh-Hant.md)*

# Η Τέχνη της Γραμμής Εντολών
+[![Ρωτήστε μία ερώτηση](https://img.shields.io/badge/%3f-Ask%20a%20Question-ff69b4.svg)](https://airtable.com/shrzMhx00YiIVAWJg)

[![Ελάτε στη συζήτηση στο https://gitter.im/jlevy/the-art-of-command-line](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/jlevy/the-art-of-command-line?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

- [Meta](#meta)
- [Τα βασικά](#basics)
- [Καθημερινή χρήση](#everyday-use)
- [Επεξεργασία αρχείων και δεδομένων](#processing-files-and-data)
- [Αποσφαλμάτωση συστήματος](#system-debugging)
- [Εντολές σε μία γραμμή](#one-liners)
- [Ασυνήθιστες αλλά χρήσιμες](#ασυνήθιστες-αλλά-χρήσιμες)
- [Μόνο για OS X](#os-x-only)
- [Μόνο για Windows](#windows-only)
- [Περισσότερες πηγές](#more-resources)
- [Αποποίηση ευθύνης](#disclaimer)


![curl -s 'https://raw.githubusercontent.com/jlevy/the-art-of-command-line/master/README.md' | egrep -o '`\w+`' | tr -d '`' | cowsay -W50](cowsay.png)

Η ευχέρεια στη χρήση της γραμμής εντολών είναι μία δεξιότητα συχνά παραμελημένη ή που θεωρείται ότι είναι για τους λίγους.
Όμως η ευχέρια αυτή βελτιώνει την ευελιξία και την παραγωγικότητά σας ως μηχανικός τόσο με προφανείς όσο και με λιγότερο ευδιάκριτους τρόπους. Αυτή είναι μία συλλογή από σημειώσεις και συμβουλές που αφορούν τη χρήση της γραμμής εντολών και τις οποίες βρήκαμε χρήσιμες, ενώ εργαζόμασταν σε Linux. Κάποιες συμβουλές είναι εισαγωγικές και μερικές πιο συγκρεκριμένες, εξειδικευμένες ή εις βάθος. Αυτή η σελίδα δεν είναι μεγάλη, αλλά αν μπορείτε να τα θυμάστε όλα, τότε γνωρίζετε πολλά.


Αυτή η εργασία είναι αποτέλεσμα [πολλών συγγραφέων και μεταφραστών](AUTHORS.md).
Μέρος της
[αρχικά](http://www.quora.com/What-are-some-lesser-known-but-useful-Unix-commands)
[δημοσιεύτηκε](http://www.quora.com/What-are-the-most-useful-Swiss-army-knife-one-liners-on-Unix)
στο [Quora](http://www.quora.com/What-are-some-time-saving-tips-that-every-Linux-user-should-know),
αλλά έπειτα μετακινήθηκε στο GitHub, όπου άνθρωποι πιο ταλαντούχοι από τον αρχικό συγγραφέα έχουν κάνει πολυάριθμες βελτιώσεις.
[**Παρακαλώ υποβάλετε μία ερώτηση**](https://airtable.com/shrzMhx00YiIVAWJg), αν έχετε μία ερώτηση σχετική με τη γραμμή εντολών. [**Παρακαλώ συνεισφέρετε**](/CONTRIBUTING.md), αν δείτε ένα λάθος ή κάτι που μπορεί να βελτιωθεί!

## Meta

Αντικείμενο:

- Αυτός ο οδηγός απευθύνεται τόσο σε αρχάριους όσο και σε έμπειρους. Οι στόχοι είναι το *εύρος* (ό,τι είναι σημαντικό), η *ακρίβεια* (να δοθούν συγκεκριμένα παραδείγματα για τις συνηθέστερες περιπτώσεις)και η *συντομία* (να αποφευχθούν πράγματα που δεν είναι αναγκαία ή παρεκβάσεις που μπορεί κανείς εύκολα να αναζητήσει αλλού). Κάθε συμβουλή είναι απαραίτητη σε κάποια περίπτωση ή εξοικονομεί χρόνο σε σημαντικό βαθμό σε σύγκριση με εναλλακτικές.
- Το παρόν είναι γραμμένο για Linux, με εξαίρεση των τμημάτων «[Μόνο για OS X](#os-x-only)» και «[Μόνο για Windows](#windows-only)». Πολλά από τα υπόλοιπα κομμάτια ισχύουν ή μπορούν να εγκατασταθούν σε άλλα Unices ή OS X (ή ακόμη και Cygwin).
- Εστιάζεται στον διαδραστικό φλοιό Bash, αν και πολλές συμβουλές ισχύουν και για άλλους φλοιούς και γενικότερα στη συγγραφή σεναρίων (scripts) για Bash.
- Περιλαμβάνει τόσο τις «τυπικές» εντολές Unix καθώς και άλλες που απαιτούν την εγκατάσταση ειδικών πακέτων λογισμικού -- αρκεί να είναι αρκετά σημαντικές ώστε να αξίζει να περιληφθούν.

Σημειώσεις:

- Για να κρατηθεί το παρόν σε μία σελίδα, υπάρχει περιεχόμενο που περιλαμβάνεται έμμεσα κάνοντας αναφορά σε αυτό. Είστε αρκετά έξυπνοι ώστε να αναζητήσετε περαιτέρω λεπτομέρειες αλλού, μόλις καταλάβετε την ιδέα ή την εντολή που χρειάζεται να αναζητήσετε στο Google. Χρησιμοποιήστε `apt-get`, `yum`, `dnf`, `pacman`, `pip` ή `brew` (ανάλογα με την περίπτωση) για να εγκαταστήσετε νέα προγράμματα.
- Χρησιμοποιήστε [Explainshell](http://explainshell.com/) για να έχετε μια χρήσιμη ανάλυση του τι κάνουν κάνουν εντολές, επιλογές, σωληνώσεις κλπ.

## Τα βασικά

- Μάθετε τα βασικά του φλοιού Bash. Πράγματι, πληκτρολογήστε `man bash` και τουλάχιστον ρίξτε μια ματιά σε αυτό που εμφανίζεται· είναι αρκετά εύκολο να το ακολουθήσετε κι όχι και τόσο μεγάλο. Άλλοι φλοιοί μπορεί να είναι μια χαρά, αλλά ο φλοιός Bash έχει πολλές δυνατότητες και είναι πάντα διαθέσιμος (το να μάθετε *μόνο* zsh, fish κλπ., αν και δελεαστικό όσο δουλεύετε στο δικό σας laptop, σας περιορίζει σε πολλές περιπτώσεις, όπως στην περίπτωση servers που ήδη υπάρχουν).

- Μάθετε τουλάχιστον έναν text-based επεξεργαστή κειμένου καλά. Ο επεξεργαστής κειμένου `nano` είναι από τους από τους απλούστερους για βασική επεξεργασία (άνοιγμα, επεξεργασία, αποθήκευση, αναζήτηση). Όμως, για τον έμπειρο χρήστη σε ένα τερματικό κειμένου, δεν υπάρχει υποκατάστατο για τον Vim (`vi`), τον δύσκολο να τον μάθει κάνεις αλλά αξιόλογο, γρήγορο και ολοκληρωμένο επεξεργαστή κειμένου. Πολλοί χρησιμοποιούν ακόμη τον κλασικό Emacs, ιδιαίτερα για μεγαλύτερες εργασίες που αφορούν επεξεργασία κειμένου. (Βέβαια, κάθε σύγχρονος προγραμματιστής που εργάζεται σε ένα μεγάλο έργο είναι απίθανο να χρησιμοποιεί μόνο έναν απλό text-based επεξεργαστή κειμένου και θα πρέπει να είναι επίσης εξοικειωμένος με σύγχρονα και με γραφικό περιβάλλον IDEs και εργαλεία.)

- Να γνωρίζετε πώς να διαβάζετε τεκμηρίωση με την εντολή `man` (για τον περίεργο, η εντολή `man man` εμφανίζει σε λίστα τους αριθμούς των ενοτήτων, π.χ. η 1 περιέχει τις εντολές του φλοιού, η 5 αρχεία/συμβάσεις και  η 8 είναι για διαχείριση). Αναζητήστε σελίδες man με την εντολή `apropos`. Να γνωρίζετε ότι μερικές εντολές δεν είναι εκτελέσιμα προγράμματα αλλά ενσωματωμένες στον φλοιό και μπορείτε να ζητήσετε βοήθεια σχετικά με αυτές με `help` και `help -d`. Μπορείτε να βρείτε αν μια εντολή είναι εκτελέσιμο πρόγραμμα, ή ενσωματωμένη στον φλοιό ή ένα ακόμη όνομα (συντόμευση) που έχει αντιστοιχηθεί στην εντολή αυτή χρησιμοποιώντας την εντολή `type command`.

- Μάθετε για την ανακατεύθυνση της εξόδου και της εισόδου με χρήση των τελεστών `>` και `<` και για τις σωληνώσεις εντολών με χρήση του `|`. Να γνωρίζετε ότι ο τελεστής `>` αντικαθιστά το αρχείο εξόδου και ο `>>` προσθέτει στο τέλος του αρχείου. Μάθετε για τα stdout και stderr.

- Μάθετε για την επέκταση αρχείων μπαλαντέρ (glob) με `*` (και ίσως του `?` και `[`...`]`) και τη χρήση εισαγωγικών και τη διαφορά ανάμεσα στα διπλά `"` και τα μονά `'` εισαγωγικά. (Δείτε περισσότερα για την επέκταση μεταβλητών παρακάτω.)

- Εξοικειωθείτε με τη διαχείριση εργασιών στον Bash: `&`, **ctrl-z**, **ctrl-c**, `jobs`, `fg`, `bg`, `kill` κλπ.

- Να γνωρίζετε την εντολή `ssh` και τα βασικά της αυθεντικοποίησης χωρίς κωδικό με χρήση των `ssh-agent`, `ssh-add` κλπ.

- Βασική διαχείριση αρχείων: `ls` και `ls -l` (συγκεκριμένα, μάθετε τι σημαίνει κάθε στήλη που εμφανίζει η `ls -l`), `less`, `head`, `tail` και `tail -f` (ή ακόμη καλύτερα, `less +F`), `ln` και `ln -s` (μάθετε τις διαφορές και τα πλεονεκτήματα των κανονικών συνδέσμων σε σύγκριση με τους συμβολικούς), `chown`, `chmod`, `du` (για μία γρήγορη περίληψη της χρήσης του δίσκου: `du -hs *`). Για διαχείριση του συστήματος αρχείων, `df`, `mount`, `fdisk`, `mkfs`, `lsblk`. Μάθετε τι είναι inode (`ls -i` ή `df -i`).

- Βασική διαχείριση δικτύου: `ip` ή `ifconfig`, `dig`, `traceroute`, `route`.

- Μάθετε και χρησιμοποιήστε ένα σύστημα διαχείρισης και ελέγχου εκδόσεων, όπως το `git`.

- Να γνωρίζετε καλά κανονικές εκφράσεις και τις διάφορες επιλογές (flags) για τις `grep`/`egrep`. Τις επιλογές `-i`, `-o`, `-v`, `-A`, `-B`και `-C` αξίζει να τις γνωρίζετε.

- Μάθετε να χρησιμοποιείτε τις εντολές `apt-get`, `yum`, `dnf` ή `pacman` (ανάλογα με τη διανομή του λειτουργικού σας συστήματος) για να βρίσκετε και να εγκαθιστάτε πακέτα λογισμικού. Και βεβαιωθείτε ότι έχετε την `pip` για να εγκαθιστάτε εργαλεία της γραμμής εντολών που βασίζονται σε Python (μερικά από τα παρακάτω είναι πιο εύκολο να εγκατασταθούν με `pip`).

## Καθημερινή χρήση

- Στον Bash, χρησιμοποιήστε **Tab** για να ολοκληρώσετε ορίσματα ή να εμφανίσετε σε λίστα όλες τις διαθέσιμες εντολές, **ctrl-r** για να αναζητήσετε στο ιστορικό των εντολών (αφού πατήσετε, πληκτρολογήστε για να αναζητήσετε, πατήστε **ctrl-r** επαναλαμβανόμενα για να περιηγηθείτε σε περισσότερα αποτελέσματα αναζήτησης, πατήστε **Enter** για να εκτελέσετε την εντολή που βρήκατε ή πατήστε το δεξί βέλος για να μεταφέρετε το αποτέλεσμα στην τρέχουσα γραμμή ώστε να μπορείτε να το επεξεργαστείτε).

- Στον Bash, χρησιμοποιήστε **ctrl-w** για να διαγράψετε την τελευταία λέξη και **ctrl-u** για να διαγράψετε το περιεχόμενο από την τρέχουσα θέση του δρομέα μέχρι την αρχή της γραμμής. Χρησιμοποιήστε **alt-b** και **alt-f** για να μετακινηθείτε κατά μια λέξη, **ctrl-a** για να μετακινήσετε τον δρομέα στην αρχή της γραμμής, **ctrl-e** για να μετακινήσετε τον δρομέα στο τέλος της γραμμής, **ctrl-k** για να διαγράψετε ως το τέλος της γραμμής, **ctrl-l** για να καθαρίσετε την οθόνη. Δείτε τη `man readline` για όλες τις συντομεύσεις πληκτρολογίου στον Bash. Υπάρχουν πολλές. Για παράδειγμα, η **alt-.** επαναλαμβάνει κυκλικά τα προηγούμενα ορίσματα και η **alt-** αναπτύσσει ένα μπαλαντέρ (glob).

- Εναλλακτικά, αν σας αρέσουν οι συντομεύσεις τύπου vi, χρησιμοποιήστε `set -o vi` (και `set -o emacs` για να επαναφέρετε).

- Για την επεξεργασία μεγάλων εντολών, αφού ορίσετε τις ρυθμίσεις του επεξεργαστή κειμένου σας (για παράδειγμα `export EDITOR=vim`), με **ctrl-x** **ctrl-e** θα ανοίξει η τρέχουσα εντολή σε έναν επεξεργαστή κειμένου για επεξεργασία πολλών γραμμών. Ή αν έχετε ορίσει συντομεύσεις τύπου vi, **escape-v**.

- Για να δείτε πρόσφατες εντολές χρησιμοποιήστε την εντολή `history`. Ακολουθήστε την με την εντολή  `!n` (όπου `n` είναι ο αριθμός της εντολής) για να την εκτελέσετε ξανά. Υπάρχουν πάρα πολλές συντομεύσεις που μπορείτε να χρησιμοποιήσετε. Από αυτές οι πιο χρήσιμες μάλλον είναι η `!$` για την τελευταία παράμετρο και η `!!` για την τελευταία εντολή (δείτε το "HISTORY EXPANSION" στην τεκμηρίωση του φλοιού). Όμως, αυτές συχνά εύκολα αντικαθίστανται από **ctrl-r** και **alt-.**.

- Πηγαίνετε στον προσωπικό σας κατάλογο (home) με `cd`. Αποκτήστε πρόσβαση σε αρχεία που βρίσκονται σε σχετική θέση με τον προσωπικό κατάλογό σας με το πρόθεμα `~` (π.χ. `~/.bashrc`). Σε σενάριο `sh` μπορείτε να αναφέρεστε στον προσωπικό σας κατάλογο ως `$HOME`.

- Για να πάτε στον προηγούμενο κατάλογο όπου εργαζόσαστε: `cd -`.

- Αν έχετε γράψει μέχρι τη μέση μία εντολή, αλλά αλλάξατε γνώμη, πατήστε **alt-#** για να προσθέσετε ένα`#` στην αρχή και να την προσθέσετε ως ένα σχόλιο (ή χρησιμοποιήστε **ctrl-a**, **#**, **enter**). Μπορείτε να επιστρέψετε σε αυτή αργότερα με το ιστορικό εντολών.

- Χρησιμοποιήστε `xargs` (ή `parallel`). Έχει πολλές δυνατότητες. Σημειώστε ότι μπορείτε να ελέγξετε πόσα στοιχεία θα εκτελέσετε ανά γραμμή (`-L`) καθώς και παράλληλη εκτέλεση εντολών (`-P`). Αν δεν είστε σίγουρος ότι θα κάνει το σωστό, χρησιμοποιήστε πρώτα `xargs echo`. Επίσης, η επιλογή `-I{}` είναι χρήσιμη. Παραδείγματα:
```bash
      find . -name '*.py' | xargs grep some_function
      cat hosts | xargs -I{} ssh root@{} hostname
```

- `pstree -p` είναι μία χρήσιμη εμφάνιση του δέντρου διεργασιών.

- Χρησιμοποιήστε `pgrep` και `pkill` για να αναζητήσετε ή να στείλετε σήμα σε διεργασίες με βάση το όνομά τους (η επιλογή `-f` είναι χρήσιμη).

- Να γνωρίζετε τα διάφορα σήματα που μπορείτε να στείλετε σε διεργασίες. Για παράδειγμα, για να αναστείλετε μία διεργασία χρησιμοποιήστε `kill -STOP [pid]`. Για ολόκληρη τη λίστα, δείτε `man 7 signal`

- Χρησιμοποιήστε `nohup` ή `disown`, αν θέλετε μία διεργασία παρασκηνίου να συνεχίσει να εκτελείται για πάντα.

- Ελέγξτε ποιες διεργασίες είναι σε αναμονή για κλήση listen με `netstat -lntp` ή `ss -plat` (για TCP· προσθέστε `-u` για UDP) ή `lsof -iTCP -sTCP:LISTEN -P -n` (που δουλεύει επίσης σε OS X).

- Δείτε επίσης `lsof` και `fuser` για ανοιχτές συνδέσεις δικτύου (sockets) και αρχεία.

- Δείτε `uptime` ή `w` για να δείτε για πόσο το σύστημα βρίσκεται σε λειτουργία.

- Χρησιμοποιήστε `alias` για να δημιουργήσετε συντομεύσεις για συχνά χρησιμοποιούμενες εντολές. Για παράδειγμα, η `alias ll='ls -latr'` δημιουργεί μία νέα συντόμευση `ll`.

- Αποθηκεύστε συντομεύσεις, ρυθμίσεις φλοιού και μεθόδους που χρησιμοποιείτε συχνά στο `~/.bashrc`και [προβλέψτε ώστε οι login φλοιοί να τα διαβάζουν](http://superuser.com/a/183980/7106). Αυτό θα κάνει τις ρυθμίσεις σας διαθέσιμες κάθε φορά που χρησιμοποιείτε τον φλοιό.

- Βάλτε τις ρυθμίσεις των μεταβλητών περιβάλλοντος καθώς και τις εντολές που χρειάζεται να εκτελεστούν με την είσοδό σας στο `~/.bash_profile`. Ξεχωριστές ρυθμίσεις θα χρειαστούν για τους φλοιούς που εκτελούνται από είσοδο από γραφικό περιβάλλον και εργασίες `cron`.

- Συγχρονίστε τα αρχεία με τις ρυθμίσεις σας (π.χ. `.bashrc` και `.bash_profile`) μεταξύ διαφορετικών υπολογιστών χρησιμοποιώντας Git.

- Κατανοήστε ότι χρειάζεται προσοχή, όταν μεταβλητές και ονόματα αρχείων περιέχουν κενούς (whitespace) χαρακτήρες. Περικλείετε τις μεταβλητές του Bash σε εισαγωγικά, π.χ. `"$FOO"`. Προτιμήστε τις επιλογές `-0` ή `-print0` για να επιτρέψετε σε κενούς χαρακτήρες να διαχωρίζουν ονόματα αρχείων, π.χ. `locate -0 pattern | xargs -0 ls -al` ή `find / -print0 -type d | xargs -0 ls -al`. Για να περάσετε ένα προς ένα από όλα τα αρχεία που περιέχουν κενούς χαρακτήρες σε έναν βρόχο επανάληψης `for`, ορίστε τη μεταβλητή IFS να είναι ο χαρακτήρας νέας γραμμής χρησιμοποιώντας `IFS=$'\n'`.

- Σε σενάρια για Bash, χρησιμοποιήστε `set -x` (ή την παραλλαγή `set -v`, που γράφει τα πρωτογενή στοιχεία, όπως σχόλια και μεταβλητές πριν αντικατασταθούν) για να τα αποσφαλματώσετε. Χρησιμοποιείτε αυστηρές λειτουργίες (strict modes) εκτός κι αν έχετε σημαντικό λόγο να μην το κάνετε: Χρησιμοποιήστε `set -e` για να εγκαταλείψετε την εκτέλεση σε περίπτωση σφάλματος (μη μηδενικός κωδικός εξόδου). Χρησιμοποιήστε `set -u` για να ανιχνεύσετε τη χρήση μεταβλητών χωρίς τιμή. Έχετε υπόψη σας και την εντολή `set -o pipefail`, για να εμφανίσετε τα σφάλματα που προκύπτουν στο ενδιάμεσο σωληνώσεων εντολών (αλλά διαβάστε περισσότερο για αυτή, αν τη χρησιμοποιήσετε καθώς αυτό το θέμα είναι ιδιαίτερα λεπτό). Για πιο πολύπλοκα σενάρια, χρησιμοποιήστε επίσης την εντολή `trap` για κωδικούς εξόδου EXIT ή ERR. Μια χρήσιμη συνήθεια είναι να ξεκινάτε ένα σενάριο έτσι, κάνοντάς το να ανιχνεύει και να τερματίζει σε συνήθη σφάλματα και να τυπώνει ένα μήνυμα:
```bash
      set -euo pipefail
      trap "echo 'error: Script failed: see failed command above'" ERR
```

- Σε σενάρια για Bash, οι υποφλοιοί (γραμμένοι μέσα σε παρενθέσεις) είναι βολικοί τρόποι ομαδοποίησης εντολών. Ένα συνηθισμένο παράδειγμα είναι η προσωρινή μετακίνηση σε διαφορετικό τρέχοντα κατάλογο, π.χ.
```bash
      # do something in current dir
      (cd /some/other/dir && other-command)
      # continue in original dir
```

- Στον Bash, σημειώστε ότι υπάρχουν πολλοί τρόποι επέκτασης μίας μεταβλητής. Έλεγχος του αν μία μεταβλητή υπάρχει: `${name:?error message}`. Για παράδειγμα, αν ένα σενάριο Bash παίρνει ένα μόνο όρισμα, απλά γράψτε `input_file=${1:?usage: $0 input_file}`. Χρήση μίας προεπιλεγμένης τιμής αν μία μεταβλητή είναι κενή: `${name:-default}`. Αν θέλετε να προσθέσετε μία επιπλέον (προαιρετική) παράμετρο στο προηγούμενο παράδειγμα, μπορείτε να χρησιμοποιήσετε κάτι όπως: `output_file=${2:-logfile}`. Αν η `$2` παραλείπεται και άρα είναι κενή, η τιμή της `output_file` θα είναι `logfile`. Αριθμητική επέκταση: `i=$(( (i + 1) % 5 ))`. Ακολουθίες: `{1..10}`. Περικοπή αλφαριθμητικών: `${var%suffix}` και `${var#prefix}`. Για παράδειγμα, αν `var=foo.pdf`, τότε η `echo ${var%.pdf}.txt` τυπώνει `foo.txt`.

- Η επέκταση με αγκύλες χρησιμοποιώντας `{`...`}` μπορεί να μειώσει τις φορές που χρειάζεται να πληκτρολογήσετε ξανά παρόμοιο κείμενο και να αυτοματοποιήσει συνδυασμούς στοιχείων. Αυτό είναι χρήσιμο σε παραδείγματα όπως `mv foo.{txt,pdf} some-dir` (που μετακινεί και τα δύο αρχεία), `cp somefile{,.bak}` (που επεκτείνεται σε `cp somefile somefile.bak`) ή `mkdir -p test-{a,b,c}/subtest-{1,2,3}` (που επεκτείνεται σε όλους τους πιθανούς συνδυασμούς και δημιουργεί ένα δέντρο καταλόγων). Η επέκταση με αγκύλες πραγματοποιείται πριν από οποιαδήποτε άλλη επέκταση.

- Η σειρά των επεκτάσεων είναι: επέκταση με αγκύλες· επέκταση περισπωμένης, επέκταση παραμέτρων και μεταβλητών, αριθμητική επέκταση και αντικατάσταση εντολής (γίνεται από τα αριστερά προς τα δεξιά)· χωρισμός λέξεων· και επέκταση ονομάτων αρχείων. Για παράδειγμα, ένα εύρος τιμών όπως `{1..20}` δεν μπορεί να εκφραστεί με μεταβλητές χρησιμοποιώντας `{$a..$b}`. Χρησιμοποιήστε αντί μεταβλητών την εντολή `seq` ή μία δομή επανάληψης `for`, π.χ. `seq $a $b` ή `for((i=a; i<=b; i++)); do ... ; done`.)

- Μπορείτε να χειριστείτε την έξοδο μίας εντολής ως αρχείο `<(some command)` (είναι γνωστό ως αντικατάσταση διεργασίας). Για παράδειγμα, συγκρίνετε το τοπικό `/etc/hosts` με ένα απομακρυσμένο:
```sh
      diff /etc/hosts <(ssh somehost cat /etc/hosts)
```

- Όταν γράφετε σενάρια, ίσως θέλετε να βάλετε όλον σας τον κώδικα μέσα σε άγκριστρα. Αν το δεξί άγκιστρο λείπει, το σενάριό σας δε θα εκτελεστεί λόγω συντακτικού σφάλματος. Αυτό είναι σκόπιμο, όταν το σενάριό σας πρόκειται να μεταφορτωθεί από το διαδίκτυο, αφού έτσι εμποδίζεται η εκτέλεση σεναρίων που έχουν μερικώς ληφθεί:
```bash
{
      # Your code here
}
```

- Να γνωρίζετε για το «here documents» στον Bash, όπως στην `cat <<EOF ...`.

- Στον Bash, ανακατευθύνετε τόσο την έξοδο όσο και την έξοδο σφαλμάτων ως εξής: `some-command >logfile 2>&1` ή `some-command &>logfile`. Συχνά για να βεβαιωθείτε ότι μία εντολή δεν αφήνει μια σύνδεση αρχείου ανοιχτή στην είσοδο, δεσμεύοντας τον στο τερματικό που βρίσκεστε, είναι μία καλή πρακτική να προσθέτετε `</dev/null`.

- Χρησιμοποιήστε `man ascii` για έναν καλό πίνακα ASCII, με δεξαεξαδικές και δεκαδικές τιμές. Για γενικές πληροφορίες που αφορούν την κωδικοποίηση, οι `man unicode`, `man utf-8` και `man latin1`είναι χρήσιμες.

- Χρησιμοποιήστε `screen` ή [`tmux`](https://tmux.github.io/) για να ενεργοποιήσετε την πολυπλεξία της οθόνης. Αυτό είναι ιδιαίτερα χρήσιμο σε απομακρυσμένες συνεδρίες ssh και για να διακόψετε ή να επαναφέρετε μια συνεδρία. H εντολή `byobu` ή `tmux` μπορεί να βελτιώσει την οθόνη παρέχοντας περισσότερες πληροφορίες και πιο εύκολη διαχείριση. Μία πιο απλή εναλλακτική μόνο για τη διατήρηση συνεδριών είναι η [`dtach`](https://github.com/bogner/dtach).

- Με ssh, το να γνωρίζετε πώς να προωθήσετε μία θύρα με τις επιλογές `-L` ή `-D` (και καμιά φορά με την `-R`) είναι χρήσιμο, π.χ. για να έχετε πρόσβαση σε ιστοσελίδες από έναν απομακρυσμένο server.

- Μπορεί να είναι χρήσιμο να κάνετε μερικές βελτιστοποιήσεις στις ssh ρυθμίσεις σας· για παράδειγμα, αυτό `~/.ssh/config` περιέχει ρυθμίσεις για να αποφεύγετε τις συνδέσεις που διακόπτονται σε ορισμένα περιβάλλοντα δικτύου, χρησιμοποιεί συμπίεση (που είναι χρήσιμη με scp σε συνδέσεις με περιορισμένο εύρος ζώνης) και πολύπλεξη καναλιών στον ίδιο server με τοπικό αρχείο έλέγχου:
```
      TCPKeepAlive=yes
      ServerAliveInterval=15
      ServerAliveCountMax=6
      Compression=yes
      ControlMaster auto
      ControlPath /tmp/%r@%h:%p
      ControlPersist yes
```

- Μερικές άλλες επιλογές σχετικές με την ssh είναι ευαίσθητες όσον αφορά την ασφάλεια και θα πρέπει να ενεργοποιούνται με προσοχή, π.χ. ανά υποδίκτυο ή host ή σε έμπιστα δίκτυα: `StrictHostKeyChecking=no`, `ForwardAgent=yes`

- ´Εχετε υπόψη σας την εντολή [`mosh`](https://mosh.org/) ως μία εναλλακτική της ssh που χρησιμοποιεί UDP, αποφεύγοντας τις συνδέσεις που διακόπτονται και διευκολύνοντας τη διαδικασία (απαιτεί ρύθμιση στον server).

- Για να πάρετε τα δικαιώματα ενός αρχείου σε οκταδική μορφή, πράγμα που είναι χρήσιμο για την παραμετροποίηση του συστήματος, αλλά δεν είναι διαθέσιμο με την `ls` και είναι εύκολο να γίνει άτσαλα, χρησιμοποιήστε κάτι όπως
```sh
      stat -c '%A %a %n' /etc/timezone
```

- Για διαδραστική επιλογή τιμών από την έξοδο μίας άλλης εντολής, χρησιμοποιήστε [`percol`](https://github.com/mooz/percol) ή [`fzf`](https://github.com/junegunn/fzf).

- Για επιλογή αρχείων με βάση την έξοδο μιας άλλη εντολής (όπως της `git`), χρησιμοποιήστε `fpp` ([PathPicker](https://github.com/facebook/PathPicker)).

- Για έναν απλό web server και για όλα τα αρχεία στον τρέχοντα κατάλογο (και υποκαταλόγους) διαθέσιμα σε οποιονδήποτε στο δίκτυο, χρησιμοποιήστε:
`python -m SimpleHTTPServer 7777` (για τη θύρα 7777 και Python 2) και `python -m http.server 7777` (για τη θύρα 7777 και Python 3).

- Για την εκτέλεση μίας εντολής ως άλλος χρήστης, χρησιμοποιήστε `sudo`. Από προεπιλογή εκτελείται ως `root`· χρησιμοποιήστε `-u` για να ορίσετε άλλον χρήστη. Χρησιμοποιήστε `-i` για να συνδεθείτε ως αυτός ο χρήστης. (Μπορεί να σας ζητηθεί το συνθηματικό σας.)

- Για να αλλάξετε τον φλοιό σε άλλον χρήστη, χρησιμοποιήστε `su username` ή `su - username`. Το τελευταίο με "-" φορτώνει το περιβάλλον με τον ίδιο τρόπο όπως αν μόλις συνδεόταν ένας άλλος χρήστης. Παραλείποντας το username χρησιμοποιείτε την προεπιλογή `root`.  Αν δεν είστε `root`, θα σας ζητηθεί το συνθηματικό.

- Έχετε υπόψη σας τον [περιορισμό των 128K](https://wiki.debian.org/CommonErrorMessages/ArgumentListTooLong) για τις γραμμές εντολών. Το σφάλμα «Η λίστα των ορισμάτων είναι πολύ μεγάλη» είναι κοινό, όταν γίνεται ταίριασμα με χαρακτήρα wildcard ενάντι μεγάλου αριθμού αρχείων. (Όταν συμβαίνει αυτό, εναλλακτικές όπως οι `find` και `xargs` μπορεί να βοηθήσουν.)

- Για να κάνετε μια απλή πράξη αριθμητικής (και βέβαια γενικά για πρόσβαση σε Python), χρησιμοποιήστε τον διερμηνευτή `python`. Για παράδειγμα,
```python
>>> 2+3
5
```

## Επεξεργασία αρχείων και δεδομένων

- Για να εντοπίσετε ένα αρχείο με βάση το όνομά του στον τρέχοντα κατάλογο, `find . -iname '*something*'` (ή με παρόμοιο τρόπο). Για να βρείτε ένα αρχείο με το όνομά του οπουδήποτε, χρησιμοποιήστε `locate something` (αλλά να έχετε στον νου σας ότι η `updatedb` μπορεί να μην έχει δημιουργήσει ευρετήριο για αρχεία που δημιουργήθηκαν πρόσφατα).

- Για γενική αναζήτηση σε αρχεία πηγαίου κώδικα ή αρχεία δεδομένων, υπάρχουν αρκετές επιλογές πιο προχωρημένες ή γρήγορες από την `grep -r`, συμπεριλαμβανομένων (και κατά προσέγγιση ταξινομημένων από την πιο παλιά στη νεότερη) των [`ack`](https://github.com/beyondgrep/ack2), [`ag`](https://github.com/ggreer/the_silver_searcher) ("the silver searcher"), και [`rg`](https://github.com/BurntSushi/ripgrep) (ripgrep).

- Για να μετατρέψετε HTML σε κείμενο: `lynx -dump -stdin`

- Για Markdown, HTML και άλλου είδους μετατροπές κειμένου, δοκιμάστε [`pandoc`](http://pandoc.org/).

- Αν χρειάζεται να χειριστείτε XML, η `xmlstarlet` είναι παλιά αλλά καλή.

- Για JSON, χρησιμοποιήστε [`jq`](http://stedolan.github.io/jq/). Για διαδραστική χρήση, δείτε επίσης [`jid`](https://github.com/simeji/jid) και [`jiq`](https://github.com/fiatjaf/jiq).

- Για YAML, χρησιμοποιήστε [`shyaml`](https://github.com/0k/shyaml).

- Για αρχεία Excel ή CSV, το πακέτο [csvkit](https://github.com/onyxfish/csvkit) παρέχει τις `in2csv`, `csvcut`, `csvjoin`, `csvgrep` κλπ.

- Για Amazon S3, η [`s3cmd`](https://github.com/s3tools/s3cmd) είναι βολική και η [`s4cmd`](https://github.com/bloomreach/s4cmd) είναι γρηγορότερη. Η [`aws`](https://github.com/aws/aws-cli) της Amazon και η βελτιωμένη [`saws`](https://github.com/donnemartin/saws) είναι απαραίτητες για εργασίες που σχετίζονται με AWS.

- Να γνωρίζετε για τις `sort` και `uniq`, συμπεριλαμβανομένων των επιλογών `-u` και `-d` της uniq -- παρακάτω δείτε το κομμάτι που αφορά τις εντολές σε μία γραμμή. Δείτε επίσης την `comm`.

- Να γνωρίζετε για τις `cut`, `paste` και `join` για να χειρίζεστε αρχεία κειμένου. Πολλοί χρησιμοποιούν την `cut`, αλλά ξεχνούν την `join`.

- Να γνωρίζετε για τη `wc` για να μετράτε νέες γραμμές (`-l`), χαρακτήρες (`-m`), λέξεις (`-w`) και bytes (`-c`).

- Να γνωρίζετε για την `tee` για να αντιγράφετε από το stdin σε ένα αρχείο κι επίσης στο stdout, όπως στην `ls -al | tee file.txt`.

- Για πιο πολύπλοκους υπολογισμούς, όπως ομαδοποίηση, αναστροφή πεδίων και στατιστικούς υπολογισμούς, έχετε υπόψη σας την εντολή [`datamash`](https://www.gnu.org/software/datamash/).

- Να γνωρίζετε ότι η τοπική διαμόρφωση του συστήματος (locale, π.χ. ελληνικό) επηρεάζει πολλά εργαλεία γραμμής εντολών με λιγότερο προφανείς τρόπους, συμπεριλαμβανομένων της σειράς ταξινόμησης (collation) και της απόδοσης. Οι περισσότερες εγκαταστάσεις Linux θα έχουν αναθέσει στη μεταβλητή `LANG` ή σε άλλες σχετικές με locale μεταβλητές τιμή μιας τοπική ρύθμισης όπως η Αγγλική ΗΠΑ. Αλλά να έχετε υπόψη ότι η ταξινόμηση μπορεί να αλλάξει, αν θέσετε άλλο locale. Και να γνωρίζετε ότι οι διεθνοποιημένες ρουτίνες μπορούν να κάνουν την ταξινόμηση ή άλλες εντολές να εκτελούνται *πολλές φορές* πιο αργά. Σε μερικές περιπτώσεις (όπως στον ορισμό διεργασιών ή της μοναδικότητας διεργασιών παρακάτω) μπορείτε με ασφάλεια να αγνοήσετε εντελώς αργές διεθνοποιημένες ρουτίνες και να χρησιμοποιήσετε παραδοσιακή ταξινόμηση με βάση bytes, χρησιμοποιώντας `export LC_ALL=C`.

- Μπορείτε να ορίσετε ένα συγκεκριμένο περιβάλλον για μία εντολή προσθέτοντάς της ως πρόθεμα τις ρυθμίσεις της μεταβλητής περιβάλλοντος, όπως στην `TZ=Pacific/Fiji date`.

- Να γνωρίζετε τα βασικά για τις `awk` και `sed` για απλή επεξεργασία δεδομένων. Δείτε [Εντολές σε μία γραμμή](#one-liners) για παραδείγματα.

- Για να αντικαταστήσετε επί τόπου όλες τις εμφανίσεις ενός αλφαριθμητικού σε ένα ή περισσότερα αρχεία:
```sh
      perl -pi.bak -e 's/old-string/new-string/g' my-files-*.txt
```

- Για να μετονομάσετε πολλά και/ή να αναζητήσετε και να αντικαταστήσετε σε αρχεία, δοκιμάστε την [`repren`](https://github.com/jlevy/repren). (Σε ορισμένες περιπτώσεις η εντολή `rename` επιτρέπει επίσης πολλαπλές μετονομασίες, αλλά να είστε προσεχτικοί καθώς δε συμπεριφέρεται με τον ίδιο τρόπο σε όλες τις διανομές Linux.)
```sh
      # Full rename of filenames, directories, and contents foo -> bar:
      repren --full --preserve-case --from foo --to bar .
      # Recover backup files whatever.bak -> whatever:
      repren --renames --from '(.*)\.bak' --to '\1' *.bak
      # Same as above, using rename, if available:
      rename 's/\.bak$//' *.bak
```

- Όπως λέει η σελίδα man, η `rsync` είναι πράγματι ένα γρήγορο και εξαιρετικά ευέλικτο εργαλείο αντιγραφής αρχείων. Είναι γνωστή για τον συγχρονισμό μεταξύ υπολογιστών, αλλά είναι εξίσου χρήσιμη και τοπικά. Όταν οι περιορισμοί ασφάλειας το επιτρέπουν, η χρήση της `rsync` αντί της `scp` επιτρέπει τη συνέχιση μιας μεταφοράς χωρίς να ξεκινήσει από την αρχή. Επίσης, είναι ανάμεσα στους [πιο γρήγορους τρόπους](https://web.archive.org/web/20130929001850/http://linuxnote.net/jianingy/en/linux/a-fast-way-to-remove-huge-number-of-files.html) να διαγράψει κανείς μεγάλο αριθμό αρχείων:
```sh
mkdir empty && rsync -r --delete empty/ some-dir && rmdir some-dir
```

- Για να παρακολουθείτε την πρόοδο όταν αντιγράφετε αρχεία, χρησιμοποιήστε τις `pv`, [`pycp`](https://github.com/dmerejkowsky/pycp), [`progress`](https://github.com/Xfennec/progress), `rsync --progress`, ή για αντιγραφή σε επίπεδο μπλοκ την `dd status=progress`.

- Χρησιμοποιήστε την `shuf` για να ανακατέψετε ή να επιλέξετε τυχαίες γραμμές από ένα αρχείο.

- Να γνωρίζετε τις επιλογές της `sort`. Για αριθμούς χρησιμοποιήστε τις `-n`, ή `-h` για χειρισμό αριθμών που είναι εύκολο να διαβαστούν από άνθρωπο (π.χ. από `du -h`). Να γνωρίζετε πώς λειτουργούν τα ορίσματα (`-t` και `-k`). Συγκεκριμένα, προσέξτε ότι χρειάζεται να γράψετε `-k1,1` για να ταξινομήσετε με βάση μόνο το πρώτο πεδίο· `-k1` σημαίνει ταξινόμηση με βάση όλη τη γραμμή. Η σταθερή ταξινόμηση (`sort -s`) μπορεί να είναι χρήσιμη. Για παράδειγμα, για να ταξινομήσετε πρώτα με βάση το πεδίο 2 και δευτερευόντως με βάση το πεδίο 1, μπορείτε να χρησιμοποιήσετε `sort -k1,1 | sort -s -k2,2`.

- Αν πότε χρειαστεί να γράψετε έναν χαρακτήρα στηλοθέτη (tab) στη γραμμή εντολών στον Bash (π.χ. για να ταξινομήσετε με βάση το όρισμα της επιλογής -t), πιέστε **ctrl-v** **[Tab]** ή γράψτε `$'\t'` (το τελευταίο είναι καλύτερο, γιατί μπορείτε να το αντιγράψετε/επικολλήσετε).

- Τα συνήθη εργαλεία αυτοματοποιημένης επεξεργασίας αλλαγών (patch) πηγαίου κώδικα είναι οι εντολές `diff` (εμφάνιση διαφορών) και `patch` (εφαρμογή διαφορών σε άλλο αρχείο). Επίσης, δείτε την `diffstat` για περίληψη στατιστικών στοιχείων της εντολής diff και `sdiff` για εμφάνιση διαφορών πλάι-πλάι. Σημειώστε ότι η  `diff -r` λειτουργεί για ολόκληρους καταλόγους. Χρησιμοποιήστε την `diff -r tree1 tree2 | diffstat` για μια περίληψη αλλαγών. Χρησιμοποιήστε την `vimdiff` για να συγκρίνετε και να επεξεργαστείτε αρχεία μέσω της διεπαφής του vim.

- Για δυαδικά αρχεία, χρησιμοποιήστε τις `hd`, `hexdump` ή την `xxd` για απλά δεκαεξαδικά dumps και τις `bvi`, `hexedit` ή `biew` για επεξεργασία σε δυαδική μορφή.

- Επίσης, για δυαδικά αρχεία η `strings` (και η `grep` κλπ.) σας δίνει τη δυνατότητα να βρείτε κομματάκια κειμένου που κρύβονται σ' αυτά.

- Για δυαδικές διαφορές (συμπίεση δέλτα), χρησιμοποιήστε `xdelta3`.

- Για να μετατρέψετε κωδικοποίηση κειμένου, δοκιμάστε την `iconv`. Ή `uconv` για πιο προχωρημένη χρήση· υποστηρίζει πιο προχωρημένα στοιχεία του προτύπου Unicode. Για παράδειγμα:
 :
```sh
      # Εμφανίζει τους δεκαεξαδικούς κωδικούς ή πραγματικά ονόματα χαρακτήρων (χρήσιμο για αποσφαλμάτωση):
      uconv -f utf-8 -t utf-8 -x '::Any-Hex;' < input.txt
      uconv -f utf-8 -t utf-8 -x '::Any-Name;' < input.txt
      # Mετατρέπει σε πεζούς χαρακτήρες και απαλείφει τους τόνους (επεκτείνοντας και απορρίπτοντάς τους):
      uconv -f utf-8 -t utf-8 -x '::Any-Lower; ::Any-NFD; [:Nonspacing Mark:] >; ::Any-NFC; ' < input.txt > output.txt
```

- Για να σπάσετε αρχεία σε κομμάτια, δείτε τη `split` (για να σπάσετε με βάση το μέγεθος) και τη `csplit` (για να σπάσετε με βάση πρότυπο).

- Ημερομηνία και ώρα: Για να πάρετε την τρέχουσα ημερομηνία και ώρα στη χρήσιμη μορφή [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601), χρησιμοποιήστε `date -u +"%Y-%m-%dT%H:%M:%SZ"` (άλλες επιλογές [είναι](https://stackoverflow.com/questions/7216358/date-command-on-os-x-doesnt-have-iso-8601-i-option) [προβληματικές](https://unix.stackexchange.com/questions/164826/date-command-iso-8601-option)). Για να χειριστείτε εκφράσεις ημερομηνίας και χρόνου, χρησιμοποιήστε τις εντολές `dateadd`, `datediff`, `strptime` κλπ. από το πακέτο [`dateutils`](http://www.fresse.org/dateutils/).

- Χρησιμοποιήστε `zless`, `zmore`, `zcat`και `zgrep` για να χειριστείτε συμπιεσμένα αρχεία.

- Ιδιότητες αρχείων μπορούν να οριστούν με την `chattr` και προσφέρει μία εναλλακτική για τα δικαιώματα των αρχείων σε χαμηλό επίπεδο. Για παράδειγμα, για να προστατευτείτε από κατά λάθος διαγραφή αρχείου χρησιμοποιήστε την επιλογή immutable:  `sudo chattr +i /critical/directory/or/file`

- Χρησιμοποιήστε τις `getfacl` και `setfacl` για να αποθηκεύσετε και να επαναφέρετε δικαιώματα αρχείων. Για παράδειγμα:
```sh
   getfacl -R /some/path > permissions.txt
   setfacl --restore=permissions.txt
```

- Για να δημιουργήσετε άδεια αρχεία γρήγορα, χρηρσιμοποιήστε την `truncate` (δημιουργεί [αραιό αρχείο](https://en.wikipedia.org/wiki/Sparse_file)), τη `fallocate` (ext4, xfs, btrfs και ocfs2 συστήματα αρχείων), την `xfs_mkfile` (σχεδόν για κάθε σύστημα αρχείων, περιλαμβάνεται στο πακέτο xfsprogs), τη `mkfile` (για συστήματα τύπου Unix όπως Solaris, Mac OS).

## Αποσφαλμάτωση συστήματος

- Για web αποσφαλμάτωση, οι εντολές `curl` και `curl -I` είναι χρήσιμες, ή οι ισοδύναμες `wget`, ή η πιο καινούρια [`httpie`](https://github.com/jkbrzt/httpie).

- Για να γνωρίζετε την τρέχουσα κατάσταση του επεξεργαστή και των δίσκων, τα κλασικά εργαλεία είναι η `top` (ή η καλύτερη `htop`), η `iostat`και η `iotop`. Χρησιμοποιήστε την `iostat -mxz 15` για βασικά στατιστικά που αφορούν τον επεξεργαστή ή για λεπτομερή στατιστικά των δίσκων ανά διαμέρισμα και για να έχετε μια εικόνα της απόδοσης.

- Για λεπτομέρειες που αφορούν τη σύνδεση δικτύου, χρησιμοποιήστε τη `netstat` και την `ss`.

- Για μια γρήγορη επισκόπηση του τι συμβαίνει σε ένα σύστημα, η `dstat` είναι ιδιαίτερα χρήσιμη. Για καλύτερη επισκόπηση με λεπτομέρειες, χρησιμοποιήστε [`glances`](https://github.com/nicolargo/glances).

- Για να γνωρίζετε την κατάσταση της μνήμης, εκτελέστε και κατανοήστε την έξοδο των `free` και `vmstat`. Συγκεκριμένα, να έχετε υπόψη ότι η «cached» τιμή είναι μνήμη που δεσμεύει ο πυρήνας του Linux ως προσωρινά αποθηκευμένο αρχείο, ώστε στην ουσία προσμετράται ως «free» τιμή.

- Η αποσφαλμάτωση συστημάτων Java είναι άλλη ιστορία, αλλά ένα απλό κόλπο για το JVM της Oracle και άλλων είναι να τρέξετε την εντολή `kill -3 <pid>` και ένα πλήρες ίχνος στοίβας  και περίληψη σωρού  (συμπεριλαμβανομένων και λεπτομερειών που αφορούν τη συλλογή απορριμάτων σε γενιές, που μπορεί να είναι πολύ κατατοπιστικές) θα εμφανιστούν στο stderr/logs. Οι εντολές του JDK `jps`, `jstat`, `jstack`, `jmap` είναι χρήσιμες. [Τα εργαλεία SJK](https://github.com/aragozin/jvm-tools) είναι για πιο προχωρημένους.

- Χρησιμοποιήστε την [`mtr`](http://www.bitwizard.nl/mtr/) ως μια βελτίωση της traceroute για να ανιχνεύετε ζητήματα του δικτύου.

- Για να δείτε γιατί ένας δίσκος είναι γεμάτος, η [`ncdu`](https://dev.yorhel.nl/ncdu) εξοικονομεί χρόνο σε σύγκριση με τις συνήθεις εντολές όπως `du -sh *`.

- Για να βρείτε ποια δικτυακή σύνδεση ή διεργασία χρησιμοποιεί εύρος ζώνης, δοκιμάστε [`iftop`](http://www.ex-parrot.com/~pdw/iftop/) ή [`nethogs`](https://github.com/raboof/nethogs).

- Το εργαλείο `ab` (έρχεται μαζί με Apache) βοηθά στον πρόχειρο έλεγχο της απόδοσης web server. Για πιο σύνθετο έλεγχο φόρτου, δοκιμάστε `siege`.

- Για πιο σοβαρή αποσφαλμάτωση δικτύου, [`wireshark`](https://wireshark.org/), [`tshark`](https://www.wireshark.org/docs/wsug_html_chunked/AppToolstshark.html), ή [`ngrep`](http://ngrep.sourceforge.net/).

- Να γνωρίζετε για τις `strace` και `ltrace`. Αυτές μπορεί να φανούν χρήσιμες, όταν ένα πρόγραμμα αποτυγχάνει, παγώνει ή καταρρέει και δε γνωρίζετε γιατί ή αν θέλετε να έχετε μία γενική ιδέα της απόδοσης. Σημειώστε την επιλογή μέτρησης (`-c`) και τη δυνατότητα να συνδέσετε σε μία διεργασία που εκτελείται (`-p`). Χρησιμοποιήστε την επιλογή για να παρακολουθείτε τις διεργασίες παιδιά (`-f`) για να μη χάνετε σημαντικές κλήσεις.

- Να γνωρίζετε για την `ldd` ώστε να ελέγχετε διαμοιραζόμενες βιβλιοθήκες κλπ. — αλλά [ποτέ να μην την εκτελείτε σε αρχεία που δεν εμπιστεύεστε](http://www.catonmat.net/blog/ldd-arbitrary-code-execution/).

- Να γνωρίζετε πώς να συνδέεστε σε μία διεργασία που εκτελείται με `gdb` και να παίρνετε τα ίχνη της στοίβας της.

- Χρησιμοποιήστε τον κατάλογο `/proc`. Είναι εκπληκτικά χρήσιμος ορισμένες φορές, όταν αποσφαλματώνετε ζωντανά προβλήματα. Παραδείγματα: `/proc/cpuinfo`, `/proc/meminfo`, `/proc/cmdline`, `/proc/xxx/cwd`, `/proc/xxx/exe`, `/proc/xxx/fd/`, `/proc/xxx/smaps` (όπου `xxx` είναι το id της διεργασίας ή pid).

- Όταν αποσφαλματώνετε κάτι που ήταν λάθος στο παρελθόν, η [`sar`](http://sebastien.godard.pagesperso-orange.fr/) μπορεί να είναι πολύ χρήσιμη. Δείχνει ιστορικά στατιστικά για επεξεργαστή, μνήμη, δίκτυο κλπ.

- Για πιο εις βάθος ανάλυση συστήματος και απόδοσης, δείτε τις `stap` ([SystemTap](https://sourceware.org/systemtap/wiki)), [`perf`](https://en.wikipedia.org/wiki/Perf_%28Linux%29) και [`sysdig`](https://github.com/draios/sysdig).

- Ελέγξτε ποιο είναι το λειτουργικό σύστημά σας με `uname` ή `uname -a` (γενικές πληροφορίες Unix/πυρήνα) ή `lsb_release -a` (πληροφορίες διανομής Linux).

- Χρησιμοποιήστε την `dmesg`, όποτε κάτι συμπεριφέρεται πραγματικά παράξενα (μπορεί να έχει να κάνει με υλικό ή με οδηγούς).

- Αν διαγράψετε ένα αρχείο και δεν απελευθερωθεί ο σύμφωνα με την `du` αναμενομένος χώρος στον δίσκο, ελέξτε αν το αρχείο χρησιμοποιείται από κάποια διεργασία:
`lsof | grep deleted | grep "filename-of-my-big-file"`


## Εντολές σε μία γραμμή

Μερικά παραδείγματα σωλήνωσης εντολών:

- Είναι εξαιρετικά βοηθητικό ορισμένες φορές το γεγονός ότι μπορείτε να εφαρμόσετε τις πράξεις της τομής, της ένωσης και της διαφοράς σε αρχεία κειμένου με τις εντολές `sort`/`comm`. Έστω ότι `a` και `b` είναι ταξινομημένα αρχεία κειμένου. Αυτό είναι γρήγορο και δουλεύει σε αρχεία οποιουδήποτε μεγέθους έως πολλά gigabytes. (H εντολή `sort` δεν περιορίζεται από τη μνήμη, αν και ίσως χρειαστεί να χρησιμοποιήσετε την επιλογή `-T`, αν ο `/tmp` βρίσκεται σε μικρή κατάτμηση (partition). Επίσης, δείτε την παρατήρηση παραπάνω για τη μεταβλητή `LC_ALL` και την επιλογή `-u` της εντολής `sort` (παραλείπεται παρακάτω ώστε να είναι πιο ξεκάθαρο το παράδειγμα).
```sh
      sort -mu a b > c # το c είναι a ένωση b
      comm -12 a b > c # c είναι a τομή b
      comm -23 a b > c # το c είναι η διαφορά του a από το b
```

- Χρησιμοποιήστε `grep . *` για να εξετάσετε γρήγορα το περιεχόμενο όλων των αρχείων ενός καταλόγου (έτσι κάθε γραμμή αρχείου εμφανίζεται σε ζεύγος με το όνομα του αρχείου), ή `head -100 *` (έτσι κάθε αρχείο έχει μια κεφαλίδα). Αυτό μπορεί να είναι χρήσιμο για καταλόγους γεμάτους με αρχεία ρυθμίσεων όπως αυτά στους καταλόγους `/sys`, `/proc`, `/etc`.


- Η άθροιση όλων των αριθμών στην τρίτη στήλη ενός αρχείου κειμένου (αυτό είναι μάλλον 3X γρηγορότερο και απαιτεί 3X λιγότερο κώδικα από την αντίστοιχη υλοποίηση σε Python):
```sh
      awk '{ x += $3 } END { print x }' myfile
```

- Για να δείτε μεγέθη/ημερομηνίες σε ένα δέντρο αρχείων, η παρακάτω είναι σα μια αναδρομική `ls -l`, αλλά είναι πιο ευανάγνωστη από `ls -lR`:
```sh
      find . -type f -ls
```

- Έστω ότι έχετε ένα αρχείο κειμένου, όπως το αρχείο καταγραφής (log)/υπ ενός web server και μία συγκεκριμένη τιμή που εμφανίζεται σε μερικές γραμμές, όπως μία παράμετρος `acct_id` που εμφανίζεται στο URL. Αν θέλετε μια καταμέτρηση του πόσα αιτήματα έγιναν για κάθε `acct_id`:
```sh
      egrep -o 'acct_id=[0-9]+' access.log | cut -d= -f2 | sort | uniq -c | sort -rn
```

- Για να παρακολουθείτε συνεχώς αλλαγές, χρησιμοποιήστε `watch`, π.χ. ελέγξτε αλλαγές σε αρχεία ενός καταλόγου με `watch -d -n 2 'ls -rtlh | tail'` ή σε ρυθμίσεις δικτύου ενώ επιδιορθώνετε τις ρυθμίσεις wifi με `watch -d -n 2 ifconfig`.

- Εκτελέστε αυτή τη μέθοδο για να πάρετε μια τυχαία συμβουλή από αυτό το έγγραφο (αναλύει Markdown και εξάγει ένα στοιχείο):
```sh
      function taocl() {
        curl -s https://raw.githubusercontent.com/jlevy/the-art-of-command-line/master/README.md |
          sed '/cowsay[.]png/d' |
          pandoc -f markdown -t html |
          xmlstarlet fo --html --dropdtd |
          xmlstarlet sel -t -v "(html/body/ul/li[count(p)>0])[$RANDOM mod last()+1]" |
          xmlstarlet unesc | fmt -80 | iconv -t US
      }
```

## Ασυνήθιστες αλλά χρήσιμες

- `expr`: εκτελέστε αριθμητικές και λογικές πράξεις ή εφαρμόζετε κανονικές εκφράσεις

- `m4`: απλός μακροεπεξεργαστής

- `yes`: τυπώστε ένα αλφαριθμητικό πολλές φορές

- `cal`: όμορφο ημερολόγιο

- `env`: εκτελέστε μία εντολή (χρήσιμο σε σενάρια)

- `printenv`: τυπώστε μεταβλητές περιβάλλοντος (χρήσιμο στην αποσφαλμάτωση και σε σενάρια)

- `look`: βρείτε αγγλικές λέξεις (ή γραμμές σε ένα αρχείο) αρχίζοντας με ένα αλφαριθμητικό

- `cut`, `paste` και `join`: επεξεργασία δεδομένων

- `fmt`: μορφοποίηση παραγράφων

- `pr`: μορφοποίηση κειμένου σε σελίδες/στήλες

- `fold`: τύλιγμα γραμμών κειμένου

- `column`: μορφοποίηση πεδίων κειμένου σε στοιχισμένες, σταθερού πλάτους στήλες ή πίνακες

- `tree`: εμφανίστε καταλόγους και υποκαταλόγους σε φωλιασμένο δένδρο, όπως η `ls` αλλά αναδρομική

- `stat`: πληροφορίες αρχείου

- `time`: εκτελέστε και χρονομετρήστε μία εντολή

- `timeout`: εκτελέστε μια εντολή για συγκεκριμένο χρονικό διάστημα και σταμάτησε τη διεργασία, όταν ολοκληρωθεί το χρονικό διάστημα αυτό

- `lockfile`: δημιουργήστε αρχεία σημαφόρους που μπορούν να διαγραφούν μόνο με `rm -f`

- `logrotate`: περιστρέψτε, συμπιέστε και στείλτε με ηλ-ταχ αρχεία καταγραφής (logs).

- `watch`: εκτελέστε μία εντολή επαναλαμβανόμενα εμφανίζοντας αποτελέσματα ή/και επισημαίνοντας αλλαγές

- [`when-changed`](https://github.com/joh/when-changed): εκτελεί όποια εντολή ορίσετε, όποτε βλέπει ότι ένα αρχείο άλλαξε. Δείτε ακόμη τις `inotifywait` και `entr`.

- `tac`: τυπώστε αρχεία ανεστραμμένα

- `comm`: συγκρίνετε ταξινομημένα αρχεία γραμμή προς γραμμή

- `strings`: εξάγετε κείμενο από δυαδικά αρχεία

- `tr`: μετάφραση χαρακτήρων ή επεξεργασία

- `iconv` ή `uconv`: μετατροπή κωδικοποίησης κειμένου

- `split` και `csplit`: χώρισμα αρχείων

- `sponge`: διαβάστε όλη την είσοδο πριν γράψετε σε αυτή, χρήσιμο όταν πρόκειται να διαβάσετε από ένα αρχείο και μετά να γράψετε σε αυτό, π.χ., `grep -v something some-file | sponge some-file`

- `units`: μετατροπές μονάδων και υπολογισμοί· κάνει ό,τι μετατροπές μπορείτε να σκεφτείτε (δείτε επίσης `/usr/share/units/definitions.units`)

- `apg`: δημιουργεί τυχαίους κωδικούς

- `xz`: υψηλής αναλογίας συμπίεση αρχείων

- `ldd`: πληροφορίες για δυναμικές βιβλιοθήκες

- `nm`: σύμβολα από αντικειμενικά αρχεία

- `ab` ή [`wrk`](https://github.com/wg/wrk): συγκριτική αξιολόγηση web servers

- `strace`: αποσφαλμάτωση κλήσης συστήματος

- [`mtr`](http://www.bitwizard.nl/mtr/): καλύτερο εργαλείο traceroute για αποσφαλμάτωση δικτύου

- `cssh`: visual concurrent shell

- `rsync`: συγχρονισμός αρχείων και καταλόγων μέσω SSH ή σε τοπικό σύστημα αρχείων

- [`wireshark`](https://wireshark.org/) και [`tshark`](https://www.wireshark.org/docs/wsug_html_chunked/AppToolstshark.html): συλλογή πακέτων και αποσφαλμάτωση δικτύου

- [`ngrep`](http://ngrep.sourceforge.net/): grep για το επίπεδο δικτύου

- `host` και `dig`: αναζητήσεις DNS

- `lsof`: εμφανίστε περιγραφείς αρχείου και πληροφορίες δικτυακών συνδέσεων

- `dstat`: χρήσιμα στατιστικά συστήματος

- [`glances`](https://github.com/nicolargo/glances): υψηλού επιπέδου επισκόπηση πολλαπλών υποσυστημάτων

- `iostat`: στατιστικά χρήσης δίσκου

- `mpstat`: στατιστικά χρήσης επεξεργαστή

- `vmstat`: στατιστικά χρήσης μνήμης

- `htop`: βελτιωμένη έκδοση της top

- `last`: ιστορικό σύνδεσης (login)

- `w`: ποιος συνδέθηκε

- `id`:  πληροφορίες ταυτότητας χρήστη/ομάδας

- [`sar`](http://sebastien.godard.pagesperso-orange.fr/): ιστορικά στατιστικά συστήματος

- [`iftop`](http://www.ex-parrot.com/~pdw/iftop/) ή [`nethogs`](https://github.com/raboof/nethogs): χρήση δικτύου ανά δικτυακή σύνδεση ή διεργασία

- `ss`: στατιστικά ανά δικτυακή σύνδεση

- `dmesg`:  μηνύματα για σφάλματα κατά την εκκίνηση ή σφάλματα συστήματος

- `sysctl`: δείτε και ρυθμίστε τις παραμέτρους του πυρήνα Linux, ενώ εκτελείται

- `hdparm`: διαχείριση/απόδοση δίσκου SATA/ATA

- `lsblk`: εμφανίστε σε λίστα συσκευές αποθήκευσης: μία προβολή σε δέντρο των δίσκων σας και των διαμερισμάτων τους

- `lshw`, `lscpu`, `lspci`, `lsusb`, `dmidecode`: πληροφορίες υλικού, συμπεριλαμβανομένων επεξεργαστή, BIOS, RAID, γραφικών, συσκευών κλπ.

- `lsmod` και `modinfo`: εμφανίστε σε λίστα και προβάλλετε λεπτομέρειες για λειτουργικές μονάδες του πυρήνα

- `fortune`, `ddate`και `sl`: ε, λοιπόν, εξαρτάται από το αν θεωρείτε τα τρένα με ατμομηχανή και τις ρήσεις του Zippy «χρήσιμα»

## Μόνο για OS X

Τα παρακάτω σημεία σχετίζονται *μόνο* με OS X.

- Διαχείριση πακέτων λογισμικού με `brew` (Homebrew) και/ή `port` (MacPorts). Μπορούν να χρησιμοποιηθούν για εγκατάσταση σε OS X πολλών από τις παραπάνω εντολές.

- Αντιγράψτε την έξοδο οποιασδήποτε εντολής σε μια desktop εφαρμογή με `pbcopy` και επικολλήστε στην είσοδο με `pbpaste`.

- Για να ενεργοποιήσετε το πλήκτρο Option σε τερματικό OS X ως πλήκτρο alt (όπως χρησιμοποιείται στις παραπάνω εντολές όπως **alt-b**, **alt-f** κλπ.), ανοίξτε Προτιμήσεις -> Προφίλ -> Πληκτρολόγιο και επιλέξτε «Χρήση Option ως μετα-πλήκτρου».

- Για να ανοίξετε ένα αρχείο με μια desktop εφαρμογή χρησιμοποιήστε `open` ή `open -a /Applications/Whatever.app`.

- Spotlight: Αναζητήστε αρχεία με `mdfind` και εμφανίστε σε λίστα μεταδεδομένα (όπως τις πληροφορίες EXIF μιας φωτογραφίας) με `mdls`.

- Έχετε υπόψη σας ότι το OS X βασίζεται σε BSD Unix και πολλές εντολές (για παράδειγμα `ps`, `ls`, `tail`, `awk`, `sed`) έχουν μικρές διαφορές από το Linux, που έχει ευρέως επηρεαστεί από το System V-style Unix και τα εργαλεία GNU. Συνήθως μπορείτε να βρίσκετε τη διαφορά επισημαίνοντας ότι μια man σελίδα έχει την επικεφαλίδα «Εγχειρίδιο γενικών εντολών BSD». Σε ορισμένες περιπτώσεις μπορούν επίσης να εγκατασταθούν εκδόσεις GNU, (όπως οι `gawk` και `gsed` για τις GNU awk και sed). Αν γράφετε σενάρια Bash που στοχεύετε να εκτελούνται σε διάφορες πλατφόρμες, αποφύγετε τέτοιες εντολές (για παράδειγμα, έχετε υπόψη σας την Python ή `perl`) ή ελέγξτε προσεχτικά.

- Για να πάρετε πληροφορίες για την έκδοση OS X χρησιμοποιήστε `sw_vers`.

## Μόνο για Windows

Τα παρακάτω σημεία σχετίζονται *μόνο* με Windows.

### Πρόσβαση στα εργαλεία του Unix από Windows

- Αποκτήστε πρόσβαση στη δύναμη του φλοιού του Unix σε περιβάλλον Microsoft Windows εγκαθιστώντας το [Cygwin](https://cygwin.com/). Τα περισσότερα από αυτά που περιγράφονται σε αυτό το έγγραφο θα λειτουργήσουν μεμιάς.

- Σε Windows 10, μπορείτε να χρησιμοποιήσετε το [Bash σε Ubuntu για Windows](https://msdn.microsoft.com/commandline/wsl/about), το οποίο παρέχει ένα περιβάλλον παρόμοιο με του Bash με εργαλεία γραμμής εντολών Unix. Έχει το πλεονέκτημα ότι επιτρέπει σε προγράμματα Linux να εκτελεστούν σε Windows. Από την άλλη πλευρά, σε αντίθεση με το περιβάλλον Cygwin, δεν επιτρέπει την εκτέλεση προγραμμάτων Windows από τη γραμμή εντολών του Bash.

- Αν σας ενδιαφέρει κυρίως η χρήση των εργαλείων ανάπτυξης GNU (όπως ο μεταγλωττιστής GCC) σε Windows, σκεφτείτε τη χρήση των [MinGW](http://www.mingw.org/) και [MSYS](http://www.mingw.org/wiki/msys), τα οποία παρέχουν εργαλεία όπως bash, gawk, make και grep. Το MSYS δεν υποστηρίζει όμως όλες τις δυνατότητες του Cygwin. Το MinGW είναι κυρίως χρήσιμο για να δημιουργήσετε εγγενείς εκδόσεις Windows εργαλείων του Unix.

- Μια άλλη επιλογή για να έχετε εντολές Unix κάτω από Windows είναι το σύστημα [Cash](https://github.com/dthree/cash). Αυτό όμως υποστηρίζει πολύ λίγες εντολές και επιλογές του Unix.

### Χρήσιμα εργαλεία της γραμμής εντολών Windows

- Μπορείτε να εκτελέσετε και να γράψετε scripts για τις περισσότερες εργασίες διαχείρισης συστήματος των Windows από τη γραμμή εντολών μαθαίνοντας και χρησιμοποιώντας την `wmic`.

- Χρήσιμα εγγενή εργαλεία της γραμμής εντολών των Windows για διαχείριση και αποσφαλμάτωση του δικτύου είναι τα `ping`,` ipconfig`, `traceroute` και `netstat`.

- Πολλές [χρήσιμες λειτουργίες των Windows] (http://www.thewindowsclub.com/rundll32-shortcut-commands-windows) μπορούν να εκτελεστούν μέσω της εντολής `Rundll32`.

### Συμβουλές για αποδοτική χρήση του Cygwin

- Εγκαταστήστε πρόσθετα προγράμματα Unix με τον διαχειριστή πακέτων του Cygwin.

- Χρησιμοποιήστε το `mintty` ως το παράθυρο γραμμής εντολών σας.

- Αποκτήστε πρόσβαση στο πρόχειρο (clipboard) των Windows μέσω του `/dev/clipboard`.

- Εκτελέστε τη `cygstart` για να ανοίξετε ένα οποιοδήποτε αρχείο με την εφαρμογή που είναι ορισμένη να χρησιμοποιείται για το άνοιγμά του.

- Αποκτήστε πρόσβαση στο μητρώο των Windows με `regtool`.

- Σημειώστε ότι η διαδρομή `C:\` των Windows γίνεται `/cygdrive/c` στο Cygwin και ότι το `/` του  Cygwin εμφανίζεται ως `C:\cygwin` στα Windows. Μετατρέψετε διαδρομές αρχείων από τη μορφή που χρησιμοποιεί το Cygwin σε αυτή που χρησιμοποιούν τα Windows και αντίστροφα με `cygpath`. Αυτό είναι πολύ χρήσιμο σε σενάρια που καλούν προγράμματα Windows.

- Μπορείτε να εκτελέσετε και να γράψετε σενάρια για τις περισσότερες εργασίες διαχείρισης συστήματος των Windows από τη γραμμή εντολών μαθαίνοντας και χρησιμοποιώντας την `wmic`.

- Μία άλλη επιλογή για να έχετε την εμφάνιση και την εμπειρία χρήσης Unix σε Windows είναι το [Cash](https://github.com/dthree/cash). Σημειώστε ότι μόνο πολύ λίγες εντολές Unix και επιλογές γραμμής εντολών είναι διαθέσιμες σε αυτό το περιβάλλον.

## Περισσότερες πηγές

- [awesome-shell](https://github.com/alebcay/awesome-shell): Μία προσεγμένη λίστα με εργαλεία και πηγές σχετικές με τον φλοιό .
- [awesome-osx-command-line](https://github.com/herrbischoff/awesome-osx-command-line): Ένας περισσότερο εις βάθος οδηγός της γραμμής εντολών του OS X.
- [Strict mode](http://redsymbol.net/articles/unofficial-bash-strict-mode/) για να γράφετε καλύτερα σενάρια φλοιού.
- [shellcheck](https://github.com/koalaman/shellcheck): Ένα εργαλείο στατικής ανάλυσης για σενάρια για φλοιό. Στην ουσία, lint για bash/sh/zsh.
- [Filenames and Pathnames in Shell](http://www.dwheeler.com/essays/filenames-in-shell.html): Οι δυστυχώς περίπλοκες μικρολεπτομέρειες του πώς να διαχειριστεί κανείς σωστά ονόματα αρχείων σε σενάρια για φλοιό.
- [Data Science at the Command Line](http://datascienceatthecommandline.com/#tools): Περισσότερες εντολές και εργαλεία χρήσιμα για την άσκηση της επιστήμης δεδομένων, από το βιβλίο με το ίδιο όνομα.

## Αποποίηση ευθύνης

Με την εξαίρεση πολύ μικρών εργασιών, ο κώδικας πρέπει να γράφεται ώστε να μπορούν οι άλλοι να τον διαβάζουν. Η δύναμη συνεπάγεται ευθύνη. Το γεγονός ότι *μπορείτε* να κάνετε κάτι με Bash δε σημαίνει απαραίτητα ότι θα έπρεπε! ;)

## Άδεια χρήσης

[![Creative Commons License](https://i.creativecommons.org/l/by-sa/4.0/88x31.png)](http://creativecommons.org/licenses/by-sa/4.0/)

Η εργασία αυτή έχει αδειοδοτηθεί με [Creative Commons Attribution-ShareAlike 4.0 International License](http://creativecommons.org/licenses/by-sa/4.0/).