'use strict';
var rp = require('request-promise');

var options = {
  method: 'GET',
  uri: 'https://www.google.com/trends/api/explore',
  qs: {
    hl: 'en',
    tz: 300,
    req: JSON.stringify({comparisonItem: [{keyword: 'Donald Trump', time: '2017-02-1 2017-02-10', geo: 'US-CA'}], cat: 0})
  }
}

rp(options)
.then((moreResults) => {
  // /** Interest over time */
  // var results = JSON.parse(moreResults.slice(4)).widgets;
  // console.log('results', results);
  // var options2 = {
  //   method: 'GET',
  //   uri: 'https://www.google.com/trends/api/widgetdata/multiline',
  //   qs: {
  //     hl: 'en-US',
  //     tz: 300,
  //     req: JSON.stringify(results[0].request),
  //     token: results[0].token
  //   }
  // }
// /**
//  * 'Numbers represent search interest relative to the highest point on the chart for the given region and time. A value of 100 is the peak popularity for the term. A value of 50 means that the term is half as popular. Likewise a score of 0 means the term was less than 1% as popular as the peak.'
// */
//   console.log('query string', `${options2.uri}?req=${options2.qs.req}&token=${options2.qs.token}&tz=${options2.qs.tz}`)
//   return rp(options2);
// })
// .then((moreResults) => {
//   /** Interest by region */
//   var results = JSON.parse(moreResults.slice(4)).widgets;
//   console.log('this is results', results);
//   results[1].request.resolution = 'DMA';
//   var options2 = {
//     method: 'GET',
//     uri: 'https://www.google.com/trends/api/widgetdata/comparedgeo',
//     qs: {
//       req: JSON.stringify(results[1].request),
//       token: results[1].token,
//       tz: 360
//     }
//   }
// /**
//  * 'See in which location your term was most popular during the specified time frame. Values are calculated on a scale from 0 to 100, where 100 is the location with the most popularity as a fraction of total searches in that location, a value of 50 indicates a location which is half as popular, and a value of 0 indicates a location where the term was less than 1% as popular as the peak. <p><p> <b>Note:</b> A higher value means a higher proportion of all queries, not a higher absolute query count. So a tiny country where 80% of the queries are for "bananas" will get twice the score of a giant country where only 40% of the queries are for "bananas".'
// */
//   console.log('query string', `${options2.uri}?req=${options2.qs.req}&token=${options2.qs.token}&tz=${options2.qs.tz}`)
//   return rp(options2);
// })
// .then((moreResults) => {
//   /** Related topics */
  // var results = JSON.parse(moreResults.slice(4)).widgets;
  // // console.log('this is results', results);
  // var options2 = {
  //   method: 'GET',
  //   uri: 'https://www.google.com/trends/api/widgetdata/relatedsearches',
  //   qs: {
  //     req: JSON.stringify(results[2].request),
  //     token: results[2].token,
  //     tz: 360
  //   }
  // }
// /**
//  * 'Users searching for your term also searched for these topics. You can view by the following metrics: <p>* <b>Top</b> - The most popular topics. Scoring is on a relative scale where a value of 100 is the most commonly searched topic, a value of 50 is a topic searched half as often, and a value of 0 is a topic searched for less than 1% as often as the most popular topic. <p>* <b>Rising</b> - Related topics with the biggest increase in search frequency since the last time period. Results marked "Breakout" had a tremendous increase, probably because these topics are new and had few (if any) prior searches.'
// */
//   return rp(options2);
// })
// .then((moreResults) => {
//   /** Related queries */
//   var results = JSON.parse(moreResults.slice(4)).widgets;
//   // console.log('this is results', results);
//   var options2 = {
//     method: 'GET',
//     uri: 'https://www.google.com/trends/api/widgetdata/relatedsearches',
//     qs: {
//       req: JSON.stringify(results[3].request),
//       token: results[3].token,
//       tz: 360
//     }
//   }
 /**
  * 'Users searching for your term also searched for these queries. You can sort by the following metrics: <p>* <b>Top</b> - The most popular search queries. Scoring is on a relative scale where a value of 100 is the most commonly searched query, 50 is a query searched half as often, and a value of 0 is a query searched for less than 1% as often as the most popular query. <p>* <b>Rising</b> - Queries with the biggest increase in search frequency since the last time period. Results marked "Breakout" had a tremendous increase, probably because these queries are new and had few (if any) prior searches.'
 */
  return rp(options2);
})
.then((res) => {
  console.log('this is res', res.slice(5));
})


// Interest over time example data
/*
{"default":{"timelineData":[{"time":"1329004800","formattedTime":"Feb 12 - Feb 18 2012","formattedAxisTime":"Feb 12, 2012","value":[3],"formattedValue":["3"]},{"time":"1329609600","formattedTime":"Feb 19 - Feb 25 2012","formattedAxisTime":"Feb 19, 2012","value":[3],"formattedValue":["3"]},{"time":"1330214400","formattedTime":"Feb 26 - Mar 3 2012","formattedAxisTime":"Feb 26, 2012","value":[3],"formattedValue":["3"]},{"time":"1330819200","formattedTime":"Mar 4 - Mar 10 2012","formattedAxisTime":"Mar 4, 2012","value":[2],"formattedValue":["2"]},{"time":"1331424000","formattedTime":"Mar 11 - Mar 17 2012","formattedAxisTime":"Mar 11, 2012","value":[2],"formattedValue":["2"]},{"time":"1332028800","formattedTime":"Mar 18 - Mar 24 2012","formattedAxisTime":"Mar 18, 2012","value":[3],"formattedValue":["3"]},{"time":"1332633600","formattedTime":"Mar 25 - Mar 31 2012","formattedAxisTime":"Mar 25, 2012","value":[3],"formattedValue":["3"]},{"time":"1333238400","formattedTime":"Apr 1 - Apr 7 2012","formattedAxisTime":"Apr 1, 2012","value":[6],"formattedValue":["6"]},{"time":"1333843200","formattedTime":"Apr 8 - Apr 14 2012","formattedAxisTime":"Apr 8, 2012","value":[3],"formattedValue":["3"]},{"time":"1334448000","formattedTime":"Apr 15 - Apr 21 2012","formattedAxisTime":"Apr 15, 2012","value":[3],"formattedValue":["3"]},{"time":"1335052800","formattedTime":"Apr 22 - Apr 28 2012","formattedAxisTime":"Apr 22, 2012","value":[3],"formattedValue":["3"]},{"time":"1335657600","formattedTime":"Apr 29 - May 5 2012","formattedAxisTime":"Apr 29, 2012","value":[3],"formattedValue":["3"]},{"time":"1336262400","formattedTime":"May 6 - May 12 2012","formattedAxisTime":"May 6, 2012","value":[3],"formattedValue":["3"]},{"time":"1336867200","formattedTime":"May 13 - May 19 2012","formattedAxisTime":"May 13, 2012","value":[4],"formattedValue":["4"]},{"time":"1337472000","formattedTime":"May 20 - May 26 2012","formattedAxisTime":"May 20, 2012","value":[3],"formattedValue":["3"]},{"time":"1338076800","formattedTime":"May 27 - Jun 2 2012","formattedAxisTime":"May 27, 2012","value":[3],"formattedValue":["3"]},{"time":"1338681600","formattedTime":"Jun 3 - Jun 9 2012","formattedAxisTime":"Jun 3, 2012","value":[3],"formattedValue":["3"]},{"time":"1339286400","formattedTime":"Jun 10 - Jun 16 2012","formattedAxisTime":"Jun 10, 2012","value":[4],"formattedValue":["4"]},{"time":"1339891200","formattedTime":"Jun 17 - Jun 23 2012","formattedAxisTime":"Jun 17, 2012","value":[5],"formattedValue":["5"]},{"time":"1340496000","formattedTime":"Jun 24 - Jun 30 2012","formattedAxisTime":"Jun 24, 2012","value":[4],"formattedValue":["4"]},{"time":"1341100800","formattedTime":"Jul 1 - Jul 7 2012","formattedAxisTime":"Jul 1, 2012","value":[3],"formattedValue":["3"]},{"time":"1341705600","formattedTime":"Jul 8 - Jul 14 2012","formattedAxisTime":"Jul 8, 2012","value":[4],"formattedValue":["4"]},{"time":"1342310400","formattedTime":"Jul 15 - Jul 21 2012","formattedAxisTime":"Jul 15, 2012","value":[3],"formattedValue":["3"]},{"time":"1342915200","formattedTime":"Jul 22 - Jul 28 2012","formattedAxisTime":"Jul 22, 2012","value":[3],"formattedValue":["3"]},{"time":"1343520000","formattedTime":"Jul 29 - Aug 4 2012","formattedAxisTime":"Jul 29, 2012","value":[3],"formattedValue":["3"]},{"time":"1344124800","formattedTime":"Aug 5 - Aug 11 2012","formattedAxisTime":"Aug 5, 2012","value":[3],"formattedValue":["3"]},{"time":"1344729600","formattedTime":"Aug 12 - Aug 18 2012","formattedAxisTime":"Aug 12, 2012","value":[4],"formattedValue":["4"]},{"time":"1345334400","formattedTime":"Aug 19 - Aug 25 2012","formattedAxisTime":"Aug 19, 2012","value":[3],"formattedValue":["3"]},{"time":"1345939200","formattedTime":"Aug 26 - Sep 1 2012","formattedAxisTime":"Aug 26, 2012","value":[3],"formattedValue":["3"]},{"time":"1346544000","formattedTime":"Sep 2 - Sep 8 2012","formattedAxisTime":"Sep 2, 2012","value":[4],"formattedValue":["4"]},{"time":"1347148800","formattedTime":"Sep 9 - Sep 15 2012","formattedAxisTime":"Sep 9, 2012","value":[8],"formattedValue":["8"]},{"time":"1347753600","formattedTime":"Sep 16 - Sep 22 2012","formattedAxisTime":"Sep 16, 2012","value":[5],"formattedValue":["5"]},{"time":"1348358400","formattedTime":"Sep 23 - Sep 29 2012","formattedAxisTime":"Sep 23, 2012","value":[4],"formattedValue":["4"]},{"time":"1348963200","formattedTime":"Sep 30 - Oct 6 2012","formattedAxisTime":"Sep 30, 2012","value":[3],"formattedValue":["3"]},{"time":"1349568000","formattedTime":"Oct 7 - Oct 13 2012","formattedAxisTime":"Oct 7, 2012","value":[3],"formattedValue":["3"]},{"time":"1350172800","formattedTime":"Oct 14 - Oct 20 2012","formattedAxisTime":"Oct 14, 2012","value":[4],"formattedValue":["4"]},{"time":"1350777600","formattedTime":"Oct 21 - Oct 27 2012","formattedAxisTime":"Oct 21, 2012","value":[5],"formattedValue":["5"]},{"time":"1351382400","formattedTime":"Oct 28 - Nov 3 2012","formattedAxisTime":"Oct 28, 2012","value":[3],"formattedValue":["3"]},{"time":"1351987200","formattedTime":"Nov 4 - Nov 10 2012","formattedAxisTime":"Nov 4, 2012","value":[3],"formattedValue":["3"]},{"time":"1352592000","formattedTime":"Nov 11 - Nov 17 2012","formattedAxisTime":"Nov 11, 2012","value":[3],"formattedValue":["3"]},{"time":"1353196800","formattedTime":"Nov 18 - Nov 24 2012","formattedAxisTime":"Nov 18, 2012","value":[7],"formattedValue":["7"]},{"time":"1353801600","formattedTime":"Nov 25 - Dec 1 2012","formattedAxisTime":"Nov 25, 2012","value":[4],"formattedValue":["4"]},{"time":"1354406400","formattedTime":"Dec 2 - Dec 8 2012","formattedAxisTime":"Dec 2, 2012","value":[3],"formattedValue":["3"]},{"time":"1355011200","formattedTime":"Dec 9 - Dec 15 2012","formattedAxisTime":"Dec 9, 2012","value":[3],"formattedValue":["3"]},{"time":"1355616000","formattedTime":"Dec 16 - Dec 22 2012","formattedAxisTime":"Dec 16, 2012","value":[4],"formattedValue":["4"]},{"time":"1356220800","formattedTime":"Dec 23 - Dec 29 2012","formattedAxisTime":"Dec 23, 2012","value":[3],"formattedValue":["3"]},{"time":"1356825600","formattedTime":"Dec 30 2012 - Jan 5 2013","formattedAxisTime":"Dec 30, 2012","value":[5],"formattedValue":["5"]},{"time":"1357430400","formattedTime":"Jan 6 - Jan 12 2013","formattedAxisTime":"Jan 6, 2013","value":[4],"formattedValue":["4"]},{"time":"1358035200","formattedTime":"Jan 13 - Jan 19 2013","formattedAxisTime":"Jan 13, 2013","value":[3],"formattedValue":["3"]},{"time":"1358640000","formattedTime":"Jan 20 - Jan 26 2013","formattedAxisTime":"Jan 20, 2013","value":[4],"formattedValue":["4"]},{"time":"1359244800","formattedTime":"Jan 27 - Feb 2 2013","formattedAxisTime":"Jan 27, 2013","value":[3],"formattedValue":["3"]},{"time":"1359849600","formattedTime":"Feb 3 - Feb 9 2013","formattedAxisTime":"Feb 3, 2013","value":[4],"formattedValue":["4"]},{"time":"1360454400","formattedTime":"Feb 10 - Feb 16 2013","formattedAxisTime":"Feb 10, 2013","value":[5],"formattedValue":["5"]},{"time":"1361059200","formattedTime":"Feb 17 - Feb 23 2013","formattedAxisTime":"Feb 17, 2013","value":[7],"formattedValue":["7"]},{"time":"1361664000","formattedTime":"Feb 24 - Mar 2 2013","formattedAxisTime":"Feb 24, 2013","value":[4],"formattedValue":["4"]},{"time":"1362268800","formattedTime":"Mar 3 - Mar 9 2013","formattedAxisTime":"Mar 3, 2013","value":[4],"formattedValue":["4"]},{"time":"1362873600","formattedTime":"Mar 10 - Mar 16 2013","formattedAxisTime":"Mar 10, 2013","value":[3],"formattedValue":["3"]},{"time":"1363478400","formattedTime":"Mar 17 - Mar 23 2013","formattedAxisTime":"Mar 17, 2013","value":[3],"formattedValue":["3"]},{"time":"1364083200","formattedTime":"Mar 24 - Mar 30 2013","formattedAxisTime":"Mar 24, 2013","value":[3],"formattedValue":["3"]},{"time":"1364688000","formattedTime":"Mar 31 - Apr 6 2013","formattedAxisTime":"Mar 31, 2013","value":[3],"formattedValue":["3"]},{"time":"1365292800","formattedTime":"Apr 7 - Apr 13 2013","formattedAxisTime":"Apr 7, 2013","value":[3],"formattedValue":["3"]},{"time":"1365897600","formattedTime":"Apr 14 - Apr 20 2013","formattedAxisTime":"Apr 14, 2013","value":[3],"formattedValue":["3"]},{"time":"1366502400","formattedTime":"Apr 21 - Apr 27 2013","formattedAxisTime":"Apr 21, 2013","value":[3],"formattedValue":["3"]},{"time":"1367107200","formattedTime":"Apr 28 - May 4 2013","formattedAxisTime":"Apr 28, 2013","value":[3],"formattedValue":["3"]},{"time":"1367712000","formattedTime":"May 5 - May 11 2013","formattedAxisTime":"May 5, 2013","value":[3],"formattedValue":["3"]},{"time":"1368316800","formattedTime":"May 12 - May 18 2013","formattedAxisTime":"May 12, 2013","value":[22],"formattedValue":["22"]},{"time":"1368921600","formattedTime":"May 19 - May 25 2013","formattedAxisTime":"May 19, 2013","value":[5],"formattedValue":["5"]},{"time":"1369526400","formattedTime":"May 26 - Jun 1 2013","formattedAxisTime":"May 26, 2013","value":[4],"formattedValue":["4"]},{"time":"1370131200","formattedTime":"Jun 2 - Jun 8 2013","formattedAxisTime":"Jun 2, 2013","value":[3],"formattedValue":["3"]},{"time":"1370736000","formattedTime":"Jun 9 - Jun 15 2013","formattedAxisTime":"Jun 9, 2013","value":[3],"formattedValue":["3"]},{"time":"1371340800","formattedTime":"Jun 16 - Jun 22 2013","formattedAxisTime":"Jun 16, 2013","value":[4],"formattedValue":["4"]},{"time":"1371945600","formattedTime":"Jun 23 - Jun 29 2013","formattedAxisTime":"Jun 23, 2013","value":[6],"formattedValue":["6"]},{"time":"1372550400","formattedTime":"Jun 30 - Jul 6 2013","formattedAxisTime":"Jun 30, 2013","value":[4],"formattedValue":["4"]},{"time":"1373155200","formattedTime":"Jul 7 - Jul 13 2013","formattedAxisTime":"Jul 7, 2013","value":[5],"formattedValue":["5"]},{"time":"1373760000","formattedTime":"Jul 14 - Jul 20 2013","formattedAxisTime":"Jul 14, 2013","value":[12],"formattedValue":["12"]},{"time":"1374364800","formattedTime":"Jul 21 - Jul 27 2013","formattedAxisTime":"Jul 21, 2013","value":[10],"formattedValue":["10"]},{"time":"1374969600","formattedTime":"Jul 28 - Aug 3 2013","formattedAxisTime":"Jul 28, 2013","value":[9],"formattedValue":["9"]},{"time":"1375574400","formattedTime":"Aug 4 - Aug 10 2013","formattedAxisTime":"Aug 4, 2013","value":[3],"formattedValue":["3"]},{"time":"1376179200","formattedTime":"Aug 11 - Aug 17 2013","formattedAxisTime":"Aug 11, 2013","value":[2],"formattedValue":["2"]},{"time":"1376784000","formattedTime":"Aug 18 - Aug 24 2013","formattedAxisTime":"Aug 18, 2013","value":[3],"formattedValue":["3"]},{"time":"1377388800","formattedTime":"Aug 25 - Aug 31 2013","formattedAxisTime":"Aug 25, 2013","value":[3],"formattedValue":["3"]},{"time":"1377993600","formattedTime":"Sep 1 - Sep 7 2013","formattedAxisTime":"Sep 1, 2013","value":[4],"formattedValue":["4"]},{"time":"1378598400","formattedTime":"Sep 8 - Sep 14 2013","formattedAxisTime":"Sep 8, 2013","value":[3],"formattedValue":["3"]},{"time":"1379203200","formattedTime":"Sep 15 - Sep 21 2013","formattedAxisTime":"Sep 15, 2013","value":[3],"formattedValue":["3"]},{"time":"1379808000","formattedTime":"Sep 22 - Sep 28 2013","formattedAxisTime":"Sep 22, 2013","value":[4],"formattedValue":["4"]},{"time":"1380412800","formattedTime":"Sep 29 - Oct 5 2013","formattedAxisTime":"Sep 29, 2013","value":[3],"formattedValue":["3"]},{"time":"1381017600","formattedTime":"Oct 6 - Oct 12 2013","formattedAxisTime":"Oct 6, 2013","value":[3],"formattedValue":["3"]},{"time":"1381622400","formattedTime":"Oct 13 - Oct 19 2013","formattedAxisTime":"Oct 13, 2013","value":[3],"formattedValue":["3"]},{"time":"1382227200","formattedTime":"Oct 20 - Oct 26 2013","formattedAxisTime":"Oct 20, 2013","value":[3],"formattedValue":["3"]},{"time":"1382832000","formattedTime":"Oct 27 - Nov 2 2013","formattedAxisTime":"Oct 27, 2013","value":[3],"formattedValue":["3"]},{"time":"1383436800","formattedTime":"Nov 3 - Nov 9 2013","formattedAxisTime":"Nov 3, 2013","value":[3],"formattedValue":["3"]},{"time":"1384041600","formattedTime":"Nov 10 - Nov 16 2013","formattedAxisTime":"Nov 10, 2013","value":[2],"formattedValue":["2"]},{"time":"1384646400","formattedTime":"Nov 17 - Nov 23 2013","formattedAxisTime":"Nov 17, 2013","value":[3],"formattedValue":["3"]},{"time":"1385251200","formattedTime":"Nov 24 - Nov 30 2013","formattedAxisTime":"Nov 24, 2013","value":[7],"formattedValue":["7"]},{"time":"1385856000","formattedTime":"Dec 1 - Dec 7 2013","formattedAxisTime":"Dec 1, 2013","value":[4],"formattedValue":["4"]},{"time":"1386460800","formattedTime":"Dec 8 - Dec 14 2013","formattedAxisTime":"Dec 8, 2013","value":[3],"formattedValue":["3"]},{"time":"1387065600","formattedTime":"Dec 15 - Dec 21 2013","formattedAxisTime":"Dec 15, 2013","value":[3],"formattedValue":["3"]},{"time":"1387670400","formattedTime":"Dec 22 - Dec 28 2013","formattedAxisTime":"Dec 22, 2013","value":[3],"formattedValue":["3"]},{"time":"1388275200","formattedTime":"Dec 29 2013 - Jan 4 2014","formattedAxisTime":"Dec 29, 2013","value":[4],"formattedValue":["4"]},{"time":"1388880000","formattedTime":"Jan 5 - Jan 11 2014","formattedAxisTime":"Jan 5, 2014","value":[5],"formattedValue":["5"]},{"time":"1389484800","formattedTime":"Jan 12 - Jan 18 2014","formattedAxisTime":"Jan 12, 2014","value":[3],"formattedValue":["3"]},{"time":"1390089600","formattedTime":"Jan 19 - Jan 25 2014","formattedAxisTime":"Jan 19, 2014","value":[3],"formattedValue":["3"]},{"time":"1390694400","formattedTime":"Jan 26 - Feb 1 2014","formattedAxisTime":"Jan 26, 2014","value":[3],"formattedValue":["3"]},{"time":"1391299200","formattedTime":"Feb 2 - Feb 8 2014","formattedAxisTime":"Feb 2, 2014","value":[4],"formattedValue":["4"]},{"time":"1391904000","formattedTime":"Feb 9 - Feb 15 2014","formattedAxisTime":"Feb 9, 2014","value":[3],"formattedValue":["3"]},{"time":"1392508800","formattedTime":"Feb 16 - Feb 22 2014","formattedAxisTime":"Feb 16, 2014","value":[3],"formattedValue":["3"]},{"time":"1393113600","formattedTime":"Feb 23 - Mar 1 2014","formattedAxisTime":"Feb 23, 2014","value":[3],"formattedValue":["3"]},{"time":"1393718400","formattedTime":"Mar 2 - Mar 8 2014","formattedAxisTime":"Mar 2, 2014","value":[5],"formattedValue":["5"]},{"time":"1394323200","formattedTime":"Mar 9 - Mar 15 2014","formattedAxisTime":"Mar 9, 2014","value":[4],"formattedValue":["4"]},{"time":"1394928000","formattedTime":"Mar 16 - Mar 22 2014","formattedAxisTime":"Mar 16, 2014","value":[3],"formattedValue":["3"]},{"time":"1395532800","formattedTime":"Mar 23 - Mar 29 2014","formattedAxisTime":"Mar 23, 2014","value":[3],"formattedValue":["3"]},{"time":"1396137600","formattedTime":"Mar 30 - Apr 5 2014","formattedAxisTime":"Mar 30, 2014","value":[3],"formattedValue":["3"]},{"time":"1396742400","formattedTime":"Apr 6 - Apr 12 2014","formattedAxisTime":"Apr 6, 2014","value":[4],"formattedValue":["4"]},{"time":"1397347200","formattedTime":"Apr 13 - Apr 19 2014","formattedAxisTime":"Apr 13, 2014","value":[3],"formattedValue":["3"]},{"time":"1397952000","formattedTime":"Apr 20 - Apr 26 2014","formattedAxisTime":"Apr 20, 2014","value":[3],"formattedValue":["3"]},{"time":"1398556800","formattedTime":"Apr 27 - May 3 2014","formattedAxisTime":"Apr 27, 2014","value":[3],"formattedValue":["3"]},{"time":"1399161600","formattedTime":"May 4 - May 10 2014","formattedAxisTime":"May 4, 2014","value":[3],"formattedValue":["3"]},{"time":"1399766400","formattedTime":"May 11 - May 17 2014","formattedAxisTime":"May 11, 2014","value":[3],"formattedValue":["3"]},{"time":"1400371200","formattedTime":"May 18 - May 24 2014","formattedAxisTime":"May 18, 2014","value":[3],"formattedValue":["3"]},{"time":"1400976000","formattedTime":"May 25 - May 31 2014","formattedAxisTime":"May 25, 2014","value":[3],"formattedValue":["3"]},{"time":"1401580800","formattedTime":"Jun 1 - Jun 7 2014","formattedAxisTime":"Jun 1, 2014","value":[4],"formattedValue":["4"]},{"time":"1402185600","formattedTime":"Jun 8 - Jun 14 2014","formattedAxisTime":"Jun 8, 2014","value":[22],"formattedValue":["22"]},{"time":"1402790400","formattedTime":"Jun 15 - Jun 21 2014","formattedAxisTime":"Jun 15, 2014","value":[14],"formattedValue":["14"]},{"time":"1403395200","formattedTime":"Jun 22 - Jun 28 2014","formattedAxisTime":"Jun 22, 2014","value":[4],"formattedValue":["4"]},{"time":"1404000000","formattedTime":"Jun 29 - Jul 5 2014","formattedAxisTime":"Jun 29, 2014","value":[5],"formattedValue":["5"]},{"time":"1404604800","formattedTime":"Jul 6 - Jul 12 2014","formattedAxisTime":"Jul 6, 2014","value":[4],"formattedValue":["4"]},{"time":"1405209600","formattedTime":"Jul 13 - Jul 19 2014","formattedAxisTime":"Jul 13, 2014","value":[3],"formattedValue":["3"]},{"time":"1405814400","formattedTime":"Jul 20 - Jul 26 2014","formattedAxisTime":"Jul 20, 2014","value":[3],"formattedValue":["3"]},{"time":"1406419200","formattedTime":"Jul 27 - Aug 2 2014","formattedAxisTime":"Jul 27, 2014","value":[3],"formattedValue":["3"]},{"time":"1407024000","formattedTime":"Aug 3 - Aug 9 2014","formattedAxisTime":"Aug 3, 2014","value":[3],"formattedValue":["3"]},{"time":"1407628800","formattedTime":"Aug 10 - Aug 16 2014","formattedAxisTime":"Aug 10, 2014","value":[4],"formattedValue":["4"]},{"time":"1408233600","formattedTime":"Aug 17 - Aug 23 2014","formattedAxisTime":"Aug 17, 2014","value":[3],"formattedValue":["3"]},{"time":"1408838400","formattedTime":"Aug 24 - Aug 30 2014","formattedAxisTime":"Aug 24, 2014","value":[3],"formattedValue":["3"]},{"time":"1409443200","formattedTime":"Aug 31 - Sep 6 2014","formattedAxisTime":"Aug 31, 2014","value":[3],"formattedValue":["3"]},{"time":"1410048000","formattedTime":"Sep 7 - Sep 13 2014","formattedAxisTime":"Sep 7, 2014","value":[5],"formattedValue":["5"]},{"time":"1410652800","formattedTime":"Sep 14 - Sep 20 2014","formattedAxisTime":"Sep 14, 2014","value":[3],"formattedValue":["3"]},{"time":"1411257600","formattedTime":"Sep 21 - Sep 27 2014","formattedAxisTime":"Sep 21, 2014","value":[3],"formattedValue":["3"]},{"time":"1411862400","formattedTime":"Sep 28 - Oct 4 2014","formattedAxisTime":"Sep 28, 2014","value":[3],"formattedValue":["3"]},{"time":"1412467200","formattedTime":"Oct 5 - Oct 11 2014","formattedAxisTime":"Oct 5, 2014","value":[5],"formattedValue":["5"]},{"time":"1413072000","formattedTime":"Oct 12 - Oct 18 2014","formattedAxisTime":"Oct 12, 2014","value":[6],"formattedValue":["6"]},{"time":"1413676800","formattedTime":"Oct 19 - Oct 25 2014","formattedAxisTime":"Oct 19, 2014","value":[5],"formattedValue":["5"]},{"time":"1414281600","formattedTime":"Oct 26 - Nov 1 2014","formattedAxisTime":"Oct 26, 2014","value":[4],"formattedValue":["4"]},{"time":"1414886400","formattedTime":"Nov 2 - Nov 8 2014","formattedAxisTime":"Nov 2, 2014","value":[3],"formattedValue":["3"]},{"time":"1415491200","formattedTime":"Nov 9 - Nov 15 2014","formattedAxisTime":"Nov 9, 2014","value":[3],"formattedValue":["3"]},{"time":"1416096000","formattedTime":"Nov 16 - Nov 22 2014","formattedAxisTime":"Nov 16, 2014","value":[3],"formattedValue":["3"]},{"time":"1416700800","formattedTime":"Nov 23 - Nov 29 2014","formattedAxisTime":"Nov 23, 2014","value":[5],"formattedValue":["5"]},{"time":"1417305600","formattedTime":"Nov 30 - Dec 6 2014","formattedAxisTime":"Nov 30, 2014","value":[3],"formattedValue":["3"]},{"time":"1417910400","formattedTime":"Dec 7 - Dec 13 2014","formattedAxisTime":"Dec 7, 2014","value":[3],"formattedValue":["3"]},{"time":"1418515200","formattedTime":"Dec 14 - Dec 20 2014","formattedAxisTime":"Dec 14, 2014","value":[3],"formattedValue":["3"]},{"time":"1419120000","formattedTime":"Dec 21 - Dec 27 2014","formattedAxisTime":"Dec 21, 2014","value":[3],"formattedValue":["3"]},{"time":"1419724800","formattedTime":"Dec 28 2014 - Jan 3 2015","formattedAxisTime":"Dec 28, 2014","value":[3],"formattedValue":["3"]},{"time":"1420329600","formattedTime":"Jan 4 - Jan 10 2015","formattedAxisTime":"Jan 4, 2015","value":[5],"formattedValue":["5"]},{"time":"1420934400","formattedTime":"Jan 11 - Jan 17 2015","formattedAxisTime":"Jan 11, 2015","value":[4],"formattedValue":["4"]},{"time":"1421539200","formattedTime":"Jan 18 - Jan 24 2015","formattedAxisTime":"Jan 18, 2015","value":[4],"formattedValue":["4"]},{"time":"1422144000","formattedTime":"Jan 25 - Jan 31 2015","formattedAxisTime":"Jan 25, 2015","value":[4],"formattedValue":["4"]},{"time":"1422748800","formattedTime":"Feb 1 - Feb 7 2015","formattedAxisTime":"Feb 1, 2015","value":[3],"formattedValue":["3"]},{"time":"1423353600","formattedTime":"Feb 8 - Feb 14 2015","formattedAxisTime":"Feb 8, 2015","value":[3],"formattedValue":["3"]},{"time":"1423958400","formattedTime":"Feb 15 - Feb 21 2015","formattedAxisTime":"Feb 15, 2015","value":[6],"formattedValue":["6"]},{"time":"1424563200","formattedTime":"Feb 22 - Feb 28 2015","formattedAxisTime":"Feb 22, 2015","value":[3],"formattedValue":["3"]},{"time":"1425168000","formattedTime":"Mar 1 - Mar 7 2015","formattedAxisTime":"Mar 1, 2015","value":[3],"formattedValue":["3"]},{"time":"1425772800","formattedTime":"Mar 8 - Mar 14 2015","formattedAxisTime":"Mar 8, 2015","value":[3],"formattedValue":["3"]},{"time":"1426377600","formattedTime":"Mar 15 - Mar 21 2015","formattedAxisTime":"Mar 15, 2015","value":[4],"formattedValue":["4"]},{"time":"1426982400","formattedTime":"Mar 22 - Mar 28 2015","formattedAxisTime":"Mar 22, 2015","value":[3],"formattedValue":["3"]},{"time":"1427587200","formattedTime":"Mar 29 - Apr 4 2015","formattedAxisTime":"Mar 29, 2015","value":[3],"formattedValue":["3"]},{"time":"1428192000","formattedTime":"Apr 5 - Apr 11 2015","formattedAxisTime":"Apr 5, 2015","value":[3],"formattedValue":["3"]},{"time":"1428796800","formattedTime":"Apr 12 - Apr 18 2015","formattedAxisTime":"Apr 12, 2015","value":[4],"formattedValue":["4"]},{"time":"1429401600","formattedTime":"Apr 19 - Apr 25 2015","formattedAxisTime":"Apr 19, 2015","value":[4],"formattedValue":["4"]},{"time":"1430006400","formattedTime":"Apr 26 - May 2 2015","formattedAxisTime":"Apr 26, 2015","value":[5],"formattedValue":["5"]},{"time":"1430611200","formattedTime":"May 3 - May 9 2015","formattedAxisTime":"May 3, 2015","value":[3],"formattedValue":["3"]},{"time":"1431216000","formattedTime":"May 10 - May 16 2015","formattedAxisTime":"May 10, 2015","value":[5],"formattedValue":["5"]},{"time":"1431820800","formattedTime":"May 17 - May 23 2015","formattedAxisTime":"May 17, 2015","value":[4],"formattedValue":["4"]},{"time":"1432425600","formattedTime":"May 24 - May 30 2015","formattedAxisTime":"May 24, 2015","value":[4],"formattedValue":["4"]},{"time":"1433030400","formattedTime":"May 31 - Jun 6 2015","formattedAxisTime":"May 31, 2015","value":[5],"formattedValue":["5"]},{"time":"1433635200","formattedTime":"Jun 7 - Jun 13 2015","formattedAxisTime":"Jun 7, 2015","value":[4],"formattedValue":["4"]},{"time":"1434240000","formattedTime":"Jun 14 - Jun 20 2015","formattedAxisTime":"Jun 14, 2015","value":[5],"formattedValue":["5"]},{"time":"1434844800","formattedTime":"Jun 21 - Jun 27 2015","formattedAxisTime":"Jun 21, 2015","value":[5],"formattedValue":["5"]},{"time":"1435449600","formattedTime":"Jun 28 - Jul 4 2015","formattedAxisTime":"Jun 28, 2015","value":[3],"formattedValue":["3"]},{"time":"1436054400","formattedTime":"Jul 5 - Jul 11 2015","formattedAxisTime":"Jul 5, 2015","value":[3],"formattedValue":["3"]},{"time":"1436659200","formattedTime":"Jul 12 - Jul 18 2015","formattedAxisTime":"Jul 12, 2015","value":[4],"formattedValue":["4"]},{"time":"1437264000","formattedTime":"Jul 19 - Jul 25 2015","formattedAxisTime":"Jul 19, 2015","value":[3],"formattedValue":["3"]},{"time":"1437868800","formattedTime":"Jul 26 - Aug 1 2015","formattedAxisTime":"Jul 26, 2015","value":[3],"formattedValue":["3"]},{"time":"1438473600","formattedTime":"Aug 2 - Aug 8 2015","formattedAxisTime":"Aug 2, 2015","value":[3],"formattedValue":["3"]},{"time":"1439078400","formattedTime":"Aug 9 - Aug 15 2015","formattedAxisTime":"Aug 9, 2015","value":[3],"formattedValue":["3"]},{"time":"1439683200","formattedTime":"Aug 16 - Aug 22 2015","formattedAxisTime":"Aug 16, 2015","value":[4],"formattedValue":["4"]},{"time":"1440288000","formattedTime":"Aug 23 - Aug 29 2015","formattedAxisTime":"Aug 23, 2015","value":[3],"formattedValue":["3"]},{"time":"1440892800","formattedTime":"Aug 30 - Sep 5 2015","formattedAxisTime":"Aug 30, 2015","value":[4],"formattedValue":["4"]},{"time":"1441497600","formattedTime":"Sep 6 - Sep 12 2015","formattedAxisTime":"Sep 6, 2015","value":[6],"formattedValue":["6"]},{"time":"1442102400","formattedTime":"Sep 13 - Sep 19 2015","formattedAxisTime":"Sep 13, 2015","value":[5],"formattedValue":["5"]},{"time":"1442707200","formattedTime":"Sep 20 - Sep 26 2015","formattedAxisTime":"Sep 20, 2015","value":[12],"formattedValue":["12"]},{"time":"1443312000","formattedTime":"Sep 27 - Oct 3 2015","formattedAxisTime":"Sep 27, 2015","value":[21],"formattedValue":["21"]},{"time":"1443916800","formattedTime":"Oct 4 - Oct 10 2015","formattedAxisTime":"Oct 4, 2015","value":[17],"formattedValue":["17"]},{"time":"1444521600","formattedTime":"Oct 11 - Oct 17 2015","formattedAxisTime":"Oct 11, 2015","value":[11],"formattedValue":["11"]},{"time":"1445126400","formattedTime":"Oct 18 - Oct 24 2015","formattedAxisTime":"Oct 18, 2015","value":[6],"formattedValue":["6"]},{"time":"1445731200","formattedTime":"Oct 25 - Oct 31 2015","formattedAxisTime":"Oct 25, 2015","value":[7],"formattedValue":["7"]},{"time":"1446336000","formattedTime":"Nov 1 - Nov 7 2015","formattedAxisTime":"Nov 1, 2015","value":[6],"formattedValue":["6"]},{"time":"1446940800","formattedTime":"Nov 8 - Nov 14 2015","formattedAxisTime":"Nov 8, 2015","value":[5],"formattedValue":["5"]},{"time":"1447545600","formattedTime":"Nov 15 - Nov 21 2015","formattedAxisTime":"Nov 15, 2015","value":[4],"formattedValue":["4"]},{"time":"1448150400","formattedTime":"Nov 22 - Nov 28 2015","formattedAxisTime":"Nov 22, 2015","value":[5],"formattedValue":["5"]},{"time":"1448755200","formattedTime":"Nov 29 - Dec 5 2015","formattedAxisTime":"Nov 29, 2015","value":[7],"formattedValue":["7"]},{"time":"1449360000","formattedTime":"Dec 6 - Dec 12 2015","formattedAxisTime":"Dec 6, 2015","value":[6],"formattedValue":["6"]},{"time":"1449964800","formattedTime":"Dec 13 - Dec 19 2015","formattedAxisTime":"Dec 13, 2015","value":[7],"formattedValue":["7"]},{"time":"1450569600","formattedTime":"Dec 20 - Dec 26 2015","formattedAxisTime":"Dec 20, 2015","value":[7],"formattedValue":["7"]},{"time":"1451174400","formattedTime":"Dec 27 2015 - Jan 2 2016","formattedAxisTime":"Dec 27, 2015","value":[9],"formattedValue":["9"]},{"time":"1451779200","formattedTime":"Jan 3 - Jan 9 2016","formattedAxisTime":"Jan 3, 2016","value":[8],"formattedValue":["8"]},{"time":"1452384000","formattedTime":"Jan 10 - Jan 16 2016","formattedAxisTime":"Jan 10, 2016","value":[9],"formattedValue":["9"]},{"time":"1452988800","formattedTime":"Jan 17 - Jan 23 2016","formattedAxisTime":"Jan 17, 2016","value":[12],"formattedValue":["12"]},{"time":"1453593600","formattedTime":"Jan 24 - Jan 30 2016","formattedAxisTime":"Jan 24, 2016","value":[24],"formattedValue":["24"]},{"time":"1454198400","formattedTime":"Jan 31 - Feb 6 2016","formattedAxisTime":"Jan 31, 2016","value":[100],"formattedValue":["100"]},{"time":"1454803200","formattedTime":"Feb 7 - Feb 13 2016","formattedAxisTime":"Feb 7, 2016","value":[69],"formattedValue":["69"]},{"time":"1455408000","formattedTime":"Feb 14 - Feb 20 2016","formattedAxisTime":"Feb 14, 2016","value":[60],"formattedValue":["60"]},{"time":"1456012800","formattedTime":"Feb 21 - Feb 27 2016","formattedAxisTime":"Feb 21, 2016","value":[63],"formattedValue":["63"]},{"time":"1456617600","formattedTime":"Feb 28 - Mar 5 2016","formattedAxisTime":"Feb 28, 2016","value":[93],"formattedValue":["93"]},{"time":"1457222400","formattedTime":"Mar 6 - Mar 12 2016","formattedAxisTime":"Mar 6, 2016","value":[65],"formattedValue":["65"]},{"time":"1457827200","formattedTime":"Mar 13 - Mar 19 2016","formattedAxisTime":"Mar 13, 2016","value":[41],"formattedValue":["41"]},{"time":"1458432000","formattedTime":"Mar 20 - Mar 26 2016","formattedAxisTime":"Mar 20, 2016","value":[33],"formattedValue":["33"]},{"time":"1459036800","formattedTime":"Mar 27 - Apr 2 2016","formattedAxisTime":"Mar 27, 2016","value":[36],"formattedValue":["36"]},{"time":"1459641600","formattedTime":"Apr 3 - Apr 9 2016","formattedAxisTime":"Apr 3, 2016","value":[51],"formattedValue":["51"]},{"time":"1460246400","formattedTime":"Apr 10 - Apr 16 2016","formattedAxisTime":"Apr 10, 2016","value":[28],"formattedValue":["28"]},{"time":"1460851200","formattedTime":"Apr 17 - Apr 23 2016","formattedAxisTime":"Apr 17, 2016","value":[26],"formattedValue":["26"]},{"time":"1461456000","formattedTime":"Apr 24 - Apr 30 2016","formattedAxisTime":"Apr 24, 2016","value":[15],"formattedValue":["15"]},{"time":"1462060800","formattedTime":"May 1 - May 7 2016","formattedAxisTime":"May 1, 2016","value":[12],"formattedValue":["12"]},{"time":"1462665600","formattedTime":"May 8 - May 14 2016","formattedAxisTime":"May 8, 2016","value":[11],"formattedValue":["11"]},{"time":"1463270400","formattedTime":"May 15 - May 21 2016","formattedAxisTime":"May 15, 2016","value":[16],"formattedValue":["16"]},{"time":"1463875200","formattedTime":"May 22 - May 28 2016","formattedAxisTime":"May 22, 2016","value":[11],"formattedValue":["11"]},{"time":"1464480000","formattedTime":"May 29 - Jun 4 2016","formattedAxisTime":"May 29, 2016","value":[10],"formattedValue":["10"]},{"time":"1465084800","formattedTime":"Jun 5 - Jun 11 2016","formattedAxisTime":"Jun 5, 2016","value":[20],"formattedValue":["20"]},{"time":"1465689600","formattedTime":"Jun 12 - Jun 18 2016","formattedAxisTime":"Jun 12, 2016","value":[57],"formattedValue":["57"]},{"time":"1466294400","formattedTime":"Jun 19 - Jun 25 2016","formattedAxisTime":"Jun 19, 2016","value":[35],"formattedValue":["35"]},{"time":"1466899200","formattedTime":"Jun 26 - Jul 2 2016","formattedAxisTime":"Jun 26, 2016","value":[18],"formattedValue":["18"]},{"time":"1467504000","formattedTime":"Jul 3 - Jul 9 2016","formattedAxisTime":"Jul 3, 2016","value":[15],"formattedValue":["15"]},{"time":"1468108800","formattedTime":"Jul 10 - Jul 16 2016","formattedAxisTime":"Jul 10, 2016","value":[12],"formattedValue":["12"]},{"time":"1468713600","formattedTime":"Jul 17 - Jul 23 2016","formattedAxisTime":"Jul 17, 2016","value":[11],"formattedValue":["11"]},{"time":"1469318400","formattedTime":"Jul 24 - Jul 30 2016","formattedAxisTime":"Jul 24, 2016","value":[8],"formattedValue":["8"]},{"time":"1469923200","formattedTime":"Jul 31 - Aug 6 2016","formattedAxisTime":"Jul 31, 2016","value":[7],"formattedValue":["7"]},{"time":"1470528000","formattedTime":"Aug 7 - Aug 13 2016","formattedAxisTime":"Aug 7, 2016","value":[7],"formattedValue":["7"]},{"time":"1471132800","formattedTime":"Aug 14 - Aug 20 2016","formattedAxisTime":"Aug 14, 2016","value":[6],"formattedValue":["6"]},{"time":"1471737600","formattedTime":"Aug 21 - Aug 27 2016","formattedAxisTime":"Aug 21, 2016","value":[6],"formattedValue":["6"]},{"time":"1472342400","formattedTime":"Aug 28 - Sep 3 2016","formattedAxisTime":"Aug 28, 2016","value":[7],"formattedValue":["7"]},{"time":"1472947200","formattedTime":"Sep 4 - Sep 10 2016","formattedAxisTime":"Sep 4, 2016","value":[6],"formattedValue":["6"]},{"time":"1473552000","formattedTime":"Sep 11 - Sep 17 2016","formattedAxisTime":"Sep 11, 2016","value":[6],"formattedValue":["6"]},{"time":"1474156800","formattedTime":"Sep 18 - Sep 24 2016","formattedAxisTime":"Sep 18, 2016","value":[14],"formattedValue":["14"]},{"time":"1474761600","formattedTime":"Sep 25 - Oct 1 2016","formattedAxisTime":"Sep 25, 2016","value":[8],"formattedValue":["8"]},{"time":"1475366400","formattedTime":"Oct 2 - Oct 8 2016","formattedAxisTime":"Oct 2, 2016","value":[7],"formattedValue":["7"]},{"time":"1475971200","formattedTime":"Oct 9 - Oct 15 2016","formattedAxisTime":"Oct 9, 2016","value":[6],"formattedValue":["6"]},{"time":"1476576000","formattedTime":"Oct 16 - Oct 22 2016","formattedAxisTime":"Oct 16, 2016","value":[6],"formattedValue":["6"]},{"time":"1477180800","formattedTime":"Oct 23 - Oct 29 2016","formattedAxisTime":"Oct 23, 2016","value":[5],"formattedValue":["5"]},{"time":"1477785600","formattedTime":"Oct 30 - Nov 5 2016","formattedAxisTime":"Oct 30, 2016","value":[5],"formattedValue":["5"]},{"time":"1478390400","formattedTime":"Nov 6 - Nov 12 2016","formattedAxisTime":"Nov 6, 2016","value":[6],"formattedValue":["6"]},{"time":"1478995200","formattedTime":"Nov 13 - Nov 19 2016","formattedAxisTime":"Nov 13, 2016","value":[6],"formattedValue":["6"]},{"time":"1479600000","formattedTime":"Nov 20 - Nov 26 2016","formattedAxisTime":"Nov 20, 2016","value":[6],"formattedValue":["6"]},{"time":"1480204800","formattedTime":"Nov 27 - Dec 3 2016","formattedAxisTime":"Nov 27, 2016","value":[7],"formattedValue":["7"]},{"time":"1480809600","formattedTime":"Dec 4 - Dec 10 2016","formattedAxisTime":"Dec 4, 2016","value":[7],"formattedValue":["7"]},{"time":"1481414400","formattedTime":"Dec 11 - Dec 17 2016","formattedAxisTime":"Dec 11, 2016","value":[7],"formattedValue":["7"]},{"time":"1482019200","formattedTime":"Dec 18 - Dec 24 2016","formattedAxisTime":"Dec 18, 2016","value":[9],"formattedValue":["9"]},{"time":"1482624000","formattedTime":"Dec 25 - Dec 31 2016","formattedAxisTime":"Dec 25, 2016","value":[10],"formattedValue":["10"]},{"time":"1483228800","formattedTime":"Jan 1 - Jan 7 2017","formattedAxisTime":"Jan 1, 2017","value":[14],"formattedValue":["14"]},{"time":"1483833600","formattedTime":"Jan 8 - Jan 14 2017","formattedAxisTime":"Jan 8, 2017","value":[18],"formattedValue":["18"]},{"time":"1484438400","formattedTime":"Jan 15 - Jan 21 2017","formattedAxisTime":"Jan 15, 2017","value":[17],"formattedValue":["17"]},{"time":"1485043200","formattedTime":"Jan 22 - Jan 28 2017","formattedAxisTime":"Jan 22, 2017","value":[10],"formattedValue":["10"]},{"time":"1485648000","formattedTime":"Jan 29 - Feb 4 2017","formattedAxisTime":"Jan 29, 2017","value":[14],"formattedValue":["14"]},{"time":"1486252800","formattedTime":"Feb 5 - Feb 11 2017","formattedAxisTime":"Feb 5, 2017","value":[53],"formattedValue":["53"]}],"averages":[]}}
*/

// Interest by region example data
/*
{"default":{"geoMapData":[{"geoCode":"US","geoName":"United States","value":[100],"formattedValue":["100"],"maxValueIndex":0},{"geoCode":"IE","geoName":"Ireland","value":[88],"formattedValue":["88"],"maxValueIndex":0},{"geoCode":"CA","geoName":"Canada","value":[73],"formattedValue":["73"],"maxValueIndex":0},{"geoCode":"GB","geoName":"United Kingdom","value":[66],"formattedValue":["66"],"maxValueIndex":0},{"geoCode":"AU","geoName":"Australia","value":[60],"formattedValue":["60"],"maxValueIndex":0},{"geoCode":"NO","geoName":"Norway","value":[55],"formattedValue":["55"],"maxValueIndex":0},{"geoCode":"ZA","geoName":"South Africa","value":[48],"formattedValue":["48"],"maxValueIndex":0},{"geoCode":"NZ","geoName":"New Zealand","value":[44],"formattedValue":["44"],"maxValueIndex":0},{"geoCode":"SE","geoName":"Sweden","value":[41],"formattedValue":["41"],"maxValueIndex":0},{"geoCode":"PR","geoName":"Puerto Rico","value":[40],"formattedValue":["40"],"maxValueIndex":0},{"geoCode":"DK","geoName":"Denmark","value":[33],"formattedValue":["33"],"maxValueIndex":0},{"geoCode":"KE","geoName":"Kenya","value":[32],"formattedValue":["32"],"maxValueIndex":0},{"geoCode":"NG","geoName":"Nigeria","value":[21],"formattedValue":["21"],"maxValueIndex":0},{"geoCode":"AE","geoName":"United Arab Emirates","value":[20],"formattedValue":["20"],"maxValueIndex":0},{"geoCode":"NL","geoName":"Netherlands","value":[19],"formattedValue":["19"],"maxValueIndex":0},{"geoCode":"SG","geoName":"Singapore","value":[18],"formattedValue":["18"],"maxValueIndex":0},{"geoCode":"FI","geoName":"Finland","value":[16],"formattedValue":["16"],"maxValueIndex":0},{"geoCode":"PT","geoName":"Portugal","value":[15],"formattedValue":["15"],"maxValueIndex":0},{"geoCode":"HK","geoName":"Hong Kong","value":[14],"formattedValue":["14"],"maxValueIndex":0},{"geoCode":"PH","geoName":"Philippines","value":[12],"formattedValue":["12"],"maxValueIndex":0},{"geoCode":"VE","geoName":"Venezuela","value":[11],"formattedValue":["11"],"maxValueIndex":0},{"geoCode":"BE","geoName":"Belgium","value":[11],"formattedValue":["11"],"maxValueIndex":0},{"geoCode":"HU","geoName":"Hungary","value":[11],"formattedValue":["11"],"maxValueIndex":0},{"geoCode":"IT","geoName":"Italy","value":[11],"formattedValue":["11"],"maxValueIndex":0},{"geoCode":"CH","geoName":"Switzerland","value":[11],"formattedValue":["11"],"maxValueIndex":0},{"geoCode":"MX","geoName":"Mexico","value":[10],"formattedValue":["10"],"maxValueIndex":0},{"geoCode":"IL","geoName":"Israel","value":[10],"formattedValue":["10"],"maxValueIndex":0},{"geoCode":"CL","geoName":"Chile","value":[9],"formattedValue":["9"],"maxValueIndex":0},{"geoCode":"AT","geoName":"Austria","value":[9],"formattedValue":["9"],"maxValueIndex":0},{"geoCode":"AR","geoName":"Argentina","value":[9],"formattedValue":["9"],"maxValueIndex":0},{"geoCode":"FR","geoName":"France","value":[9],"formattedValue":["9"],"maxValueIndex":0},{"geoCode":"ES","geoName":"Spain","value":[8],"formattedValue":["8"],"maxValueIndex":0},{"geoCode":"CO","geoName":"Colombia","value":[8],"formattedValue":["8"],"maxValueIndex":0},{"geoCode":"DE","geoName":"Germany","value":[7],"formattedValue":["7"],"maxValueIndex":0},{"geoCode":"MY","geoName":"Malaysia","value":[6],"formattedValue":["6"],"maxValueIndex":0},{"geoCode":"RO","geoName":"Romania","value":[6],"formattedValue":["6"],"maxValueIndex":0},{"geoCode":"PL","geoName":"Poland","value":[5],"formattedValue":["5"],"maxValueIndex":0},{"geoCode":"BR","geoName":"Brazil","value":[5],"formattedValue":["5"],"maxValueIndex":0},{"geoCode":"ID","geoName":"Indonesia","value":[3],"formattedValue":["3"],"maxValueIndex":0},{"geoCode":"IN","geoName":"India","value":[3],"formattedValue":["3"],"maxValueIndex":0},{"geoCode":"TR","geoName":"Turkey","value":[2],"formattedValue":["2"],"maxValueIndex":0}]}}
*/

// Related topics example data
/*
{"default":{"rankedList":[{"rankedKeyword":[{"topic":{"mid":"/m/016mbz","title":"O. J. Simpson","type":"American football running back"},"value":100,"formattedValue":"100","link":"/"},{"topic":{"mid":"/m/09c7w0","title":"United States","type":"Country"},"value":10,"formattedValue":"10","link":"/"},{"topic":{"mid":"/m/0b4znm","title":"O. J. Simpson murder case","type":"Court case"},"value":10,"formattedValue":"10","link":"/"},{"topic":{"mid":"/m/092x18","title":"Trial","type":"Topic"},"value":5,"formattedValue":"5","link":"/"},{"topic":{"mid":"/m/027m85","title":"Nicole Brown Simpson","type":"O. J. Simpson's ex-wife"},"value":5,"formattedValue":"5","link":"/"},{"topic":{"mid":"/m/0f2f9","title":"Television program","type":"Topic"},"value":5,"formattedValue":"5","link":"/"},{"topic":{"mid":"/m/0d1w9","title":"Prison","type":"Topic"},"value":5,"formattedValue":"5","link":"/"},{"topic":{"mid":"/m/01x48v","title":"Robert Kardashian","type":"Attorney"},"value":5,"formattedValue":"5","link":"/"},{"topic":{"mid":"/m/043p2f2","title":"Khlo\u00e9 Kardashian","type":"Television personality"},"value":5,"formattedValue":"5","link":"/"},{"topic":{"mid":"/m/04gc2","title":"Lawyer","type":"Occupation"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/029wnx","title":"Daughter","type":"Topic"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/0261x8t","title":"Kim Kardashian","type":"Television personality"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/08324h","title":"Robert Shapiro","type":"Defender"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/02nwt9","title":"Marcia Clark","type":"Prosecutor"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/06y57","title":"Sydney","type":"City"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/043rcw4","title":"Kris Jenner","type":"Television personality"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/0121_xw_","title":"American Crime Story","type":"American television series"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/051_y","title":"Murder","type":"Topic"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/024fjv","title":"Net worth","type":"Topic"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/01wz17","title":"Johnnie Cochran","type":"Lawyer"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/027_tg","title":"FX","type":"Cable television channel"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/0jtdp","title":"Documentary film","type":"Topic"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/04ctx","title":"Knife","type":"Sports Equipment"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/0174n1","title":"glove","type":"Garment"},"value":0,"formattedValue":"0","link":"/"},{"topic":{"mid":"/m/0lbxg","title":"Father","type":"Topic"},"value":0,"formattedValue":"0","link":"/"}]},{"rankedKeyword":[{"topic":{"mid":"/m/0121_xw_","title":"American Crime Story","type":"American television series"},"value":125200,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/0w33w61","title":"Budweiser Made in America Festival","type":"Music Festival"},"value":60050,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/06f8gb","title":"Sarah Paulson","type":"Actress"},"value":22700,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/010k5t0j","title":"American Crime","type":"American drama series"},"value":19650,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/027_tg","title":"FX","type":"Cable television channel"},"value":17900,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/016tbr","title":"David Schwimmer","type":"Actor"},"value":16050,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/0f1lfn","title":"Oscar Pistorius","type":"Runner"},"value":15050,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/0c424dj","title":"Bill Hodgman","type":"Politician"},"value":8450,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/0pdcx2_","title":"Murder of Travis Alexander","type":"Topic"},"value":8300,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/06x0z8","title":"Connie Britton","type":"Actress"},"value":6700,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/014v6f","title":"Cuba Gooding Jr.","type":"Actor"},"value":6100,"formattedValue":"Breakout","link":"/"},{"topic":{"mid":"/m/01z77k","title":"Miniseries","type":"Topic"},"value":4350,"formattedValue":"+4,350%","link":"/"},{"topic":{"mid":"/m/0f502","title":"John Travolta","type":"Actor"},"value":2800,"formattedValue":"+2,800%","link":"/"},{"topic":{"mid":"/m/09g8zlg","title":"Aaron Hernandez","type":"American football tight end"},"value":2450,"formattedValue":"+2,450%","link":"/"},{"topic":{"mid":"/m/0f2f9","title":"Television program","type":"Topic"},"value":1400,"formattedValue":"+1,400%","link":"/"},{"topic":{"mid":"/m/0gk4g","title":"Myocardial infarction","type":"Topic"},"value":1200,"formattedValue":"+1,200%","link":"/"},{"topic":{"mid":"/m/01mqh5","title":"Selma Blair","type":"Film actress"},"value":1200,"formattedValue":"+1,200%","link":"/"},{"topic":{"mid":"/m/010wty2t","title":"Glen Rogers","type":"Topic"},"value":1150,"formattedValue":"+1,150%","link":"/"},{"topic":{"mid":"/m/04ctx","title":"Knife","type":"Sports Equipment"},"value":1100,"formattedValue":"+1,100%","link":"/"},{"topic":{"mid":"/m/09c7w0","title":"United States","type":"Country"},"value":1000,"formattedValue":"+1,000%","link":"/"},{"topic":{"mid":"/m/024fjv","title":"Net worth","type":"Topic"},"value":700,"formattedValue":"+700%","link":"/"},{"topic":{"mid":"/m/033qlf","title":"Christopher Darden","type":"Lawyer"},"value":600,"formattedValue":"+600%","link":"/"},{"topic":{"mid":"/m/0jtdp","title":"Documentary film","type":"Topic"},"value":500,"formattedValue":"+500%","link":"/"},{"topic":{"mid":"/m/07kfbc5","title":"30 for 30","type":"TV series"},"value":500,"formattedValue":"+500%","link":"/"},{"topic":{"mid":"/m/08324h","title":"Robert Shapiro","type":"Defender"},"value":450,"formattedValue":"+450%","link":"/"}]}]}}
*/

// Related queries example data
/*
{"default":{"rankedList":[{"rankedKeyword":[{"query":"people vs oj simpson","value":100,"formattedValue":"100","link":"/"},{"query":"people vs oj","value":100,"formattedValue":"100","link":"/"},{"query":"oj trial","value":95,"formattedValue":"95","link":"/"},{"query":"oj simpson trial","value":95,"formattedValue":"95","link":"/"},{"query":"kardashian","value":90,"formattedValue":"90","link":"/"},{"query":"kardashian oj simpson","value":90,"formattedValue":"90","link":"/"},{"query":"the people vs oj simpson","value":75,"formattedValue":"75","link":"/"},{"query":"the people vs oj","value":75,"formattedValue":"75","link":"/"},{"query":"nicole simpson","value":70,"formattedValue":"70","link":"/"},{"query":"oj simpson case","value":65,"formattedValue":"65","link":"/"},{"query":"oj simpson movie","value":50,"formattedValue":"50","link":"/"},{"query":"oj simpson kids","value":45,"formattedValue":"45","link":"/"},{"query":"nicole brown simpson","value":40,"formattedValue":"40","link":"/"},{"query":"nicole brown","value":40,"formattedValue":"40","link":"/"},{"query":"oj simpson show","value":40,"formattedValue":"40","link":"/"},{"query":"robert kardashian","value":35,"formattedValue":"35","link":"/"},{"query":"oj simpson khloe","value":35,"formattedValue":"35","link":"/"},{"query":"robert kardashian oj simpson","value":35,"formattedValue":"35","link":"/"},{"query":"oj simpson jail","value":35,"formattedValue":"35","link":"/"},{"query":"oj simpson cast","value":30,"formattedValue":"30","link":"/"},{"query":"khloe kardashian oj simpson","value":30,"formattedValue":"30","link":"/"},{"query":"khloe kardashian","value":30,"formattedValue":"30","link":"/"},{"query":"oj simpson story","value":30,"formattedValue":"30","link":"/"},{"query":"oj simpson daughter","value":25,"formattedValue":"25","link":"/"},{"query":"oj simpson murder","value":25,"formattedValue":"25","link":"/"}]},{"rankedKeyword":[{"query":"oj simpson american crime story","value":129000,"formattedValue":"Breakout","link":"/"},{"query":"american crime story","value":126500,"formattedValue":"Breakout","link":"/"},{"query":"the people vs oj simpson cast","value":120500,"formattedValue":"Breakout","link":"/"},{"query":"people vs oj simpson movie","value":107850,"formattedValue":"Breakout","link":"/"},{"query":"people vs oj simpson series","value":60700,"formattedValue":"Breakout","link":"/"},{"query":"the people vs oj simpson movie","value":60550,"formattedValue":"Breakout","link":"/"},{"query":"oj made in america","value":60250,"formattedValue":"Breakout","link":"/"},{"query":"oj simpson made in america","value":59300,"formattedValue":"Breakout","link":"/"},{"query":"the people vs oj simpson","value":56650,"formattedValue":"Breakout","link":"/"},{"query":"watch the people vs oj simpson","value":56300,"formattedValue":"Breakout","link":"/"},{"query":"the people vs oj","value":54600,"formattedValue":"Breakout","link":"/"},{"query":"people vs oj simpson show","value":48450,"formattedValue":"Breakout","link":"/"},{"query":"people vs oj","value":31150,"formattedValue":"Breakout","link":"/"},{"query":"people vs oj simpson","value":30250,"formattedValue":"Breakout","link":"/"},{"query":"people vs oj simpson tv show","value":28700,"formattedValue":"Breakout","link":"/"},{"query":"the people vs oj simpson episode 1","value":27650,"formattedValue":"Breakout","link":"/"},{"query":"the people vs oj simpson tv series","value":26750,"formattedValue":"Breakout","link":"/"},{"query":"oj simpson 2016","value":24600,"formattedValue":"Breakout","link":"/"},{"query":"sarah paulson","value":22100,"formattedValue":"Breakout","link":"/"},{"query":"american crime","value":16200,"formattedValue":"Breakout","link":"/"},{"query":"david schwimmer","value":15150,"formattedValue":"Breakout","link":"/"},{"query":"oscar pistorius","value":12250,"formattedValue":"Breakout","link":"/"},{"query":"aaron hernandez","value":11850,"formattedValue":"Breakout","link":"/"},{"query":"where is oj simpson today in 2016","value":11650,"formattedValue":"Breakout","link":"/"},{"query":"the people versus oj simpson","value":11250,"formattedValue":"Breakout","link":"/"}]}]}}
*/