#https://unix.stackexchange.com/questions/60590/is-there-a-command-line-utility-to-transpose-a-csv-file

import csv, sys

#constants
DEBUG = True
INPUT_FILE_NAME_TRAIN = "ALL_AML_train.csv.normalized"
OUTPUT_FILE_NAME_TRAIN = "ALL_AML_gcol_train.tmp"
INPUT_FILE_NAME_TEST = "ALL_AML_test.csv.normalized"
OUTPUT_FILE_NAME_TEST = "ALL_AML_gcol_test.tmp"

def transposeRows(input_file_name, output_file_name):
	with open(input_file_name) as file:
		out_file = open(output_file_name, "w")
		rows = list(csv.reader(file))
		writer = csv.writer(out_file)
		for col in range(0, len(rows[0])):
			writer.writerow([row[col] for row in rows])
			
transposeRows(INPUT_FILE_NAME_TRAIN, OUTPUT_FILE_NAME_TRAIN)
transposeRows(INPUT_FILE_NAME_TEST, OUTPUT_FILE_NAME_TEST)