const { needs, relaunch } = require('frogfs');

let installed = false;
installed |= needs('html-minifier');
if (installed) {
	relaunch();
}

const { exit, stdin, stdout } = require('process');
const html_minifier = require('html-minifier');

const options = {
	includeAutoGeneratedTags: true,
	removeAttributeQuotes: true,
	removeComments: true,
	removeRedundantAttributes: true,
	removeScriptTypeAttributes: true,
	removeStyleLinkTypeAttributes: true,
	sortClassName: true,
	useShortDoctype: true,
	collapseWhitespace: true
};

var input = '';
stdin.setEncoding('utf-8');
stdin.on('data', (data) => {
	input = input.concat(data.toString());
});
stdin.on('close', () => {
	let output = html_minifier.minify(input, options);
	stdout.write(output);
	exit(0);
});
