export const icons = {
    alert: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMy4yIiB5PSIxNC4yIiB3aWR0aD0iNDIuNiIgaGVpZ2h0PSIyMC42IiByeD0iNC44IiBmaWxsPSIjZmZmIiBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMS42Ii8+PGNpcmNsZSBjeD0iMTIiIGN5PSIyNCIgcj0iNiIgZmlsbD0iI0ZCRURDOCIvPjxjaXJjbGUgY3g9IjEyIiBjeT0iMjgiIHI9IjEiIGZpbGw9IiNDMDg4MTEiLz48cGF0aCBkPSJNMTIgMjB2NiIgc3Ryb2tlPSIjQzA4ODExIiBzdHJva2Utd2lkdGg9IjIiLz48cGF0aCBzdHJva2U9IiM4RThFOEUiIHN0cm9rZS13aWR0aD0iMiIgZD0iTTIyIDIyaDExIi8+PHBhdGggc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjIiIGQ9Ik0yMiAyN2gxOSIvPjwvc3ZnPgo=',
    button: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iNi41IiB5PSIxNS41IiB3aWR0aD0iMzYiIGhlaWdodD0iMTciIHJ4PSIzLjUiIGZpbGw9IiM0QUExRUQiIHN0cm9rZT0iIzRBQTFFRCIvPjxwYXRoIGQ9Im0xMi42ODQgMjcgLjQzMi0xLjMyN2gyLjFMMTUuNjQ3IDI3aDEuMzE5bC0yLjAwNi01LjgxOGgtMS41ODVMMTEuMzY2IDI3aDEuMzE4Wm0uNzQ1LTIuMjg3LjcxNi0yLjIwMmguMDQ1bC43MTYgMi4yMDJoLTEuNDc3Wm01Ljk4MyAyLjM3MmMxLjE2MiAwIDEuODkyLS42ODIgMS45NDgtMS42ODRoLTEuMTQyYy0uMDcuNDY1LS4zNzcuNzI3LS43OTIuNzI3LS41NjYgMC0uOTMyLS40NzUtLjkzMi0xLjMxIDAtLjgyNC4zNy0xLjI5NS45MzItMS4yOTUuNDQzIDAgLjcyNy4yOTIuNzkyLjcyN2gxLjE0MmMtLjA1LTEuMDA5LS44MTUtMS42Ny0xLjk1NC0xLjY3LTEuMzI0IDAtMi4xNDIuOTE3LTIuMTQyIDIuMjU1IDAgMS4zMjcuODA0IDIuMjUgMi4xNDggMi4yNVptNS4wNDQtNC40NDloLS44MnYtMS4wNDVoLTEuMjF2MS4wNDVoLS41OTh2LjkxaC41OTd2Mi4yNzJjLS4wMDYuODU1LjU3NyAxLjI3OSAxLjQ1NSAxLjI0Mi4zMTItLjAxMi41MzQtLjA3NC42NTYtLjExNGwtLjE5LS45Yy0uMDYuMDEtLjE4OC4wNC0uMzAyLjA0LS4yNDEgMC0uNDA5LS4wOTItLjQwOS0uNDI3di0yLjExM2guODIxdi0uOTFaTTI1LjI0NSAyN2gxLjIxdi00LjM2NGgtMS4yMVYyN1ptLjYwOC00LjkyNmMuMzYgMCAuNjU2LS4yNzYuNjU2LS42MTQgMC0uMzM1LS4yOTYtLjYxLS42NTYtLjYxLS4zNTggMC0uNjU0LjI3NS0uNjU0LjYxIDAgLjMzOC4yOTYuNjE0LjY1NC42MTRabTMuNTQzIDUuMDExYzEuMzI0IDAgMi4xNDgtLjkwNiAyLjE0OC0yLjI1IDAtMS4zNTItLjgyNC0yLjI1Ni0yLjE0OC0yLjI1Ni0xLjMyNCAwLTIuMTQ4LjkwNC0yLjE0OCAyLjI1NiAwIDEuMzQ0LjgyNCAyLjI1IDIuMTQ4IDIuMjVabS4wMDYtLjkzN2MtLjYxMSAwLS45MjQtLjU2LS45MjQtMS4zMjEgMC0uNzYyLjMxMy0xLjMyNC45MjQtMS4zMjQuNiAwIC45MTIuNTYyLjkxMiAxLjMyNCAwIC43NjEtLjMxMyAxLjMyLS45MTIgMS4zMlptNC4xMzktMS42N2MuMDAzLS41NjMuMzM4LS44OTMuODI3LS44OTMuNDg1IDAgLjc3OC4zMTguNzc1Ljg1MlYyN2gxLjIxdi0yLjc3OGMwLTEuMDE4LS41OTYtMS42NDMtMS41MDUtMS42NDMtLjY0OCAwLTEuMTE3LjMxOS0xLjMxMy44MjdoLS4wNTF2LS43N2gtMS4xNTNWMjdoMS4yMXYtMi41MjNaIiBmaWxsPSIjZmZmIi8+PC9zdmc+Cg==',
    batch: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMy4yIiB5PSIzLjIiIHdpZHRoPSI0MS42IiBoZWlnaHQ9IjQxLjYiIHJ4PSI0LjgiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBkPSJNOCAxMHY1YTIgMiAwIDAgMCAyIDJoMjhhMiAyIDAgMCAwIDItMnYtNWEyIDIgMCAwIDAtMi0ySDEwYTIgMiAwIDAgMC0yIDJaTTggMjJ2NWEyIDIgMCAwIDAgMiAyaDI4YTIgMiAwIDAgMCAyLTJ2LTVhMiAyIDAgMCAwLTItMkgxMGEyIDIgMCAwIDAtMiAyWk04IDM0djVhMiAyIDAgMCAwIDIgMmgyOGEyIDIgMCAwIDAgMi0ydi01YTIgMiAwIDAgMC0yLTJIMTBhMiAyIDAgMCAwLTIgMloiIGZpbGw9IiNFRUUiLz48L3N2Zz4K',
    cascader: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGcgY2xpcC1wYXRoPSJ1cmwoI2EpIj48cmVjdCB4PSIuMiIgeT0iMy4yIiB3aWR0aD0iNDcuNiIgaGVpZ2h0PSIxNC42IiByeD0iMy44IiBmaWxsPSIjRkNGQ0ZDIiBzdHJva2U9IiNERURFREUiIHN0cm9rZS13aWR0aD0iMS42Ii8+PHJlY3QgeD0iNCIgeT0iMTUiIHdpZHRoPSI0MyIgaGVpZ2h0PSIyOSIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0RFREVERSIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBzdHJva2U9IiM3NTc1NzUiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBkPSJNNyAxMWgyTTIwIDExaDkiLz48cGF0aCBzdHJva2U9IiNCRUJFQkUiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0xNyA5LjEzMSAxMy4xMzEgMTMiLz48cGF0aCBkPSJNMjQgMzRoMjJ2N2EyIDIgMCAwIDEtMiAySDI0di05WiIgZmlsbD0iI0VDRjVGRCIvPjxwYXRoIHN0cm9rZT0iIzc1NzU3NSIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0xNyAyMGgxOU0yNiAyOWgxNU0yOCAzOWg4Ii8+PHBhdGggZD0ibTE2IDI4IDIuNSAyIDIuNS0yTTggMTlsMi41IDIgMi41LTJNMzcgMTBsMi41IDIgMi41LTIiIHN0cm9rZT0iI0JFQkVCRSIgc3Ryb2tlLXdpZHRoPSIxLjYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjxwYXRoIGQ9Im00MCAzOS4zNjEgMS4zNjEgMS4xMzRMNDMuNjMgMzgiIHN0cm9rZT0iIzNDOTJEQyIgc3Ryb2tlLXdpZHRoPSIxLjQiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjwvZz48ZGVmcz48Y2xpcFBhdGggaWQ9ImEiPjxwYXRoIGZpbGw9IiNmZmYiIGQ9Ik0wIDBoNDh2NDhIMHoiLz48L2NsaXBQYXRoPjwvZGVmcz48L3N2Zz4K',
    checkbox: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0ibTguMTY2IDEzLjc5MSAxLjc1IDEuNDU4IDIuOTE3LTMuMjA4TTguMTY2IDM0LjQ1OGwxLjc1IDEuNDU4IDIuOTE3LTMuMjA4IiBzdHJva2U9IiNGNUY1RjUiIHN0cm9rZS13aWR0aD0iMS4yIi8+PHJlY3QgeD0iOS41IiB5PSI2LjUiIHdpZHRoPSI5IiBoZWlnaHQ9IjkiIHJ4PSIyLjUiIGZpbGw9IiMzQzkyREMiIHN0cm9rZT0iIzNDOTJEQyIvPjxyZWN0IHg9IjkuNSIgeT0iMzIuNSIgd2lkdGg9IjkiIGhlaWdodD0iOSIgcng9IjIuNSIgZmlsbD0iIzNDOTJEQyIgc3Ryb2tlPSIjM0M5MkRDIi8+PHBhdGggZD0ibTEyIDExLjM2MSAxLjM2MSAxLjEzNEwxNS42MyAxME0xMiAzNy4zNjFsMS4zNjEgMS4xMzRMMTUuNjMgMzYiIHN0cm9rZT0iI2ZmZiIgc3Ryb2tlLXdpZHRoPSIxLjQiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjxwYXRoIHN0cm9rZT0iI0RFREVERSIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0yMyAxMC42NjZoMTRNMjMgMzYuNjY2aDE0Ii8+PHJlY3QgeD0iOS41IiB5PSIxOS41IiB3aWR0aD0iOSIgaGVpZ2h0PSI5IiByeD0iMi41IiBmaWxsPSIjZmZmIiBzdHJva2U9IiNERURFREUiLz48cGF0aCBzdHJva2U9IiNERURFREUiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBkPSJNMjMgMjMuMzM0aDExIi8+PC9zdmc+Cg==',
    controller: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMy4yIiB5PSI3LjIiIHdpZHRoPSI0MS42IiBoZWlnaHQ9IjMzLjYiIHJ4PSI0LjgiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMS42IiBkPSJNNCAxNi4yaDQwIi8+PHJlY3QgeD0iNyIgeT0iMTkiIHdpZHRoPSIzNCIgaGVpZ2h0PSIxOCIgcng9IjIiIGZpbGw9IiNFRUUiLz48L3N2Zz4K',
    date: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTE1LjQgMjIuNUg2LjZ2NC43MzdjMCAuMjI4LjE4NS40MTMuNDE0LjQxM2g3Ljk3MmEuNDE0LjQxNCAwIDAgMCAuNDE0LS40MTNWMjIuNVptLTguMzg3LTMuNzVoNy45NzRjMS4xMTIgMCAyLjAxMy45MDEgMi4wMTMgMi4wMTN2Ni40NzRhMi4wMTQgMi4wMTQgMCAwIDEtMi4wMTQgMi4wMTNINy4wMTRBMi4wMTQgMi4wMTQgMCAwIDEgNSAyNy4yMzd2LTYuNDc0YzAtMS4xMTIuOTAxLTIuMDEzIDIuMDEzLTIuMDEzWm0yLjM1MyA1LjM3NWEuODc1Ljg3NSAwIDEgMS0xLjc1IDAgLjg3NS44NzUgMCAwIDEgMS43NSAwWk04LjQ5IDI3LjI1YS44NzUuODc1IDAgMSAwIDAtMS43NS44NzUuODc1IDAgMCAwIDAgMS43NVptMy4zODQtMy4xMjVhLjg3NS44NzUgMCAxIDEtMS43NSAwIC44NzUuODc1IDAgMCAxIDEuNzUgMFpNMTEgMjcuMjVhLjg3NS44NzUgMCAxIDAgMC0xLjc1Ljg3NS44NzUgMCAwIDAgMCAxLjc1Wm0zLjU1LTMuMTI1YS44NzUuODc1IDAgMSAxLTEuNzUgMCAuODc1Ljg3NSAwIDAgMSAxLjc1IDBaIiBmaWxsPSIjQjJCMkIyIi8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTIxIDI0aDEyIi8+PHBhdGggZD0iTTM4IDIwaDEuNW0xLjUgMGgtMS41bTAgMHY4bTAgMEgzOG0xLjUgMEg0MSIgc3Ryb2tlPSIjOTQ5NDk0IiBzdHJva2Utd2lkdGg9IjEuNiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PC9zdmc+Cg==',
    daterange: 'data:image/svg+xml;base64,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',
    datePicker: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTExLjQzNSAyMi41SDYuNnY0LjczN2MwIC4yMjguMTg1LjQxNC40MTQuNDE0aDIuMTM0Yy4xNTYuNTg5LjQyOCAxLjEzLjc5IDEuNkg3LjAxNEEyLjAxNCAyLjAxNCAwIDAgMSA1IDI3LjIzNnYtNi40NzNjMC0xLjExMi45MDEtMi4wMTQgMi4wMTMtMi4wMTRoNy45NzRjMS4xMTIgMCAyLjAxMy45MDIgMi4wMTMgMi4wMTRWMjMuNjcyQTQuNDkxIDQuNDkxIDAgMCAwIDEzLjUgMjJjLS43NDQgMC0xLjQ0Ni4xODEtMi4wNjUuNVpNOCAyNC43NWEuNzUuNzUgMCAxIDAgMC0xLjUuNzUuNzUgMCAwIDAgMCAxLjVabS43NSAxLjVhLjc1Ljc1IDAgMSAxLTEuNSAwIC43NS43NSAwIDAgMSAxLjUgMFoiIGZpbGw9IiNCMkIyQjIiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTE1LjY4NCAyOC42NWEzLjE1IDMuMTUgMCAwIDAgMC00LjQ3MyAzLjE5NyAzLjE5NyAwIDAgMC00LjUwMiAwIDMuMTUgMy4xNSAwIDAgMCAwIDQuNDc0IDMuMTk3IDMuMTk3IDAgMCAwIDQuNTAyIDBabS0xLjg3NS0zLjU1M2EuNTIyLjUyMiAwIDEgMC0xLjA0NCAwdjEuNWMwIC4yNDUuMTcuNDU4LjQxLjUxbDEuNjM2LjM1NmEuNTIyLjUyMiAwIDEgMCAuMjIzLTEuMDJsLTEuMjI2LS4yNjd2LTEuMDhaIiBmaWxsPSIjQjJCMkIyIi8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTIxIDI0aDEyIi8+PHBhdGggZD0iTTM4IDIwaDEuNW0xLjUgMGgtMS41bTAgMHY4bTAgMEgzOG0xLjUgMEg0MSIgc3Ryb2tlPSIjOTQ5NDk0IiBzdHJva2Utd2lkdGg9IjEuNiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PC9zdmc+Cg==',
    divider: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTcgNnY4YTQgNCAwIDAgMCA0IDRoMjZhNCA0IDAgMCAwIDQtNFY2TTQxIDQydi04YTQgNCAwIDAgMC00LTRIMTFhNCA0IDAgMCAwLTQgNHY4IiBzdHJva2U9IiNCRUJFQkUiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1kYXNoYXJyYXk9IjEgNCIvPjxwYXRoIGQ9Ik00MSAyNC44YS44LjggMCAwIDAgMC0xLjZ2MS42Wk03IDIzLjJhLjguOCAwIDAgMCAwIDEuNnYtMS42Wm0zNCAwSDd2MS42aDM0di0xLjZaIiBmaWxsPSIjOEU4RThFIi8+PC9zdmc+Cg==',
    grid: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTQwIDM5SDdWMTZhMSAxIDAgMCAxIDEtMWgzMWExIDEgMCAwIDEgMSAxdjIzWiIgZmlsbD0iI2ZmZiIvPjxwYXRoIGQ9Ik0yMyAzOFYxME03IDI3aDMzLjI1TTcgMjFoMzMuMjVNNyAzM2gzMy4yNSIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIGQ9Ik00MCAxNUg3di01YTEgMSAwIDAgMSAxLTFoMzFhMSAxIDAgMCAxIDEgMXY1WiIgZmlsbD0iI0VFRSIvPjxwYXRoIGQ9Ik02Ljg3NSAxNWgzMy4yNSIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIvPjxyZWN0IHg9IjYuOCIgeT0iOS44IiB3aWR0aD0iMzMuNCIgaGVpZ2h0PSIyOC40IiByeD0iMi4yIiBzdHJva2U9IiM3NTc1NzUiIHN0cm9rZS13aWR0aD0iMS42Ii8+PC9zdmc+Cg==',
    html: 'data:image/svg+xml;base64,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',
    link: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48ZyBjbGlwLXBhdGg9InVybCgjYSkiIHN0cm9rZT0iI0IyQjJCMiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCI+PHBhdGggZD0ibTEyIDIxLjcwMy0yLjAyNC0yLjA4OGEyLjMyMSAyLjMyMSAwIDAgMC0zLjIyMi0uMDkxbC0uMDk5LjA5MWEyLjE4MSAyLjE4MSAwIDAgMC0uMDkgMy4xNGwyLjAyNSAyLjA4N00xMC4yMTcgMjYuNTIxbDEuNzYgMS44MTVhMi4zOSAyLjM5IDAgMCAwIDMuMzE4LjA5NHYwYTIuMjQ2IDIuMjQ2IDAgMCAwIC4wOTItMy4yMzNsLTEuNzYtMS44MTVNMTIuNSAyNS41bC0zLTMiLz48L2c+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTIxIDI0aDEyIi8+PHBhdGggZD0iTTM4IDIwaDEuNW0xLjUgMGgtMS41bTAgMHY4bTAgMEgzOG0xLjUgMEg0MSIgc3Ryb2tlPSIjOTQ5NDk0IiBzdHJva2Utd2lkdGg9IjEuNiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PGRlZnM+PGNsaXBQYXRoIGlkPSJhIj48cGF0aCBmaWxsPSIjZmZmIiB0cmFuc2Zvcm09InRyYW5zbGF0ZSg1IDE4KSIgZD0iTTAgMGgxMnYxMkgweiIvPjwvY2xpcFBhdGg+PC9kZWZzPjwvc3ZnPgo=',
    input: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBkPSJNMjEgMjRoMTIiLz48cGF0aCBkPSJNMzggMjBoMS41bTEuNSAwaC0xLjVtMCAwdjhtMCAwSDM4bTEuNSAwSDQxIiBzdHJva2U9IiM5NDk0OTQiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz48cGF0aCBkPSJNNy4yNSAyMi4wNzRWMjAuOThhLjczLjczIDAgMCAxIC43My0uNzNIMTFtMy43NSAxLjgyNFYyMC45OGEuNzMuNzMgMCAwIDAtLjczLS43M0gxMW0wIDB2Ny41bTAgMEg5LjExbTEuODkgMGgyLjA1MSIgc3Ryb2tlPSIjQjJCMkIyIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PC9zdmc+Cg==',
    number: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0RFREVERSIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBkPSJNNC41IDI2LjA2aDguNTU1TTExLjYyOSAxOS41bC0xLjQyNiA4LjU1NU04LjA2NCAxOS41bC0xLjQyNiA4LjU1NU01LjIxMyAyMi4wNjdIMTMuNSIgc3Ryb2tlPSIjQjJCMkIyIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTIxIDI0aDEyIi8+PHBhdGggZD0iTTM4IDIwaDEuNW0xLjUgMGgtMS41bTAgMHY4bTAgMEgzOG0xLjUgMEg0MSIgc3Ryb2tlPSIjOTQ5NDk0IiBzdHJva2Utd2lkdGg9IjEuNiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PC9zdmc+Cg==',
    radio: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTIwIDM1aDE5TTIwIDI0aDIxTTIwIDEzaDEzIi8+PHJlY3QgeD0iNyIgeT0iMzEiIHdpZHRoPSI4IiBoZWlnaHQ9IjgiIHJ4PSI0IiBmaWxsPSIjZmZmIiBzdHJva2U9IiNERURFREUiIHN0cm9rZS13aWR0aD0iMS4yIi8+PHJlY3QgeD0iNyIgeT0iMjAiIHdpZHRoPSI4IiBoZWlnaHQ9IjgiIHJ4PSI0IiBmaWxsPSIjM0M5MkRDIiBzdHJva2U9IiMzQzkyREMiLz48cmVjdCB4PSI3IiB5PSI5IiB3aWR0aD0iOCIgaGVpZ2h0PSI4IiByeD0iNCIgZmlsbD0iI2ZmZiIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuMiIvPjxyZWN0IHg9IjEwIiB5PSIyMyIgd2lkdGg9IjIiIGhlaWdodD0iMiIgcng9IjEiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI2ZmZiIvPjwvc3ZnPgo=',
    rate: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTcuODU0IDE3LjljLjIxLS42MTcgMS4wODItLjYxNyAxLjI5MiAwbDEuMTI0IDMuMzA5aDMuNTUzYy42NjggMCAuOTM4Ljg2LjM4OSAxLjI0MmwtMi44NDcgMS45NzcgMS4xMDQgMy4yNDhjLjIxMi42MjItLjQ5NCAxLjE1NC0xLjAzNS43OEw4LjUgMjYuNDE2bC0yLjkzNCAyLjAzOGMtLjU0LjM3NS0xLjI0Ni0uMTU3LTEuMDM1LS43OGwxLjEwNC0zLjI0Ny0yLjg0Ny0xLjk3N2MtLjU0OC0uMzgxLS4yNzktMS4yNDIuMzktMS4yNDJoMy41NTFsMS4xMjUtMy4zMXoiIGZpbGw9IiNFQ0JCNDAiLz48cGF0aCBkPSJNMjQuMjE4IDE3LjljLjIxLS42MTcgMS4wODItLjYxNyAxLjI5MSAwbDEuMTI1IDMuMzA5aDMuNTUzYy42NjggMCAuOTM3Ljg2LjM4OSAxLjI0MmwtMi44NDggMS45NzcgMS4xMDQgMy4yNDhjLjIxMi42MjItLjQ5NCAxLjE1NC0xLjAzNC43OGwtMi45MzQtMi4wMzktMi45MzUgMi4wMzhjLS41NC4zNzUtMS4yNDYtLjE1Ny0xLjAzNC0uNzhsMS4xMDQtMy4yNDctMi44NDctMS45NzdjLS41NDktLjM4MS0uMjgtMS4yNDIuMzg5LTEuMjQyaDMuNTUybDEuMTI1LTMuMzF6IiBmaWxsPSIjRDhEOEQ4Ii8+PHBhdGggZD0iTTM5LjIxNSAxNy45OTZjLjIwNC0uNjI4IDEuMDkzLS42MjggMS4yOTcgMGwuODgyIDIuNzE1YS42ODIuNjgyIDAgMCAwIC42NDkuNDcxaDIuODU1Yy42NiAwIC45MzUuODQ2LjQgMS4yMzRsLTIuMzEgMS42NzhhLjY4Mi42ODIgMCAwIDAtLjI0Ny43NjJsLjg4MyAyLjcxNmMuMjA0LjYyOC0uNTE1IDEuMTUtMS4wNS43NjJsLTIuMzEtMS42NzhhLjY4Mi42ODIgMCAwIDAtLjgwMSAwbC0yLjMxIDEuNjc4Yy0uNTM0LjM4OC0xLjI1My0uMTM0LTEuMDUtLjc2MmwuODgzLTIuNzE2YS42ODIuNjgyIDAgMCAwLS4yNDgtLjc2MmwtMi4zMS0xLjY3OGMtLjUzNC0uMzg4LS4yNi0xLjIzNC40MDEtMS4yMzRoMi44NTVjLjI5NiAwIC41NTgtLjE5LjY0OS0uNDdsLjg4Mi0yLjcxNnoiIGZpbGw9IiNERURFREUiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTI1IDE3LjQ1MWMtLjM0Ni0uMjE2LS44NjYtLjA5NC0xLjAxNS4zNjhsLTEuMDM2IDMuMTg2SDE5LjZjLS42NjEgMC0uOTM2Ljg0Ni0uNDAxIDEuMjM0bDIuNzEgMS45Ny0xLjAzNSAzLjE4NmMtLjIwNC42MjguNTE1IDEuMTUgMS4wNS43NjJsMi43MS0xLjk3LjM2Ny4yNjd2LTkuMDAzeiIgZmlsbD0iI0VDQkI0MCIvPjwvc3ZnPgo=',
    select: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iNCIgd2lkdGg9IjQ2IiBoZWlnaHQ9IjEzIiByeD0iMyIgZmlsbD0iI0ZDRkNGQyIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIHN0cm9rZT0iIzc1NzU3NSIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik03IDExaDE3Ii8+PHJlY3QgeD0iNCIgeT0iMTUiIHdpZHRoPSI0MyIgaGVpZ2h0PSIyOSIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0RFREVERSIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBmaWxsPSIjRUNGNUZEIiBkPSJNNSAyNmg0MXY4SDV6Ii8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTEwIDIxaDEzIi8+PHBhdGggc3Ryb2tlPSIjNzU3NTc1IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTEwIDMwaDI1Ii8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTEwIDM5aDE3Ii8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIgZD0iTTQgMjUuMmg0M000IDM0LjJoNDMiLz48cGF0aCBkPSJtMzggMTAgMi41IDIgMi41LTIiIHN0cm9rZT0iI0JFQkVCRSIgc3Ryb2tlLXdpZHRoPSIxLjYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjxwYXRoIGQ9Im0zOSAzMC4zNjEgMS4zNjEgMS4xMzRMNDIuNjMgMjkiIHN0cm9rZT0iIzNDOTJEQyIgc3Ryb2tlLXdpZHRoPSIxLjQiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjwvc3ZnPgo=',
    slider: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMTAiIHk9IjIyIiB3aWR0aD0iMzQiIGhlaWdodD0iMyIgcng9IjEuNSIgZmlsbD0iI0Q4RDhEOCIvPjxyZWN0IHg9IjUiIHk9IjIyIiB3aWR0aD0iMjkiIGhlaWdodD0iMyIgcng9IjEuNSIgZmlsbD0iIzRBQTFFRCIvPjxjaXJjbGUgY3g9IjMxLjM5OSIgY3k9IjIzLjM5OSIgcj0iMy44OTkiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI0JFQkVCRSIvPjwvc3ZnPgo=',
    switch: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iNy41IiB5PSIyMS41IiB3aWR0aD0iMTMiIGhlaWdodD0iNyIgcng9IjMuNSIgZmlsbD0iIzNDOTJEQyIgc3Ryb2tlPSIjM0M5MkRDIi8+PHJlY3QgeD0iMTUiIHk9IjIzIiB3aWR0aD0iNCIgaGVpZ2h0PSI0IiByeD0iMiIgZmlsbD0iI2ZmZiIvPjxwYXRoIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0yNSAyNWgxNiIvPjwvc3ZnPgo=',
    table: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTQzIDM4SDVWMTdhMSAxIDAgMCAxIDEtMWgzNmExIDEgMCAwIDEgMSAxdjIxWiIgZmlsbD0iI2ZmZiIvPjxwYXRoIGQ9Ik01IDM1aDM4djFhMiAyIDAgMCAxLTIgMkg3YTIgMiAwIDAgMS0yLTJ2LTFaIiBmaWxsPSIjREVERURFIi8+PHBhdGggZD0iTTEyIDM4VjExTTI4IDM4VjExTTUgMjJoMzhNNSAyOWgzOE0yMCAzOFYxMU0zNiAzOFYxMSIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIGQ9Ik00MyAxNkg1di01YTEgMSAwIDAgMSAxLTFoMzZhMSAxIDAgMCAxIDEgMXY1WiIgZmlsbD0iI0RFREVERSIvPjxyZWN0IHg9IjQuOCIgeT0iMTAuOCIgd2lkdGg9IjM4LjQiIGhlaWdodD0iMjcuNCIgcng9IjIuMiIgc3Ryb2tlPSIjNzU3NTc1IiBzdHJva2Utd2lkdGg9IjEuNiIvPjwvc3ZnPgo=',
    //tableGrid: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTQzIDM4SDVWMTdhMSAxIDAgMCAxIDEtMWgzNmExIDEgMCAwIDEgMSAxdjIxWiIgZmlsbD0iI2ZmZiIvPjxwYXRoIGQ9Ik01IDM1aDM4djFhMiAyIDAgMCAxLTIgMkg3YTIgMiAwIDAgMS0yLTJ2LTFaIiBmaWxsPSIjREVERURFIi8+PHBhdGggZD0iTTEyIDM4VjExTTI4IDM4VjExTTUgMjJoMzhNNSAyOWgzOE0yMCAzOFYxMU0zNiAzOFYxMSIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIGQ9Ik00MyAxNkg1di01YTEgMSAwIDAgMSAxLTFoMzZhMSAxIDAgMCAxIDEgMXY1WiIgZmlsbD0iI0RFREVERSIvPjxyZWN0IHg9IjQuOCIgeT0iMTAuOCIgd2lkdGg9IjM4LjQiIGhlaWdodD0iMjcuNCIgcng9IjIuMiIgc3Ryb2tlPSIjNzU3NTc1IiBzdHJva2Utd2lkdGg9IjEuNiIvPjwvc3ZnPgo=',
    tableGrid: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAAXNSR0IArs4c6QAAAdZJREFUeF7tW+1NAzEMdScBJgFPAp0EOgllEpdJKJOAnsqh9s5pPsShfLxI9+uiyH6x42fH2cjgYzO4/kIAaAGDI0AXiBmAmT2JyG1sXqX/DyJyVNVjSL6gBZjZi4g8V6pYrlhbETl4QLgAdKb8BNZOVbGpF2MBgJk9iIjlQtzI/K2q7s9l9QCA8gChx7FXVbjD7/AA+OpR80knVb3QORUA1388oH6ixqvzT1UVp3J0XHHDnDXcQ5wA0ALoAjwDSqIAD0GPRTEKOAgwDJ6yx+54APjzW5TBnCY8ighAmA9Q0GBaOpsMKu5lojlruHKUEqFE3eufRgAKmWD9W5soIS2AFlCWC+REgdAJvkNdLtFSUYT1QmnOGn8aBUiFSYWdiipzAeYCSwSYDHWaDDEKMAoMHgUSCVz905gMMRkqS4bqt+1ECekChS6ANPY9EeSbQFEUKfXnP65x7/U5lFoAiRCJ0OBEiC5AF6ALLJsMWRJjSazPkthHw93hMaKJzvG7WI8QbmS8+/3Y4i38R8e4xgDoqU1+vimLTtOR2uUXuw90Yg8mcMHY6muR890PMtmrb4bMDMrja7V9Hj1J7kuRCR0+mmrh6F5TRlrAmui2sDYtoIVdWlPGb2X9hV8f9TMcAAAAAElFTkSuQmCC',
    text: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTEwIDExSDZhMiAyIDAgMCAwLTIgMnY0TTM4IDM4aDRhMiAyIDAgMCAwIDItMnYtNE00NCAxN3YtNGEyIDIgMCAwIDAtMi0yaC00TTQgMzJ2NGEyIDIgMCAwIDAgMiAyaDQiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPjxwYXRoIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik0yOCAxN2gxMU0yOCAyMmgxMU05IDI4aDMwTTkgMzNoMjQiLz48cGF0aCBkPSJNOC42MjIgMTUuODQ0VjIzaDEuNDY4di00LjY3NWguMDU5bDEuODUyIDQuNjRoMWwxLjg1MS00LjYyM2guMDZWMjNoMS40Njd2LTcuMTU2aC0xLjg2NmwtMS45NyA0LjgwOGgtLjA4NGwtMS45NzEtNC44MDhIOC42MjJaIiBmaWxsPSIjOEU4RThFIi8+PHBhdGggZD0iTTIxLjAwNiAxNnY3bTAgMEwyNCAyMG0tMi45OTQgM0wxOCAyMCIgc3Ryb2tlPSIjOEU4RThFIiBzdHJva2Utd2lkdGg9IjEuNCIvPjwvc3ZnPgo=',
    textarea: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iOSIgd2lkdGg9IjQ2IiBoZWlnaHQ9IjMxIiByeD0iMyIgZmlsbD0iI0ZDRkNGQyIgc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIGQ9Ik01LjUgMjIuNWg5TTUuNSAyMC4yNWg5TTEzIDE4aDEuNU01LjUgMTQuOTE5di0uNzg3YzAtLjM1LjI4My0uNjMyLjYzMi0uNjMySDguNW0zIDEuNDE5di0uNzg3YS42MzIuNjMyIDAgMCAwLS42MzItLjYzMkg4LjVtMCAwVjE4bTAgMEg2Ljk1N004LjUgMThoMS41NDMiIHN0cm9rZT0iI0IyQjJCMiIgc3Ryb2tlLXdpZHRoPSIxLjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPjxwYXRoIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik02IDI5aDI4TTYgMzRoMTciLz48cGF0aCBkPSJNMzkgMjdoMS41bTEuNSAwaC0xLjVtMCAwdjhtMCAwSDM5bTEuNSAwSDQyIiBzdHJva2U9IiM5NDk0OTQiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz48L3N2Zz4K',
    time: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0iTTYuNTUgMjRhNC40NSA0LjQ1IDAgMSAxIDguOSAwIDQuNDUgNC40NSAwIDAgMS04LjkgMFpNMTEgMTcuOTVhNi4wNSA2LjA1IDAgMSAwIDAgMTIuMSA2LjA1IDYuMDUgMCAwIDAgMC0xMi4xWk0xMC4yIDIxYS44LjggMCAxIDEgMS42IDB2My4wMmEuOC44IDAgMCAxLS40OS43MzdsLTIuNjI0IDEuMTA2YS44LjggMCAwIDEtLjYyMS0xLjQ3NWwyLjEzNS0uOVYyMVoiIGZpbGw9IiNCMkIyQjIiLz48cGF0aCBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBkPSJNMjEgMjRoMTIiLz48cGF0aCBkPSJNMzggMjBoMS41bTEuNSAwaC0xLjVtMCAwdjhtMCAwSDM4bTEuNSAwSDQxIiBzdHJva2U9IiM5NDk0OTQiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiLz48L3N2Zz4K',
    uploadFile: 'data:image/svg+xml;base64,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',
    uploadImg: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iNS44IiB5PSIxMC44IiB3aWR0aD0iMzYuNCIgaGVpZ2h0PSIyNi40IiByeD0iMy4yIiBmaWxsPSIjZmZmIiBzdHJva2U9IiM3NTc1NzUiIHN0cm9rZS13aWR0aD0iMS42Ii8+PGNpcmNsZSBjeD0iMTMuNSIgY3k9IjE4LjUiIHI9IjMuNSIgZmlsbD0iI0VFQ0E4NiIvPjxwYXRoIGQ9Ik0yNy45MjMgMTguMzY2YTEgMSAwIDAgMSAxLjY5Ni0uMDE4bDguMzk1IDEzLjExM0ExIDEgMCAwIDEgMzcuMTcyIDMzSDIwLjc4MWExIDEgMCAwIDEtLjg1NC0xLjUybDcuOTk2LTEzLjExNFoiIGZpbGw9IiM4MkJGOTkiLz48cGF0aCBkPSJNMTYuNjc2IDI2LjE5OWExIDEgMCAwIDEgMS42NDggMGwzLjU5OSA1LjIzNEExIDEgMCAwIDEgMjEuMDk5IDMzSDEzLjlhMSAxIDAgMCAxLS44MjQtMS41NjdsMy41OTktNS4yMzRaIiBmaWxsPSIjODJCRjk5Ii8+PC9zdmc+Cg==',
    state: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMy4yIiB5PSI3LjIiIHdpZHRoPSI0MS42IiBoZWlnaHQ9IjM0LjYiIHJ4PSIzLjgiIGZpbGw9IiNmZmYiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBvcGFjaXR5PSIuNSIgZD0iTTcgMzB2NmEyIDIgMCAwIDAgMiAyaDMwYTIgMiAwIDAgMCAyLTJ2LTZhMiAyIDAgMCAwLTItMkg5YTIgMiAwIDAgMC0yIDJaTTcgMTN2NmEyIDIgMCAwIDAgMiAyaDMwYTIgMiAwIDAgMCAyLTJ2LTZhMiAyIDAgMCAwLTItMkg5YTIgMiAwIDAgMC0yIDJaIiBmaWxsPSIjRDhEOEQ4Ii8+PHJlY3QgeD0iMTQuMiIgeT0iMTcuMiIgd2lkdGg9IjMyLjYiIGhlaWdodD0iMTUuNiIgcng9IjEuOCIgZmlsbD0iI2ZmZiIgc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIG9wYWNpdHk9Ii41IiBkPSJNMTcgMjJ2NmEyIDIgMCAwIDAgMiAyaDIzYTIgMiAwIDAgMCAyLTJ2LTZhMiAyIDAgMCAwLTItMkgxOWEyIDIgMCAwIDAtMiAyWiIgZmlsbD0iI0Q4RDhEOCIvPjwvc3ZnPgo=',
    tabs: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIHZpZXdCb3g9IjAgMCA0OCA0OCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy4yIiB5PSI3LjIiIHdpZHRoPSI0MS42IiBoZWlnaHQ9IjMzLjYiIHJ4PSI0LjgiIGZpbGw9IndoaXRlIiBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMS42Ii8+CjxyZWN0IHg9IjciIHk9IjI2IiB3aWR0aD0iMzQiIGhlaWdodD0iMTAiIHJ4PSIxIiBmaWxsPSIjRTVFNUU1Ii8+CjxsaW5lIHgxPSI0IiB5MT0iMjIuMiIgeDI9IjQ0IiB5Mj0iMjIuMiIgc3Ryb2tlPSIjRTVFNUU1IiBzdHJva2Utd2lkdGg9IjEuNiIvPgo8cGF0aCBkPSJNMjcuNjg4MSAxOEgzMC4zMzc2QzMxLjgzNjUgMTggMzIuNTcxNiAxNy4yMzYyIDMyLjU3MTYgMTYuMjE2NkMzMi41NzE2IDE1LjIyNTkgMzEuODY4NSAxNC42NDQyIDMxLjE3MTcgMTQuNjA5VjE0LjU0NTFDMzEuODEwOSAxNC4zOTQ5IDMyLjMxNTkgMTMuOTQ3NCAzMi4zMTU5IDEzLjE1MTZDMzIuMzE1OSAxMi4xNzY4IDMxLjYxMjggMTEuNDU0NSAzMC4xOTM4IDExLjQ1NDVIMjcuNjg4MVYxOFpNMjguODczOCAxNy4wMDkyVjE1LjA5MTZIMzAuMTgxQzMwLjkxMjkgMTUuMDkxNiAzMS4zNjY3IDE1LjUzOTEgMzEuMzY2NyAxNi4xMjM5QzMxLjM2NjcgMTYuNjQ0OSAzMS4wMDg3IDE3LjAwOTIgMzAuMTQ5IDE3LjAwOTJIMjguODczOFpNMjguODczOCAxNC4yMzgzVjEyLjQzMjVIMzAuMDcyM0MzMC43NjkgMTIuNDMyNSAzMS4xMzAyIDEyLjgwMDEgMzEuMTMwMiAxMy4zMDVDMzEuMTMwMiAxMy44ODAzIDMwLjY2MzYgMTQuMjM4MyAzMC4wNDY3IDE0LjIzODNIMjguODczOFoiIGZpbGw9IiMyQjJCMkIiLz4KPHJlY3QgeD0iNyIgeT0iOSIgd2lkdGg9IjE3IiBoZWlnaHQ9IjExIiByeD0iNS41IiBmaWxsPSIjREFFQ0ZDIi8+CjxwYXRoIGQ9Ik0xMy43Mjk4IDE4TDE0LjI2OTkgMTYuMzg2SDE2LjczMDlMMTcuMjc0MiAxOEgxOC41Mzk4TDE2LjIzMjMgMTEuNDU0NUgxNC43Njg1TDEyLjQ2NDIgMThIMTMuNzI5OFpNMTQuNTg5NSAxNS40MzM2TDE1LjQ3NDggMTIuNzk2OUgxNS41MjZMMTYuNDExMyAxNS40MzM2SDE0LjU4OTVaIiBmaWxsPSIjM0M5MkRDIi8+Cjwvc3ZnPgo=',
    collapse: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIHZpZXdCb3g9IjAgMCA0OCA0OCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3QgeD0iMy4yIiB5PSI3LjIiIHdpZHRoPSI0MS42IiBoZWlnaHQ9IjMzLjYiIHJ4PSI0LjgiIGZpbGw9IndoaXRlIiBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMS42Ii8+CjxwYXRoIGQ9Ik04LjcyOTggMTdMOS4yNjk5MyAxNS4zODZIMTEuNzMwOUwxMi4yNzQyIDE3SDEzLjUzOThMMTEuMjMyMyAxMC40NTQ1SDkuNzY4NTFMNy40NjQxOCAxN0g4LjcyOThaTTkuNTg5NTMgMTQuNDMzNkwxMC40NzQ4IDExLjc5NjlIMTAuNTI2TDExLjQxMTMgMTQuNDMzNkg5LjU4OTUzWiIgZmlsbD0iIzc4Nzg3OCIvPgo8cGF0aCBkPSJNMzQgMTQuNTk5NkwzNiAxMi45OTk2TDM4IDE0LjU5OTYiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiIHN0cm9rZS1saW5lY2FwPSJzcXVhcmUiLz4KPHBhdGggZD0iTTcgMjJMNyAzNEM3IDM1LjEwNDYgNy44OTU0MyAzNiA5IDM2TDM5IDM2QzQwLjEwNDYgMzYgNDEgMzUuMTA0NiA0MSAzNEw0MSAyMkM0MSAyMC44OTU0IDQwLjEwNDYgMjAgMzkgMjBMOSAyMEM3Ljg5NTQzIDIwIDcgMjAuODk1NCA3IDIyWiIgZmlsbD0iI0U1RTVFNSIvPgo8L3N2Zz4K',
    map: 'data:image/svg+xml;base64,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',
    iframe: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIHZpZXdCb3g9IjAgMCA0OCA0OCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTQxIDZIN0M0Ljc5MDg2IDYgMyA3Ljc5MDg2IDMgMTBWMzhDMyA0MC4yMDkxIDQuNzkwODYgNDIgNyA0Mkg0MUM0My4yMDkxIDQyIDQ1IDQwLjIwOTEgNDUgMzhWMTBDNDUgNy43OTA4NiA0My4yMDkxIDYgNDEgNloiIGZpbGw9IndoaXRlIiBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMS42Ii8+CjxwYXRoIGQ9Ik0zNCA2SDQxQzQyLjA2MDkgNiA0My4wNzgzIDYuNDIxNDMgNDMuODI4NCA3LjE3MTU3QzQ0LjU3ODYgNy45MjE3MiA0NSA4LjkzOTEzIDQ1IDEwVjM4QzQ1IDM5LjA2MDkgNDQuNTc4NiA0MC4wNzgzIDQzLjgyODQgNDAuODI4NEM0My4wNzgzIDQxLjU3ODYgNDIuMDYwOSA0MiA0MSA0MkgzNFY2WiIgZmlsbD0iI0Y3RjdGNyIgc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIvPgo8cGF0aCBkPSJNMzcgMjdMMzkuNSAzMEw0MiAyN000MiAyMUwzOS41IDE4TDM3IDIxIiBzdHJva2U9IiM5NDk0OTQiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPHBhdGggZD0iTTkgN0gzMlYyMUg5VjdaIiBmaWxsPSJ3aGl0ZSIvPgo8cGF0aCBvcGFjaXR5PSIwLjUiIGQ9Ik0yOCAzMEg4QzcuNzM0NzggMzAgNy40ODA0MyAzMC4xMDU0IDcuMjkyODkgMzAuMjkyOUM3LjEwNTM2IDMwLjQ4MDQgNyAzMC43MzQ4IDcgMzFDNyAzMS4yNjUyIDcuMTA1MzYgMzEuNTE5NiA3LjI5Mjg5IDMxLjcwNzFDNy40ODA0MyAzMS44OTQ2IDcuNzM0NzggMzIgOCAzMkgyOEMyOC4yNjUyIDMyIDI4LjUxOTYgMzEuODk0NiAyOC43MDcxIDMxLjcwNzFDMjguODk0NiAzMS41MTk2IDI5IDMxLjI2NTIgMjkgMzFDMjkgMzAuNzM0OCAyOC44OTQ2IDMwLjQ4MDQgMjguNzA3MSAzMC4yOTI5QzI4LjUxOTYgMzAuMTA1NCAyOC4yNjUyIDMwIDI4IDMwWk0yOCAyNUg4QzcuNzM0NzggMjUgNy40ODA0MyAyNS4xMDU0IDcuMjkyODkgMjUuMjkyOUM3LjEwNTM2IDI1LjQ4MDQgNyAyNS43MzQ4IDcgMjZDNyAyNi4yNjUyIDcuMTA1MzYgMjYuNTE5NiA3LjI5Mjg5IDI2LjcwNzFDNy40ODA0MyAyNi44OTQ2IDcuNzM0NzggMjcgOCAyN0gyOEMyOC4yNjUyIDI3IDI4LjUxOTYgMjYuODk0NiAyOC43MDcxIDI2LjcwNzFDMjguODk0NiAyNi41MTk2IDI5IDI2LjI2NTIgMjkgMjZDMjkgMjUuNzM0OCAyOC44OTQ2IDI1LjQ4MDQgMjguNzA3MSAyNS4yOTI5QzI4LjUxOTYgMjUuMTA1NCAyOC4yNjUyIDI1IDI4IDI1Wk0yMSAzNUg4QzcuNzM0NzggMzUgNy40ODA0MyAzNS4xMDU0IDcuMjkyODkgMzUuMjkyOUM3LjEwNTM2IDM1LjQ4MDQgNyAzNS43MzQ4IDcgMzZDNyAzNi4yNjUyIDcuMTA1MzYgMzYuNTE5NiA3LjI5Mjg5IDM2LjcwNzFDNy40ODA0MyAzNi44OTQ2IDcuNzM0NzggMzcgOCAzN0gyMUMyMS4yNjUyIDM3IDIxLjUxOTYgMzYuODk0NiAyMS43MDcxIDM2LjcwNzFDMjEuODk0NiAzNi41MTk2IDIyIDM2LjI2NTIgMjIgMzZDMjIgMzUuNzM0OCAyMS44OTQ2IDM1LjQ4MDQgMjEuNzA3MSAzNS4yOTI5QzIxLjUxOTYgMzUuMTA1NCAyMS4yNjUyIDM1IDIxIDM1WiIgZmlsbD0iI0Q4RDhEOCIvPgo8cGF0aCBkPSJNMTguNTYxMSAxNC4wMTA4TDE2LjM2ODEgMTEuNzQ5OEMxNS45MTI2IDExLjI4NDQgMTUuMjk0MyAxMS4wMTM4IDE0LjY0MzMgMTAuOTk1MkMxMy45OTIzIDEwLjk3NjUgMTMuMzU5NSAxMS4yMTEyIDEyLjg3ODEgMTEuNjQ5OEwxMi43NzExIDExLjc0OThDMTIuNTM2NSAxMS45NjM3IDEyLjM0NzQgMTIuMjIyNyAxMi4yMTUgMTIuNTExMkMxMi4wODI3IDEyLjc5OTggMTIuMDA5OSAxMy4xMTIxIDEyLjAwMDkgMTMuNDI5NEMxMS45OTIgMTMuNzQ2OCAxMi4wNDcxIDE0LjA2MjcgMTIuMTYyOSAxNC4zNTgzQzEyLjI3ODcgMTQuNjUzOCAxMi40NTI5IDE0LjkyMzEgMTIuNjc1MSAxNS4xNDk4TDE0Ljg2NzEgMTcuNDExOE0xNi42MzAxIDE5LjIzMDhMMTguNTM3MSAyMS4xOTY4QzE5LjAwNjQgMjEuNjc1OCAxOS42NDMyIDIxLjk1NCAyMC4zMTM1IDIxLjk3MzFDMjAuOTgzOCAyMS45OTIxIDIxLjYzNTMgMjEuNzUwNCAyMi4xMzExIDIxLjI5ODhWMjEuMjk4OEMyMi4zNzI4IDIxLjA3ODYgMjIuNTY3NyAyMC44MTE5IDIyLjcwNCAyMC41MTQ3QzIyLjg0MDQgMjAuMjE3NiAyMi45MTU1IDE5Ljg5NTkgMjIuOTI0OSAxOS41NjkxQzIyLjkzNDIgMTkuMjQyMiAyMi44Nzc2IDE4LjkxNjggMjIuNzU4NCAxOC42MTIzQzIyLjYzOTIgMTguMzA3OCAyMi40NTk4IDE4LjAzMDUgMjIuMjMxMSAxNy43OTY4TDIwLjMyNDEgMTUuODI5OE0xOS4xMDMxIDE4LjEyNThMMTUuODUzMSAxNC44NzU4IiBzdHJva2U9IiNCMkIyQjIiIHN0cm9rZS13aWR0aD0iMS42MjUiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPgo8L3N2Zz4K',
    dialog: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMyIgeT0iMzMiIHdpZHRoPSIyMCIgaGVpZ2h0PSI5IiByeD0iMyIgZmlsbD0iIzNDOTJEQyIvPjxyZWN0IHg9IjguMiIgeT0iOC4yIiB3aWR0aD0iMzUuNiIgaGVpZ2h0PSIyNy42IiByeD0iNC44IiBmaWxsPSIjZmZmIiBzdHJva2U9IiNEOEQ4RDgiIHN0cm9rZS13aWR0aD0iMS42Ii8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIgZD0iTTkgMjAuMmgzNCIvPjxyZWN0IHg9IjEyIiB5PSIyMyIgd2lkdGg9IjI4IiBoZWlnaHQ9IjkiIHJ4PSIxIiBmaWxsPSIjRUVFIi8+PHBhdGggZD0iTTM0LjIwMyAxMi4wNjMgMzkgMTdtLTUtLjA2M0wzOC43OTcgMTIiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjQiLz48L3N2Zz4K',
    step: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIHZpZXdCb3g9IjAgMCA0OCA0OCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMjcuNzY0OCIgY3k9IjguNTg4NTIiIHI9IjIuNTg4MjQiIHRyYW5zZm9ybT0icm90YXRlKC0xODAgMjcuNzY0OCA4LjU4ODUyKSIgZmlsbD0iI0U1RTVFNSIvPgo8cGF0aCBkPSJNMjkuNzA2MSA4LjU4ODg3TDEyLjIzNTUgOC41ODg3OSIgc3Ryb2tlPSIjM0M5MkRDIiBzdHJva2Utd2lkdGg9IjIuNTg4MjQiLz4KPGNpcmNsZSBjeD0iMjcuNzY1IiBjeT0iOC41ODg2OSIgcj0iMS45NDExOCIgdHJhbnNmb3JtPSJyb3RhdGUoLTE4MCAyNy43NjUgOC41ODg2OSkiIGZpbGw9IiMzQzkyREMiIHN0cm9rZT0iIzNDOTJEQyIgc3Ryb2tlLXdpZHRoPSIxLjI5NDEyIi8+CjxjaXJjbGUgY3g9IjEzLjI5NDMiIGN5PSI4LjU4ODY5IiByPSIyLjI2NDcxIiB0cmFuc2Zvcm09InJvdGF0ZSgtMTgwIDEzLjI5NDMgOC41ODg2OSkiIGZpbGw9IiMzQzkyREMiIHN0cm9rZT0iIzNDOTJEQyIgc3Ryb2tlLXdpZHRoPSIxLjk0MTE4Ii8+CjxjaXJjbGUgY3g9IjMwLjUiIGN5PSI4LjUiIHI9IjUuNSIgZmlsbD0iIzNDOTJEQyIvPgo8Y2lyY2xlIGN4PSIzMC41IiBjeT0iOC41IiByPSI1LjUiIGZpbGw9IiMzQzkyREMiLz4KPHJlY3QgeD0iNC4yIiB5PSIxNy4yIiB3aWR0aD0iMzkuNiIgaGVpZ2h0PSIyNS42IiByeD0iNC44IiBmaWxsPSJ3aGl0ZSIgc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIvPgo8cGF0aCBkPSJNMTAgMjRMMTAgMzZDMTAgMzcuMTA0NiAxMC44OTU0IDM4IDEyIDM4TDM2IDM4QzM3LjEwNDYgMzggMzggMzcuMTA0NiAzOCAzNkwzOCAyNEMzOCAyMi44OTU0IDM3LjEwNDYgMjIgMzYgMjJMMTIgMjJDMTAuODk1NCAyMiAxMCAyMi44OTU0IDEwIDI0WiIgZmlsbD0iI0U1RTVFNSIvPgo8cGF0aCBkPSJNMjguNSA4Ljg2MTExTDI5Ljg2MTEgOS45OTUzN0wzMi4xMjk2IDcuNSIgc3Ryb2tlPSJ3aGl0ZSIgc3Ryb2tlLXdpZHRoPSIxLjQiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8L3N2Zz4K',
    qrcode: 'data:image/svg+xml;base64,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',
    signature: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iNCIgeT0iNyIgd2lkdGg9IjQwIiBoZWlnaHQ9IjMzIiByeD0iMiIgZmlsbD0iI2ZmZiIvPjxwYXRoIGQ9Ik0xMCA3SDZhMiAyIDAgMCAwLTIgMnY0TTM4IDQwaDRhMiAyIDAgMCAwIDItMnYtNE00NCAxM1Y5YTIgMiAwIDAgMC0yLTJoLTRNNCAzNHY0YTIgMiAwIDAgMCAyIDJoNCIgc3Ryb2tlPSIjREVERURFIiBzdHJva2Utd2lkdGg9IjEuNiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PHBhdGggZD0iTTEwIDI5LjM3N2MyLjgwNy0uMTQzIDguNDIxLTIuMTQzIDguNDIxLTlzLTMuNjUtNy43MTQtNS40NzQtNy4yODVjLTEuMjYzLjQyOC0zLjM2OCAyLjMxNC0xLjY4NCA2LjQyOCAyLjEwNSA1LjE0MyA2LjczNyA5Ljg1NyA5LjY4NCAxMC4yODUgMi45NDguNDI5IDUuMDUzLjQyOSA2LjMxNi0zIDEuMjYzLTMuNDI4IDIuNTI2LTMuODU3IDMuNzktMyAxLjQ4NiAxLjAxLjQ0NyA1LjU3MiAyLjk0NyA2IDIuNS40MjkgMy4zLS4yMDcgNC41LTQuMzA1IiBzdHJva2U9IiM2QTZBNkEiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PC9zdmc+Cg==',
    barcode: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMyIgeT0iNiIgd2lkdGg9IjQyIiBoZWlnaHQ9IjM2IiByeD0iNCIgZmlsbD0iI2ZmZiIgc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIGQ9Ik04IDI5djdhMSAxIDAgMCAwIDEgMWgyYTEgMSAwIDAgMCAxLTF2LTdhMSAxIDAgMCAwLTEtMUg5YTEgMSAwIDAgMC0xIDFaTTggMTJ2N2ExIDEgMCAwIDAgMSAxaDJhMSAxIDAgMCAwIDEtMXYtN2ExIDEgMCAwIDAtMS0xSDlhMSAxIDAgMCAwLTEgMVpNMTQgMjguNXY4YS41LjUgMCAwIDAgLjUuNWgxYS41LjUgMCAwIDAgLjUtLjV2LThhLjUuNSAwIDAgMC0uNS0uNWgtMWEuNS41IDAgMCAwLS41LjVaTTE0IDEydjdhMSAxIDAgMSAwIDIgMHYtN2ExIDEgMCAxIDAtMiAwWk0yOCAyOXY3YTEgMSAwIDAgMCAxIDFoMWExIDEgMCAwIDAgMS0xdi03YTEgMSAwIDAgMC0xLTFoLTFhMSAxIDAgMCAwLTEgMVpNMjggMTJ2N2ExIDEgMCAwIDAgMSAxaDFhMSAxIDAgMCAwIDEtMXYtN2ExIDEgMCAwIDAtMS0xaC0xYTEgMSAwIDAgMC0xIDFaTTYuOCAyNC42aDM0LjRhLjguOCAwIDAgMCAwLTEuNkg2LjhhLjguOCAwIDAgMCAwIDEuNlpNMTggMjl2N2ExIDEgMCAxIDAgMiAwdi03YTEgMSAwIDEgMC0yIDBaTTE4IDEydjdhMSAxIDAgMSAwIDIgMHYtN2ExIDEgMCAxIDAtMiAwWk0yMiAyOXY3YTEgMSAwIDAgMCAxIDFoMmExIDEgMCAwIDAgMS0xdi03YTEgMSAwIDAgMC0xLTFoLTJhMSAxIDAgMCAwLTEgMVpNMjIgMTJ2N2ExIDEgMCAwIDAgMSAxaDJhMSAxIDAgMCAwIDEtMXYtN2ExIDEgMCAwIDAtMS0xaC0yYTEgMSAwIDAgMC0xIDFaTTMzIDI5djdhMSAxIDAgMCAwIDEgMWg1YTEgMSAwIDAgMCAxLTF2LTdhMSAxIDAgMCAwLTEtMWgtNWExIDEgMCAwIDAtMSAxWk0zMyAxMnY3YTEgMSAwIDAgMCAxIDFoNWExIDEgMCAwIDAgMS0xdi03YTEgMSAwIDAgMC0xLTFoLTVhMSAxIDAgMCAwLTEgMVoiIGZpbGw9IiM4RThFOEUiLz48L3N2Zz4K',
    card: 'data:image/png;base64,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',
    editor: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTgiIHdpZHRoPSI0NiIgaGVpZ2h0PSIyNCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBkPSJNMSAxMy43MjdoMi45MzdjMS40NDggMCAyLjI3OS0uNzczIDIuMjc5LTEuODMxIDAtLjk0Ni0uNjg3LTEuNTQtMS40OC0xLjU3NnYtLjA2NGMuNzItLjE1IDEuMjI0LS42NyAxLjIyNC0xLjQxOSAwLS45ODctLjc2LTEuNjU1LTIuMjMtMS42NTVIMXY2LjU0NVptMS41ODItMS4yNzV2LTEuNTZoMS4wMDdjLjYwNCAwIC45NzUuMzIuOTc1LjgyMiAwIC40NjMtLjMyLjczOC0xLjAwNC43MzhoLS45NzhabTAtMi41OFY4LjQzOWguOTAxYy41MjggMCAuODYzLjI3MS44NjMuNzA2IDAgLjQ2LS4zNy43MjktLjg4OC43MjloLS44NzZaTTI5LjA0NCA3aC0xLjYzNnYxLjAyM2EzLjE4IDMuMTggMCAwIDEtLjQ2IDEuNzA0bC45NzEuNDk1Yy41NDYtLjQ3OCAxLjEyNS0xLjM2NCAxLjEyNS0yLjJWN1ptMi4xMTQgMGgtMS42MzZ2MS4wMjNhMy4xOCAzLjE4IDAgMCAxLS40NiAxLjcwNGwuOTcxLjQ5NWMuNTQ1LS40NzggMS4xMjUtMS4zNjQgMS4xMjUtMi4yVjdaTTEyLjEzNSA3LjE4MmgtMS4zODRsLTEuMDg2IDYuNTQ1aDEuMzgzbDEuMDg3LTYuNTQ1Wk0yMC4xOTYgMTAuMDQ2Yy4wMDMuNjU5LS40NDggMS4wMDQtLjkzNyAxLjAwNC0uNTE0IDAtLjg0Ni0uMzYxLS44NS0uOTRWNy4yMjhoLTEuMzYxdjMuMTI1Yy4wMDMgMS4xNDguNjc0IDEuODQ4IDEuNjYyIDEuODQ4LjczOCAwIDEuMjY5LS4zOCAxLjQ5LS45NTZoLjA1di44OTJoMS4zMDd2LTQuOTFoLTEuMzYxdjIuODJaIiBmaWxsPSIjOTQ5NDk0Ii8+PHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0yMyAxMy4yNWEuNzUuNzUgMCAwIDEtLjc1Ljc1aC01LjVhLjc1Ljc1IDAgMCAxIDAtMS41aDUuNWEuNzUuNzUgMCAwIDEgLjc1Ljc1WiIgZmlsbD0iIzk0OTQ5NCIvPjxwYXRoIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIGQ9Ik02IDI1aDI4TTYgMzBoMTciLz48cGF0aCBkPSJNMzkgMjNoMS41bTEuNSAwaC0xLjVtMCAwdjhtMCAwSDM5bTEuNSAwSDQyIiBzdHJva2U9IiM5NDk0OTQiIHN0cm9rZS13aWR0aD0iMS42IiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz48L3N2Zz4K',
    slot: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAAAXNSR0IArs4c6QAAAu1JREFUeF7tmj2P00AQhmcs0VGho4eCFFR0V9BkNtdDwV0DElwVwV8ABAj4C6BUHBI0dxTQJztpKOioKELB9ZyorkPyokEOCntrO9l82HFmm0h27J159p3dHe8gbHjDDfcfFIAqYMMJaAhsuAB0EswNAWZ+CgB3AeDSmqvkGACeEdFByI8gAGa+BwBv1txx3/z9EIQ8ADL6TxoG4ICI9n2f8gDI6IsKmtQUwLwKGALA2zWRhEzebc/WuRUQfEEdgTBzKIQVwLwhoAoIEdQQqCEBnQN0EqxoFbDWbksChYhbAPBtNBq97Ha7v0NRkuUbO9m9fl6y0uv1zrVarYeIeDVN0xPZixhjvhRFXiUhwMzi9A8AOD9h3Aci2vWNzUm2gskKMx8BwK2Jd5wCwGUiEhjBVgkAa+0NRPzoW0REZ/INZn4HALe9/74nojsBWM6/5py7aYz5VCsAg8FgN0mSw2kADIfDQ+fcf8pAxKN2u703DYA0Tfc6nY4ooz4KUACqAA0BnQN0EtRVQJdB3QfoRsgjENoKN3InaK3tIGLf8/+EiC76qrDWvkLE+5PXnXOvjTEPAlvhnwAgida/5pzbMcYMarUVFmOstX1E7EwY9piIXgQAbGewxpnjaebUmTSXmR8BwPPxO5xzA2PMOI2uTy4wtkSU4Jy7kCTJdyL6WjBKW86563IfET+XpLfX0jS9goi/ikZ+3Fcl6XCeo1VcVwD6TbCib4JVyD3U57JCIO9wVCowjolIflfasm+LoT6Xcjha5JzAkY+aK4HAzFK2Iweg/glwkY1zH46Wja7U4UhlydJbVr80awXL0gGs7PA0J8bLwM8EIKZIqu4AggpdZJlcnQHkhmdUqewsy0yZLmPuL7J/BbDAEVhlEdXU63yZf4tUQFlfy74fNQcpgJhhiVyHY7qa5ZmVKiBmnzCLMzH/jdqJRoWAWFezcvoo5/9+jYpB3aRnFECTRjPGF1VADLUmPaMKaNJoxviy8Qr4A3/mBG6tp6yUAAAAAElFTkSuQmCC',
    password: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iMTUiIHdpZHRoPSI0NiIgaGVpZ2h0PSIxOCIgcng9IjMiIGZpbGw9IiNGQ0ZDRkMiIHN0cm9rZT0iI0Q4RDhEOCIgc3Ryb2tlLXdpZHRoPSIxLjYiLz48cGF0aCBkPSJNMjQuMDMxIDI2LjI2NGEyLjAzMSAyLjAzMSAwIDEgMCAwLTQuMDYyIDIuMDMxIDIuMDMxIDAgMCAwIDAgNC4wNjJaTTMwLjkxMiAyNi4yNjRhMi4wMzEgMi4wMzEgMCAxIDAgMC00LjA2MyAyLjAzMSAyLjAzMSAwIDAgMCAwIDQuMDYzWiIgZmlsbD0iI0Q4RDhEOCIvPjxnIGNsaXAtcGF0aD0idXJsKCNhKSI+PHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xMS4xNzggMjUuODI0YTQuMDY3IDQuMDY3IDAgMSAwLTIuMDQ3LTIuMjIybC00LjAyMSA0LjAyYS4zNzUuMzc1IDAgMCAwLS4xMS4yNjZ2MS43MzVjMCAuMjA3LjE2OC4zNzUuMzc1LjM3NWgxLjI1QS4zNzUuMzc1IDAgMCAwIDcgMjkuNjIzdi0uMjQ4YzAtLjIwNy4xNjgtLjM3NS4zNzUtLjM3NWgxLjI1QS4zNzUuMzc1IDAgMCAwIDkgMjguNjI1di0xLjI0NmMwLS4yMDcuMTY4LS4zNzUuMzc1LS4zNzVoLjQ3Yy4xIDAgLjE5NC0uMDQuMjY1LS4xMWwxLjA2OC0xLjA3Wm0xLjc1NC00LjY4N2ExLjAxNyAxLjAxNyAwIDEgMCAyLjAzNCAwIDEuMDE3IDEuMDE3IDAgMCAwLTIuMDM0IDBaIiBmaWxsPSIjQjJCMkIyIi8+PC9nPjxwYXRoIGQ9Ik0zOCAyMGgxLjVtMS41IDBoLTEuNW0wIDB2OG0wIDBIMzhtMS41IDBINDEiIHN0cm9rZT0iIzk0OTQ5NCIgc3Ryb2tlLXdpZHRoPSIxLjYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIvPjxkZWZzPjxjbGlwUGF0aCBpZD0iYSI+PHBhdGggZmlsbD0iI2ZmZiIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoNSAxOCkiIGQ9Ik0wIDBoMTJ2MTJIMHoiLz48L2NsaXBQYXRoPjwvZGVmcz48L3N2Zz4K',
    dataTable: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAKNJREFUWEftlbEVwkAMQ30bkA1ShI4NUmmXDMAoGYAh2EAMQQcFGyR9ivCcd9R2dxRyrWfr/XsnFZK7NZwiAyIgAiSXhr/QSsvjfttz4JEwcQcwk7yZ2RDo3wCmpPYwkElCX3quz3UKDKwAOpKvhFkZEAEREIGDwJZIwk8NIg+XPtD/tJ6wY7T7L7rA8z2aZ+2Cq5ldInHtgpRWXSACIiACIvAFU2o7gtYoH8IAAAAASUVORK5CYII=',
    code: 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDgiIGhlaWdodD0iNDgiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHJlY3QgeD0iMSIgeT0iOSIgd2lkdGg9IjQ2IiBoZWlnaHQ9IjMxIiByeD0iMyIgZmlsbD0iI0ZDRkNGQyIgc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjEuNiIvPjxwYXRoIGQ9Ik04LjQ2MiAxMy41SDcuMzQxYTEgMSAwIDAgMC0xIDF2MS43MzlhMSAxIDAgMCAxLS4zNzIuNzc4bC0xLjA4Mi44NzJhLjEzMy4xMzMgMCAwIDAgLjAwNy4yMTNsMS4wMjQuNzI0YTEgMSAwIDAgMSAuNDIzLjgxN1YyMS41YTEgMSAwIDAgMCAxIDFIOC41TTExLjUzOCAyMi41aDEuMTIxYTEgMSAwIDAgMCAxLTF2LTEuNzM5YTEgMSAwIDAgMSAuMzcyLS43NzhsMS4wODItLjg3MmEuMTMzLjEzMyAwIDAgMC0uMDA3LS4yMTNsLTEuMDI0LS43MjRhMSAxIDAgMCAxLS40MjMtLjgxN1YxNC41YTEgMSAwIDAgMC0xLTFIMTEuNSIgc3Ryb2tlPSIjQjJCMkIyIiBzdHJva2Utd2lkdGg9IjEuNSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIi8+PHBhdGggc3Ryb2tlPSIjRDhEOEQ4IiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgZD0iTTYgMjloMjhNNiAzNGgxNyIvPjxwYXRoIGQ9Ik0zOSAyN2gxLjVtMS41IDBoLTEuNW0wIDB2OG0wIDBIMzltMS41IDBINDIiIHN0cm9rZT0iIzk0OTQ5NCIgc3Ryb2tlLXdpZHRoPSIxLjYiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPjwvc3ZnPgo=',
}

export const getItemIcon = (type) => {
    return icons[type]
}
