package nl.jixxed.eliteodysseymaterials.enums;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

import java.util.List;

class HorizonsBlueprintTypeTest {

    @Test
    void allExperimental() {
        final List<String> specials = List.of("special_auto_loader",
                "special_concordant_sequence",
                "special_corrosive_shell",
                "special_blinding_shell",
                "special_dispersal_field",
                "special_weapon_toughened",
                "special_drag_munitions",
                "special_emissive_munitions",
                "special_feedback_cascade",
                "special_feedback_cascade_cooled",
                "special_weapon_efficient",
                "special_force_shell",
                "special_fsd_interrupt",
                "special_high_yield_shell",
                "special_incendiary_rounds",
                "special_distortion_field",
                "special_choke_canister",
                "special_mass_lock",
                "special_weapon_rateoffire",
                "special_overload_munitions",
                "special_weapon_damage",
                "special_penetrator_munitions",
                "special_deep_cut_payload",
                "special_phasing_sequence",
                "special_plasma_slug",
                "special_plasma_slug_cooled",
                "special_radiant_canister",
                "special_regeneration_sequence",
                "special_reverberating_cascade",
                "special_scramble_spectrum",
                "special_screening_shell",
                "special_shiftlock_canister",
                "special_smart_rounds",
                "special_weapon_lightweight",
                "special_super_penetrator",
                "special_super_penetrator_cooled",
                "special_lock_breaker",
                "special_thermal_cascade",
                "special_thermal_conduit",
                "special_thermalshock",
                "special_thermal_vent",
                "special_shieldbooster_explosive",
                "special_shieldbooster_toughened",
                "special_shieldbooster_efficient",
                "special_shieldbooster_kinetic",
                "special_shieldbooster_chunky",
                "special_shieldbooster_thermic",
                "special_armour_kinetic",
                "special_armour_chunky",
                "special_armour_explosive",
                "special_armour_thermic",
                "special_powerplant_toughened",
                "special_powerplant_highcharge",
                "special_powerplant_lightweight",
                "special_powerplant_cooled",
                "special_engine_toughened",
                "special_engine_overloaded",
                "special_engine_haulage",
                "special_engine_lightweight",
                "special_engine_cooled",
                "special_fsd_fuelcapacity",
                "special_fsd_toughened",
                "special_fsd_heavy",
                "special_fsd_lightweight",
                "special_fsd_cooled",
                "special_powerdistributor_capacity",
                "special_powerdistributor_toughened",
                "special_powerdistributor_efficient",
                "special_powerdistributor_lightweight",
                "special_powerdistributor_fast",
                "special_hullreinforcement_kinetic",
                "special_hullreinforcement_chunky",
                "special_hullreinforcement_explosive",
                "special_hullreinforcement_thermic",
                "special_shieldcell_oversized",
                "special_shieldcell_toughened",
                "special_shieldcell_efficient",
                "special_shieldcell_gradual",
                "special_shieldcell_lightweight",
                "special_shield_toughened",
                "special_shield_regenerative",
                "special_shield_kinetic",
                "special_shield_health",
                "special_shield_efficient",
                "special_shield_resistive",
                "special_shield_lightweight",
                "special_shield_thermic");
        final List<HorizonsBlueprintType> experimentals = specials.stream().map(HorizonsBlueprintType::forInternalName).toList();
        Assertions.assertThat(HorizonsBlueprintType.values()).allMatch(horizonsBlueprintType -> {
            return horizonsBlueprintType.isExperimental() == experimentals.contains(horizonsBlueprintType);
        });

    }
}