package nl.jixxed.eliteodysseymaterials.service.eddn;

import nl.jixxed.eliteodysseymaterials.enums.Expansion;
import nl.jixxed.eliteodysseymaterials.schemas.eddn.scan.*;
import nl.jixxed.eliteodysseymaterials.schemas.journal.Scan.Scan;
import nl.jixxed.eliteodysseymaterials.service.LocationService;

public class EDDNScanMapper extends EDDNMapper {
    public static Message mapToEDDN(final Scan scan, final Expansion expansion) {
        return new Message.MessageBuilder()
                .withTimestamp(scan.getTimestamp())
                .withEvent(scan.getEvent())
                .withStarSystem(scan.getStarSystem())
                .withSystemAddress(scan.getSystemAddress())
                .withStarPos(LocationService.getCurrentStarPos(scan.getSystemAddress()))
                .withHorizons(expansion.equals(Expansion.HORIZONS) || expansion.equals(Expansion.ODYSSEY))
                .withOdyssey(expansion.equals(Expansion.ODYSSEY))
                .withScanType(scan.getScanType())
                .withBodyName(scan.getBodyName())
                .withBodyID(scan.getBodyID())
                .withParents(mapToOptionalEmptyIfEmptyList(scan.getParents())
                        .map(parents -> parents.stream()
                                .map(parent -> new Parent.ParentBuilder()
                                        .withNull(parent.getNull().orElse(null))
                                        .withStar(parent.getStar().orElse(null))
                                        .withPlanet(parent.getPlanet().orElse(null))
                                        .withRing(parent.getRing().orElse(null))
                                        .build())
                                .toList())
                        .orElse(null))
                .withDistanceFromArrivalLS(scan.getDistanceFromArrivalLS())
                .withTidalLock(scan.getTidalLock().orElse(null))
                .withTerraformState(scan.getTerraformState().orElse(null))
                .withPlanetClass(scan.getPlanetClass().orElse(null))
                .withAtmosphere(scan.getAtmosphere().orElse(null))
                .withAtmosphereType(scan.getAtmosphereType().orElse(null))
                .withAtmosphereComposition(mapToOptionalEmptyIfEmptyList(scan.getAtmosphereComposition())
                        .map(atmosphereCompositions -> atmosphereCompositions.stream()
                                .map(atmosphereComposition -> new AtmosphereComposition.AtmosphereCompositionBuilder()
                                        .withName(atmosphereComposition.getName())
                                        .withPercent(atmosphereComposition.getPercent())
                                        .build())
                                .toList())
                        .orElse(null))
                .withVolcanism(scan.getVolcanism().orElse(null))
                .withMassEM(scan.getMassEM().orElse(null))
                .withRadius(scan.getRadius().orElse(null))
                .withSurfaceGravity(scan.getSurfaceGravity().orElse(null))
                .withSurfaceTemperature(scan.getSurfaceTemperature().orElse(null))
                .withSurfacePressure(scan.getSurfacePressure().orElse(null))
                .withLandable(scan.getLandable().orElse(null))
                .withComposition(scan.getComposition()
                        .map(composition -> new Composition.CompositionBuilder()
                                .withIce(composition.getIce())
                                .withMetal(composition.getMetal())
                                .withRock(composition.getRock())
                                .build())
                        .orElse(null))
                .withSemiMajorAxis(scan.getSemiMajorAxis().orElse(null))
                .withEccentricity(scan.getEccentricity().orElse(null))
                .withOrbitalInclination(scan.getOrbitalInclination().orElse(null))
                .withPeriapsis(scan.getPeriapsis().orElse(null))
                .withOrbitalPeriod(scan.getOrbitalPeriod().orElse(null))
                .withAscendingNode(scan.getAscendingNode().orElse(null))
                .withMeanAnomaly(scan.getMeanAnomaly().orElse(null))
                .withRotationPeriod(scan.getRotationPeriod().orElse(null))
                .withAxialTilt(scan.getAxialTilt().orElse(null))
                .withWasDiscovered(scan.getWasDiscovered())
                .withWasMapped(scan.getWasMapped())
                .withStarType(scan.getStarType().orElse(null))
                .withSubclass(scan.getSubclass().orElse(null))
                .withStellarMass(scan.getStellarMass().orElse(null))
                .withAbsoluteMagnitude(scan.getAbsoluteMagnitude().orElse(null))
                .withAge_MY(scan.getAge_MY().orElse(null))
                .withLuminosity(scan.getLuminosity().orElse(null))
                .withRings(mapToOptionalEmptyIfEmptyList(scan.getRings()).map(rings -> rings.stream()
                                .map(ring -> new Ring.RingBuilder()
                                        .withName(ring.getName())
                                        .withInnerRad(ring.getInnerRad())
                                        .withOuterRad(ring.getOuterRad())
                                        .withMassMT(ring.getMassMT())
                                        .withRingClass(ring.getRingClass())
                                        .build())
                                .toList())
                        .orElse(null))
                .withMaterials(mapToOptionalEmptyIfEmptyList(scan.getMaterials()).map(materials -> materials.stream()
                                .map(material -> new Material.MaterialBuilder()
                                        .withName(material.getName())
                                        .withPercent(material.getPercent())
                                        .build())
                                .toList())
                        .orElse(null))
                .withReserveLevel(scan.getReserveLevel().orElse(null))
                .build();
    }
}
