package nl.jixxed.eliteodysseymaterials.service.eddn;

import nl.jixxed.eliteodysseymaterials.enums.Expansion;
import nl.jixxed.eliteodysseymaterials.schemas.eddn.approachsettlement.SystemFaction;
import nl.jixxed.eliteodysseymaterials.schemas.eddn.carrierjump.*;
import nl.jixxed.eliteodysseymaterials.schemas.eddn.fsdjump.Message;
import nl.jixxed.eliteodysseymaterials.schemas.journal.FSDJump.FSDJump;

public class EDDNFSDJumpMapper extends EDDNMapper {
    public static Message mapToEDDN(final FSDJump fsdjump, final Expansion expansion) {
        return new Message.MessageBuilder()
                .withTimestamp(fsdjump.getTimestamp())
                .withEvent(fsdjump.getEvent())
                .withSystemAddress(fsdjump.getSystemAddress())
                .withStarPos(fsdjump.getStarPos())
                .withStarSystem(fsdjump.getStarSystem())
                .withHorizons(expansion.equals(Expansion.HORIZONS) || expansion.equals(Expansion.ODYSSEY))
                .withOdyssey(expansion.equals(Expansion.ODYSSEY))
                .withTaxi(fsdjump.getTaxi().orElse(null))
                .withMulticrew(fsdjump.getMulticrew().orElse(null))
                .withBodyID(fsdjump.getBodyID())
                .withBody(fsdjump.getBody())
                .withBodyType(fsdjump.getBodyType())
                .withPopulation(fsdjump.getPopulation())
                .withPowerplayState(fsdjump.getPowerplayState().orElse(null))
                .withPowers(mapToOptionalEmptyIfEmptyList(fsdjump.getPowers()).orElse(null))
                .withControllingPower(fsdjump.getControllingPower().orElse(null))
                .withSystemEconomy(fsdjump.getSystemEconomy())
                .withSystemAllegiance(fsdjump.getSystemAllegiance())
                .withSystemFaction(fsdjump.getSystemFaction()
                        .map(faction -> new SystemFaction.SystemFactionBuilder()
                                .withName(faction.getName())
                                .withFactionState(faction.getFactionState().orElse(null))
                                .build())
                        .orElse(null))
                .withSystemGovernment(fsdjump.getSystemGovernment())
                .withSystemSecondEconomy(fsdjump.getSystemSecondEconomy())
                .withSystemSecurity(fsdjump.getSystemSecurity())
                .withFactions(mapToOptionalEmptyIfEmptyList(fsdjump.getFactions())
                        .map(factions -> factions.stream()
                        .map(faction -> new Faction.FactionBuilder()
                                .withName(faction.getName())
                                .withFactionState(faction.getFactionState())
                                .withAllegiance(faction.getAllegiance())
                                .withGovernment(faction.getGovernment())
                                .withHappiness(faction.getHappiness())
                                .withInfluence(faction.getInfluence())
                                .withActiveStates(mapToOptionalEmptyIfEmptyList(faction.getActiveStates())
                                        .map(activeStates -> activeStates.stream()
                                                .map(activeState -> new ActiveState.ActiveStateBuilder()
                                                        .withState(activeState.getState())
                                                        .build())
                                                .toList())
                                        .orElse(null))
                                .withPendingStates(mapToOptionalEmptyIfEmptyList(faction.getPendingStates())
                                        .map(pendingStates -> pendingStates.stream()
                                                .map(pendingState -> new PendingState.PendingStateBuilder()
                                                        .withState(pendingState.getState())
                                                        .withTrend(pendingState.getTrend())
                                                        .build())
                                                .toList())
                                        .orElse(null))
                                .withRecoveringStates(mapToOptionalEmptyIfEmptyList(faction.getRecoveringStates())
                                        .map(recoveringStates -> recoveringStates.stream()
                                                .map(recoveringState -> new RecoveringState.RecoveringStateBuilder()
                                                        .withState(recoveringState.getState())
                                                        .withTrend(recoveringState.getTrend())
                                                        .build())
                                                .toList())
                                        .orElse(null))
                                .build())
                        .toList()).orElse(null))
                .withConflicts(mapToOptionalEmptyIfEmptyList(fsdjump.getConflicts())
                        .map(conflicts -> conflicts.stream()
                                .map(conflict -> new Conflict.ConflictBuilder()
                                        .withStatus(conflict.getStatus())
                                        .withWarType(conflict.getWarType())
                                        .withFaction1(new ConflictFaction.ConflictFactionBuilder()
                                                .withName(conflict.getFaction1().getName())
                                                .withStake(conflict.getFaction1().getStake())
                                                .withWonDays(conflict.getFaction1().getWonDays())
                                                .build())
                                        .withFaction2(new ConflictFaction.ConflictFactionBuilder()
                                                .withName(conflict.getFaction2().getName())
                                                .withStake(conflict.getFaction2().getStake())
                                                .withWonDays(conflict.getFaction2().getWonDays())
                                                .build())
                                        .build())
                                .toList())
                        .orElse(null))
                .withThargoidWar(fsdjump.getThargoidWar()
                        .map(thargoidWar -> new ThargoidWar.ThargoidWarBuilder()
                                .withCurrentState(thargoidWar.getCurrentState())
                                .withSuccessStateReached(thargoidWar.getSuccessStateReached())
                                .withEstimatedRemainingTime(thargoidWar.getEstimatedRemainingTime().orElse(null))
                                .withWarProgress(thargoidWar.getWarProgress().orElse(null))
                                .withRemainingPorts(thargoidWar.getRemainingPorts().orElse(null))
                                .withNextStateFailure(thargoidWar.getNextStateFailure().orElse(null))
                                .withNextStateSuccess(thargoidWar.getNextStateSuccess().orElse(null))
                                .build())
                        .orElse(null))
                .build();
    }
}
