package nl.jixxed.eliteodysseymaterials.service.ar;

import lombok.extern.slf4j.Slf4j;
import nl.jixxed.eliteodysseymaterials.enums.BartenderMenuType;

import java.awt.*;
import java.awt.image.BufferedImage;
@Slf4j
public class BartenderMenuHelper {


    public static BartenderMenuType getMenuType(final BufferedImage bartenderMenuCapture, final BartenderMenu bartenderMenu) {
        if (bartenderMenuCapture == null) {
            return BartenderMenuType.NONE;
        }
        final Point leftPixel = bartenderMenu.getSubMenuDetectionLeftPixel();
        final Point rightPixel = bartenderMenu.getSubMenuDetectionRightPixel();
        final int leftRGB = bartenderMenuCapture.getRGB(leftPixel.x, leftPixel.y);
        final int rightRGB = bartenderMenuCapture.getRGB(rightPixel.x, rightPixel.y);
        if(leftRGB == rightRGB){
            return BartenderMenuType.SUBMENU;
        }else if(isMainMenuCircuits(bartenderMenuCapture,bartenderMenu)){//test 12
            return BartenderMenuType.MAIN_CIRCUITS;
        }else if(isMainMenuTech(bartenderMenuCapture,bartenderMenu)){//test 11
            return BartenderMenuType.MAIN_TECH;
        }else {
            return BartenderMenuType.MAIN_CHEMICALS;
        }
    }

    private static boolean isMainMenuTech(final BufferedImage bartenderMenuCapture, final BartenderMenu bartenderMenu) {
        final Point leftPixel = bartenderMenu.getLine11LeftPixel();
        final Point rightPixel = bartenderMenu.getLine11RightPixel();
       return bartenderMenuCapture.getRGB(leftPixel.x, leftPixel.y) != bartenderMenuCapture.getRGB(rightPixel.x, rightPixel.y);
    }

    private static boolean isMainMenuCircuits(final BufferedImage bartenderMenuCapture, final BartenderMenu bartenderMenu) {
        final Point leftPixel = bartenderMenu.getLine12LeftPixel();
        final Point rightPixel = bartenderMenu.getLine12RightPixel();
        return bartenderMenuCapture.getRGB(leftPixel.x, leftPixel.y) != bartenderMenuCapture.getRGB(rightPixel.x, rightPixel.y);
    }

    public static boolean isTradeMenu(final BufferedImage bartenderMenuCapture, final  BartenderMenu bartenderMenu) {
        return bartenderMenuCapture != null && !isSellMenu(bartenderMenuCapture,bartenderMenu);
    }
    private static boolean isSellMenu(final BufferedImage bartenderMenuCapture, final  BartenderMenu bartenderMenu) {
        if (bartenderMenuCapture == null) {
            return false;
        }
        final Point leftPixel = bartenderMenu.getSellMenuDetectionLeftPixel();
        final Point rightPixel = bartenderMenu.getSellMenuDetectionRightPixel();
        return bartenderMenuCapture.getRGB(leftPixel.x, leftPixel.y) == bartenderMenuCapture.getRGB(rightPixel.x, rightPixel.y);
    }

}
