package nl.jixxed.eliteodysseymaterials.enums;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import nl.jixxed.eliteodysseymaterials.domain.ApplicationState;

import java.util.function.Supplier;

@RequiredArgsConstructor
public enum EngineerPrerequisite {
    ODYSSEY_A1(OdysseyBlueprintName.ENGINEER_A1, "blueprint.description.engineer_a1", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.DOMINO_GREEN)),
    ODYSSEY_A2(OdysseyBlueprintName.ENGINEER_A2, "blueprint.description.engineer_a2", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.KIT_FOWLER)),
    ODYSSEY_A3(OdysseyBlueprintName.ENGINEER_A3, "blueprint.description.engineer_a3", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.KIT_FOWLER)),
    ODYSSEY_A4(OdysseyBlueprintName.ENGINEER_A4, "blueprint.description.engineer_a4", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.YARDEN_BOND)),
    ODYSSEY_A5(OdysseyBlueprintName.ENGINEER_A5, "blueprint.description.engineer_a5", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.YARDEN_BOND)),
    ODYSSEY_B1(OdysseyBlueprintName.ENGINEER_B1, "blueprint.description.engineer_b1", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.HERO_FERRARI)),
    ODYSSEY_B2(OdysseyBlueprintName.ENGINEER_B2, "blueprint.description.engineer_b2", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.WELLINGTON_BECK)),
    ODYSSEY_B3(OdysseyBlueprintName.ENGINEER_B3, "blueprint.description.engineer_b3", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.WELLINGTON_BECK)),
    ODYSSEY_B4(OdysseyBlueprintName.ENGINEER_B4, "blueprint.description.engineer_b4", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.UMA_LASZLO)),
    ODYSSEY_B5(OdysseyBlueprintName.ENGINEER_B5, "blueprint.description.engineer_b5", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.UMA_LASZLO)),
    ODYSSEY_C1(OdysseyBlueprintName.ENGINEER_C1, "blueprint.description.engineer_c1", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.JUDE_NAVARRO)),
    ODYSSEY_C2(OdysseyBlueprintName.ENGINEER_C2, "blueprint.description.engineer_c2", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.TERRA_VELASQUEZ)),
    ODYSSEY_C3(OdysseyBlueprintName.ENGINEER_C3, "blueprint.description.engineer_c3", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.TERRA_VELASQUEZ)),
    ODYSSEY_C4(OdysseyBlueprintName.ENGINEER_C4, "blueprint.description.engineer_c4", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.ODEN_GEIGER)),
    ODYSSEY_C5(OdysseyBlueprintName.ENGINEER_C5, "blueprint.description.engineer_c5", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.ODEN_GEIGER)),
    ODYSSEY_D1_1(OdysseyBlueprintName.ENGINEER_D1_1, "blueprint.description.engineer_d1_1", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.BALTANOS)),
    ODYSSEY_D1_2(OdysseyBlueprintName.ENGINEER_D1_2, "blueprint.description.engineer_d1_2", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.ROSA_DAYETTE)),
    ODYSSEY_D1_3(OdysseyBlueprintName.ENGINEER_D1_3, "blueprint.description.engineer_d1_3", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.ELEANOR_BRESA)),
    ODYSSEY_D2(OdysseyBlueprintName.ENGINEER_D2, "blueprint.description.engineer_d2", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.YI_SHEN)),
    ODYSSEY_D3(OdysseyBlueprintName.ENGINEER_D3, "blueprint.description.engineer_d3", () -> ApplicationState.getInstance().isEngineerUnlocked(Engineer.YI_SHEN)),
    HORIZONS_A_LEARN(HorizonsBlueprintName.ENGINEER_A, "blueprint.description.horizons.engineer_a_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.ELVIRA_MARTUUK)),
    HORIZONS_A_INVITE(HorizonsBlueprintName.ENGINEER_A, "blueprint.description.horizons.engineer_a_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.ELVIRA_MARTUUK)),
    HORIZONS_A_UNLOCK(HorizonsBlueprintName.ENGINEER_A, "blueprint.description.horizons.engineer_a_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.ELVIRA_MARTUUK)),
    HORIZONS_A1_LEARN(HorizonsBlueprintName.ENGINEER_A1, "blueprint.description.horizons.engineer_a1_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.MEL_BRANDON)),
    HORIZONS_A1_INVITE(HorizonsBlueprintName.ENGINEER_A1, "blueprint.description.horizons.engineer_a1_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.MEL_BRANDON)),
    HORIZONS_A1_UNLOCK(HorizonsBlueprintName.ENGINEER_A1, "blueprint.description.horizons.engineer_a1_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.MEL_BRANDON)),
    HORIZONS_A2_LEARN(HorizonsBlueprintName.ENGINEER_A2, "blueprint.description.horizons.engineer_a2_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.ZACARIAH_NEMO)),
    HORIZONS_A2_INVITE(HorizonsBlueprintName.ENGINEER_A2, "blueprint.description.horizons.engineer_a2_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.ZACARIAH_NEMO)),
    HORIZONS_A2_UNLOCK(HorizonsBlueprintName.ENGINEER_A2, "blueprint.description.horizons.engineer_a2_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.ZACARIAH_NEMO)),
    HORIZONS_A3_LEARN(HorizonsBlueprintName.ENGINEER_A3, "blueprint.description.horizons.engineer_a3_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.MARCO_QWENT)),
    HORIZONS_A3_INVITE(HorizonsBlueprintName.ENGINEER_A3, "blueprint.description.horizons.engineer_a3_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.MARCO_QWENT)),
    HORIZONS_A3_UNLOCK(HorizonsBlueprintName.ENGINEER_A3, "blueprint.description.horizons.engineer_a3_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.MARCO_QWENT)),
    HORIZONS_A3A_LEARN(HorizonsBlueprintName.ENGINEER_A3A, "blueprint.description.horizons.engineer_a3a_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.PROFESSOR_PALIN)),
    HORIZONS_A3A_INVITE(HorizonsBlueprintName.ENGINEER_A3A, "blueprint.description.horizons.engineer_a3a_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.PROFESSOR_PALIN)),
    HORIZONS_A3A_UNLOCK(HorizonsBlueprintName.ENGINEER_A3A, "blueprint.description.horizons.engineer_a3a_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.PROFESSOR_PALIN)),
    HORIZONS_A3B_LEARN(HorizonsBlueprintName.ENGINEER_A3B, "blueprint.description.horizons.engineer_a3b_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.LORI_JAMESON)),
    HORIZONS_A3B_INVITE(HorizonsBlueprintName.ENGINEER_A3B, "blueprint.description.horizons.engineer_a3b_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.LORI_JAMESON)),
    HORIZONS_A3B_UNLOCK(HorizonsBlueprintName.ENGINEER_A3B, "blueprint.description.horizons.engineer_a3b_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.LORI_JAMESON)),
    HORIZONS_A3C_LEARN(HorizonsBlueprintName.ENGINEER_A3C, "blueprint.description.horizons.engineer_a3c_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.CHLOE_SEDESI)),
    HORIZONS_A3C_INVITE(HorizonsBlueprintName.ENGINEER_A3C, "blueprint.description.horizons.engineer_a3c_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.CHLOE_SEDESI)),
    HORIZONS_A3C_UNLOCK(HorizonsBlueprintName.ENGINEER_A3C, "blueprint.description.horizons.engineer_a3c_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.CHLOE_SEDESI)),
    HORIZONS_B_LEARN(HorizonsBlueprintName.ENGINEER_B, "blueprint.description.horizons.engineer_b_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.THE_DWELLER)),
    HORIZONS_B_INVITE(HorizonsBlueprintName.ENGINEER_B, "blueprint.description.horizons.engineer_b_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.THE_DWELLER)),
    HORIZONS_B_UNLOCK(HorizonsBlueprintName.ENGINEER_B, "blueprint.description.horizons.engineer_b_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.THE_DWELLER)),
    HORIZONS_B1_LEARN(HorizonsBlueprintName.ENGINEER_B1, "blueprint.description.horizons.engineer_b1_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.MARSHA_HICKS)),
    HORIZONS_B1_INVITE(HorizonsBlueprintName.ENGINEER_B1, "blueprint.description.horizons.engineer_b1_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.MARSHA_HICKS)),
    HORIZONS_B1_UNLOCK(HorizonsBlueprintName.ENGINEER_B1, "blueprint.description.horizons.engineer_b1_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.MARSHA_HICKS)),
    HORIZONS_B2_LEARN(HorizonsBlueprintName.ENGINEER_B2, "blueprint.description.horizons.engineer_b2_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.LEI_CHEUNG)),
    HORIZONS_B2_INVITE(HorizonsBlueprintName.ENGINEER_B2, "blueprint.description.horizons.engineer_b2_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.LEI_CHEUNG)),
    HORIZONS_B2_UNLOCK(HorizonsBlueprintName.ENGINEER_B2, "blueprint.description.horizons.engineer_b2_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.LEI_CHEUNG)),
    HORIZONS_B2A_LEARN(HorizonsBlueprintName.ENGINEER_B2A, "blueprint.description.horizons.engineer_b2a_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.RAM_TAH)),
    HORIZONS_B2A_INVITE(HorizonsBlueprintName.ENGINEER_B2A, "blueprint.description.horizons.engineer_b2a_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.RAM_TAH)),
    HORIZONS_B2A_UNLOCK(HorizonsBlueprintName.ENGINEER_B2A, "blueprint.description.horizons.engineer_b2a_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.RAM_TAH)),
    HORIZONS_C_LEARN(HorizonsBlueprintName.ENGINEER_C, "blueprint.description.horizons.engineer_c_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.FELICITY_FARSEER)),
    HORIZONS_C_INVITE(HorizonsBlueprintName.ENGINEER_C, "blueprint.description.horizons.engineer_c_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.FELICITY_FARSEER)),
    HORIZONS_C_UNLOCK(HorizonsBlueprintName.ENGINEER_C, "blueprint.description.horizons.engineer_c_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.FELICITY_FARSEER)),
    HORIZONS_C1_LEARN(HorizonsBlueprintName.ENGINEER_C1, "blueprint.description.horizons.engineer_c1_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.JURI_ISHMAAK)),
    HORIZONS_C1_INVITE(HorizonsBlueprintName.ENGINEER_C1, "blueprint.description.horizons.engineer_c1_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.JURI_ISHMAAK)),
    HORIZONS_C1_UNLOCK(HorizonsBlueprintName.ENGINEER_C1, "blueprint.description.horizons.engineer_c1_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.JURI_ISHMAAK)),
    HORIZONS_C1A_LEARN(HorizonsBlueprintName.ENGINEER_C1A, "blueprint.description.horizons.engineer_c1a_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.COLONEL_BRIS_DEKKER)),
    HORIZONS_C1A_INVITE(HorizonsBlueprintName.ENGINEER_C1A, "blueprint.description.horizons.engineer_c1a_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.COLONEL_BRIS_DEKKER)),
    HORIZONS_C1A_UNLOCK(HorizonsBlueprintName.ENGINEER_C1A, "blueprint.description.horizons.engineer_c1a_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.COLONEL_BRIS_DEKKER)),
    HORIZONS_C1B_LEARN(HorizonsBlueprintName.ENGINEER_C1B, "blueprint.description.horizons.engineer_c1b_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.THE_SARGE)),
    HORIZONS_C1B_INVITE(HorizonsBlueprintName.ENGINEER_C1B, "blueprint.description.horizons.engineer_c1b_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.THE_SARGE)),
    HORIZONS_C1B_UNLOCK(HorizonsBlueprintName.ENGINEER_C1B, "blueprint.description.horizons.engineer_c1b_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.THE_SARGE)),
    HORIZONS_D_LEARN(HorizonsBlueprintName.ENGINEER_D, "blueprint.description.horizons.engineer_d_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.TOD_THE_BLASTER_MCQUINN)),
    HORIZONS_D_INVITE(HorizonsBlueprintName.ENGINEER_D, "blueprint.description.horizons.engineer_d_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.TOD_THE_BLASTER_MCQUINN)),
    HORIZONS_D_UNLOCK(HorizonsBlueprintName.ENGINEER_D, "blueprint.description.horizons.engineer_d_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.TOD_THE_BLASTER_MCQUINN)),
    HORIZONS_D1_LEARN(HorizonsBlueprintName.ENGINEER_D1, "blueprint.description.horizons.engineer_d1_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.PETRA_OLMANOVA)),
    HORIZONS_D1_INVITE(HorizonsBlueprintName.ENGINEER_D1, "blueprint.description.horizons.engineer_d1_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.PETRA_OLMANOVA)),
    HORIZONS_D1_UNLOCK(HorizonsBlueprintName.ENGINEER_D1, "blueprint.description.horizons.engineer_d1_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.PETRA_OLMANOVA)),
    HORIZONS_D2_LEARN(HorizonsBlueprintName.ENGINEER_D2, "blueprint.description.horizons.engineer_d2_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.SELENE_JEAN)),
    HORIZONS_D2_INVITE(HorizonsBlueprintName.ENGINEER_D2, "blueprint.description.horizons.engineer_d2_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.SELENE_JEAN)),
    HORIZONS_D2_UNLOCK(HorizonsBlueprintName.ENGINEER_D2, "blueprint.description.horizons.engineer_d2_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.SELENE_JEAN)),
    HORIZONS_D2A_LEARN(HorizonsBlueprintName.ENGINEER_D2A, "blueprint.description.horizons.engineer_d2a_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.DIDI_VATERMANN)),
    HORIZONS_D2A_INVITE(HorizonsBlueprintName.ENGINEER_D2A, "blueprint.description.horizons.engineer_d2a_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.DIDI_VATERMANN)),
    HORIZONS_D2A_UNLOCK(HorizonsBlueprintName.ENGINEER_D2A, "blueprint.description.horizons.engineer_d2a_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.DIDI_VATERMANN)),
    HORIZONS_D2B_LEARN(HorizonsBlueprintName.ENGINEER_D2B, "blueprint.description.horizons.engineer_d2b_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.BILL_TURNER)),
    HORIZONS_D2B_INVITE(HorizonsBlueprintName.ENGINEER_D2B, "blueprint.description.horizons.engineer_d2b_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.BILL_TURNER)),
    HORIZONS_D2B_UNLOCK(HorizonsBlueprintName.ENGINEER_D2B, "blueprint.description.horizons.engineer_d2b_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.BILL_TURNER)),
    HORIZONS_E_LEARN(HorizonsBlueprintName.ENGINEER_E, "blueprint.description.horizons.engineer_e_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.LIZ_RYDER)),
    HORIZONS_E_INVITE(HorizonsBlueprintName.ENGINEER_E, "blueprint.description.horizons.engineer_e_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.LIZ_RYDER)),
    HORIZONS_E_UNLOCK(HorizonsBlueprintName.ENGINEER_E, "blueprint.description.horizons.engineer_e_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.LIZ_RYDER)),
    HORIZONS_E1_LEARN(HorizonsBlueprintName.ENGINEER_E1, "blueprint.description.horizons.engineer_e1_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.ETIENNE_DORN)),
    HORIZONS_E1_INVITE(HorizonsBlueprintName.ENGINEER_E1, "blueprint.description.horizons.engineer_e1_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.ETIENNE_DORN)),
    HORIZONS_E1_UNLOCK(HorizonsBlueprintName.ENGINEER_E1, "blueprint.description.horizons.engineer_e1_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.ETIENNE_DORN)),
    HORIZONS_E2_LEARN(HorizonsBlueprintName.ENGINEER_E2, "blueprint.description.horizons.engineer_e2_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.HERA_TANI)),
    HORIZONS_E2_INVITE(HorizonsBlueprintName.ENGINEER_E2, "blueprint.description.horizons.engineer_e2_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.HERA_TANI)),
    HORIZONS_E2_UNLOCK(HorizonsBlueprintName.ENGINEER_E2, "blueprint.description.horizons.engineer_e2_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.HERA_TANI)),
    HORIZONS_E2A_LEARN(HorizonsBlueprintName.ENGINEER_E2A, "blueprint.description.horizons.engineer_e2a_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.BROO_TARQUIN)),
    HORIZONS_E2A_INVITE(HorizonsBlueprintName.ENGINEER_E2A, "blueprint.description.horizons.engineer_e2a_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.BROO_TARQUIN)),
    HORIZONS_E2A_UNLOCK(HorizonsBlueprintName.ENGINEER_E2A, "blueprint.description.horizons.engineer_e2a_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.BROO_TARQUIN)),
    HORIZONS_E2B_LEARN(HorizonsBlueprintName.ENGINEER_E2B, "blueprint.description.horizons.engineer_e2b_learn", () -> ApplicationState.getInstance().isEngineerKnown(Engineer.TIANA_FORTUNE)),
    HORIZONS_E2B_INVITE(HorizonsBlueprintName.ENGINEER_E2B, "blueprint.description.horizons.engineer_e2b_invite", () -> ApplicationState.getInstance().isEngineerInvited(Engineer.TIANA_FORTUNE)),
    HORIZONS_E2B_UNLOCK(HorizonsBlueprintName.ENGINEER_E2B, "blueprint.description.horizons.engineer_e2b_unlock", () -> ApplicationState.getInstance().isEngineerUnlockedExact(Engineer.TIANA_FORTUNE));

    @Getter
    private final BlueprintName blueprintName;
    @Getter
    private final String localisationKey;
    private final Supplier<Boolean> isCompletedSupplier;

    public Boolean isCompleted() {
        return this.isCompletedSupplier.get();
    }
}
