package nl.jixxed.eliteodysseymaterials.domain.ships.optional_internals.military;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.optional_internals.ShieldCellBankBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.MilitaryOptionalModule;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleClass;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleSize;
import nl.jixxed.eliteodysseymaterials.domain.ships.Origin;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;

import java.util.List;
import java.util.Map;

public class ShieldCellBank extends MilitaryOptionalModule {
    public static final ShieldCellBank SHIELD_CELL_BANK_1_E = new ShieldCellBank("SHIELD_CELL_BANK_1_E", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_1, ModuleClass.E, 520, "Int_ShieldCellBank_Size1_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.3), Map.entry(HorizonsModifier.INTEGRITY, 32.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.41), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.0), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 12.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 170.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_1_D = new ShieldCellBank("SHIELD_CELL_BANK_1_D", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_1, ModuleClass.D, 1290, "Int_ShieldCellBank_Size1_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.5), Map.entry(HorizonsModifier.INTEGRITY, 24.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.55), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.0), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 16.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 170.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 1.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_1_C = new ShieldCellBank("SHIELD_CELL_BANK_1_C", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_1, ModuleClass.C, 3230, "Int_ShieldCellBank_Size1_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.3), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.69), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.0), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 20.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 170.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_1_B = new ShieldCellBank("SHIELD_CELL_BANK_1_B", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_1, ModuleClass.B, 8080, "Int_ShieldCellBank_Size1_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.0), Map.entry(HorizonsModifier.INTEGRITY, 56.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.83), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.0), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 24.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 170.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_1_A = new ShieldCellBank("SHIELD_CELL_BANK_1_A", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_1, ModuleClass.A, 20200, "Int_ShieldCellBank_Size1_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.3), Map.entry(HorizonsModifier.INTEGRITY, 48.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.97), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.0), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 28.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 170.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_2_E = new ShieldCellBank("SHIELD_CELL_BANK_2_E", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_2, ModuleClass.E, 1450, "Int_ShieldCellBank_Size2_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.5), Map.entry(HorizonsModifier.INTEGRITY, 41.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.5), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.5), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 14.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 240.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_2_D = new ShieldCellBank("SHIELD_CELL_BANK_2_D", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_2, ModuleClass.D, 3620, "Int_ShieldCellBank_Size2_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.0), Map.entry(HorizonsModifier.INTEGRITY, 31.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.67), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.5), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 18.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 240.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_2_C = new ShieldCellBank("SHIELD_CELL_BANK_2_C", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_2, ModuleClass.C, 9050, "Int_ShieldCellBank_Size2_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.5), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.84), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.5), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 23.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 240.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_2_B = new ShieldCellBank("SHIELD_CELL_BANK_2_B", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_2, ModuleClass.B, 22620, "Int_ShieldCellBank_Size2_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.0), Map.entry(HorizonsModifier.INTEGRITY, 71.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.01), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.5), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 28.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 240.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_2_A = new ShieldCellBank("SHIELD_CELL_BANK_2_A", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_2, ModuleClass.A, 56550, "Int_ShieldCellBank_Size2_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.5), Map.entry(HorizonsModifier.INTEGRITY, 61.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.18), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 1.5), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 32.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 240.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_3_E = new ShieldCellBank("SHIELD_CELL_BANK_3_E", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_3, ModuleClass.E, 4050, "Int_ShieldCellBank_Size3_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.0), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.61), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 2.3), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 17.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 340.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_3_D = new ShieldCellBank("SHIELD_CELL_BANK_3_D", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_3, ModuleClass.D, 10130, "Int_ShieldCellBank_Size3_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.0), Map.entry(HorizonsModifier.INTEGRITY, 38.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.82), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 2.3), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 23.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 340.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_3_C = new ShieldCellBank("SHIELD_CELL_BANK_3_C", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_3, ModuleClass.C, 25330, "Int_ShieldCellBank_Size3_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.0), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.02), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 2.3), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 29.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 340.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_3_B = new ShieldCellBank("SHIELD_CELL_BANK_3_B", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_3, ModuleClass.B, 63330, "Int_ShieldCellBank_Size3_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.0), Map.entry(HorizonsModifier.INTEGRITY, 90.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.22), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 2.3), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 35.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 340.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_3_A = new ShieldCellBank("SHIELD_CELL_BANK_3_A", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_3, ModuleClass.A, 158330, "Int_ShieldCellBank_Size3_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.0), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.43), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 2.3), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 41.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 340.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_4_E = new ShieldCellBank("SHIELD_CELL_BANK_4_E", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_4, ModuleClass.E, 11350, "Int_ShieldCellBank_Size4_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.0), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.74), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 3.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 20.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 410.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_4_D = new ShieldCellBank("SHIELD_CELL_BANK_4_D", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_4, ModuleClass.D, 28370, "Int_ShieldCellBank_Size4_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.0), Map.entry(HorizonsModifier.INTEGRITY, 48.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.98), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 3.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 26.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 410.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_4_C = new ShieldCellBank("SHIELD_CELL_BANK_4_C", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_4, ModuleClass.C, 70930, "Int_ShieldCellBank_Size4_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.0), Map.entry(HorizonsModifier.INTEGRITY, 80.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.23), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 3.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 33.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 410.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_4_B = new ShieldCellBank("SHIELD_CELL_BANK_4_B", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_4, ModuleClass.B, 177330, "Int_ShieldCellBank_Size4_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.0), Map.entry(HorizonsModifier.INTEGRITY, 112.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.48), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 3.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 39.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 410.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_4_A = new ShieldCellBank("SHIELD_CELL_BANK_4_A", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_4, ModuleClass.A, 443330, "Int_ShieldCellBank_Size4_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.0), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.72), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 3.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 46.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 410.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_5_E = new ShieldCellBank("SHIELD_CELL_BANK_5_E", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_5, ModuleClass.E, 31780, "Int_ShieldCellBank_Size5_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.0), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.9), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 5.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 21.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 540.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_5_D = new ShieldCellBank("SHIELD_CELL_BANK_5_D", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_5, ModuleClass.D, 79440, "Int_ShieldCellBank_Size5_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.0), Map.entry(HorizonsModifier.INTEGRITY, 58.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.2), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 5.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 28.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 540.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 2.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_5_C = new ShieldCellBank("SHIELD_CELL_BANK_5_C", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_5, ModuleClass.C, 198610, "Int_ShieldCellBank_Size5_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.0), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.5), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 5.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 35.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 540.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_5_B = new ShieldCellBank("SHIELD_CELL_BANK_5_B", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_5, ModuleClass.B, 496530, "Int_ShieldCellBank_Size5_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.0), Map.entry(HorizonsModifier.INTEGRITY, 134.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.8), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 5.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 41.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 540.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_5_A = new ShieldCellBank("SHIELD_CELL_BANK_5_A", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_5, ModuleClass.A, 1241320, "Int_ShieldCellBank_Size5_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.0), Map.entry(HorizonsModifier.INTEGRITY, 115.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.1), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 5.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 48.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 540.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_6_E = new ShieldCellBank("SHIELD_CELL_BANK_6_E", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_6, ModuleClass.E, 88980, "Int_ShieldCellBank_Size6_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.0), Map.entry(HorizonsModifier.INTEGRITY, 90.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.06), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 7.6), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 20.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 640.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 5.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_6_D = new ShieldCellBank("SHIELD_CELL_BANK_6_D", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_6, ModuleClass.D, 222440, "Int_ShieldCellBank_Size6_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.0), Map.entry(HorizonsModifier.INTEGRITY, 68.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.42), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 7.6), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 26.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 640.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_6_C = new ShieldCellBank("SHIELD_CELL_BANK_6_C", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_6, ModuleClass.C, 556110, "Int_ShieldCellBank_Size6_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.0), Map.entry(HorizonsModifier.INTEGRITY, 113.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.77), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 7.6), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 33.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 640.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_6_B = new ShieldCellBank("SHIELD_CELL_BANK_6_B", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_6, ModuleClass.B, 1390280, "Int_ShieldCellBank_Size6_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 64.0), Map.entry(HorizonsModifier.INTEGRITY, 158.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.12), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 7.6), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 39.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 640.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 5.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_6_A = new ShieldCellBank("SHIELD_CELL_BANK_6_A", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_6, ModuleClass.A, 3475690, "Int_ShieldCellBank_Size6_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.0), Map.entry(HorizonsModifier.INTEGRITY, 136.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.48), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 7.6), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 46.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 640.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_7_E = new ShieldCellBank("SHIELD_CELL_BANK_7_E", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_7, ModuleClass.E, 249140, "Int_ShieldCellBank_Size7_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.0), Map.entry(HorizonsModifier.INTEGRITY, 105.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.24), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 11.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 24.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 720.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 5.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_7_D = new ShieldCellBank("SHIELD_CELL_BANK_7_D", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_7, ModuleClass.D, 622840, "Int_ShieldCellBank_Size7_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.0), Map.entry(HorizonsModifier.INTEGRITY, 79.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.66), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 11.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 32.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 720.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_7_C = new ShieldCellBank("SHIELD_CELL_BANK_7_C", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_7, ModuleClass.C, 1557110, "Int_ShieldCellBank_Size7_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.0), Map.entry(HorizonsModifier.INTEGRITY, 131.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.07), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 11.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 41.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 720.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_7_B = new ShieldCellBank("SHIELD_CELL_BANK_7_B", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_7, ModuleClass.B, 3892770, "Int_ShieldCellBank_Size7_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 128.0), Map.entry(HorizonsModifier.INTEGRITY, 183.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.48), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 11.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 49.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 720.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 5.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_7_A = new ShieldCellBank("SHIELD_CELL_BANK_7_A", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_7, ModuleClass.A, 9731930, "Int_ShieldCellBank_Size7_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.0), Map.entry(HorizonsModifier.INTEGRITY, 157.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.9), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 11.4), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 57.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 720.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_8_E = new ShieldCellBank("SHIELD_CELL_BANK_8_E", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_8, ModuleClass.E, 697580, "Int_ShieldCellBank_Size8_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.0), Map.entry(HorizonsModifier.INTEGRITY, 120.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.44), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 17.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 28.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 800.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 5.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_8_D = new ShieldCellBank("SHIELD_CELL_BANK_8_D", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_8, ModuleClass.D, 1743960, "Int_ShieldCellBank_Size8_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 64.0), Map.entry(HorizonsModifier.INTEGRITY, 90.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.92), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 17.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 37.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 800.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 3.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_8_C = new ShieldCellBank("SHIELD_CELL_BANK_8_C", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_8, ModuleClass.C, 4359900, "Int_ShieldCellBank_Size8_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.0), Map.entry(HorizonsModifier.INTEGRITY, 150.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.4), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 17.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 47.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 800.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_8_B = new ShieldCellBank("SHIELD_CELL_BANK_8_B", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_8, ModuleClass.B, 10899760, "Int_ShieldCellBank_Size8_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 256.0), Map.entry(HorizonsModifier.INTEGRITY, 210.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.88), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 17.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 56.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 800.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 5.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));
    public static final ShieldCellBank SHIELD_CELL_BANK_8_A = new ShieldCellBank("SHIELD_CELL_BANK_8_A", HorizonsBlueprintName.SHIELD_CELL_BANK, ModuleSize.SIZE_8, ModuleClass.A, 27249390, "Int_ShieldCellBank_Size8_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.0), Map.entry(HorizonsModifier.INTEGRITY, 180.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.36), Map.entry(HorizonsModifier.BOOT_TIME, 25.0), Map.entry(HorizonsModifier.SHIELDBANK_SPIN_UP, 5.0), Map.entry(HorizonsModifier.SHIELDBANK_DURATION, 17.1), Map.entry(HorizonsModifier.SHIELDBANK_REINFORCEMENT, 65.0), Map.entry(HorizonsModifier.SHIELDBANK_HEAT, 800.0), Map.entry(HorizonsModifier.AMMO_CLIP_SIZE, 1.0), Map.entry(HorizonsModifier.AMMO_MAXIMUM, 4.0), Map.entry(HorizonsModifier.AMMO_COST, 300.0)));

    public static final List<ShieldCellBank> SHIELD_CELL_BANKS = List.of(
            SHIELD_CELL_BANK_1_E,
            SHIELD_CELL_BANK_1_D,
            SHIELD_CELL_BANK_1_C,
            SHIELD_CELL_BANK_1_B,
            SHIELD_CELL_BANK_1_A,
            SHIELD_CELL_BANK_2_E,
            SHIELD_CELL_BANK_2_D,
            SHIELD_CELL_BANK_2_C,
            SHIELD_CELL_BANK_2_B,
            SHIELD_CELL_BANK_2_A,
            SHIELD_CELL_BANK_3_E,
            SHIELD_CELL_BANK_3_D,
            SHIELD_CELL_BANK_3_C,
            SHIELD_CELL_BANK_3_B,
            SHIELD_CELL_BANK_3_A,
            SHIELD_CELL_BANK_4_E,
            SHIELD_CELL_BANK_4_D,
            SHIELD_CELL_BANK_4_C,
            SHIELD_CELL_BANK_4_B,
            SHIELD_CELL_BANK_4_A,
            SHIELD_CELL_BANK_5_E,
            SHIELD_CELL_BANK_5_D,
            SHIELD_CELL_BANK_5_C,
            SHIELD_CELL_BANK_5_B,
            SHIELD_CELL_BANK_5_A,
            SHIELD_CELL_BANK_6_E,
            SHIELD_CELL_BANK_6_D,
            SHIELD_CELL_BANK_6_C,
            SHIELD_CELL_BANK_6_B,
            SHIELD_CELL_BANK_6_A,
            SHIELD_CELL_BANK_7_E,
            SHIELD_CELL_BANK_7_D,
            SHIELD_CELL_BANK_7_C,
            SHIELD_CELL_BANK_7_B,
            SHIELD_CELL_BANK_7_A,
            SHIELD_CELL_BANK_8_E,
            SHIELD_CELL_BANK_8_D,
            SHIELD_CELL_BANK_8_C,
            SHIELD_CELL_BANK_8_B,
            SHIELD_CELL_BANK_8_A
    );

    public ShieldCellBank(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, basePrice, internalName, attributes);
    }

    public ShieldCellBank(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, basePrice, internalName, attributes);
    }

    public ShieldCellBank(ShieldCellBank shieldCellBank) {
        super(shieldCellBank);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return ShieldCellBankBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return ExperimentalEffectBlueprints.SHIELD_CELL_BANK.keySet().stream().toList();
    }


    @Override
    public ShieldCellBank Clone() {
        return new ShieldCellBank(this);
    }
}
