package nl.jixxed.eliteodysseymaterials.domain.ships.optional_internals.military;

import nl.jixxed.eliteodysseymaterials.domain.ships.MilitaryOptionalModule;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleClass;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleSize;
import nl.jixxed.eliteodysseymaterials.domain.ships.Origin;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MetaAlloyHullReinforcementPackage extends MilitaryOptionalModule {
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_1_E = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_1_E", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_1, ModuleClass.E, Origin.TECHBROKER, 7500, "Int_MetaAlloyHullReinforcement_Size1_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  72.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_1_D = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_1_D", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_1, ModuleClass.D, Origin.TECHBROKER, 22500, "Int_MetaAlloyHullReinforcement_Size1_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  1.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  99.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_2_E = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_2_E", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_2, ModuleClass.E, Origin.TECHBROKER, 18000, "Int_MetaAlloyHullReinforcement_Size2_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  135.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_2_D = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_2_D", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_2, ModuleClass.D, Origin.TECHBROKER, 54000, "Int_MetaAlloyHullReinforcement_Size2_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  171.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_3_E = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_3_E", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_3, ModuleClass.E, Origin.TECHBROKER, 42000, "Int_MetaAlloyHullReinforcement_Size3_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  207.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_3_D = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_3_D", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_3, ModuleClass.D, Origin.TECHBROKER, 126000, "Int_MetaAlloyHullReinforcement_Size3_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  234.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_4_E = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_4_E", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_4, ModuleClass.E, Origin.TECHBROKER, 97500, "Int_MetaAlloyHullReinforcement_Size4_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  16.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  270.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_4_D = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_4_D", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_4, ModuleClass.D, Origin.TECHBROKER, 292500, "Int_MetaAlloyHullReinforcement_Size4_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  297.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_5_E = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_5_E", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_5, ModuleClass.E, Origin.TECHBROKER, 225000, "Int_MetaAlloyHullReinforcement_Size5_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  32.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  324.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));
    public static final MetaAlloyHullReinforcementPackage META_ALLOY_HULL_REINFORCEMENT_PACKAGE_5_D = new MetaAlloyHullReinforcementPackage("META_ALLOY_HULL_REINFORCEMENT_PACKAGE_5_D", HorizonsBlueprintName.META_ALLOY_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_5, ModuleClass.D, Origin.TECHBROKER, 675000, "Int_MetaAlloyHullReinforcement_Size5_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  16.0), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,  351.0), Map.entry(HorizonsModifier.KINETIC_RESISTANCE,  0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE,  0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE,  0.0), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE,  0.03)));

    public static final List<MetaAlloyHullReinforcementPackage> META_ALLOY_HULL_REINFORCEMENT_PACKAGES = List.of(
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_1_E,
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_1_D,
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_2_E,
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_2_D,
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_3_E,
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_3_D,
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_4_E,
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_4_D,
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_5_E,
            META_ALLOY_HULL_REINFORCEMENT_PACKAGE_5_D
    );
    public static final List<HorizonsModifier> HIDDEN_STATS = List.of(HorizonsModifier.POWER_DRAW, HorizonsModifier.KINETIC_RESISTANCE, HorizonsModifier.THERMAL_RESISTANCE, HorizonsModifier.EXPLOSIVE_RESISTANCE);

    public MetaAlloyHullReinforcementPackage(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, basePrice, internalName, attributes);
    }

    public MetaAlloyHullReinforcementPackage(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, basePrice, internalName, attributes);
    }

    public MetaAlloyHullReinforcementPackage(MilitaryOptionalModule militaryOptionalModule) {
        super(militaryOptionalModule);
    }

    public MetaAlloyHullReinforcementPackage(MetaAlloyHullReinforcementPackage metaAlloyHullReinforcementPackage) {
        super(metaAlloyHullReinforcementPackage);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return Collections.emptyList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return Collections.emptyList();
    }

    @Override
    public MetaAlloyHullReinforcementPackage Clone() {
        return new MetaAlloyHullReinforcementPackage(this);
    }

    @Override
    public boolean isHiddenStat(HorizonsModifier modifier) {
        if(HIDDEN_STATS.contains(modifier)){
            return true;
        }
        return super.isHiddenStat(modifier);
    }
}
