package nl.jixxed.eliteodysseymaterials.domain.ships.optional_internals.military;

import nl.jixxed.eliteodysseymaterials.constants.horizons.optional_internals.GuardianShieldReinforcementPackageBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.MilitaryOptionalModule;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleClass;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleSize;
import nl.jixxed.eliteodysseymaterials.domain.ships.Origin;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GuardianShieldReinforcementPackage extends MilitaryOptionalModule {
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_1_E = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_1_E", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_1, ModuleClass.E, Origin.GUARDIAN, 10000, "Int_GuardianShieldReinforcement_Size1_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.35), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  44.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_1_D = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_1_D", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_1, ModuleClass.D, Origin.GUARDIAN, 30000, "Int_GuardianShieldReinforcement_Size1_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  1.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.46), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  61.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_2_E = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_2_E", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_2, ModuleClass.E, Origin.GUARDIAN, 24000, "Int_GuardianShieldReinforcement_Size2_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.56), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  83.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_2_D = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_2_D", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_2, ModuleClass.D, Origin.GUARDIAN, 72000, "Int_GuardianShieldReinforcement_Size2_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.67), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  105.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_3_E = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_3_E", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_3, ModuleClass.E, Origin.GUARDIAN, 57600, "Int_GuardianShieldReinforcement_Size3_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.74), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  127.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_3_D = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_3_D", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_3, ModuleClass.D, Origin.GUARDIAN, 172800, "Int_GuardianShieldReinforcement_Size3_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.84), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  143.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_4_E = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_4_E", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_4, ModuleClass.E, Origin.GUARDIAN, 138240, "Int_GuardianShieldReinforcement_Size4_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  16.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.95), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  165.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_4_D = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_4_D", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_4, ModuleClass.D, Origin.GUARDIAN, 414720, "Int_GuardianShieldReinforcement_Size4_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  1.05), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  182.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_5_E = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_5_E", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_5, ModuleClass.E, Origin.GUARDIAN, 331777, "Int_GuardianShieldReinforcement_Size5_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  32.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  1.16), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  198.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianShieldReinforcementPackage GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_5_D = new GuardianShieldReinforcementPackage("GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_5_D", HorizonsBlueprintName.GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_5, ModuleClass.D, Origin.GUARDIAN, 995328, "Int_GuardianShieldReinforcement_Size5_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  16.0), Map.entry(HorizonsModifier.INTEGRITY,  36.0), Map.entry(HorizonsModifier.POWER_DRAW,  1.26), Map.entry(HorizonsModifier.SHIELD_REINFORCEMENT,  215.0), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));

    public static final List<GuardianShieldReinforcementPackage> GUARDIAN_SHIELD_REINFORCEMENT_PACKAGES = List.of(
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_1_E,
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_1_D,
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_2_E,
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_2_D,
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_3_E,
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_3_D,
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_4_E,
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_4_D,
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_5_E,
            GUARDIAN_SHIELD_REINFORCEMENT_PACKAGE_5_D
    );

    public GuardianShieldReinforcementPackage(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, basePrice, internalName, attributes);
    }

    public GuardianShieldReinforcementPackage(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, basePrice, internalName, attributes);
    }

    public GuardianShieldReinforcementPackage(GuardianShieldReinforcementPackage guardianShieldReinforcementPackage) {
        super(guardianShieldReinforcementPackage);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return GuardianShieldReinforcementPackageBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return Collections.emptyList();
    }

    @Override
    public GuardianShieldReinforcementPackage Clone() {
        return new GuardianShieldReinforcementPackage(this);
    }

    @Override
    public boolean hasPowerToggle() {
        return false;
    }

    @Override
    public boolean isPassivePower() {
        return true;
    }
}
