package nl.jixxed.eliteodysseymaterials.domain.ships.optional_internals.military;

import nl.jixxed.eliteodysseymaterials.constants.horizons.optional_internals.GuardianModuleReinforcementPackageBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.MilitaryOptionalModule;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleClass;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleSize;
import nl.jixxed.eliteodysseymaterials.domain.ships.Origin;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GuardianModuleReinforcementPackage extends MilitaryOptionalModule {
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_1_E = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_1_E", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_1, ModuleClass.E, Origin.GUARDIAN, 10000, "Int_GuardianModuleReinforcement_Size1_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.INTEGRITY,  85.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.27), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.30), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_1_D = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_1_D", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_1, ModuleClass.D, Origin.GUARDIAN, 30000, "Int_GuardianModuleReinforcement_Size1_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  1.0), Map.entry(HorizonsModifier.INTEGRITY,  77.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.34), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.60), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_2_E = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_2_E", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_2, ModuleClass.E, Origin.GUARDIAN, 24000, "Int_GuardianModuleReinforcement_Size2_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.INTEGRITY,  127.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.41), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.30), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_2_D = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_2_D", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_2, ModuleClass.D, Origin.GUARDIAN, 72000, "Int_GuardianModuleReinforcement_Size2_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.INTEGRITY,  116.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.47), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.60), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_3_E = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_3_E", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_3, ModuleClass.E, Origin.GUARDIAN, 57600, "Int_GuardianModuleReinforcement_Size3_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.INTEGRITY,  187.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.54), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.30), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_3_D = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_3_D", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_3, ModuleClass.D, Origin.GUARDIAN, 172800, "Int_GuardianModuleReinforcement_Size3_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.INTEGRITY,  171.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.61), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.60), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_4_E = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_4_E", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_4, ModuleClass.E, Origin.GUARDIAN, 138240, "Int_GuardianModuleReinforcement_Size4_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  16.0), Map.entry(HorizonsModifier.INTEGRITY,  286.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.68), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.30), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_4_D = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_4_D", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_4, ModuleClass.D, Origin.GUARDIAN, 414720, "Int_GuardianModuleReinforcement_Size4_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.INTEGRITY,  259.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.74), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.60), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_5_E = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_5_E", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_5, ModuleClass.E, Origin.GUARDIAN, 331777, "Int_GuardianModuleReinforcement_Size5_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  32.0), Map.entry(HorizonsModifier.INTEGRITY,  424.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.81), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.30), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianModuleReinforcementPackage GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_5_D = new GuardianModuleReinforcementPackage("GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_5_D", HorizonsBlueprintName.GUARDIAN_MODULE_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_5, ModuleClass.D, Origin.GUARDIAN, 995328, "Int_GuardianModuleReinforcement_Size5_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  16.0), Map.entry(HorizonsModifier.INTEGRITY,  385.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.88), Map.entry(HorizonsModifier.MODULE_DEFENCE_ABSORPTION,  0.60), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));

    public static final List<GuardianModuleReinforcementPackage> GUARDIAN_MODULE_REINFORCEMENT_PACKAGES = List.of(
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_1_E,
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_1_D,
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_2_E,
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_2_D,
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_3_E,
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_3_D,
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_4_E,
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_4_D,
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_5_E,
            GUARDIAN_MODULE_REINFORCEMENT_PACKAGE_5_D
    );

    public GuardianModuleReinforcementPackage(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, basePrice, internalName, attributes);
    }

    public GuardianModuleReinforcementPackage(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, basePrice, internalName, attributes);
    }

    public GuardianModuleReinforcementPackage(GuardianModuleReinforcementPackage guardianModuleReinforcementPackage) {
        super(guardianModuleReinforcementPackage);
    }
    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return GuardianModuleReinforcementPackageBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return Collections.emptyList();
    }

    @Override
    public GuardianModuleReinforcementPackage Clone() {
        return new GuardianModuleReinforcementPackage(this);
    }

    @Override
    public boolean hasPowerToggle() {
        return false;
    }

    @Override
    public boolean isPassivePower() {
        return true;
    }
}
