package nl.jixxed.eliteodysseymaterials.domain.ships.optional_internals.military;

import nl.jixxed.eliteodysseymaterials.constants.horizons.optional_internals.GuardianHullReinforcementPackageBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.MilitaryOptionalModule;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleClass;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleSize;
import nl.jixxed.eliteodysseymaterials.domain.ships.Origin;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GuardianHullReinforcementPackage extends MilitaryOptionalModule {
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_1_E = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_1_E", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_1, ModuleClass.E, Origin.GUARDIAN, 10000, "Int_GuardianHullReinforcement_Size1_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,100.0), Map.entry(HorizonsModifier.POWER_DRAW,0.45), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_1_D = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_1_D", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_1, ModuleClass.D, Origin.GUARDIAN, 30000, "Int_GuardianHullReinforcement_Size1_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  1.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,138.0), Map.entry(HorizonsModifier.POWER_DRAW,0.56), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_2_E = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_2_E", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_2, ModuleClass.E, Origin.GUARDIAN, 24000, "Int_GuardianHullReinforcement_Size2_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,188.0), Map.entry(HorizonsModifier.POWER_DRAW,0.68), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_2_D = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_2_D", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_2, ModuleClass.D, Origin.GUARDIAN, 72000, "Int_GuardianHullReinforcement_Size2_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,238.0), Map.entry(HorizonsModifier.POWER_DRAW,0.79), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_3_E = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_3_E", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_3, ModuleClass.E, Origin.GUARDIAN, 57600, "Int_GuardianHullReinforcement_Size3_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,288.0), Map.entry(HorizonsModifier.POWER_DRAW,0.90), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_3_D = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_3_D", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_3, ModuleClass.D, Origin.GUARDIAN,172800, "Int_GuardianHullReinforcement_Size3_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,325.0), Map.entry(HorizonsModifier.POWER_DRAW,1.01), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_4_E = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_4_E", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_4, ModuleClass.E, Origin.GUARDIAN,138240, "Int_GuardianHullReinforcement_Size4_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,375.0), Map.entry(HorizonsModifier.POWER_DRAW,1.13), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_4_D = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_4_D", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_4, ModuleClass.D, Origin.GUARDIAN,414720, "Int_GuardianHullReinforcement_Size4_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,413.0), Map.entry(HorizonsModifier.POWER_DRAW,1.24), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_5_E = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_5_E", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_5, ModuleClass.E, Origin.GUARDIAN,331777, "Int_GuardianHullReinforcement_Size5_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,450.0), Map.entry(HorizonsModifier.POWER_DRAW,1.35), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));
    public static final GuardianHullReinforcementPackage GUARDIAN_HULL_REINFORCEMENT_PACKAGE_5_D = new GuardianHullReinforcementPackage("GUARDIAN_HULL_REINFORCEMENT_PACKAGE_5_D", HorizonsBlueprintName.GUARDIAN_HULL_REINFORCEMENT_PACKAGE, ModuleSize.SIZE_5, ModuleClass.D, Origin.GUARDIAN,995328, "Int_GuardianHullReinforcement_Size5_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.HULL_REINFORCEMENT,488.0), Map.entry(HorizonsModifier.POWER_DRAW,1.46), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.0), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.0), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, 0.02), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.05), Map.entry(HorizonsModifier.ANTI_GUARDIAN_ZONE_RESISTANCE,  false)));

    public static final List<GuardianHullReinforcementPackage> GUARDIAN_HULL_REINFORCEMENT_PACKAGES = List.of(
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_1_E,
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_1_D,
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_2_E,
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_2_D,
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_3_E,
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_3_D,
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_4_E,
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_4_D,
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_5_E,
            GUARDIAN_HULL_REINFORCEMENT_PACKAGE_5_D
    );
    public static final List<HorizonsModifier> HIDDEN_STATS = List.of(HorizonsModifier.KINETIC_RESISTANCE, HorizonsModifier.THERMAL_RESISTANCE);

    public GuardianHullReinforcementPackage(final String id, final HorizonsBlueprintName name, final ModuleSize moduleSize, final ModuleClass moduleClass, final Origin origin, final long basePrice, final String internalName, final Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, basePrice, internalName, attributes);
    }

    public GuardianHullReinforcementPackage(final GuardianHullReinforcementPackage hullReinforcementPackage) {
        super(hullReinforcementPackage  );
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return GuardianHullReinforcementPackageBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return Collections.emptyList();
    }

    @Override
    public GuardianHullReinforcementPackage Clone() {
        return new GuardianHullReinforcementPackage(this);
    }

    @Override
    public boolean hasPowerToggle() {
        return false;
    }

    @Override
    public boolean isPassivePower() {
        return true;
    }

    @Override
    public boolean isHiddenStat(HorizonsModifier modifier) {
        if(HIDDEN_STATS.contains(modifier)){
            return true;
        }
        return super.isHiddenStat(modifier);
    }
}
