package nl.jixxed.eliteodysseymaterials.domain.ships.optional_internals;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.optional_internals.ShieldGeneratorBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.*;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintGrade;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ShieldGenerator extends OptionalModule {
    public static final ShieldGenerator SHIELD_GENERATOR_1_E = new ShieldGenerator("SHIELD_GENERATOR_1_E", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_1, ModuleClass.E, false, 300,                                                        "Int_ShieldGenerator_Size1_Class1",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.30), Map.entry(HorizonsModifier.INTEGRITY, 32.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.72), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 13.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 25.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 63.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.30), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .80), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.30), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_1_D = new ShieldGenerator("SHIELD_GENERATOR_1_D", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_1, ModuleClass.D, false, 1240,                                                       "Int_ShieldGenerator_Size1_Class2",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 0.50), Map.entry(HorizonsModifier.INTEGRITY, 24.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.96), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 13.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 25.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 63.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_1_C = new ShieldGenerator("SHIELD_GENERATOR_1_C", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_1, ModuleClass.C, false, 5140,                                                       "Int_ShieldGenerator_Size1_Class3",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.30), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.20), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 13.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 25.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 63.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.50), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.50), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_1_A = new ShieldGenerator("SHIELD_GENERATOR_1_A", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_1, ModuleClass.A, false, 88075,                                                      "Int_ShieldGenerator_Size1_Class5",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.30), Map.entry(HorizonsModifier.INTEGRITY, 48.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.68), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 13.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 25.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 63.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.70), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.20), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.70), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_2_E_FREE = new ShieldGenerator("SHIELD_GENERATOR_2_E_FREE", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_2, ModuleClass.E, false, 0,                                                       "Int_ShieldGenerator_Size2_Class1_free",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 41.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.90), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 28.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 55.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 138.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.30), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .80), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.30), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_2_E = new ShieldGenerator("SHIELD_GENERATOR_2_E", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_2, ModuleClass.E, false, 1980,                                                       "Int_ShieldGenerator_Size2_Class1",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 41.0), Map.entry(HorizonsModifier.POWER_DRAW, 0.90), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 28.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 55.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 138.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.30), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .80), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.30), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_2_D = new ShieldGenerator("SHIELD_GENERATOR_2_D", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_2, ModuleClass.D, false, 5930,                                                       "Int_ShieldGenerator_Size2_Class2",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.00), Map.entry(HorizonsModifier.INTEGRITY, 31.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.20), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 28.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 55.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 138.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_2_C = new ShieldGenerator("SHIELD_GENERATOR_2_C", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_2, ModuleClass.C, false, 17800,                                                      "Int_ShieldGenerator_Size2_Class3",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.50), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 28.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 55.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 138.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.50), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.50), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_2_B = new ShieldGenerator("SHIELD_GENERATOR_2_B", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_2, ModuleClass.B, false, 53410,                                                      "Int_ShieldGenerator_Size2_Class4",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY, 71.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.80), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 28.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 55.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 138.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.60), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.10), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.60), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_2_A = new ShieldGenerator("SHIELD_GENERATOR_2_A", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_2, ModuleClass.A, false, 160220,                                                     "Int_ShieldGenerator_Size2_Class5",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 61.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.10), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 28.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 55.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 138.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.70), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.20), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.70), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_3_E = new ShieldGenerator("SHIELD_GENERATOR_3_E", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_3, ModuleClass.E, false, 6270,                                                       "Int_ShieldGenerator_Size3_Class1",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.08), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 83.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 165.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 413.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.30), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .80), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.30), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.87), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_3_D = new ShieldGenerator("SHIELD_GENERATOR_3_D", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_3, ModuleClass.D, false, 18810,                                                      "Int_ShieldGenerator_Size3_Class2",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.00), Map.entry(HorizonsModifier.INTEGRITY, 38.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.44), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 83.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 165.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 413.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.87), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_3_C = new ShieldGenerator("SHIELD_GENERATOR_3_C", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_3, ModuleClass.C, false, 56440,                                                      "Int_ShieldGenerator_Size3_Class3",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.80), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 83.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 165.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 413.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.50), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.50), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.87), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_3_B = new ShieldGenerator("SHIELD_GENERATOR_3_B", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_3, ModuleClass.B, false, 169300,                                                     "Int_ShieldGenerator_Size3_Class4",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY, 90.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.16), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 83.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 165.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 413.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.60), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.10), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.60), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.87), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_3_A = new ShieldGenerator("SHIELD_GENERATOR_3_A", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_3, ModuleClass.A, false, 507910,                                                     "Int_ShieldGenerator_Size3_Class5",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.52), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 83.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 165.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 413.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.70), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.20), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.70), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.87), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_4_E = new ShieldGenerator("SHIELD_GENERATOR_4_E", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_4, ModuleClass.E, false, 19880,                                                      "Int_ShieldGenerator_Size4_Class1",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.32), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 143.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 285.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 713.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.30), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .80), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.30), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 2.53), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_4_D = new ShieldGenerator("SHIELD_GENERATOR_4_D", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_4, ModuleClass.D, false, 59630,                                                      "Int_ShieldGenerator_Size4_Class2",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 4.00), Map.entry(HorizonsModifier.INTEGRITY, 48.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.76), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 143.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 285.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 713.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 2.53), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_4_C = new ShieldGenerator("SHIELD_GENERATOR_4_C", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_4, ModuleClass.C, false, 178900,                                                     "Int_ShieldGenerator_Size4_Class3",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 80.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.20), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 143.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 285.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 713.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.50), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.50), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 2.53), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_4_B = new ShieldGenerator("SHIELD_GENERATOR_4_B", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_4, ModuleClass.B, false, 536690,                                                     "Int_ShieldGenerator_Size4_Class4",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.INTEGRITY, 112.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.64), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 143.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 285.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 713.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.60), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.10), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.60), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 2.53), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_4_A = new ShieldGenerator("SHIELD_GENERATOR_4_A", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_4, ModuleClass.A, false, 1610080,                                                    "Int_ShieldGenerator_Size4_Class5",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.08), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 143.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 285.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 713.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.70), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.20), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.70), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 2.53), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_5_E = new ShieldGenerator("SHIELD_GENERATOR_5_E", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_5, ModuleClass.E, false, 63010,                                                      "Int_ShieldGenerator_Size5_Class1",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.56), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 203.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 405.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1013.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.30), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .80), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.30), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 3.75), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_5_D = new ShieldGenerator("SHIELD_GENERATOR_5_D", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_5, ModuleClass.D, false, 189040,                                                     "Int_ShieldGenerator_Size5_Class2",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 8.00), Map.entry(HorizonsModifier.INTEGRITY, 58.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.08), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 203.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 405.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1013.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 3.75), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_5_C = new ShieldGenerator("SHIELD_GENERATOR_5_C", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_5, ModuleClass.C, false, 567110,                                                     "Int_ShieldGenerator_Size5_Class3",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.60), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 203.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 405.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1013.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.50), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.50), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 3.75), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_5_B = new ShieldGenerator("SHIELD_GENERATOR_5_B", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_5, ModuleClass.B, false, 1701320,                                                    "Int_ShieldGenerator_Size5_Class4",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.00), Map.entry(HorizonsModifier.INTEGRITY, 134.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.12), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 203.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 405.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1013.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.60), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.10), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.60), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 3.75), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_5_A = new ShieldGenerator("SHIELD_GENERATOR_5_A", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_5, ModuleClass.A, false, 5103950,                                                    "Int_ShieldGenerator_Size5_Class5",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 115.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.64), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 203.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 405.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1013.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.70), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.20), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.70), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 3.75), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_6_E = new ShieldGenerator("SHIELD_GENERATOR_6_E", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_6, ModuleClass.E, false, 199750,                                                     "Int_ShieldGenerator_Size6_Class1",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 90.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.86), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 270.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 540.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1350.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.30), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .80), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.30), Map.entry(HorizonsModifier.REGEN_RATE, 1.3), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 5.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_6_D = new ShieldGenerator("SHIELD_GENERATOR_6_D", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_6, ModuleClass.D, false, 599240,                                                     "Int_ShieldGenerator_Size6_Class2",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 16.00), Map.entry(HorizonsModifier.INTEGRITY, 68.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.48), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 270.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 540.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1350.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.3), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 5.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_6_C = new ShieldGenerator("SHIELD_GENERATOR_6_C", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_6, ModuleClass.C, false, 1797730,                                                    "Int_ShieldGenerator_Size6_Class3",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 113.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.10), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 270.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 540.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1350.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.50), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.50), Map.entry(HorizonsModifier.REGEN_RATE, 1.3), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 5.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_6_B = new ShieldGenerator("SHIELD_GENERATOR_6_B", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_6, ModuleClass.B, false, 5393180,                                                    "Int_ShieldGenerator_Size6_Class4",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 64.00), Map.entry(HorizonsModifier.INTEGRITY, 158.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.72), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 270.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 540.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1350.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.60), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.10), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.60), Map.entry(HorizonsModifier.REGEN_RATE, 1.3), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 5.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_6_A = new ShieldGenerator("SHIELD_GENERATOR_6_A", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_6, ModuleClass.A, false, 16179530,                                                   "Int_ShieldGenerator_Size6_Class5",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 136.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.34), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 270.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 540.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1350.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.70), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.20), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.70), Map.entry(HorizonsModifier.REGEN_RATE, 1.3), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 5.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_7_E = new ShieldGenerator("SHIELD_GENERATOR_7_E", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_7, ModuleClass.E, false, 633200,                                                     "Int_ShieldGenerator_Size7_Class1",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 105.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.10), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 530.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1060.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 2650.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.30), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .80), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.30), Map.entry(HorizonsModifier.REGEN_RATE, 1.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 7.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_7_D = new ShieldGenerator("SHIELD_GENERATOR_7_D", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_7, ModuleClass.D, false, 1899600,                                                    "Int_ShieldGenerator_Size7_Class2",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 32.00), Map.entry(HorizonsModifier.INTEGRITY, 79.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.80), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 530.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1060.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 2650.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 7.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_7_C = new ShieldGenerator("SHIELD_GENERATOR_7_C", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_7, ModuleClass.C, false, 5698790,                                                    "Int_ShieldGenerator_Size7_Class3",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 131.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.50), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 530.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1060.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 2650.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.50), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.50), Map.entry(HorizonsModifier.REGEN_RATE, 1.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 7.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_7_B = new ShieldGenerator("SHIELD_GENERATOR_7_B", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_7, ModuleClass.B, false, 17096370,                                                   "Int_ShieldGenerator_Size7_Class4",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 128.00), Map.entry(HorizonsModifier.INTEGRITY, 183.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.20), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 530.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1060.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 2650.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.60), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.10), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.60), Map.entry(HorizonsModifier.REGEN_RATE, 1.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 7.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_7_A = new ShieldGenerator("SHIELD_GENERATOR_7_A", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_7, ModuleClass.A, false, 51289110,                                                   "Int_ShieldGenerator_Size7_Class5",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 157.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.90), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 530.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1060.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 2650.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.70), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.20), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.70), Map.entry(HorizonsModifier.REGEN_RATE, 1.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 7.33), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_8_E = new ShieldGenerator("SHIELD_GENERATOR_8_E", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_8, ModuleClass.E, false, 2007240,                                                    "Int_ShieldGenerator_Size8_Class1",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 120.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.40), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 900.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1800.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 4500.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.30), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .80), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.30), Map.entry(HorizonsModifier.REGEN_RATE, 2.4), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 9.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_8_D = new ShieldGenerator("SHIELD_GENERATOR_8_D", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_8, ModuleClass.D, false, 6021720,                                                    "Int_ShieldGenerator_Size8_Class2",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 64.00), Map.entry(HorizonsModifier.INTEGRITY, 90.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.20), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 900.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1800.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 4500.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 2.4), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 9.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_8_C = new ShieldGenerator("SHIELD_GENERATOR_8_C", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_8, ModuleClass.C, false, 18065170,                                                   "Int_ShieldGenerator_Size8_Class3",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 150.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.00), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 900.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1800.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 4500.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.50), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.50), Map.entry(HorizonsModifier.REGEN_RATE, 2.4), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 9.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_8_B = new ShieldGenerator("SHIELD_GENERATOR_8_B", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_8, ModuleClass.B, false, 54195500,                                                   "Int_ShieldGenerator_Size8_Class4",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 256.00), Map.entry(HorizonsModifier.INTEGRITY, 210.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.80), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 900.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1800.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 4500.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.60), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.10), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.60), Map.entry(HorizonsModifier.REGEN_RATE, 2.4), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 9.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_8_A = new ShieldGenerator("SHIELD_GENERATOR_8_A", HorizonsBlueprintName.SHIELD_GENERATOR, ModuleSize.SIZE_8, ModuleClass.A, false, 162586490,                                                  "Int_ShieldGenerator_Size8_Class5",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 180.0), Map.entry(HorizonsModifier.POWER_DRAW, 5.60), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 900.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1800.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 4500.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.70), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.20), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.70), Map.entry(HorizonsModifier.REGEN_RATE, 2.4), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 9.60), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator BI_WEAVE_SHIELD_GENERATOR_1_C = new ShieldGenerator("BI_WEAVE_SHIELD_GENERATOR_1_C", HorizonsBlueprintName.BI_WEAVE_SHIELD_GENERATOR, ModuleSize.SIZE_1, ModuleClass.C, false, 7710,                            "Int_ShieldGenerator_Size1_Class3_Fast",    Map.ofEntries(Map.entry(HorizonsModifier.MASS, 1.30), Map.entry(HorizonsModifier.INTEGRITY, 40.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.20), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 13.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 25.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 63.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 2.40),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator BI_WEAVE_SHIELD_GENERATOR_2_C = new ShieldGenerator("BI_WEAVE_SHIELD_GENERATOR_2_C", HorizonsBlueprintName.BI_WEAVE_SHIELD_GENERATOR, ModuleSize.SIZE_2, ModuleClass.C, false, 26710,                           "Int_ShieldGenerator_Size2_Class3_Fast",    Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.50), Map.entry(HorizonsModifier.INTEGRITY, 51.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.50), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 28.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 55.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 138.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 2.40),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator BI_WEAVE_SHIELD_GENERATOR_3_C = new ShieldGenerator("BI_WEAVE_SHIELD_GENERATOR_3_C", HorizonsBlueprintName.BI_WEAVE_SHIELD_GENERATOR, ModuleSize.SIZE_3, ModuleClass.C, false, 84650,                           "Int_ShieldGenerator_Size3_Class3_Fast",    Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 64.0), Map.entry(HorizonsModifier.POWER_DRAW, 1.80), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 83.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 165.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 413.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 2.80),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator BI_WEAVE_SHIELD_GENERATOR_4_C = new ShieldGenerator("BI_WEAVE_SHIELD_GENERATOR_4_C", HorizonsBlueprintName.BI_WEAVE_SHIELD_GENERATOR, ModuleSize.SIZE_4, ModuleClass.C, false, 268350,                          "Int_ShieldGenerator_Size4_Class3_Fast",    Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 80.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.20), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 143.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 285.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 713.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 1.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 3.80),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator BI_WEAVE_SHIELD_GENERATOR_5_C = new ShieldGenerator("BI_WEAVE_SHIELD_GENERATOR_5_C", HorizonsBlueprintName.BI_WEAVE_SHIELD_GENERATOR, ModuleSize.SIZE_5, ModuleClass.C, false, 850660,                          "Int_ShieldGenerator_Size5_Class3_Fast",    Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.60), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 203.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 405.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1013.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 2.2), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 5.63),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator BI_WEAVE_SHIELD_GENERATOR_6_C = new ShieldGenerator("BI_WEAVE_SHIELD_GENERATOR_6_C", HorizonsBlueprintName.BI_WEAVE_SHIELD_GENERATOR, ModuleSize.SIZE_6, ModuleClass.C, false, 2696590,                         "Int_ShieldGenerator_Size6_Class3_Fast",    Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 113.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.10), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 270.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 540.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1350.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 3.2), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 8.00),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator BI_WEAVE_SHIELD_GENERATOR_7_C = new ShieldGenerator("BI_WEAVE_SHIELD_GENERATOR_7_C", HorizonsBlueprintName.BI_WEAVE_SHIELD_GENERATOR, ModuleSize.SIZE_7, ModuleClass.C, false, 8548190,                         "Int_ShieldGenerator_Size7_Class3_Fast",    Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 131.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.50), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 530.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1060.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 2650.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 4.4), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 11.00),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator BI_WEAVE_SHIELD_GENERATOR_8_C = new ShieldGenerator("BI_WEAVE_SHIELD_GENERATOR_8_C", HorizonsBlueprintName.BI_WEAVE_SHIELD_GENERATOR, ModuleSize.SIZE_8, ModuleClass.C, false, 27097750,                        "Int_ShieldGenerator_Size8_Class3_Fast",    Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 150.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.00), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 900.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1800.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 4500.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.40), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, .90), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.40), Map.entry(HorizonsModifier.REGEN_RATE, 5.8), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 14.40),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator PRISMATIC_SHIELD_GENERATOR_1_A = new ShieldGenerator("PRISMATIC_SHIELD_GENERATOR_1_A", HorizonsBlueprintName.PRISMATIC_SHIELD_GENERATOR, ModuleSize.SIZE_1, ModuleClass.A, Origin.POWERPLAY, false, 132195,     "Int_ShieldGenerator_Size1_Class5_Strong",  Map.ofEntries(Map.entry(HorizonsModifier.MASS, 2.60), Map.entry(HorizonsModifier.INTEGRITY, 48.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.52), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 13.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 25.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 63.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.50), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 2.00), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.20),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator PRISMATIC_SHIELD_GENERATOR_2_A = new ShieldGenerator("PRISMATIC_SHIELD_GENERATOR_2_A", HorizonsBlueprintName.PRISMATIC_SHIELD_GENERATOR, ModuleSize.SIZE_2, ModuleClass.A, Origin.POWERPLAY, false, 240336,     "Int_ShieldGenerator_Size2_Class5_Strong",  Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 61.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.15), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 28.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 55.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 138.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.50), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 2.00), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.20),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator PRISMATIC_SHIELD_GENERATOR_3_A = new ShieldGenerator("PRISMATIC_SHIELD_GENERATOR_3_A", HorizonsBlueprintName.PRISMATIC_SHIELD_GENERATOR, ModuleSize.SIZE_3, ModuleClass.A, Origin.POWERPLAY, false, 761868,     "Int_ShieldGenerator_Size3_Class5_Strong",  Map.ofEntries(Map.entry(HorizonsModifier.MASS, 10.00), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 3.78), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 83.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 165.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 413.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.50), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 2.00), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.30),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator PRISMATIC_SHIELD_GENERATOR_4_A = new ShieldGenerator("PRISMATIC_SHIELD_GENERATOR_4_A", HorizonsBlueprintName.PRISMATIC_SHIELD_GENERATOR, ModuleSize.SIZE_4, ModuleClass.A, Origin.POWERPLAY, false, 2415120,    "Int_ShieldGenerator_Size4_Class5_Strong",  Map.ofEntries(Map.entry(HorizonsModifier.MASS, 20.00), Map.entry(HorizonsModifier.INTEGRITY, 96.0), Map.entry(HorizonsModifier.POWER_DRAW, 4.62), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 143.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 285.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 713.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.50), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 2.00), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.66),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator PRISMATIC_SHIELD_GENERATOR_5_A = new ShieldGenerator("PRISMATIC_SHIELD_GENERATOR_5_A", HorizonsBlueprintName.PRISMATIC_SHIELD_GENERATOR, ModuleSize.SIZE_5, ModuleClass.A, Origin.POWERPLAY, false, 7655930,    "Int_ShieldGenerator_Size5_Class5_Strong",  Map.ofEntries(Map.entry(HorizonsModifier.MASS, 40.00), Map.entry(HorizonsModifier.INTEGRITY, 115.0), Map.entry(HorizonsModifier.POWER_DRAW, 5.46), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 203.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 405.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1013.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.50), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 2.00), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 2.34),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator PRISMATIC_SHIELD_GENERATOR_6_A = new ShieldGenerator("PRISMATIC_SHIELD_GENERATOR_6_A", HorizonsBlueprintName.PRISMATIC_SHIELD_GENERATOR, ModuleSize.SIZE_6, ModuleClass.A, Origin.POWERPLAY, false, 24269297,   "Int_ShieldGenerator_Size6_Class5_Strong",  Map.ofEntries(Map.entry(HorizonsModifier.MASS, 80.00), Map.entry(HorizonsModifier.INTEGRITY, 136.0), Map.entry(HorizonsModifier.POWER_DRAW, 6.51), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 270.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 540.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 1350.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.50), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 2.00), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 3.20),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator PRISMATIC_SHIELD_GENERATOR_7_A = new ShieldGenerator("PRISMATIC_SHIELD_GENERATOR_7_A", HorizonsBlueprintName.PRISMATIC_SHIELD_GENERATOR, ModuleSize.SIZE_7, ModuleClass.A, Origin.POWERPLAY, false, 76933668,   "Int_ShieldGenerator_Size7_Class5_Strong",  Map.ofEntries(Map.entry(HorizonsModifier.MASS, 160.00), Map.entry(HorizonsModifier.INTEGRITY, 157.0), Map.entry(HorizonsModifier.POWER_DRAW, 7.35), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 530.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1060.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 2650.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.50), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 2.00), Map.entry(HorizonsModifier.REGEN_RATE, 1.1), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 4.25),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator PRISMATIC_SHIELD_GENERATOR_8_A = new ShieldGenerator("PRISMATIC_SHIELD_GENERATOR_8_A", HorizonsBlueprintName.PRISMATIC_SHIELD_GENERATOR, ModuleSize.SIZE_8, ModuleClass.A, Origin.POWERPLAY, false, 243879730,  "Int_ShieldGenerator_Size8_Class5_Strong",  Map.ofEntries(Map.entry(HorizonsModifier.MASS, 320.00), Map.entry(HorizonsModifier.INTEGRITY, 180.0), Map.entry(HorizonsModifier.POWER_DRAW, 8.40), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 900.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 1800.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 4500.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 1.00), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.50), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 2.00), Map.entry(HorizonsModifier.REGEN_RATE, 1.4), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 5.40),/*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    public static final ShieldGenerator SHIELD_GENERATOR_3_A_PRE = new ShieldGenerator("SHIELD_GENERATOR_3_A_PRE", HorizonsBlueprintName.SHIELD_GENERATOR_PRE, ModuleSize.SIZE_3, ModuleClass.A, false, 0,                                         "Int_ShieldGenerator_Size3_Class5",         Map.ofEntries(Map.entry(HorizonsModifier.MASS, 5.00), Map.entry(HorizonsModifier.INTEGRITY, 77.0), Map.entry(HorizonsModifier.POWER_DRAW, 2.52), Map.entry(HorizonsModifier.BOOT_TIME, 1.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_MASS, 83.0), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_MASS, 165.0), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_MASS, 413.0), Map.entry(HorizonsModifier.SHIELDGEN_MINIMUM_STRENGTH, 0.70), Map.entry(HorizonsModifier.SHIELDGEN_OPTIMAL_STRENGTH, 1.20), Map.entry(HorizonsModifier.SHIELDGEN_MAXIMUM_STRENGTH, 1.70), Map.entry(HorizonsModifier.REGEN_RATE, 1.0), Map.entry(HorizonsModifier.BROKEN_REGEN_RATE, 1.87), /*thmload,1.2,*/ Map.entry(HorizonsModifier.ENERGY_PER_REGEN, 0.6), Map.entry(HorizonsModifier.KINETIC_RESISTANCE, 0.40), Map.entry(HorizonsModifier.THERMAL_RESISTANCE, -0.20), Map.entry(HorizonsModifier.EXPLOSIVE_RESISTANCE, 0.50), Map.entry(HorizonsModifier.CAUSTIC_RESISTANCE, 0.0)));
    static {
        SHIELD_GENERATOR_3_A_PRE.getModifications().add(
                        new Modification(HorizonsBlueprintType.THERMAL_RESISTANT_SHIELDS_KINETIC_RESISTANT_SHIELDS, 1.0, HorizonsBlueprintGrade.GRADE_5)
        );
    }
    public static final List<ShieldGenerator> SHIELD_GENERATORS = List.of(
            SHIELD_GENERATOR_1_E,
            SHIELD_GENERATOR_1_D,
            SHIELD_GENERATOR_1_C,
            SHIELD_GENERATOR_1_A,
            SHIELD_GENERATOR_2_E,
            SHIELD_GENERATOR_2_D,
            SHIELD_GENERATOR_2_C,
            SHIELD_GENERATOR_2_B,
            SHIELD_GENERATOR_2_A,
            SHIELD_GENERATOR_3_E,
            SHIELD_GENERATOR_3_D,
            SHIELD_GENERATOR_3_C,
            SHIELD_GENERATOR_3_B,
            SHIELD_GENERATOR_3_A,
            SHIELD_GENERATOR_4_E,
            SHIELD_GENERATOR_4_D,
            SHIELD_GENERATOR_4_C,
            SHIELD_GENERATOR_4_B,
            SHIELD_GENERATOR_4_A,
            SHIELD_GENERATOR_5_E,
            SHIELD_GENERATOR_5_D,
            SHIELD_GENERATOR_5_C,
            SHIELD_GENERATOR_5_B,
            SHIELD_GENERATOR_5_A,
            SHIELD_GENERATOR_6_E,
            SHIELD_GENERATOR_6_D,
            SHIELD_GENERATOR_6_C,
            SHIELD_GENERATOR_6_B,
            SHIELD_GENERATOR_6_A,
            SHIELD_GENERATOR_7_E,
            SHIELD_GENERATOR_7_D,
            SHIELD_GENERATOR_7_C,
            SHIELD_GENERATOR_7_B,
            SHIELD_GENERATOR_7_A,
            SHIELD_GENERATOR_8_E,
            SHIELD_GENERATOR_8_D,
            SHIELD_GENERATOR_8_C,
            SHIELD_GENERATOR_8_B,
            SHIELD_GENERATOR_8_A,
            BI_WEAVE_SHIELD_GENERATOR_1_C,
            BI_WEAVE_SHIELD_GENERATOR_2_C,
            BI_WEAVE_SHIELD_GENERATOR_3_C,
            BI_WEAVE_SHIELD_GENERATOR_4_C,
            BI_WEAVE_SHIELD_GENERATOR_5_C,
            BI_WEAVE_SHIELD_GENERATOR_6_C,
            BI_WEAVE_SHIELD_GENERATOR_7_C,
            BI_WEAVE_SHIELD_GENERATOR_8_C,
            PRISMATIC_SHIELD_GENERATOR_1_A,
            PRISMATIC_SHIELD_GENERATOR_2_A,
            PRISMATIC_SHIELD_GENERATOR_3_A,
            PRISMATIC_SHIELD_GENERATOR_4_A,
            PRISMATIC_SHIELD_GENERATOR_5_A,
            PRISMATIC_SHIELD_GENERATOR_6_A,
            PRISMATIC_SHIELD_GENERATOR_7_A,
            PRISMATIC_SHIELD_GENERATOR_8_A,
            SHIELD_GENERATOR_3_A_PRE
    );
    public ShieldGenerator(final String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, boolean multiCrew, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, multiCrew, basePrice, internalName, attributes);
    }

    public ShieldGenerator(final String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, boolean multiCrew, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, multiCrew, basePrice, internalName, attributes);
    }

    public ShieldGenerator(ShieldGenerator shieldGenerator) {
        super(shieldGenerator);
    }
//    Enhanced low power
//    Kinetic resistant
//    Reinforced
//    Thermal resistant
//    Experimental Effects
//    Fast Charge
//    Multi-Weave
//    Hi-Cap
//    Lo-Draw
//    Thermo Block
//    Force Block
//    Double Braced
//    Stripped Down
    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        if(isPreEngineered()){
            return Collections.emptyList();
        }
        return ShieldGeneratorBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        if(isPreEngineered()){
            return Collections.emptyList();
        }
        return ExperimentalEffectBlueprints.SHIELD_GENERATOR.keySet().stream().toList();
    }

    @Override
    public ShieldGenerator Clone() {
        return new ShieldGenerator(this);
    }

    @Override
    public String getClarifier() {
        if (isPreEngineered() || HorizonsBlueprintName.BI_WEAVE_SHIELD_GENERATOR.equals(getName()) || HorizonsBlueprintName.PRISMATIC_SHIELD_GENERATOR.equals(getName())) {
            return " " + LocaleService.getLocalizedStringForCurrentLocale(this.getName().getLocalizationKey());
        }
        return "";

    }
    @Override
    public boolean isPreEngineered() {
        return SHIELD_GENERATOR_3_A_PRE.equals(this);
    }
    @Override
    public boolean isCGExclusive() {
        return isPreEngineered();
    }

    @Override
    public boolean isHiddenStat(HorizonsModifier modifier) {
        if( HorizonsModifier.CAUSTIC_RESISTANCE.equals(modifier)){
            return true;
        }
        return super.isHiddenStat(modifier);
    }

    @Override
    public int getGrouping() {
        final int typeValue = switch (getName()) {
            case SHIELD_GENERATOR -> 1;
            case BI_WEAVE_SHIELD_GENERATOR -> 2;
            case PRISMATIC_SHIELD_GENERATOR -> 3;
            case SHIELD_GENERATOR_PRE -> 4;
            default -> 0;
        };
        return getModuleSize().intValue() * 10 + typeValue;
    }

    public boolean isSelectable() {
        return !SHIELD_GENERATOR_2_E_FREE.equals(this);
    }
}
