package nl.jixxed.eliteodysseymaterials.domain.ships.optional_internals;

import nl.jixxed.eliteodysseymaterials.constants.horizons.optional_internals.HatchBreakerLimpetControllerBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleClass;
import nl.jixxed.eliteodysseymaterials.domain.ships.ModuleSize;
import nl.jixxed.eliteodysseymaterials.domain.ships.OptionalModule;
import nl.jixxed.eliteodysseymaterials.domain.ships.Origin;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HatchBreakerLimpetController extends OptionalModule {
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_1_E = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_1_E", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_1, ModuleClass.E, true, 600, "Int_DroneControl_ResourceSiphon_Size1_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  1.3), Map.entry(HorizonsModifier.INTEGRITY,  32.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.12), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  2.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  1500.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  1600.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  22.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  1.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  6.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_1_D = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_1_D", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_1, ModuleClass.D, true, 1200, "Int_DroneControl_ResourceSiphon_Size1_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  0.5), Map.entry(HorizonsModifier.INTEGRITY,  24.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.16), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  1.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  2000.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  2100.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  19.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  2.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  7.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_1_C = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_1_C", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_1, ModuleClass.C, true, 2400, "Int_DroneControl_ResourceSiphon_Size1_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  1.3), Map.entry(HorizonsModifier.INTEGRITY,  40.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.2), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  1.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  2500.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  2600.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  16.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  3.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  8.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_1_B = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_1_B", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_1, ModuleClass.B, true, 4800, "Int_DroneControl_ResourceSiphon_Size1_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.INTEGRITY,  56.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.24), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  2.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  3000.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  3100.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  13.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  4.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  9.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_1_A = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_1_A", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_1, ModuleClass.A, true, 9600, "Int_DroneControl_ResourceSiphon_Size1_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  1.3), Map.entry(HorizonsModifier.INTEGRITY,  48.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.28), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  1.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  3500.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  3600.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  10.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  5.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  10.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_3_E = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_3_E", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_3, ModuleClass.E, true, 5400, "Int_DroneControl_ResourceSiphon_Size3_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  5.0), Map.entry(HorizonsModifier.INTEGRITY,  51.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.18), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  4.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  1620.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  1720.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  17.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  1.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  6.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_3_D = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_3_D", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_3, ModuleClass.D, true, 10800, "Int_DroneControl_ResourceSiphon_Size3_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.INTEGRITY,  38.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.24), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  3.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  2160.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  2260.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  14.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  2.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  7.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_3_C = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_3_C", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_3, ModuleClass.C, true, 21600, "Int_DroneControl_ResourceSiphon_Size3_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  5.0), Map.entry(HorizonsModifier.INTEGRITY,  64.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.3), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  3.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  2700.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  2800.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  12.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  3.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  8.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_3_B = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_3_B", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_3, ModuleClass.B, true, 43200, "Int_DroneControl_ResourceSiphon_Size3_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.INTEGRITY,  90.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.36), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  4.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  3240.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  3340.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  10.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  4.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  9.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_3_A = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_3_A", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_3, ModuleClass.A, true, 86400, "Int_DroneControl_ResourceSiphon_Size3_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  5.0), Map.entry(HorizonsModifier.INTEGRITY,  77.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.42), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  3.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  3780.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  3870.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  7.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  5.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  10.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_5_E = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_5_E", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_5, ModuleClass.E, true, 48600, "Int_DroneControl_ResourceSiphon_Size5_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  20.0), Map.entry(HorizonsModifier.INTEGRITY,  77.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.3), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  9.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  1980.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  2080.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  11.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  1.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  6.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_5_D = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_5_D", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_5, ModuleClass.D, true, 97200, "Int_DroneControl_ResourceSiphon_Size5_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.INTEGRITY,  58.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.4), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  6.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  2640.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  2740.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  10.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  2.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  7.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_5_C = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_5_C", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_5, ModuleClass.C, true, 194400, "Int_DroneControl_ResourceSiphon_Size5_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  20.0), Map.entry(HorizonsModifier.INTEGRITY,  96.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.5), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  7.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  3300.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  3400.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  8.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  3.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  8.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_5_B = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_5_B", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_5, ModuleClass.B, true, 388800, "Int_DroneControl_ResourceSiphon_Size5_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  32.0), Map.entry(HorizonsModifier.INTEGRITY,  134.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.6), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  9.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  3960.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  4060.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  6.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  4.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  9.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_5_A = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_5_A", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_5, ModuleClass.A, true, 777600, "Int_DroneControl_ResourceSiphon_Size5_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  20.0), Map.entry(HorizonsModifier.INTEGRITY,  115.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.7), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  6.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  4620.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  4720.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  5.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  5.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  10.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_7_E = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_7_E", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_7, ModuleClass.E, true, 437400, "Int_DroneControl_ResourceSiphon_Size7_Class1", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  80.0), Map.entry(HorizonsModifier.INTEGRITY,  105.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.42), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  18.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  2580.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  2680.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  6.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  1.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  6.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_7_D = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_7_D", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_7, ModuleClass.D, true, 874800, "Int_DroneControl_ResourceSiphon_Size7_Class2", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  32.0), Map.entry(HorizonsModifier.INTEGRITY,  79.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.56), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  12.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  3440.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  3540.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  5.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  2.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  7.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_7_C = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_7_C", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_7, ModuleClass.C, true, 1749600, "Int_DroneControl_ResourceSiphon_Size7_Class3", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  80.0), Map.entry(HorizonsModifier.INTEGRITY,  131.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.7), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  15.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  4300.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  4400.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  4.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  3.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  8.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_7_B = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_7_B", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_7, ModuleClass.B, true, 3499200, "Int_DroneControl_ResourceSiphon_Size7_Class4", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  128.0), Map.entry(HorizonsModifier.INTEGRITY,  183.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.84), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  18.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  5160.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  5260.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  3.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  4.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  9.0)));
    public static final HatchBreakerLimpetController HATCH_BREAKER_LIMPET_CONTROLLER_7_A = new HatchBreakerLimpetController("HATCH_BREAKER_LIMPET_CONTROLLER_7_A", HorizonsBlueprintName.HATCH_BREAKER_LIMPET_CONTROLLER, ModuleSize.SIZE_7, ModuleClass.A, true, 6998400, "Int_DroneControl_ResourceSiphon_Size7_Class5", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  80.0), Map.entry(HorizonsModifier.INTEGRITY,  157.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.98), Map.entry(HorizonsModifier.BOOT_TIME,  3.0), Map.entry(HorizonsModifier.MAX_ACTIVE_LIMPETS,  12.0), Map.entry(HorizonsModifier.DRONE_TARGET_RANGE,  6020.0), Map.entry(HorizonsModifier.DRONE_ACTIVE_RANGE,  6120.0), Map.entry(HorizonsModifier.DRONE_LIFE_TIME,  120.0), Map.entry(HorizonsModifier.DRONE_SPEED,  500.0), Map.entry(HorizonsModifier.DRONE_HACKING_TIME,  2.0), Map.entry(HorizonsModifier.DRONE_MIN_JETTISONED_CARGO,  5.0), Map.entry(HorizonsModifier.DRONE_MAX_JETTISONED_CARGO,  10.0)));

    public static final List<HatchBreakerLimpetController> HATCH_BREAKER_LIMPET_CONTROLLERS = List.of(
            HATCH_BREAKER_LIMPET_CONTROLLER_1_E,
            HATCH_BREAKER_LIMPET_CONTROLLER_1_D,
            HATCH_BREAKER_LIMPET_CONTROLLER_1_C,
            HATCH_BREAKER_LIMPET_CONTROLLER_1_B,
            HATCH_BREAKER_LIMPET_CONTROLLER_1_A,
            HATCH_BREAKER_LIMPET_CONTROLLER_3_E,
            HATCH_BREAKER_LIMPET_CONTROLLER_3_D,
            HATCH_BREAKER_LIMPET_CONTROLLER_3_C,
            HATCH_BREAKER_LIMPET_CONTROLLER_3_B,
            HATCH_BREAKER_LIMPET_CONTROLLER_3_A,
            HATCH_BREAKER_LIMPET_CONTROLLER_5_E,
            HATCH_BREAKER_LIMPET_CONTROLLER_5_D,
            HATCH_BREAKER_LIMPET_CONTROLLER_5_C,
            HATCH_BREAKER_LIMPET_CONTROLLER_5_B,
            HATCH_BREAKER_LIMPET_CONTROLLER_5_A,
            HATCH_BREAKER_LIMPET_CONTROLLER_7_E,
            HATCH_BREAKER_LIMPET_CONTROLLER_7_D,
            HATCH_BREAKER_LIMPET_CONTROLLER_7_C,
            HATCH_BREAKER_LIMPET_CONTROLLER_7_B,
            HATCH_BREAKER_LIMPET_CONTROLLER_7_A
    );
    public HatchBreakerLimpetController(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, boolean multiCrew, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, multiCrew, basePrice, internalName, attributes);
    }

    public HatchBreakerLimpetController(String id, HorizonsBlueprintName name, ModuleSize moduleSize, ModuleClass moduleClass, Origin origin, boolean multiCrew, long basePrice, String internalName, Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, multiCrew, basePrice, internalName, attributes);
    }

    public HatchBreakerLimpetController(HatchBreakerLimpetController hatchBreakerLimpetController) {
        super(hatchBreakerLimpetController);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return HatchBreakerLimpetControllerBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return Collections.emptyList();
    }

    @Override
    public HatchBreakerLimpetController Clone() {
        return new HatchBreakerLimpetController(this);
    }
}
