package nl.jixxed.eliteodysseymaterials.domain.ships.hardpoint;

import nl.jixxed.eliteodysseymaterials.constants.horizons.ExperimentalEffectBlueprints;
import nl.jixxed.eliteodysseymaterials.constants.horizons.hardpoints.PulseLaserBlueprints;
import nl.jixxed.eliteodysseymaterials.domain.ships.*;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintName;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsBlueprintType;
import nl.jixxed.eliteodysseymaterials.enums.HorizonsModifier;
import nl.jixxed.eliteodysseymaterials.service.LocaleService;

import java.util.List;
import java.util.Map;

public class PulseLaser extends HardpointModule {
    public static final PulseLaser PULSE_LASER_1_F_F = new PulseLaser("PULSE_LASER_1_F_F", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_1, ModuleClass.F, false, Mounting.FIXED, 2200, "Hpt_PulseLaser_Fixed_Small", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.INTEGRITY,  40.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.39), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  7.885), Map.entry(HorizonsModifier.DAMAGE,  2.05), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.3), Map.entry(HorizonsModifier.THERMAL_LOAD,  0.33), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  20.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  3.846), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.26), Map.entry(HorizonsModifier.BREACH_DAMAGE,  1.7), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_1_G_G = new PulseLaser("PULSE_LASER_1_G_G", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_1, ModuleClass.G, false, Mounting.GIMBALLED, 6600, "Hpt_PulseLaser_Gimbal_Small", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.INTEGRITY,  40.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.39), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  6.24), Map.entry(HorizonsModifier.DAMAGE,  1.56), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.31), Map.entry(HorizonsModifier.THERMAL_LOAD,  0.31), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  20.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  4.0), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.25), Map.entry(HorizonsModifier.BREACH_DAMAGE,  1.3), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_1_G_T = new PulseLaser("PULSE_LASER_1_G_T", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_1, ModuleClass.G, true, Mounting.TURRETED, 26000, "Hpt_PulseLaser_Turret_Small", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  2.0), Map.entry(HorizonsModifier.INTEGRITY,  40.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.38), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  3.967), Map.entry(HorizonsModifier.DAMAGE,  1.19), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.19), Map.entry(HorizonsModifier.THERMAL_LOAD,  0.19), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  20.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  3.333), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.3), Map.entry(HorizonsModifier.BREACH_DAMAGE,  1.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_2_E_F = new PulseLaser("PULSE_LASER_2_E_F", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_2, ModuleClass.E, false, Mounting.FIXED, 17600, "Hpt_PulseLaser_Fixed_Medium", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.INTEGRITY,  51.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.6), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  12.069), Map.entry(HorizonsModifier.DAMAGE,  3.5), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.5), Map.entry(HorizonsModifier.THERMAL_LOAD,  0.56), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  3.448), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.29), Map.entry(HorizonsModifier.BREACH_DAMAGE,  3.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_2_F_G = new PulseLaser("PULSE_LASER_2_F_G", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_2, ModuleClass.F, false, Mounting.GIMBALLED, 35400, "Hpt_PulseLaser_Gimbal_Medium", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.INTEGRITY,  51.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.6), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  9.571), Map.entry(HorizonsModifier.DAMAGE,  2.68), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.54), Map.entry(HorizonsModifier.THERMAL_LOAD,  0.54), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  3.571), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.28), Map.entry(HorizonsModifier.BREACH_DAMAGE,  2.3), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_2_F_T = new PulseLaser("PULSE_LASER_2_F_T", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_2, ModuleClass.F, true, Mounting.TURRETED, 132800, "Hpt_PulseLaser_Turret_Medium", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.INTEGRITY,  51.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.58), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  6.212), Map.entry(HorizonsModifier.DAMAGE,  2.05), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.33), Map.entry(HorizonsModifier.THERMAL_LOAD,  0.33), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  3.03), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.33), Map.entry(HorizonsModifier.BREACH_DAMAGE,  1.7), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_3_D_F = new PulseLaser("PULSE_LASER_3_D_F", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_3, ModuleClass.D, false, Mounting.FIXED, 70400, "Hpt_PulseLaser_Fixed_Large", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.INTEGRITY,  64.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.9), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  18.121), Map.entry(HorizonsModifier.DAMAGE,  5.98), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.86), Map.entry(HorizonsModifier.THERMAL_LOAD,  0.96), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  52.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  3.03), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.33), Map.entry(HorizonsModifier.BREACH_DAMAGE,  5.1), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_3_E_G = new PulseLaser("PULSE_LASER_3_E_G", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_3, ModuleClass.E, false, Mounting.GIMBALLED, 140600, "Hpt_PulseLaser_Gimbal_Large", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.INTEGRITY,  64.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.92), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  14.774), Map.entry(HorizonsModifier.DAMAGE,  4.58), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.92), Map.entry(HorizonsModifier.THERMAL_LOAD,  0.92), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  52.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  3.226), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.31), Map.entry(HorizonsModifier.BREACH_DAMAGE,  3.9), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_3_F_T = new PulseLaser("PULSE_LASER_3_F_T", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_3, ModuleClass.F, true, Mounting.TURRETED, 400400, "Hpt_PulseLaser_Turret_Large", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  8.0), Map.entry(HorizonsModifier.INTEGRITY,  64.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.89), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  9.459), Map.entry(HorizonsModifier.DAMAGE,  3.5), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.56), Map.entry(HorizonsModifier.THERMAL_LOAD,  0.56), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  52.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  2.703), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.37), Map.entry(HorizonsModifier.BREACH_DAMAGE,  3.0), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_4_A_F = new PulseLaser("PULSE_LASER_4_A_F", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_4, ModuleClass.A, false, Mounting.FIXED, 177600, "Hpt_PulseLaser_Fixed_Huge", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  16.0), Map.entry(HorizonsModifier.INTEGRITY,  80.0), Map.entry(HorizonsModifier.POWER_DRAW,  1.33), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  26.947), Map.entry(HorizonsModifier.DAMAGE,  10.24), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  1.48), Map.entry(HorizonsModifier.THERMAL_LOAD,  1.64), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  65.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  2.632), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.38), Map.entry(HorizonsModifier.BREACH_DAMAGE,  8.7), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_LASER_4_A_G = new PulseLaser("PULSE_LASER_4_A_G", HorizonsBlueprintName.PULSE_LASER, ModuleSize.SIZE_4, ModuleClass.A, false, Mounting.GIMBALLED, 877600, "Hpt_PulseLaser_Gimbal_Huge", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  16.0), Map.entry(HorizonsModifier.INTEGRITY,  80.0), Map.entry(HorizonsModifier.POWER_DRAW,  1.37), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  21.722), Map.entry(HorizonsModifier.DAMAGE,  7.82), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  1.56), Map.entry(HorizonsModifier.THERMAL_LOAD,  1.56), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  65.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  2.778), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.36), Map.entry(HorizonsModifier.BREACH_DAMAGE,  6.6), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));
    public static final PulseLaser PULSE_DISRUPTOR_LASER_2_E_F = new PulseLaser("PULSE_DISRUPTOR_LASER_2_E_F", HorizonsBlueprintName.PULSE_DISRUPTOR_LASER, ModuleSize.SIZE_2, ModuleClass.E, Origin.POWERPLAY, false, Mounting.FIXED, 26400, "Hpt_PulseLaser_Fixed_Medium_Disruptor", Map.ofEntries(Map.entry(HorizonsModifier.MASS,  4.0), Map.entry(HorizonsModifier.INTEGRITY,  51.0), Map.entry(HorizonsModifier.POWER_DRAW,  0.7), Map.entry(HorizonsModifier.BOOT_TIME,  0.0), Map.entry(HorizonsModifier.DAMAGE_PER_SECOND,  4.667), Map.entry(HorizonsModifier.DAMAGE,  2.8), Map.entry(HorizonsModifier.DISTRIBUTOR_DRAW,  0.9), Map.entry(HorizonsModifier.THERMAL_LOAD,  1.0), Map.entry(HorizonsModifier.ARMOUR_PIERCING,  35.0), Map.entry(HorizonsModifier.MAXIMUM_RANGE,  3000.0), Map.entry(HorizonsModifier.RATE_OF_FIRE,  1.667), Map.entry(HorizonsModifier.BURST_INTERVAL,  0.6), Map.entry(HorizonsModifier.BREACH_DAMAGE,  2.4), Map.entry(HorizonsModifier.MIN_BREACH_CHANCE,  40.0), Map.entry(HorizonsModifier.MAX_BREACH_CHANCE,  80.0), Map.entry(HorizonsModifier.THERMAL_DAMAGE_RATIO,  1.0), Map.entry(HorizonsModifier.DAMAGE_FALLOFF_START,  500.0), Map.entry(HorizonsModifier.JITTER,  0.0), Map.entry(HorizonsModifier.TARGET_SIGNATURE_INCREASED,false), Map.entry(HorizonsModifier.PART_OF_DAMAGE_THROUGH_SHIELDS,false), Map.entry(HorizonsModifier.TARGET_MODULES_MALFUNCTIONS,false) , Map.entry(HorizonsModifier.WING_SHIELD_REGENERATION_INCREASED,false), Map.entry(HorizonsModifier.TARGET_HEAT_INCREASED,false)));

    public static final List<PulseLaser> PULSE_LASERS = List.of(
            PULSE_LASER_1_F_F,
            PULSE_LASER_1_G_G,
            PULSE_LASER_1_G_T,
            PULSE_LASER_2_E_F,
            PULSE_LASER_2_F_G,
            PULSE_LASER_2_F_T,
            PULSE_LASER_3_D_F,
            PULSE_LASER_3_E_G,
            PULSE_LASER_3_F_T,
            PULSE_LASER_4_A_F,
            PULSE_LASER_4_A_G,
            PULSE_DISRUPTOR_LASER_2_E_F
    );

    private PulseLaser(final String id, final HorizonsBlueprintName name, final ModuleSize moduleSize, final ModuleClass moduleClass, final boolean multiCrew, final Mounting mounting, final long basePrice, final String internalName, final Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, multiCrew, mounting, basePrice, internalName, attributes);
    }

    private PulseLaser(final String id, final HorizonsBlueprintName name, final ModuleSize moduleSize, final ModuleClass moduleClass, final Origin origin, final boolean multiCrew, final Mounting mounting, final long basePrice, final String internalName, final Map<HorizonsModifier, Object> attributes) {
        super(id, name, moduleSize, moduleClass, origin, multiCrew, mounting, basePrice, internalName, attributes);
    }

    private PulseLaser(final PulseLaser pulseLaser) {
        super(pulseLaser);
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedBlueprints() {
        return PulseLaserBlueprints.BLUEPRINTS.keySet().stream().toList();
    }

    @Override
    public List<HorizonsBlueprintType> getAllowedExperimentalEffects() {
        return ExperimentalEffectBlueprints.PULSE_LASER.keySet().stream().toList();
    }

    @Override
    public PulseLaser Clone() {
        return new PulseLaser(this);
    }
    @Override
    public String getClarifier() {
        if(PULSE_DISRUPTOR_LASER_2_E_F.equals(this)){
            return " " + LocaleService.getLocalizedStringForCurrentLocale(getName().getLocalizationKey());
        }
        return super.getClarifier();
    }
}
